/* 
   Copyright (C) 2009 German A. Arias <german@xelalug.org>

   This file is part of FísicaLab application

   FísicaLab is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public
   License as published by the Free Software Foundation; either
   version 3 of the License, or (at your option) any later version.
 
   This application is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.
 
   You should have received a copy of the GNU General Public
   License along with this library; if not, write to the Free
   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111 USA.
*/

#include <AppKit/AppKit.h>
#include "MIInformacion.h"

@implementation MIInformacion

- (void)awakeFromNib
{
conteoReferencia = 0;
sistema = 0;
[mostrarInfo setDataSource: self] ;
[mostrarInfo setDelegate: self] ;
listaObjetos = [NSMutableDictionary dictionary] ;
[listaObjetos retain] ;
}

- (void) sisUnidades: (id)sender
{
 if(sistema != [sender tag])
    {
    sistema = [sender tag] ;
      
        if([sender tag] == 0)
          {
          [sender setState: NSOnState] ;
          [ingles setState: NSOffState] ;
          }
        else
          {
          [sender setState: NSOnState] ;
          [si setState: NSOffState] ;
          } 
    
    }
    else
    {
    [sender setState: NSOnState] ;
    }

}

- (void) calcular: (id)sender
{
  /* insert your code here */
  int cod = [sender codigo: self] ;
  [mostrarInfo deselectAll: sender] ;
  
  if([borrarVisor state] == NSOffState)
  {
  [visorRes setString: @""] ;
  }
  
  switch(cod)
  {
  case 0:
        {
        [cinemaPuntual setSistema: sistema] ;
        [cinemaPuntual crearEcuaciones: listaObjetos] ;
        }
        break;
  case 1:
        {
        [estatPuntual setSistema: sistema] ;
        [estatPuntual celdas: [sender subviews]] ;
        [estatPuntual crearEcuaciones: listaObjetos] ;
        }
        break;
   case 2:
        {
        [dinamiPuntual setSistema: sistema] ;
        [dinamiPuntual celdas: [sender subviews]] ;
        [dinamiPuntual crearEcuaciones: listaObjetos] ;
        }
        break;
  }
}


- (void) agregarObjeto: (id)nuevo
{
  /* insert your code here */
  NSString *gravedad ;
  NSMutableArray *listaTitulos ;
  NSMutableArray *listaDatos ;
  NSMutableArray *listaValores = [NSMutableArray array] ;
  NSMutableDictionary *datos ;
  
  NSNumber *tipo ;
  conteoReferencia = conteoReferencia + 1;
  
  if(sistema == 0)
  {
  gravedad = [NSString stringWithString: @"9.81"] ;
  }
  else
  {
  gravedad = [NSString stringWithString: @"32.2"] ;
  }
  
  switch ([nuevo tag])
  {
  case 1:
        {
        listaTitulos = [NSMutableArray arrayWithObjects: @"tf", nil] ;
        listaDatos = [NSMutableArray arrayWithObjects: @"0", nil] ;
        }
        break ;
  case 2:
        {
        listaTitulos = [NSMutableArray arrayWithObjects: @"Nombre", @"Objeto", @"xsi", @"ysi", @"vsx", @"vsy", @"xof", @"yof", @"vxof", @"vyof", nil] ;
        listaDatos = [NSMutableArray arrayWithObjects: @"0", @"0", @"0", @"0", @"0", @"0", @"0", @"0", @"0", @"0", nil] ;
        }
        break;      
  case 3:
        {
        listaTitulos = [NSMutableArray arrayWithObjects: @"Nombre", @"ax", @"ay", @"xi", @"yi", @"vxi", @"vyi", @"ti", @"xf", @"yf", @"vxf", @"vyf", nil] ;
        listaDatos = [NSMutableArray arrayWithObjects: @"0", @"0", @"0", @"0", @"0", @"0", @"0", @"0", @"0", @"0", @"0", @"0", nil] ;
        }
        break;
  case 4:
        {
        listaTitulos = [NSMutableArray arrayWithObjects: @"Nombre", @"ax", @"ay", @"xi", @"yi", @"vi", @"angi", @"ti", @"xf", @"yf", @"vf", @"angf", nil] ;
        listaDatos = [NSMutableArray arrayWithObjects: @"0", @"0", @"0", @"0", @"0", @"0", @"0", @"0", @"0", @"0", @"0", @"0", nil] ;
        }
        break;
   case 5:
        {
        listaTitulos = [NSMutableArray arrayWithObjects: @"Nombre", @"ax", @"xi", @"vxi", @"ti", @"xf", @"vxf", nil] ;
        listaDatos = [NSMutableArray arrayWithObjects: @"0", @"0", @"0", @"0", @"0", @"0", @"0", nil] ;
        }
        break; 
   case 6:
        {
        listaTitulos = [NSMutableArray arrayWithObjects: @"Nombre", @"ay", @"yi", @"vyi", @"ti", @"yf", @"vyf", nil] ;
        listaDatos = [NSMutableArray arrayWithObjects: @"0", @"0", @"0", @"0", @"0", @"0", @"0", nil] ;
        }
        break;
   case 7:
        {
        listaTitulos = [NSMutableArray arrayWithObjects: @"Nombre", @"Objeto", @"xsi", @"vsx", @"xof", @"vxof", nil] ;
        listaDatos = [NSMutableArray arrayWithObjects: @"0", @"0", @"0", @"0", @"0", @"0", nil] ;
        }
        break;
   case 8:
        {
        listaTitulos = [NSMutableArray arrayWithObjects: @"Nombre", @"Objeto", @"ysi", @"vsy", @"yof", @"vyof", nil] ;
        listaDatos = [NSMutableArray arrayWithObjects: @"0", @"0", @"0", @"0", @"0", @"0", nil] ;
        }
        break;
   case 9:
        {
        listaTitulos = [NSMutableArray arrayWithObjects: @"Nombre", @"xi", @"xf", @"ti", @"vx", nil] ;
        listaDatos = [NSMutableArray arrayWithObjects: @"0", @"0", @"0", @"0", @"0", nil] ;
        }
        break;
  case 10:
        {
        listaTitulos = [NSMutableArray arrayWithObjects: @"Nombre", @"yi", @"yf", @"ti", @"vy", nil] ;
        listaDatos = [NSMutableArray arrayWithObjects: @"0", @"0", @"0", @"0", @"0", nil] ;
        }
        break;
   case 11:
        {
        listaTitulos = [NSMutableArray arrayWithObjects: @"Objeto 1", @"Objeto 2", @"d", nil] ;
        listaDatos = [NSMutableArray arrayWithObjects: @"0", @"0", @"0", nil] ;
        }
        break;
   case 12:
        {
        listaTitulos = [NSMutableArray arrayWithObjects: @"Objeto 1", @"Objeto 2", @"v", @"ang", nil] ;
        listaDatos = [NSMutableArray arrayWithObjects: @"0", @"0", @"0", @"0", nil] ;
        }
        break;
   case 13:
        {
        listaTitulos = [NSMutableArray arrayWithObjects: @"Nombre", @"a", @"angf", @"xi", @"yi", @"vi", @"ti", @"xf", @"yf", @"vf", nil] ;
        listaDatos = [NSMutableArray arrayWithObjects: @"0", @"0", @"0", @"0", @"0", @"0", @"0", @"0", @"0", @"0", nil] ;
        }
        break;
   case 14:
        {
        listaTitulos = [NSMutableArray arrayWithObjects: @"x1 (y1)", @"x2 (y2)", @"x1 - x2 (y1 - y2)", nil] ;
        listaDatos = [NSMutableArray arrayWithObjects: @"0", @"0", @"0", nil] ;
        }
        break;
   case 15:
        {
        listaTitulos = [NSMutableArray arrayWithObjects: @"Nombre", @"xf", @"yf", nil] ;
        listaDatos = [NSMutableArray arrayWithObjects: @"0", @"0", @"0", nil] ;
        }
        break;
   case 50:
        {
        listaTitulos = [NSMutableArray arrayWithObjects: @"g", nil] ;
        listaDatos = [NSMutableArray arrayWithObjects: gravedad, nil] ;
        }
        break;
   case 51:
        {
        listaTitulos = [NSMutableArray arrayWithObjects: @"m", nil] ;
        listaDatos = [NSMutableArray arrayWithObjects: @"0", nil] ;
        }
        break;
   case 52:
        {
        listaTitulos = [NSMutableArray arrayWithObjects: @"m", @"ang", nil] ;
        listaDatos = [NSMutableArray arrayWithObjects: @"0", @"0", nil] ;
        }
        break;
   case 53:
        {
        listaTitulos = [NSMutableArray arrayWithObjects: @"m", @"ang", nil] ;
        listaDatos = [NSMutableArray arrayWithObjects: @"0", @"0", nil] ;
        }
        break;
   case 54:
        {
        listaTitulos = [NSMutableArray arrayWithObjects: @"Nombre", nil] ;
        listaDatos = [NSMutableArray arrayWithObjects: @"Polea", nil] ;
        }
        break;
   case 55:
        {
        listaTitulos = [NSMutableArray arrayWithObjects: @"Nombre", nil] ;
        listaDatos = [NSMutableArray arrayWithObjects: @"Punto", nil] ;
        }
        break; 
   case 56 ... 59:
        {
        listaTitulos = [NSMutableArray arrayWithObjects: @"f", @"ang", nil] ;
        listaDatos = [NSMutableArray arrayWithObjects: @"0", @"0", nil] ;
        }
        break;
   case 60 ... 63:
        {
        listaTitulos = [NSMutableArray arrayWithObjects: @"f", nil] ;
        listaDatos = [NSMutableArray arrayWithObjects: @"0", nil] ;
        }
        break;
   case 64 ... 71:
        {
        listaTitulos = [NSMutableArray arrayWithObjects: @"u", nil] ;
        listaDatos = [NSMutableArray arrayWithObjects: @"0", nil] ;
        }
        break;
   case 72:
        {
        listaTitulos = [NSMutableArray arrayWithObjects: @"f", @"ang", nil] ;
        listaDatos = [NSMutableArray arrayWithObjects: @"0", @"0", nil] ;
        }
        break;
   case 73:
   case 74:
        {
        listaTitulos = [NSMutableArray arrayWithObjects: @"f", nil] ;
        listaDatos = [NSMutableArray arrayWithObjects: @"0", nil] ;
        }
        break;
   case 75 ... 78:
        {
        listaTitulos = [NSMutableArray arrayWithObjects: @"k", @"d", nil] ;
        listaDatos = [NSMutableArray arrayWithObjects: @"0", @"0", nil] ;
        }
        break;
   case 100:
        {
        listaTitulos = [NSMutableArray arrayWithObjects: @"g", @"t", nil] ;
        listaDatos = [NSMutableArray arrayWithObjects: gravedad, @"0", nil] ;
        }
        break;
   case 101:
        {
        listaTitulos = [NSMutableArray arrayWithObjects: @"Nombre", @"m", @"vi", @"angi", @"vf", @"angf", nil] ;
        listaDatos = [NSMutableArray arrayWithObjects: @"0", @"0", @"0", @"0", @"0", @"0", nil] ;
        }
        break;
   case 102:
        {
        listaTitulos = [NSMutableArray arrayWithObjects: @"Nombre", @"m", @"vxi", @"vxf", nil] ;
        listaDatos = [NSMutableArray arrayWithObjects: @"0", @"0", @"0", @"0", nil] ;
        }
        break;
   case 103:
        {
        listaTitulos = [NSMutableArray arrayWithObjects: @"Nombre", @"m", @"vyi", @"vyf", nil] ;
        listaDatos = [NSMutableArray arrayWithObjects: @"0", @"0", @"0", @"0", nil] ;
        }
        break;
   case 104:
        {
        listaTitulos = [NSMutableArray arrayWithObjects: @"Nombre", @"m", @"a", @"vi", @"vf", @"d", @"Relativo a", nil] ;
        listaDatos = [NSMutableArray arrayWithObjects: @"0", @"0", @"0", @"0", @"0", @"0", @"sf", nil] ;
        }
        break;
   case 105:
        {
        listaTitulos = [NSMutableArray arrayWithObjects: @"Nombre", @"m", @"a", @"vi", @"vf", @"d", @"Relativo a", nil] ;
        listaDatos = [NSMutableArray arrayWithObjects: @"0", @"0", @"0", @"0", @"0", @"0", @"sf", nil] ;
        }
        break;        
   case 106:
        {
        listaTitulos = [NSMutableArray arrayWithObjects: @"Nombre", @"m", @"ang", @"a", @"vi", @"vf", @"d", @"Relativo a", nil] ;
        listaDatos = [NSMutableArray arrayWithObjects: @"0", @"0", @"0", @"0", @"0", @"0", @"0", @"sf", nil] ;
        }
        break;
   case 107:
        {
        listaTitulos = [NSMutableArray arrayWithObjects: @"Nombre", @"m", @"ang", @"a", @"vi", @"vf", @"d", @"Relativo a", nil] ;
        listaDatos = [NSMutableArray arrayWithObjects: @"0", @"0", @"0", @"0", @"0", @"0", @"0", @"sf", nil] ;
        }
        break;
   case 108:
        {
        listaTitulos = [NSMutableArray arrayWithObjects: @"Nombre", nil] ;
        listaDatos = [NSMutableArray arrayWithObjects: @"Polea", nil] ;
        }
        break;
   case 109 ... 112:
        {
        listaTitulos = [NSMutableArray arrayWithObjects: @"f", @"ang", nil] ;
        listaDatos = [NSMutableArray arrayWithObjects: @"0", @"0", nil] ;
        }
        break;
   case 113 ... 116:
        {
        listaTitulos = [NSMutableArray arrayWithObjects: @"f", nil] ;
        listaDatos = [NSMutableArray arrayWithObjects: @"0", nil] ;
        }
        break;
   case 117 ... 124:
        {
        listaTitulos = [NSMutableArray arrayWithObjects: @"Normal", @"u", nil] ;
        listaDatos = [NSMutableArray arrayWithObjects: @"0", @"0", nil] ;
        }
        break;
   case 125 ... 128:
        {
        listaTitulos = [NSMutableArray arrayWithObjects: @"Normal", @"u", @"ang", nil] ;
        listaDatos = [NSMutableArray arrayWithObjects: @"0", @"0", @"0", nil] ;
        }
        break;
   case 129 ... 132:
        {
        listaTitulos = [NSMutableArray arrayWithObjects: @"Normal", @"u", nil] ;
        listaDatos = [NSMutableArray arrayWithObjects: @"0", @"0", nil] ;
        }
        break; 
   case 133 ... 136:
        {
        listaTitulos = [NSMutableArray arrayWithObjects: @"Nombre", @"k", @"xi", @"xf", nil] ;
        listaDatos = [NSMutableArray arrayWithObjects: @"0", @"0", @"0", @"0", nil] ;
        }
        break;                       
   case 137:
        {
        listaTitulos = [NSMutableArray arrayWithObjects: @"a1", @"a2", @"z", nil] ;
        listaDatos = [NSMutableArray arrayWithObjects: @"0", @"0", @"-1", nil] ;
        }
        break;
   case 138:
        {
        listaTitulos = [NSMutableArray arrayWithObjects: @"Objeto 1", @"Objeto 2", @"e", @"angn", nil] ;
        listaDatos = [NSMutableArray arrayWithObjects: @"0", @"0", @"0", @"0", nil] ;
        }
        break;
   case 139:
        {
        listaTitulos = [NSMutableArray arrayWithObjects: @"Objeto 1", @"Objeto 2", @"Objeto 3", @"Objeto 4", @"Trabajo", nil] ;
        listaDatos = [NSMutableArray arrayWithObjects: @"0", @"0", @"0", @"0", @"0", nil] ;        
        }
        break;   
   case 140:
        {
        listaTitulos = [NSMutableArray arrayWithObjects: @"Objeto", @"Impulso", @"ang", @"fImp", nil] ;
        listaDatos = [NSMutableArray arrayWithObjects: @"0", @"0", @"0", @"0", nil] ;
        }
        break;
   case 141:
        {
        listaTitulos = [NSMutableArray arrayWithObjects: @"Objeto", @"Potencia", nil] ;
        listaDatos = [NSMutableArray arrayWithObjects: @"0", @"0", nil] ;
        }
        break;
   case 143:
        {
        listaTitulos = [NSMutableArray arrayWithObjects: @"Objeto", @"asf", @"ang_asf", @"vfsf", @"ang_vfsf", @"dsf", @"ang_dsf", nil] ;
        listaDatos = [NSMutableArray arrayWithObjects: @"0", @"0", @"0", @"0", @"0", @"0", @"0", nil] ;
        }
        break;          
   case 144:
        {
        listaTitulos = [NSMutableArray arrayWithObjects: @"m", @"vi", @"ang", @"m1", @"vf1", @"ang1", @"m2", @"vf2", @"ang2", @"m3", @"vf3", @"ang3", @"m4", @"vf4", @"ang4", @"Energia", nil] ;
        listaDatos = [NSMutableArray arrayWithObjects: @"0", @"0", @"0", @"0", @"0", @"0", @"0", @"0", @"0", @"0", @"0", @"0", @"0", @"0", @"0", @"0", nil] ;
        }
        break;      
  }
  
tipo = [NSNumber numberWithInt: [nuevo tag] ] ;
datos = [NSMutableDictionary dictionaryWithObjectsAndKeys: tipo, @"Tipo", listaTitulos, @"Titulos", listaDatos, @"Datos", listaValores, @"Valores", nil] ;
identificador = [[NSNumber alloc] initWithInt: conteoReferencia] ;
[listaObjetos setObject: datos forKey: identificador] ;
[nuevo setTag: [identificador intValue]] ;
[mostrarInfo reloadData] ;  
}


- (void) borrarObjeto: (int)codigo
{
  /* insert your code here */
  identificador = [[NSNumber alloc] initWithInt: codigo] ;
  [listaObjetos removeObjectForKey: identificador] ;
  [mostrarInfo reloadData] ;
}

- (void) selecObjeto: (int)codigo
{
  /* insert your code here */
  [mostrarInfo deselectRow: [mostrarInfo selectedRow] ] ;
  identificador = [[NSNumber alloc] initWithInt: codigo] ;
  [mostrarInfo reloadData] ;
}

- (void) borrarObjetos: (BOOL) parametro
{
conteoReferencia = 0;
[listaObjetos removeAllObjects] ;
[mostrarInfo reloadData] ;
}

- (int) numberOfRowsInTableView: (NSTableView*)aTableView
{
return [[[listaObjetos objectForKey: identificador] objectForKey: @"Titulos"] count] ;
}

- (id) tableView: (NSTableView*)aTableView objectValueForTableColumn: (NSTableColumn*)aTableColumn row: (int)rowIndex
{
id imprimir ;     
NSMutableDictionary *objeto = [listaObjetos objectForKey: identificador] ;
NSMutableArray *lista = [objeto objectForKey: [aTableColumn identifier] ] ;
imprimir = [lista objectAtIndex: rowIndex] ;
return imprimir ;
}

- (void) tableView: (NSTableView*)aTableView setObjectValue: (id)anObject forTableColumn: (NSTableColumn*)aTableColumn row: (int)rowIndex
{
NSMutableDictionary *objeto = [listaObjetos objectForKey: identificador] ;
NSMutableArray *lista = [objeto objectForKey: [aTableColumn identifier] ] ;
[lista replaceObjectAtIndex: rowIndex withObject: anObject] ;
}

- (void) dealloc
{
RELEASE(listaObjetos) ;
RELEASE(identificador) ;
[super dealloc] ;
}

@end
