// Copyright (C) 2005 Javier Amor Garcia
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.


#include "Screen.hh"
#include "Reader.hh"
#include "Input.hh"
#include <iostream>
#include <boost/bind.hpp>
#include "TextSourceFactory.hh"
#include <string>

using namespace std;


void
usage()
{
  cout << "Usage: Ogham  [file ..]" << endl << endl;
  cout << "Arguments:" << endl;
  cout << "-                  read form the stdin" << endl;
  cout << "-h --help          show this help message" << endl;
  cout << "-V --version       show version information" << endl << endl;
  cout << "Keyboard commands while reading:" << endl;
  cout << "up/down arrow      increase/decrease speed" << endl;
  cout << "left/right arrow   backwards/forward in the text" << endl;
  cout << "space              pause/resume reading" << endl;
  cout << "</>                change to the previous/next file" << endl;
  cout << "q                  quit program" << endl;
  
  exit(0);
}

void
version()
{
  cout << "Ogham  0.1" << endl;
  cout << "Copyright (C) 2005 by Javier Amor Garcia" << endl;
  cout << "Distribuited under the terms of the Gnu Public License" << endl;
  exit(0);
}



void
bindKeys (Reader *r, Input *in)
{
  in->addKey(KEY_DOWN, boost::bind(&Reader::decreaseSpeed, r, 50));
  in->addKey(KEY_UP, boost::bind(&Reader::increaseSpeed, r, 50));
  in->addKey(KEY_RIGHT, boost::bind(&Reader::forward, r, 20));
  in->addKey(KEY_LEFT, boost::bind(&Reader::rewind, r, 20));
  in->addKey(' ', boost::bind(&Reader::switchReadState, r));
  in->addKey('<', boost::bind(&Reader::switchSource, r, false));
  in->addKey('>', boost::bind(&Reader::switchSource, r, true));
  in->addKey('q', boost::bind(&Input::stopInput, in));
}


void
parseArgs (int argc, char **argv, Reader *r)
{
  if (argc < 2)
    usage();
  else
    for (int i=1; i < argc; i++)
      {
	string arg(argv[i]);
	if (arg == "--help" || arg == "-h")
	  usage();
	else if (arg == "--version" || arg == "-V")
	  version();
	else
	  {
	    try
	      {
		if (arg == "-")
		  r->addSource(TextSourceFactory::fromStdin());
		else
		  r->addSource(TextSourceFactory::fromFile(argv[i]));
	      }
	    catch (exception &e)
	      {
		std::cout << "Ogham error: " << e.what()  << endl;
		exit (1);
	      }
	    
	  }
      }
}




int
main (int argc, char **argv)
{

  Reader r;
  Input in;

  bindKeys(&r, &in);
  parseArgs(argc, argv, &r);
  
  Screen s;
  r.setView((View*) &s);
  r.setSpeed(300);

  r.startRead();
  in.listenInput();
}


