// Copyright (C) 2005 Javier Amor Garcia

// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.

// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.

// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.


#include "Window.hh"
#include <string.h>



Window::Window(int height, int width, int starty, int startx)
{
  this->height = height;
  this->width = width;
  this->startx = startx;
  this->starty = starty;
 
  

  win = newwin(height, width, starty, startx);
  
  box(win, 0 , 0);		/* 0, 0 gives default characters 
				 * for the vertical and horizontal
				 * lines			*/
  mediumX = getmaxx(win)/2;
  mediumY = getmaxy(win)/2;
  wrefresh(win);		/* Show that box 		*/

}


void Window::refresh()
{
  wrefresh(win);
}


void Window::displayText (int y, int x, char *text)
{
  mvwprintw(win, y, x, text);
  this->refresh();
  
}


void Window::displayVerticalCenteredText(int x, char *text)
{
  displayText(mediumY, x, text);
}


void Window::displayCenteredText(char *text)
{
  displayHorizontalCenteredText(mediumY, text);
}

void Window::displayHorizontalCenteredText(int y, char *text)
{
  size_t len = strlen(text);
  int x = mediumX - len/2;
  if (x <= 0)
    x=0;
  displayText(y, x, text);
}


void Window::clearCurrentLine()
{
  int x,y;
  getyx(win, x, y);
  clearLine(y);
  
}

void Window::clearCentralLine()
{
  clearLine(mediumY);
 }


void Window::clearLine (int y)
{
  wmove(win, y, 0);
  wclrtoeol(win);
  wvline(win, 0, 1);
  wmove (win, y, COLS-2);
  wvline (win, 0, 1);  
}



int Window::getHeight()
{
  return  height;
}

int Window::getWidth()
{
  return width ;
}

int Window::getStartX()
{
  return startx;
}

int Window::getStartY()
{
  return starty;
}


