// Copyright (C) 2005 Javier Amor Garcia

// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.

// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.

// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.


#include "TextSource.hh"
#include <assert.h>

#include <stdexcept>

using namespace std;
using namespace boost;


const string TextSource::delims(" ,:;.\t\n");
const string TextSource::noPrintableDelims(" \t\n");





TextSource::TextSource (string sourcename) :  elements(),  elementsIndex(0),  name(sourcename),   fullyReaded(false), readAheadThread(NULL)
{
}



TextSource::~TextSource()
{
  if (readAheadThread != NULL)
    delete readAheadThread;
}


void TextSource::startReadAhead()
{
   readAheadThread = new boost::thread(boost::bind(&TextSource::readAhead, this));
}


void TextSource::readAhead()
{
  while (parseLine())
    ;
  fullyReaded = true;
}


string TextSource::readElement()
{
  while ( elementsIndex >= elements.size())
    {
      
      if (fullyReaded)
	{
	  return string("EOF");
	}
      
      thread::yield();
    }
  
  int retIndex = elementsIndex;
  elementsIndex++;
  return elements[retIndex];
}

void TextSource::rewind(int n)
{
  seek(elementsIndex-n);
  
}

void TextSource::forward(int n)
{
  seek(elementsIndex+n);
}

void TextSource::seek(int n)
{
  if (n < 0)
    n =0;
  while (n >= elements.size())
    {
      if (fullyReaded)
	{
	  n = elements.size()-1;  
	  break;
	}
      thread::yield();
    }
  
  elementsIndex = n;
  
}

  



bool TextSource::parseLine()
{
  string line;
  do
    {
      if (eof())
	  return false;
      else if (bad())
	  return false;
      else
	line = getTextLine();
    } while  (line.length() <= 0);



  string::size_type beg, end;

  
  beg = line.find_first_not_of(delims);
  while(beg != string::npos)
    {
      end = line.find_first_of(delims, beg);
      
      if (end == string::npos) //???replace with an assertion.???
	end = line.length();
       if (noPrintableDelims.find(line[end]) == string::npos)
      	end+=1;
      
      elements.push_back(line.substr(beg, end-beg));
 
      beg = line.find_first_not_of(delims, end);
    }
  
    return true;
  
}

const string TextSource::getName()
{
  return name;
  
}

pair<int,int> TextSource::getPosition()
{
  
  return pair<int,int>(elementsIndex, elements.size());
  
}


bool TextSource::getFullyReaded()
{
  
  return fullyReaded;
}




