// Copyright (C) 2005 Javier Amor Garcia

// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.

// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.

// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.


#ifndef SCREEN_HH
#define SCREEN_HH

#include "View.hh"
#include <ncurses.h>
#include <utility>
using namespace std;

class DataWindow; class StatusWindow; class ControlWindow;


class Screen : public View
{
public:
  Screen();
  Screen(bool statusWindow, bool controlWindow);
  ~Screen();

    
  void displayTextData(char *text);
  void displayPosition(pair<int,int> pos);
  void displaySpeed(int wpm);
  void displayFilename(char *filename);
    
private:
  void initCurses();  
  

  DataWindow* data;
  StatusWindow* status;
  //ControlWindow* controls;

  static const int WSTATUS_HEIGHT= 3;
  static const int WCONTROL_HEIGHT= 4;
    

};



#endif
