// Copyright (C) 2005 Javier Amor Garcia

// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.

// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.

// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.


#ifndef INPUT_HH
#define INPUT_HH

#include <map>
#include <utility>
#include <boost/signal.hpp>
#include <boost/function.hpp>


using namespace std;

typedef map<int, boost::signal<void ()>* > keys_type;

class Input
{
public:
  Input();
  void listenInput();
  void addKey(int key, boost::function<void ()> slot);
  void stopInput();
  
private:
  keys_type keys ;
  void executeKeyCallback(int key);
  bool listeningInput;
  
};


#endif
