// Copyright (C) 2005 Javier Amor Garcia

// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.

// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.

// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.


#include "Input.hh"
#include <curses.h>
#include <assert.h>


Input::Input() : listeningInput(false)
{
  
}


void Input::listenInput()
{
  listeningInput = true;
  
  while (listeningInput)
    {
      int key = getch();
      keys_type::iterator pos = keys.find(key);
      if (pos == keys.end())
	continue;
      else
	{
	  boost::signal< void ()>* ptr=  pos->second;
	  (*ptr)();
	}
      
      
    }
}

void Input::stopInput()
{
  listeningInput = false;
}

//       switch(key)
// 	{
// 	case KEY_DOWN: reader->increaseSpeed(-50); break;
// 	case KEY_UP: reader->increaseSpeed(50); break;
// 	case KEY_RIGHT: reader->forward(20); break;
// 	case KEY_LEFT: reader->rewind(20); break;
// 	case ' ': reader->switchReadState(); break;
// 	case 'q': active = false; break;
// 	default:   break;
	  
// 	}
 


void Input::addKey(int key, boost::function<void ()> slot)
{
  boost::signal< void ()>* sig = new boost::signal< void ()>();
  sig->connect(slot);
  keys[key] = sig; //LEAK!!!! si ya existe
  


}
