// Free Image Manipulator - a program to massive image manipulation.
// Copyright (C) 2006 Kacper Bielecki
// 
// This program is free software; you can redistribute it and/or modify it 
// under the terms of the GNU General Public License as published by the Free 
// Software Foundation; either version 2 of the License, or (at your option) 
// any later version.
// 
// This program is distributed in the hope that it will be useful, but WITHOUT
// ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or 
// FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for 
// more details.
// 
// You should have received a copy of the GNU General Public License along 
// with this program; if not, write to the Free Software Foundation, Inc., 
// 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
// 
//
// C++ Implementation: process
//
// Description: 
//
//
// Author: Kacper <kazjote@stud.ics.p.lodz.pl>, (C) 2006
//
// Copyright: See COPYING file that comes with this distribution
//
//
#include "process.h"
#include "image.h"
#include <iostream>


process::~process()
{
}

process::process( Image *& image, Image *& preview, QObject * parent, const transOptions * n_options, ThreadSort sort )
	: QObject(parent), im_old(image), pre_old(preview), 
		options(*n_options), threadSort(sort)
{
   im = im_old;
   /*im = new Image( *im_old );
   std::cout << "Po stworzeniu im" 
   << std::endl;*/
   /*if ( pre_old > 0 )
   {
      pre = new Image( *pre_old );
      std::cout << "Po stworzeniu pre" 
         << std::endl;
}*/
}

void process::run( )
{
	std::cout << "W watku" << std::endl;
	//if (pre)
	//	delete pre;
	//std::cout << "Skasowany" << std::endl;
	Image *pre_temp = 0;
	try
	{
		if (im)
			pre_temp = new Image(*im);			
		else
			std::cout << "Nie ma obrazka w watku tworzenia preview" 
					<< std::endl;
	}
	catch(...)
	{
		return ;
	}
	std::cout << "Skopiowalem obrazki" << std::endl;
	if (pre_temp->getImage())
	{
		if ((options.h != 0) || (options.w != 0))
		{
			std::cout << "Skaluje" << std::endl;
			pre_temp->resize(options.w, options.h);
		}
		if (options.text != "")
		{
			int fontColor[3];
			fontColor[0] = options.fontColor[0];
			fontColor[1] = options.fontColor[1];
			fontColor[2] = options.fontColor[2];
			int color[3] = { options.bgColor[0], options.bgColor[1], options.bgColor[2] };
			int margins[4];
			margins[1] = margins[3] = options.lr_margin;
			margins[0] = margins[2] = options.tb_margin;
			int borders[4] = { options.pos_top, options.pos_right, options.pos_bottom, options.pos_left };
			
			pre_temp->print_string(
					static_cast<double>(options.text_size),
			options.text.toUtf8().data(),
			options.fontPath.toStdString(),
			color,
			options.bgOpacity,
			margins,
			borders,
			fontColor,
			options.opacity
										 );
		}
      
      for ( std::vector<transOptions::additionalOptions>::iterator iter = options.additionalImages.begin();
            iter != options.additionalImages.end();
            ++iter
          )
      {
         pre_temp->paste_other_image( (*iter).path.toStdString(), 
                                      (*iter).width, (*iter).height,
                                      (*iter).posLeft, (*iter).posRight,
                                      (*iter).posTop, (*iter).posBottom,
                                      (*iter).opacity
                                    );
      }
      
		if (threadSort == thread_preview)
			pre_temp->resize(PREV_WIDTH, PREV_HEIGHT);
	}
	std::cout << "Zmienilem rozmiar" << std::endl;
   
   if ( pre_old )
      delete pre_old;
   pre_old = pre_temp;
   
   //delete im_old;
   //im_old = im;
      
}
