// Free Image Manipulator - a program to massive image manipulation.
// Copyright (C) 2006 Kacper Bielecki
// 
// This program is free software; you can redistribute it and/or modify it 
// under the terms of the GNU General Public License as published by the Free 
// Software Foundation; either version 2 of the License, or (at your option) 
// any later version.
// 
// This program is distributed in the hope that it will be useful, but WITHOUT
// ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or 
// FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for 
// more details.
// 
// You should have received a copy of the GNU General Public License along 
// with this program; if not, write to the Free Software Foundation, Inc., 
// 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
// 
//
// C++ Implementation: preview
//
// Description: 
//
//
// Author: Kacper <kazjote@stud.ics.p.lodz.pl>, (C) 2006
//
// Copyright: See COPYING file that comes with this distribution
//
//
#include "preview.h"
#include <gd.h>
#include <QPainter>
#include <iostream>

// DEBUG
#include <ctime>

preview::preview(QWidget *parent)
	: QFrame(parent), logo(":/logo_big.png", "png")
{
	setFrameStyle(QFrame::Panel | QFrame::Plain);
   image = 0;
}


preview::~preview()
{
}

void preview::paintEvent( QPaintEvent * event )
{
   clock_t start = clock();
	QFrame::paintEvent( event );
	QPainter painter(this);
	if ( image && image->getImage() )
	{
      gdImagePtr gdIm = image->getImage();
		int k = 0;
      int max_i = gdIm->sx;
      int max_j = gdIm->sy;
		for(int i = 0; i<max_i; i++)
      {
			for (int j = 0; j<max_j; j++)
			{
            k = gdImageGetPixel(gdIm, i, j);
            painter.setPen( QColor(
                  gdImageRed(gdIm, k), 
                  gdImageGreen(gdIm, k),
                  gdImageBlue(gdIm, k),
                  255 - gdImageAlpha(gdIm, k) * 2
                                  ));
				painter.drawPoint(i+(width()-max_i)/2,j+ (height()-max_j)/2);
    //std::cout << gdImageAlpha(image, k) << std::endl;
			}
      }
      painter.setPen( QPen( QColor( 0,0,0 ) ) );
      for (int i = 0; i < 3; i++ )
         {
         painter.drawLine( 
               QPoint( (width() - max_i) / 2 - 2 + i, ( height() - max_j ) / 2 - 2), 
               QPoint( (width() - max_i) / 2 - 2 + i, ( height() - max_j ) / 2 + max_j - 3 ) );
         painter.drawLine( 
               QPoint( (width() - max_i) / 2 - 2, ( height() - max_j ) / 2 - 2 + i), 
               QPoint( (width() - max_i) / 2 - 3 + max_i, ( height() - max_j ) / 2 - 2 + i) );
         }
	}
   else
   {
      painter.drawImage(QPointF((width()-250)/2, (height()-253)/2), logo);
   }
   std::cout << (double)( clock() - start ) / (double)CLOCKS_PER_SEC << std::endl;
}

void preview::setImage( Image * new_image )
{
   if ( image )
      delete image;
   image = new Image();
   *image = *new_image;
}


