//
// C++ Implementation: imagetreeview
//
// Description: 
//
//
// Author: Kacper <kazjote@stud.ics.p.lodz.pl>, (C) 2006
//
// Copyright: See COPYING file that comes with this distribution
//
//
#include "imagetreeview.h"

#include <QDragEnterEvent>
#include <QUrl>
#include <QHeaderView>

#include <iostream>

#include <QMenu>

imageTreeView::imageTreeView(QWidget *parent)
 : QTreeView(parent)
{
  
   setAcceptDrops( true );
   setDragEnabled(true);
   setDropIndicatorShown(true);
   
   std::cout << "HELO!!" << std::endl;
}

imageTreeView::~imageTreeView()
{
}

void imageTreeView::contextMenuEvent( QContextMenuEvent * event )
{
   QString title( tr( "Files" ) );
   QMenu menu( title, 0 );
   menu.addAction( QString( tr("Add files...") ), window, SLOT(addFiles()) );
   
   if ( selectionModel()->selectedIndexes().size() > 0 )
   {
      menu.addAction( QString( tr("Delete files...") ), window, SLOT(delFiles()) );
   }
   
   menu.exec( event->globalPos() );
}

void imageTreeView::setModel( QAbstractItemModel * model )
{
   QTreeView::setModel( model );
   
   QHeaderView *head = header();
   head->resizeSection(head->logicalIndex(1), 50);
   head->resizeSection(head->logicalIndex(2), 50);
   head->resizeSection(head->logicalIndex(3), 50);
   head->setResizeMode(head->logicalIndex(0), QHeaderView::Stretch);
   head->setResizeMode(head->logicalIndex(1), QHeaderView::Custom);
   head->setResizeMode(head->logicalIndex(2), QHeaderView::Custom);
   head->setResizeMode(head->logicalIndex(3), QHeaderView::Custom);
   head->setStretchLastSection ( false );
}
