// Free Image Manipulator - a program to massive image manipulation.
// Copyright (C) 2006 Kacper Bielecki
// 
// This program is free software; you can redistribute it and/or modify it 
// under the terms of the GNU General Public License as published by the Free 
// Software Foundation; either version 2 of the License, or (at your option) 
// any later version.
// 
// This program is distributed in the hope that it will be useful, but WITHOUT
// ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or 
// FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for 
// more details.
// 
// You should have received a copy of the GNU General Public License along 
// with this program; if not, write to the Free Software Foundation, Inc., 
// 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
// 
//
// C++ Interface: images
//
// Description: 
//
//
// Author: Kacper <kazjote@stud.ics.p.lodz.pl>, (C) 2006
//
// Copyright: See COPYING file that comes with this distribution
//
//
#ifndef IMAGES_H
#define IMAGES_H

#include <vector>
#include "image_ext.h"

class QString;

/**
@author Kacper
*/
class Images : public QObject
{
Q_OBJECT
private:
	std::vector<Image_ext*> images;
	std::pair<bool, std::vector<Image_ext*>::iterator> im_iter;
	
public:
	Image_ext* operator[](const int i);
	
   Images(QObject *parent = 0);
	
	/**
	 * Resetuje iterator do wektora obrazków.
	 */
	void resetIter();
	/**
	 * Zwraca kolejny obrazek.
	 * Jeżeli nie istnieje zwracane jest 0
	 */
	Image_ext* getIter();
	
	int count();
	
   ~Images();
	
public slots:
	void addRequest( QString filepath );
	void delRequest( int i );
	void clear();

signals:
	void added(Image_ext* image);
	void deleted(int i);
};

#endif
