// Free Image Manipulator - a program to massive image manipulation.
// Copyright (C) 2006 Kacper Bielecki
// 
// This program is free software; you can redistribute it and/or modify it 
// under the terms of the GNU General Public License as published by the Free 
// Software Foundation; either version 2 of the License, or (at your option) 
// any later version.
// 
// This program is distributed in the hope that it will be useful, but WITHOUT
// ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or 
// FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for 
// more details.
// 
// You should have received a copy of the GNU General Public License along 
// with this program; if not, write to the Free Software Foundation, Inc., 
// 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
// 
/**
 * Image.cpp
 */

#include "image.h"
#include <iostream>

#include <ctime>
#include <cstdlib>
#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>


using namespace std;
 
Image::Image() 
{
	created = false;
   image = 0;
}

Image::~Image()
{
	if (created)
		gdImageDestroy(image);
}

void Image::load_from_file(const string &file_path)
{
	int pos = file_path.find_last_of(".");
	if (!pos)
		throw ImageError(ImageError::BadName);
	
	FILE *fd = fopen(file_path.c_str(), "rb");
	if (!fd)
		throw ImageError(ImageError::BadName);
	
	// Sprawdzenie rozszerzenia i próba wczytania pliku
	string extension(file_path.substr(pos+1));
	if ((extension == "jpeg") || (extension == "jpg") ||
			 (extension == "JPEG") || (extension == "JPG"))
	{
		if ((image = gdImageCreateFromJpeg(fd)))
			image_format = jpeg;
		else image = 0;
	}
	else
	if ((extension == "gif") || (extension == "GIF") ||
			 (extension == "Gif") || (extension == "GIf"))
	{
		if ((image = gdImageCreateFromGif(fd)))
			image_format = gif;
		else image = 0;
	}
	else
		if ((extension == "png") || (extension == "PNG") ||
					(extension == "PNg") || (extension == "Png"))
	{
		if ((image = gdImageCreateFromPng(fd)))
			image_format = png;
		else image = 0;
	}
	else
		if ((extension == "bmp") || (extension == "BMP") ||
					(extension == "BMp") || (extension == "Bmp"))
	{
		if ((image = gdImageCreateFromWBMP(fd)))
			image_format = bmp;
		else image = 0;
	}
	else
		image = 0;
	
	fclose(fd);
	if (!image)
		throw ImageError(ImageError::LoadError);
	else
		created = true;
}

void Image::save_to_file(
		const std::string &file_path, 
		ImageFormat format,
		const int quality,
      int size                  
                        ) const
{
	if (!created)
		throw ImageError(ImageError::NoImage);
	
	if (format == none)
		format = image_format;
	
	if (format == jpeg)
   {
      if ( size < 1 )
      {
         FILE *out = fopen(file_path.c_str(), "wb");
         if (!out)
            throw ImageError(ImageError::BadName);
         gdImageJpeg(image, out, quality);
         
         fclose( out );
      }
      else
      {
         std::cout << "Dziele !! FILESIZE: " << size << std::endl;
         // Zdublowany po czesci kod z format==png
         int start = 0;
         int stop = 100;
         int avg;
         
         // Bisekcja
         do
         {
            FILE *out = fopen(file_path.c_str(), "wb");
            if (!out)
               throw ImageError(ImageError::BadName);
            
            avg = ( start + stop ) / 2;
            
            gdImageJpeg( image, out, avg );
            
            fclose( out );
            struct stat buf;
            if ( stat( file_path.c_str(), &buf ) > -1 )
            {
               std::cout << "REAL FILESIZE: " << buf.st_size << std::endl;
               if ( ( buf.st_size ) > size )
               {
                  // Rozmiar za duzy!! Zmniejszyc jakosc!!
                  stop = avg;
               }
               else
               {
                  start = avg;
               }
            }
            else
            {
               std::cerr << "ERROR!!" << std::endl;
            }
            
            
            
         } 
         while ( abs( stop - start ) > 1 );
         
         if ( avg != start )
         {
            // Rozmiar w ostatnim cyklu byl za duzy wiec trzeba zapisac obraz jeszcze raz
            // z mniejszym stopniem kompresji
            FILE *out = fopen(file_path.c_str(), "wb");
            if (!out)
               throw ImageError(ImageError::BadName);
            
            gdImageJpeg( image, out, start );
            
            fclose( out );
         }
      }
   }
   
	else if (format == gif)
   {
      FILE *out = fopen(file_path.c_str(), "wb");
      if (!out)
         throw ImageError(ImageError::BadName);
      
		gdImageGif(image, out);
      
      fclose( out );
   }
   
	else if (format == png)
   {
      if ( size < 1 )
      {
         FILE *out = fopen(file_path.c_str(), "wb");
         if (!out)
            throw ImageError(ImageError::BadName);
         
         int q = ( 100 - quality ) / 10;
         if ( q > 9 ) q = 9;
      
		   gdImagePngEx(image, out, q);
         
         fclose( out );
      }
      else
      {
         // 0 == q --> the best quality
         int start = 0;
         int stop = 9;
         int avg;
         // Bisekcja
         do
         {
            FILE *out = fopen(file_path.c_str(), "wb");
            if (!out)
               throw ImageError(ImageError::BadName);
            
            avg = ( start + stop ) / 2;
            
            gdImagePngEx( image, out, avg );
            
            struct stat buf;
            stat( file_path.c_str(), &buf );
            
            if ( ( buf.st_size * 1024 ) > size )
            {
               // Rozmiar za duzy!! Zwiekszyc kompresje!!
               start = avg;
            }
            else
            {
               stop = avg;
            }
            
            
            fclose( out );
         } 
         while ( abs( stop - start ) <= 1 );
         
         if ( avg != stop )
         {
            // Rozmiar w ostatnim cyklu byl za duzy wiec trzeba zapisac obraz jeszcze raz
            // z mniejszym stopniem kompresji
            FILE *out = fopen(file_path.c_str(), "wb");
            if (!out)
               throw ImageError(ImageError::BadName);
            
            gdImagePngEx( image, out, stop );
            
            fclose( out );
         }
      }
   }
		
}

bool Image::resize(const int max_x, const int max_y) 
{
	if ((max_x == 0) && (max_y == 0))
		return false;
   
   int x,y;	
   final_dimensions ( max_x, max_y, image->sx, image->sy, x, y );
   
	gdImagePtr temp_image = newImage(x, y);
	
	gdImageCopyResampled(temp_image, image, 0, 0, 0, 0,
			x, y, image->sx, image->sy);
			
	gdImageDestroy(image);
	image = temp_image;
	return true;
}

void Image::print_string(const double size, const std::string &tekst, 
								 const std::string &font_path, int color[3], 
								 int opacity, int margins[4], int border[4], int font_color[3],
								 int font_opacity) 
{
	int bl_size[8], bl_size2[8];
	// Pobranie rozmiar� napisu
	//char *font = "/home/kacper/Projekty/net-sec/src/ariblk.ttf";
	char font[256];
	strncpy(font, font_path.c_str(), 256);
	char text_s[1024];
	if (tekst.length() > 1023) return ;
	strcpy(text_s, tekst.c_str());
	
	/** 
	 * Wyliczenie rozmiaru czcionki...
	 */
	double font_size;
	// Consider only x dim. as text is wider then higher
	int max_text_size= static_cast<int>(image->sx * size) / 100;
	
	double biggest_font = 50; // Font size to start from
	do
	{
		biggest_font *= 2;
		/*char *err = */gdImageStringFT(NULL, bl_size, 0, font, biggest_font,
				0., 0, 0, text_s);
	} 
	while
	(
			((bl_size[2] - bl_size[0]) < max_text_size)    // X dim. less than max x size
	);
	
	std::cout << "biggest font: " << biggest_font << std::endl;
	
	// Chech if biggest font size is not right size
	if ((bl_size[2] - bl_size[0]) == max_text_size)
		font_size = biggest_font;
	else
	{
		double limits[3] = {	0, biggest_font, 0 };
		// Połowienie przedziałów
		int pre_size = 0; 
		int curr_size = 0;
		// Rozmiar w poprzednim przebiegu musi być sprawdzany,
		// gdyż dla małych czcionek rozmiar napisu przestaje się
		// zmniejszać
		do
		{
			limits[2] = limits[0] + ((limits[1] - limits[0]) / 2); 
			/*char *err = */gdImageStringFT(NULL, bl_size, 0, font, limits[2],
				0., 0, 0, text_s);
			if ((bl_size[2] - bl_size[0]) < max_text_size)
			{
				limits[0] = limits[2];
				std::cout << "Za malo!" << std::endl;
			}
			else
				if ((bl_size[2] - bl_size[0]) > max_text_size)
				{
					limits[1] = limits[2];
					std::cout << "Za duzo!" << std::endl;
				}
			
			pre_size = curr_size;
			curr_size =	bl_size[2] - bl_size[0];
			std::cout << "Max text size: " << max_text_size << std::endl;
			std::cout << "Curr size: " << (bl_size[2] - bl_size[0]) << std::endl;
			std::cout << "Limits: " << limits[0] << " " << limits[1] << " " << limits[2] << std::endl;				
		} while (((bl_size[2] - bl_size[0]) != max_text_size) &&
							(pre_size != curr_size));
		font_size = static_cast<double>(limits[2]);
	}
	
	
	char *err = gdImageStringFT(NULL, bl_size, 0, font, font_size, 
			0., 0, 0, text_s);
			
	if (err)
		std::cout << err << std::endl;
	
	margins[0] = (image->sy * margins[0]) / 200;
	margins[1] = (image->sx * margins[1]) / 200;
	margins[2] = (image->sy * margins[2]) / 200;
	margins[3] = (image->sx * margins[3]) / 200;
	// Wyliczenie polozenia tekstu
	int y;
	if (border[0] > -1)
		// Ustawiamy pozycję od góry
		y = (border[0] * image->sy) / 100 - (margins[0]+margins[2]);
	else 
		// Pozycja od dołu
		y = image->sy - ((border[2] * image->sy) / 100) - (bl_size[1] - bl_size[7]) - (margins[0]+margins[2]);
	int x;
	if (border[3] > -1)
		// Ustawiamy pozycję od prawej
		x = (border[3] * image->sx) / 100 - (margins[1] + margins[3]);
	else
		// pozycja od prawej
		x = image->sx - ((border[1] * image->sx) / 100) - (bl_size[2] - bl_size[0])  - (margins[1] + margins[3]);
	
	for (int i = 0; i < 8; i++)
		std::cout << bl_size[i] << std::endl;
	std::cout << x << " : " << y << std::endl;
	
	int opacity_factor = (opacity * 127) / 100;
	int font_opacity_factor = (font_opacity * 127) / 100;
	int text_color = gdImageColorResolveAlpha(image, font_color[0], font_color[1], font_color[2],font_opacity_factor);
	int back_color = gdImageColorResolveAlpha(image, color[0],color[1],color[2],opacity_factor);
		
	gdImageFilledRectangle(
			image, 
			x, //image->sx - right - (bl_size[4] - bl_size[6]), 
			y, //image->sy - down - (bl_size[1] - bl_size[7]),
			x + (bl_size[2] - bl_size[0]) + margins[1] + margins[3],
			y + (bl_size[1] - bl_size[7]) + margins[0] + margins[2],
			back_color);
	
	std::cout << x << " : " << y << std::endl;
	gdImageStringFT(image, bl_size2, text_color, font, font_size, 0., 
						 x - bl_size[0] + margins[3], //image->sx - right - (bl_size[4] - bl_size[6]),
						 y /*+ (bl_size[1] */- bl_size[7] + margins[0], //image->sy - down - bl_size[3],
						 text_s);
}

Image::Image( Image & new_im )
{
	std::cout << "W konstruktorze kopiujacym" << std::endl;

   operator=( new_im );
   
	std::cout << "Koniec konstruktora kopiujacego" << std::endl;
}

ImageFormat Image::getImageFormat( ) const
{
	return image_format;
}

gdImagePtr Image::getImage() const
{
	if (image)
		return image;
	else
		return 0;
}

bool Image::isCreated( ) const
{
	return created;
}

void Image::setImageFormat( const ImageFormat format )
{
	image_format = format;
}

gdImagePtr Image::newImage( int x, int y )
{
   gdImagePtr temp_image = gdImageCreateTrueColor(x, y);
   
   temp_image->alphaBlendingFlag = 1;
   temp_image->saveAlphaFlag = 1;
   
   int color = gdTrueColorAlpha(255, 255, 255, 127);
   
   int width = temp_image->sx;
   int height = temp_image->sy;
   
   clock_t start = clock();
   for ( int i = 0; i < height; i++ )
      for ( int j = 0; j < width; j++ )
   {
      temp_image->tpixels[i][j] = color;
   }
   // std::cout << (double)( clock() - start ) / (double)CLOCKS_PER_SEC;
/*   int transparent = gdTrueColorAlpha(0,0,0,127);
   //gdImageAlphaBlending(temp_image, 1);
   for (int i = 0; i < x; i++)
      for (int j = 0; j < y; j++)
   {
      gdImageSetPixel(temp_image, x, y, transparent);
}*/
 //  gdImageColorTransparent(temp_image, black);
//   int trans_color = gdImageColorAllocateAlpha(temp_image, 255, 0, 0, 95);
//   gdImageFilledRectangle(temp_image, 0, 0, x, y, trans_color);
   
   return temp_image;
}

void Image::paste_other_image( const std::string file_path, int width, int height, int left, int right, int                                  top, int bottom, int opacity )
{
   std::cout << "W paste_other_image (..)" << std::endl;
   Image other_im;
   
   try
   {
      std::cout << "file_path :" << file_path << std::endl;
      other_im.load_from_file( file_path );
      
      // Transforming width and height into px
      width = width * ( getImage()->sx / 100 );
      height = height * ( getImage()->sy / 100 );
      
      int target_width, target_height;
      final_dimensions ( width, height, other_im.getImage()->sx, other_im.getImage()->sy,
                         target_width, target_height );
      
      std::cout << "After final_dimensions()" << file_path << std::endl;
      //QMessageBox::warning( 0, QString(), QString( "Waiting" ), 
      //                      QMessageBox::Ok, QMessageBox::Ok );

      
      // Calculate left or right, top or bottom
      if ( right > -1 )
      {
         right = (int) ( (double)right / 100. * getImage()->sx );
         left = (int) ( getImage()->sx - right - target_width );
      }
      else
      {
         left = (int) ( (double)left / 100. * getImage()->sx );
      }
      
      if ( bottom > -1 )
      {
         bottom = (int) ( (double)bottom / 100. * getImage()->sy );
         top = getImage()->sy - bottom - target_height;
      }
      else
      {
         top = (int) ( (double)top / 100. * getImage()->sy );
      }
      
      std::cout << "Before if (opacity > 0)" << std::endl;
      if ( opacity > 0 )
               // Change opacity value from percentage to value (0..127)
      {
         opacity = opacity * 127 / 100;
         
         gdImagePtr im = other_im.getImage();
         std::cout << "Alpha of point 0,0"<< gdImageAlpha(im, im->tpixels[0][0]) << std::endl;
         for ( int i = 0; i < im->sy; ++i )
         {
            for ( int j = 0; j < im->sx; ++j )
            
            {
            int alpha = gdImageAlpha(im, im->tpixels[i][j]);
           
            if ( alpha + opacity > 127 )
               alpha = 127;
            else
               alpha += opacity;
            
            
            if ( ( alpha > 127 ) || ( alpha < 0 ) )
               std::cout << "ASERCJA ALFY NIE SPELNIONA!!" << std::endl;
            
            im->tpixels[i][j] = gdTrueColorAlpha( gdImageRed( im, im->tpixels[i][j] ),
                  gdImageGreen( im, im->tpixels[i][j] ),
                  gdImageBlue( im, im->tpixels[i][j] ),
                  alpha );
            }
            std::cout << "Po " << i << " rzedzie." << std::endl;
         }
         
      }
      
      std::cout << "Paste!!" << std::endl;
      
      gdImageCopyResampled(
            getImage(),
            other_im.getImage(),
            left, top,
            0, 0,
            target_width, target_height,
            other_im.getImage()->sx, other_im.getImage()->sy
                          );
      
      std::cout << "After Paste!!" << std::endl;
   }
   catch ( ImageError e )
   {
      throw e;
   }
   
   
}

void Image::final_dimensions( int max_width, int max_height, int im_width,
                              int im_height, int & final_width, int & final_height ) const
{
   if ((max_width == 0) && (max_height == 0))
   {
      final_width = im_width;
      final_height = im_height;
      return ;
   }
   float ratio;
   if (max_width == 0)
   {
      ratio = static_cast<float>(max_height) / static_cast<float>(im_height);
   }
   else
      if (max_height == 0)
   {
      ratio = static_cast<float>(max_width) / static_cast<float>(im_width);
   }
   else
   {
      float ratio_x = 
            static_cast<float>(max_width) / static_cast<float>(im_width);
      float ratio_y = 
            ratio = static_cast<float>(max_height) / static_cast<float>(im_height);
				
      (ratio_x<=ratio_y) ? ratio=ratio_x : ratio=ratio_y;
   }
	
   final_width = static_cast<int>(ratio * im_width);
   final_height = static_cast<int>(ratio * im_height);
}

Image & Image::operator =( const Image &new_im )
{
   if (new_im.isCreated())
   {
      std::cout << "Kopiuje" << std::endl;
      image_format = new_im.getImageFormat();
      std::cout << "Format" << std::endl;
      image = newImage(new_im.getImage()->sx, new_im.getImage()->sy);
      std::cout << "Stworzylem" << std::endl;
      gdImageCopy(image, new_im.getImage(), 0, 0, 0, 0, image->sx, image->sy);
      std::cout << "Skopiowalem" << std::endl;

      created = true;
   }
   else
      created = false;
   
   return *this;
}
