//
// C++ Implementation: additionalimages
//
// Description: 
//
//
// Author: Kacper <kazjote@stud.ics.p.lodz.pl>, (C) 2006
//
// Copyright: See COPYING file that comes with this distribution
//
//
#include "additionalimages.h"
#include "image.h"

#include <QComboBox>
#include <QSpinBox>
#include <QRadioButton>
#include <QFileDialog>
#include <QMessageBox>
#include <QLineEdit>
#include <QFileInfo>

#include <algorithm>
#include <vector>

additionalImages::additionalImages(QObject *parent,
                     QComboBox *imagesCombo,
                     QSpinBox *opacitySpin,
   
                     QRadioButton *lRadioButton,
                     QRadioButton *rRadioButton,
                     QRadioButton *tRadioButton,
                     QRadioButton *bRadioButton,
   
                     QComboBox *widthCombo,
                     QComboBox *heightCombo,
                                  
                     QSpinBox *leftPosSpin,
                     QSpinBox *rightPosSpin,
                     QSpinBox *topPosSpin,
                     QSpinBox *bottomPosSpin)
 : QObject(parent)
{
   this->imagesCombo = imagesCombo;
   this->opacitySpin = opacitySpin;
   
   this->lRadioButton = lRadioButton;
   this->rRadioButton = rRadioButton;
   this->bRadioButton = bRadioButton;
   this->tRadioButton = tRadioButton;
   
   this->widthCombo = widthCombo;
   this->heightCombo = heightCombo;
   
   this->leftPosSpin = leftPosSpin;
   this->rightPosSpin = rightPosSpin;
   this->topPosSpin = topPosSpin;
   this->bottomPosSpin = bottomPosSpin;
   
   allowActualisation = true;
   
   connect( imagesCombo, SIGNAL( currentIndexChanged( int ) ), this, SLOT( changeSelection( int ) ) );
}


additionalImages::~additionalImages()
{
}

void additionalImages::getOptions( std::vector<transOptions::additionalOptions> &options )
{
   options.clear();
   
   for ( std::vector<transOptions::additionalOptions>::iterator iter = images.begin();
         iter != images.end();
         ++iter
       )
   {
      options.push_back( *iter );
   }
}

void additionalImages::addImage( )
{
   allowActualisation = false;
   
   QStringList filePaths = QFileDialog::getOpenFileNames( 
         0, 
         QString( tr( "Choose files to open." ) ),
         lastDir,
         "Images (*.jpg *.jpeg *.gif *.png)"
                                                        );
   QStringList::Iterator iter = filePaths.begin();
   
   while ( iter != filePaths.end() )
   {
      // Prba wczytania obrazka!
      Image temp;
      try
      {
         temp.load_from_file( (*iter).toStdString() );
         
         // Pobranie sciezki katalogu 
         QFileInfo fileInfo( *iter );
         lastDir = fileInfo.dir().absolutePath();
         
         ImagesOptions iOptions;
#ifdef WIN32
         iOptions.path = fileInfo.absolutePath() + QString("\\") + fileInfo.fileName();
#else
         iOptions.path = fileInfo.absolutePath() + QString("/") + fileInfo.fileName();
#endif
         std::cout << "New file_path: " << iOptions.path.toStdString() << std::endl;
         iOptions.width = 10;
         iOptions.height = 10;
         iOptions.posLeft = 0;
         iOptions.posRight = -1;
         iOptions.posTop = 0;
         iOptions.posBottom = -1;
         iOptions.opacity = 0;
         
         images.push_back( iOptions );
         
         imagesCombo->addItem( fileInfo.fileName() );
      }
      catch ( ImageError )
      {
         std::cout << "Blad!!" << std::endl;
         
         QMessageBox::warning( 0, QString( tr( "Can't open file." ) ), QString( tr( "I can't open file %1. Its format is probably not supported." ) ).arg( *iter ), QMessageBox::Ok, QMessageBox::NoButton );
      }
      ++iter;
   }
   
   allowActualisation = true;
      
}

void additionalImages::delImage( )
{
   int index;
   
   if ( ( ( index = imagesCombo->currentIndex() ) > -1 ) && ( images.size() > (unsigned int)index ) )
   {
      imagesCombo->removeItem( index );
      std::vector<ImagesOptions>::iterator iter = images.begin();
      
      for (int i = 0; i < index; ++i )
         ++iter;
      
      images.erase( iter );
   }
}

void additionalImages::changeSelection( int pos )
{
   allowActualisation = false;
   
   pos = imagesCombo->currentIndex();
   if ( pos > -1 )
   {     
      // Wczytywanie ustawie do formy
      ImagesOptions &image = images.at( pos );
      opacitySpin->setValue( image.opacity );
      
      widthCombo->lineEdit()->setText( QString::number( image.width ) );
      heightCombo->lineEdit()->setText( QString::number( image.height ) );
      
      if ( image.posLeft > -1 )
      {
         lRadioButton->setChecked( true );
         leftPosSpin->setValue ( image.posLeft );
      }
      else
      {
         // image.posRight > -1
         rRadioButton->setChecked( true );
         rightPosSpin->setValue( image.posRight );
      }
      
      if ( image.posTop > -1 )
      {
         tRadioButton->setChecked( true );
         topPosSpin->setValue( image.posTop );
      }
      else
      {
         // image.posBottom > -1
         bRadioButton->setChecked( true );
         bottomPosSpin->setValue( image.posBottom );
      }
   }
   
   allowActualisation = true;
}

void additionalImages::actualizeWithGUI( )
{
   int pos = imagesCombo->currentIndex();
   std::cout << "AKTUALIZUJ!!" << std::endl;
   if ( ( pos > -1 ) && ( pos < images.size() ) && allowActualisation )
   {
      ImagesOptions &image = images.at( pos );
      
      image.width = widthCombo->lineEdit()->text().toInt();
      image.height = heightCombo->lineEdit()->text().toInt();
      
      image.posLeft = lRadioButton->isChecked() ? leftPosSpin->value() : -1;
      image.posRight = rRadioButton->isChecked() ? rightPosSpin->value() : -1;
      
      image.posTop = tRadioButton->isChecked() ? topPosSpin->value() : -1;
      image.posBottom = bRadioButton->isChecked() ? bottomPosSpin->value() : -1;
      
      image.opacity = opacitySpin->value();
   }
}



QDataStream & operator <<( QDataStream &wy, additionalImages &ai )
{
   wy << ai.images.size();
   
   for ( std::vector<transOptions::additionalOptions>::iterator iter = ai.images.begin();
         iter != ai.images.end(); ++iter )
   {
      wy << (*iter).path;
      wy << (*iter).width;
      wy << (*iter).height;
      wy << (*iter).posLeft;
      wy << (*iter).posRight;
      wy << (*iter).posTop;
      wy << (*iter).posBottom;
      wy << (*iter).opacity;
   }
   
   return wy;
}

QDataStream & operator >>( QDataStream &we, additionalImages &ai )
{
   
   while ( ai.imagesCombo->model()->rowCount() )
      ai.imagesCombo->model()->removeRow( 0 );
   
   ai.images.clear();
   
   int count; we >> count;
   
   bool go = true;
   
   for ( int i = 0; (i < count) && go; ++i )
   {
      QString path; 
      we >> path;
      
      bool can_open = false;
      
      // Try to open file.
      if ( QFileInfo( path ).exists() )
      {
         try
         {
            Image temp;
            temp.load_from_file( path.toStdString() );
            
            can_open = true;
         }
         catch ( ImageError e )
         {
            can_open = false;
            
            switch ( QMessageBox::question(
                     0, QString( QMessageBox::tr("File not found!") ),
            QString( QMessageBox::tr( "The required file %1 was not found on your computer. I can't load all settings. Do you want to choose different location for that file? If you choose NO it will be skipped" ) ).arg( path ),
            QMessageBox::Yes, QMessageBox::No, QMessageBox::Abort
                                          ) )
            {
               case QMessageBox::Yes:
                  do 
                  {
                     path = QFileDialog::getOpenFileName ( 
                           0, QString( QMessageBox::tr( "Choose image file." ) ), 
                           ai.lastDir, 
                           QString( QMessageBox::tr( "Images (*.jpg *.jpeg *.gif *.png)" ) )
                                                         );
                     if ( path != QString() )
                     {
                        try
                        {
                           Image temp;
                           temp.load_from_file( path.toStdString() );
            
                           can_open = true;
                        }
                        catch ( ImageError e ) 
                        {
                           QMessageBox::warning( 0, QString( QMessageBox::tr( "Can't open file." ) ), QString( QMessageBox::tr( "I can't open file %1. Its format is probably not supported. Choose different file instead." ) ).arg( path ), QMessageBox::Ok, QMessageBox::NoButton );
                        }
                     }                     
                  }
                  while ( path != QString() );
                  break;
                  
               case QMessageBox::No:
                  break;
                  
               case QMessageBox::Abort:
                  go = false;
                  break;
            }
         }
      }
      
      transOptions::additionalOptions options;
      options.path = path;
      we >> options.width;
      we >> options.height;
      we >> options.posLeft;
      we >> options.posRight;
      we >> options.posTop;
      we >> options.posBottom;
      we >> options.opacity;
      
      if ( can_open )
      {
         ai.images.push_back( options );
         
         QString fileName = QFileInfo( options.path ).fileName();
         ai.imagesCombo->addItem( fileName );
      }
   }
   return we;
}

