/*
  Copyright (C) 2008 Ben Asselstine
  Written by Ben Asselstine

  This file is part of fileschanged.

  fileschanged is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  fileschanged is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with fileschanged; if not, write to the Free Software
  Foundation, Inc., 51 Franklin Street, Fifth Floor Boston, MA 02110-1301  USA
*/
#include <string.h>
#include <stdlib.h>
#include "node.h"
#include "canonicalize.h"

void 
node_free(struct node_t *node)
{
  free (node->filename); node->filename = NULL;
  return;
}

int 
node_copy(struct node_t *dst, struct node_t *src)
{
  memcpy (dst, src, sizeof (struct node_t));
  dst->filename = strdup (src->filename);
  if (!dst->filename)
    return -1;
  return 0;
}

int 
node_new (struct node_t *node, char *filename, int deref_symlinks)
{
  int retval;
  if ((!node) || (!filename))
    return -1;
  memset (node, 0, sizeof (struct node_t));
  if (deref_symlinks)
    retval = stat (filename, &node->statbuf);
  else
    retval = lstat (filename, &node->statbuf);
  if (retval != 0)
    return -2;
  if (!S_ISLNK (node->statbuf.st_mode))
    node->filename = canonicalize_file_name (filename);
  else
    node->filename = strdup (filename);
  if (!node->filename)
    return -2;
  return 0;
}

int 
node_compare(struct node_t *n1, struct node_t *n2)
{
  if ((!n1) || (!n2))
    return 0;
  if ((!(n1->filename)) || (!(n2->filename)))
    return 0;
  return strcmp (n1->filename, n2->filename);
}

int 
node_is_empty(struct node_t *node)
{
  if (!(node->filename))
    return 1;
  return 0;
}
