/*
  Copyright (C) 2008 Ben Asselstine
  Written by Ben Asselstine

  This file is part of fileschanged.

  fileschanged is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  fileschanged is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with fileschanged; if not, write to the Free Software
  Foundation, Inc., 51 Franklin Street, Fifth Floor Boston, MA 02110-1301  USA
*/
#ifndef FILESCHANGED_HANDLERS_H
#define FILESCHANGED_HANDLERS_H
#include "fileschanged_priv.h"

struct handler_t
{
	enum fileschanged_action_enum_t id;
	int (*handler)(struct fileschanged_priv_t *f, enum fileschanged_action_enum_t id, char *filename, void *hook, int (*handler)(char *filename, enum fileschanged_action_enum_t action, void *hook));
};

int handle_event(struct fileschanged_priv_t *f, FAMEvent *e, time_t time_of_event, void *hook, int (*handler)(char *filename, enum fileschanged_action_enum_t action, void *hook));

#endif
