#ifndef TURENT_HH
#define TURENT_HH

#include <ClanLib/core.h>

class Tank;

class Turent
{
private:
  Tank* tank;

  CL_Surface sur;
  CL_Surface fire_sur;

  // The angle of the turent relative to the tank in radians
  float angle;

  bool fireing;
  int  reloading;
  int  reloading_speed;

public:
  Turent (Tank*, int reloading_speed, std::string, std::string);
  ~Turent ();

  void draw ();
  void update ();

  void increase_angle ();
  void decrease_angle ();
  void start_fire ();
  void stop_fire ();
  void set_angle (float angle);
};

#endif // TURENT_HH

// EOF
