/*
	Loads a single surface from a pcx file without using resource files.
*/

#include <ClanLib/png.h>
#include <ClanLib/core.h>

#include "KeyboardController.hh"
#include "JoystickController.hh"
#include "Tank.hh"
#include "Turent.hh"
#include "Tower.hh"

CL_ResourceManager* resources;

class SurfaceApp : public CL_ClanApplication
{
public:
  virtual char *get_title() { return "Surface application"; }
	
  CL_Surface load_surface()
  {
    return CL_Surface(new CL_PCXProvider("survivor.pcx", NULL), true);
  }
	
  virtual int main(int, char **)
  {
    try
      {
	CL_SetupCore::init();
	CL_SetupCore::init_display();
	CL_SetupPNG::init ();

	// Set mode: 320x200 16 bpp
	CL_Display::set_videomode(800, 600, 16, false);
	
	resources =  CL_ResourceManager::create("data/firepower.scr", false);

	Tank tank1 (35, "firepower/tank", "firepower/turent", "firepower/fire");
	Tank tank2 (5, "firepower/tank2", "firepower/turent2", "firepower/fire2");
	Tower tower (100.0, 100.0);
	JoystickController controller(&tank1);
	KeyboardController kcontroller (&tank2);

	// Loop until the user hits escape:
	while (CL_Keyboard::get_keycode(CL_KEY_ESCAPE) == false)
	  {	
	    CL_Display::clear_display (0.7, 0.7, 0.6);
	    
	    tank1.draw ();
	    tank2.draw ();
	    tower.draw ();
	    tank1.update ();
	    tank2.update ();
	    tower.update ();
	    controller.update ();
	    kcontroller.update ();

	    // Flip front and backbuffer. This makes the changes visible:
	    CL_Display::flip_display();
	    
	    // Update keyboard input and handle system events:
	    // Exits the loop if ClanLib requests shutdown - for instance if
	    // someone closes the window.
	    CL_System::keep_alive();
	  }

	CL_SetupPNG::deinit ();
	CL_SetupCore::deinit_display();
	CL_SetupCore::deinit();
      }
    catch (CL_Error err)
      {
	std::cout << "Error: " << err.message.c_str() << std::endl;
      }

    return 0;
  }
} app;

  // EOF 
