#include <iostream>
#include "Tank.hh"
#include "Turent.hh"

extern CL_ResourceManager* resources;

const float circle = 6.2831854;

Turent::Turent (Tank* arg_tank) :
  sur ("firepower/turent", resources)
{
  tank = arg_tank;
}

Turent::~Turent ()
{
}

void 
Turent::draw ()
{
  float absolute_angle = tank->get_angle () + angle;
  int frame = int(fmod (absolute_angle, circle) / circle * 16.0);
  
  sur.put_screen (tank->get_x_pos () - 50, tank->get_y_pos () - 50, frame);
}

void
Turent::update ()
{
}

void 
Turent::increase_angle ()
{
  angle += tank->get_increment ();
  angle = fmod (angle + circle, circle);
}

void Turent::decrease_angle ()
{
  angle -= tank->get_increment ();
  angle = fmod (angle + circle, circle);
}

void 
Turent::set_angle (float arg_angle)
{
  angle = arg_angle;
}

// EOF 
