#ifndef TANK_HH
#define TANK_HH

#include <ClanLib/core.h>
#include <deque>

class Turent;

class Tank 
{
private:
  float angle;
  float speed;
  float velocity;
  float x_pos;
  float y_pos;
  float increment;
  int   inc_step;
  int frame;
  CL_Surface sur;
  CL_Surface smod;
  Turent* turent;

  std::deque<CL_Vector> smodpos;
  float tmp_angle;
  int smod_step;

public:
  Tank ();
  ~Tank ();
  
  void draw ();
  void update ();

  void increase_angle ();
  void decrease_angle ();
  void set_angle (float);
  Turent* get_turent () { return turent; }

  float get_x_pos () { return x_pos; }
  float get_y_pos () { return y_pos; }
  float get_angle () { return angle; }
  float get_increment () { return increment; }

  void increase_velocity ();
  void decrease_velocity ();
};

#endif // TANK_HH

// EOF
