/*
	Loads a single surface from a pcx file without using resource files.
*/

#include <ClanLib/png.h>
#include <ClanLib/core.h>

#include "Tank.hh"
#include "Turent.hh"

CL_ResourceManager* resources;

class SurfaceApp : public CL_ClanApplication
{
public:
  virtual char *get_title() { return "Surface application"; }
	
  CL_Surface load_surface()
  {
    return CL_Surface(new CL_PCXProvider("survivor.pcx", NULL), true);
  }
	
  virtual int main(int, char **)
  {
    try
      {
	CL_SetupCore::init();
	CL_SetupCore::init_display();
	CL_SetupPNG::init ();

	CL_InputAxis* vel_axis = CL_Input::joysticks[0]->get_axis (1);
	CL_InputAxis* dir_axis = CL_Input::joysticks[0]->get_axis (0);

	CL_InputButton* left_t = CL_Input::joysticks[0]->get_button (7);
	CL_InputButton* right_t = CL_Input::joysticks[0]->get_button (6);

	// Set mode: 320x200 16 bpp
	CL_Display::set_videomode(640, 480, 16, false);
	
	resources =  CL_ResourceManager::create("data/firepower.scr", false);

	Tank tank;

	// Loop until the user hits escape:
	while (CL_Keyboard::get_keycode(CL_KEY_ESCAPE) == false)
	  {	
	    CL_Display::clear_display (0.7, 0.7, 0.6);
	    
	    if (CL_Keyboard::get_keycode (CL_KEY_LSHIFT))
	      {
		if (CL_Keyboard::get_keycode (CL_KEY_RIGHT))
		  tank.get_turent ()->increase_angle ();
		else if (CL_Keyboard::get_keycode (CL_KEY_LEFT))
		  tank.get_turent ()->decrease_angle ();
	      }
	    else
	      {
		if (dir_axis->get_pos () > 0.5)
		  tank.increase_angle ();
		else if (dir_axis->get_pos () < -0.5)
		  tank.decrease_angle ();
	      }

	    if (left_t->is_pressed ())
	      tank.get_turent ()->increase_angle ();
	    else if (right_t->is_pressed ())
	      tank.get_turent ()->decrease_angle ();

	    if (vel_axis->get_pos () < -0.5)
	      tank.increase_velocity ();
	    else if (vel_axis->get_pos () > 0.5)
	      tank.decrease_velocity ();

	    tank.draw ();
	    tank.update ();

	    // Flip front and backbuffer. This makes the changes visible:
	    CL_Display::flip_display();
	    
	    // Update keyboard input and handle system events:
	    // Exits the loop if ClanLib requests shutdown - for instance if
	    // someone closes the window.
	    CL_System::keep_alive();
	  }

	CL_SetupPNG::deinit ();
	CL_SetupCore::deinit_display();
	CL_SetupCore::deinit();
      }
    catch (CL_Error err)
      {
	std::cout << "Error: " << err.message.c_str() << std::endl;
      }

    return 0;
  }
} app;

  // EOF 
