/***************************************************************
 *                    simula+@metz.ensam.fr                    *
 *                   GNU/linux version 2.6.0                   *
 *            software under General Public License            *
 ***************************************************************
 * copyright © 2003,2004,2005,2006 CREUSE Emmanuel
 * copyright © 2011,2012 COLLARD Christophe
 * copyright © 2003,2004,2005,2006,2011,2012 Centre National de la Recherche Scientifique
 * copyright © 2003,2004,2005,2006 Laboratoire de Physique et Mécanique des Matériaux (LPMM - UMR 7554)
 * copyright © 2003,2004,2005,2006 Laboratoire de Mathématiques et ses Applications de Valenciennes (LAMAV - EA 4015)
 * copyright © 2011,2012 Centre d'Elaboration de Matériaux et d'Etudes Structurales (CEMES - CNRS)
 ***************************************************************/

/*
    tests-FEMOL++ belongs to Finite Element Method Object Libraries (FEMOL++)
    FEMOL++ is part of Simula+

    Simula+ is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    Simula+ is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Simula+; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/


#ifndef __cplusplus
#error Must use C++ for the type interface.
#endif

#if !defined(__IOSTREAM_H)
#include <iostream>
#endif

#if !defined(__STDIO_H)
#include <stdio.h>
#endif

#if !defined(__TIME_H)
#include <time.h>
#endif

#if !defined (__STDLIB_H)
#include <stdlib.h>
#endif

#if !defined (__CONVERT_TEST_H)
#include "meshes/convert-test.h"
#endif

#if !defined (__NODE_TEST_H)
#include "meshes/node-test.h"
#endif

#if !defined (__TRIANGLE_TEST_H)
#include "meshes/triangle-test.h"
#endif

#if !defined (__RECTANGLE_TEST_H)
#include "meshes/rectangle-test.h"
#endif

#if !defined (__TETRAHEDRON_TEST_H)
#include "meshes/tetrahedron-test.h"
#endif

#if !defined (__MESH_TEST_H)
#include "meshes/mesh-test.h"
#endif

#if !defined (__MESH_TRI_2D_TEST_H)
#include "meshes/mesh_tri_2d-test.h"
#endif

#if !defined (__P1C2D_TEST_H)
#include "elements/p1c2d-test.h"
#endif

#if !defined (__TETRAP0_TEST_H)
#include "elements/tetrap0-test.h"
#endif

#if !defined (__TETRART0_TEST_H)
#include "elements/tetraRT0-test.h"
#endif

#if !defined (__P1C3D_TEST_H)
#include "elements/p1c3d-test.h"
#endif

#if !defined (__P1NC2D_TEST_H)
#include "elements/p1nc2d-test.h"
#endif

#if !defined (__Q12D_TEST_H)
#include "elements/q12d-test.h"
#endif

#if !defined (__RT02D_TEST_H)
#include "elements/rt02d-test.h"
#endif
 
#if !defined (__P2C2D_TEST_H)
#include "elements/p2c2d-test.h"
#endif

using namespace std;
using namespace femol;


main()
{
  int detail, result; // parameter to write/hide test procedure
  clock_t start, end;
  clock_t start_main, end_main;

  result = 1;

  detail = 0;
  start = clock();
  if (detail)
    //=======================================================================
    cout << "--------------------------convert-------------------------- \n";
    //=======================================================================
  result *= test_convert(detail);
  end = clock();
  cout << "cpu time : " << (long double)(end-start)/CLOCKS_PER_SEC << endl;
  cout << endl;

  detail = 0;
  start = clock();
  if (detail)
    //=======================================================================
    cout << "----------------------------node--------------------------- \n";
    //=======================================================================
  result *= test_node (detail);
  end = clock();
  cout << "cpu time : " << (long double)(end-start)/CLOCKS_PER_SEC << endl;
  cout << endl;

  detail = 0;
  start = clock();
  if (detail)
    //=======================================================================
    cout << "-------------------------triangle-------------------------- \n";
    //=======================================================================
  result *= test_triangle (detail);
  end = clock();
  cout << "cpu time : " << (long double)(end-start)/CLOCKS_PER_SEC << endl;
  cout << endl;

  detail = 0;
  start = clock();
  if (detail)
    //=======================================================================
    cout << "-------------------------rectangle------------------------- \n";
    //=======================================================================
  result *= test_rectangle (detail);
  end = clock();
  cout << "cpu time : " << (long double)(end-start)/CLOCKS_PER_SEC << endl;
  cout << endl;

  detail = 0;
  start = clock();
  if (detail)
    //=======================================================================
    cout << "------------------------tetrahedron------------------------ \n";
    //=======================================================================
  result *= test_tetrahedron (detail);
  end = clock();
  cout << "cpu time : " << (long double)(end-start)/CLOCKS_PER_SEC << endl;
  cout << endl;

  detail = 0;
  start = clock();
  if (detail)
    //=======================================================================
    cout << "----------------------------mesh--------------------------- \n";
    //=======================================================================
  result *= test_mesh (detail);
  end = clock();
  cout << "cpu time : " << (long double)(end-start)/CLOCKS_PER_SEC << endl;
  cout << endl;

  detail = 0;
  start = clock();
  if (detail)
    //=======================================================================
    cout << "------------------------mesh_tri_2d------------------------ \n";
    //=======================================================================
  result *= test_mesh_tri_2d (detail);
  end = clock();
  cout << "cpu time : " << (long double)(end-start)/CLOCKS_PER_SEC << endl;
  cout << endl;

  detail = 0;
  start = clock();
  if (detail)
    //=======================================================================
    cout << "---------------------------p1c2d--------------------------- \n";
    //=======================================================================
  result *= test_p1c2d(detail);
  end = clock();
  cout << "cpu time : " << (long double)(end-start)/CLOCKS_PER_SEC << endl;
  cout << endl;

  detail = 0;
  start = clock();
  if (detail)
    //=======================================================================
    cout << "--------------------------tetrap0-------------------------- \n";
    //=======================================================================
  result *= test_tetrap0 (detail);
  end = clock();
  cout << "cpu time : " << (long double)(end-start)/CLOCKS_PER_SEC << endl;
  cout << endl;

  detail = 0;
  start = clock();
  if (detail)
    //=======================================================================
    cout << "-------------------------tetraRT0-------------------------- \n";
    //=======================================================================
  result *= test_tetraRT0 (detail);
  end = clock();
  cout << "cpu time : " << (long double)(end-start)/CLOCKS_PER_SEC << endl;
  cout << endl;

  detail = 0;
  start = clock();
  if (detail)
    //=======================================================================
    cout << "---------------------------p1c3d--------------------------- \n";
    //=======================================================================
  result *= test_p1c3d (detail);
  end = clock();
  cout << "cpu time : " << (long double)(end-start)/CLOCKS_PER_SEC << endl;
  cout << endl;

  detail = 0;
  start = clock();
  if (detail)
    //=======================================================================
    cout << "--------------------------p1nc2d--------------------------- \n";
    //=======================================================================
  result *= test_p1nc2d (detail);
  end = clock();
  cout << "cpu time : " << (long double)(end-start)/CLOCKS_PER_SEC << endl;
  cout << endl;

  detail = 0;
  start = clock();
  if (detail)
    //=======================================================================
    cout << "---------------------------q12d---------------------------- \n";
    //=======================================================================
  result *= test_q12d (detail);
  end = clock();
  cout << "cpu time : " << (long double)(end-start)/CLOCKS_PER_SEC << endl;
  cout << endl;

  detail = 0;
  start = clock();
  if (detail)
    //=======================================================================
    cout << "---------------------------rt02d--------------------------- \n";
    //=======================================================================
  result *= test_rt02d (detail);
  end = clock();
  cout << "cpu time : " << (long double)(end-start)/CLOCKS_PER_SEC << endl;
  cout << endl;

  detail = 0;
  start = clock();
  if (detail)
    //=======================================================================
    cout << "---------------------------p2c2d--------------------------- \n";
    //=======================================================================
  result *= test_p2c2d (detail);
  end = clock();
  cout << "cpu time : " << (long double)(end-start)/CLOCKS_PER_SEC << endl;
  cout << endl;

  cout << endl;

  end_main = clock();

  cout << "============================================================== \n";
  if (result) cout << green << "-------OK------------end of FEMOL++ tests------------OK-------" << reset;
  else cout << red << "-----FAILED----------end of FEMOL++ tests----------FAILED-----" << reset;
  cout << "============================================================== \n";

  cout<<"cpu time : " << (long double)(end_main-start_main)/CLOCKS_PER_SEC << endl;
}
