/***************************************************************
 *                    simula+@metz.ensam.fr                    *
 *                   GNU/linux version 2.6.0                   *
 *            software under General Public License            *
 ***************************************************************
 * copyright © 2003,2004,2005,2006 CREUSE Emmanuel
 * copyright © 2003 MERCIER Denis
 * copyright © 2011 COLLARD Christophe
 * copyright © 2003,2004,2005,2006,2011 Centre National de la Recherche Scientifique
 * copyright © 2003,2004,2005,2006 Arts et Métiers ParisTech
 * copyright © 2003,2004,2005,2006 Université de Valenciennes et du Hainaut Cambrésis
 * copyright © 2003,2004,2005,2006 Laboratoire de Physique et Mécanique des Matériaux (LPMM - UMR 7554)
 * copyright © 2003,2004,2005,2006 Laboratoire de Mathématiques et ses Applications de Valenciennes (LAMAV - EA 4015)
 * copyright © 2011 Centre d'Elaboration de Matériaux et d'Etudes Structurales (CEMES - CNRS)
 ***************************************************************/

/*
    convert-test belongs to Mathematical Object Libraries (FEMOL++)
    FEMOL++ is part of Simula+

    Simula+ is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    Simula+ is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Simula+; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/

#ifndef __cplusplus
#error Must use C++ for the type convert-test.
#endif

#if !defined(__NODE_TEST_H)
#define _node_test_h


#if !defined(__IOSTREAM_H)
#include <iostream>
#endif

#if !defined(__STDIO_H)
#include <stdio.h>
#endif

#if !defined (__STDLIB_H)
#include <stdlib.h>
#endif

#if !defined(__VECTORS_H)
#include "MOL++/vectors.h"
#endif

#if !defined(__CONVERT_H)
#include "FEMOL++/meshes/convert.h"
#endif

#if !defined(__AFFICHE_H)
#include "tests/affiche.h"
#endif

using namespace std;
using namespace femol;


//===========================
int test_convert (int detail)
//===========================
{
  int result=1;

  if (detail < 0) 
    { cout << "============================================================== \n";
      cout << blue << "                     convert test skipped" << reset;
      cout << "============================================================== \n";
      return result;
    }

  int resultloc = 1;
  int n1, n2, number_nodes1, number_nodes2, n;
  double x, y;
 
  //test for conversion NETGEN TETRA -> FORMAT3D TETRA
  make_conversion3dtetra<double> ("data/Convert_mesh_tools/From_Netgen/Tetra_meshes/file_output_tetra_netgen.dat", "converted_tetra.dat");

  //comparaison du fichier de sortie de "converted_tetra.dat" et de "file_input_tetra_simula.dat"
  ifstream file1 ("converted_tetra.dat");
  assert (!file1.fail());
  ifstream file2 ("data/Convert_mesh_tools/From_Netgen/Tetra_meshes/file_input_tetra_simula.dat");
  assert (!file2.fail());

  file1 >> n1;
  file2 >> n2;
  file1 >> number_nodes1;
  file2 >> number_nodes2;

  resultloc *= (!(abs (n1 - n2)  +  abs (number_nodes1 - number_nodes2)));

  for (int i=1; i<=number_nodes1; i++)
    for (int j=1; j<=4; j++)
      { file1 >> x;
	file2 >> y;
	resultloc *= abs (x - y)  <  epsilon;
      }

  file1 >> n1;
  file2 >> n2;

  resultloc *= !abs (n1 - n2);

  for (int i=1; i<=n1; i++)
    for (int j=1; j<=4; j++)
      { file1 >> x;
	file2 >> y;
	resultloc *= abs (x - y) < epsilon;
      }

  file1.close();
  file2.close();
  remove ("converted_tetra.dat");
  
  if (detail) affiche ("make_conversion3dtetra ", resultloc);
  else result *= resultloc;
  resultloc = 1;


  //-----------------------------------------------------------
  // test for conversion NETGEN TRI -> FORMAT2D TRI FOR L-SHAPE
  //-----------------------------------------------------------

  make_conversion2dtri<double> ("data/Convert_mesh_tools/From_Netgen/Triangle_meshes/LSHAPE/file_output_tri_netgen.dat", "converted_tri.dat", "lshape2d");
  ifstream file3 ("converted_tri.dat");
  assert (!file3.fail());
  ifstream file4 ("data/Convert_mesh_tools/From_Netgen/Triangle_meshes/LSHAPE/file_input_tri_simula.dat");
  assert (!file4.fail());

  file3 >> n1;
  file4 >> n2;
  file3 >> number_nodes1;
  file4 >> number_nodes2;

  resultloc *= !(abs (n1 - n2)  +  abs (number_nodes1 - number_nodes2));

  for (int i=1; i<=number_nodes1; i++)
    for (int j=1; j<=3; j++)
      { file3 >> x;
	file4 >> y;
	resultloc *= abs (x - y) < epsilon;
      }

  file3 >> n1;
  file4 >> n2;

  resultloc *= !abs (n1 - n2);

  for (int i=1; i<=n1; i++)
    for (int j=1; j<=3; j++)
      { file3 >> x;
	file4 >> y;
	resultloc *= abs (x - y) < epsilon;
      }

  file3.close ();
  file4.close ();
  remove ("converted_tri.dat");

  if (detail) affiche ("make_conversion2dtri for lshape", resultloc);
  else  result *= resultloc;


  //---------------------------------------------------------------
  // test for conversion NETGEN TRI -> FORMAT2D TRI FOR UNIT CIRCLE
  //---------------------------------------------------------------

  make_conversion2dtri<double> ("data/Convert_mesh_tools/From_Netgen/Triangle_meshes/UNITCIRCLE/file_output_tri_netgen.dat", "converted_tri.dat", "circle");
  ifstream file5 ("converted_tri.dat");
  assert (!file5.fail());
  ifstream file6 ("data/Convert_mesh_tools/From_Netgen/Triangle_meshes/UNITCIRCLE/file_input_tri_simula.dat");
  assert (!file6.fail());

  file5 >> n1;
  file6 >> n2;
  file5 >> number_nodes1;
  file6 >> number_nodes2;

  resultloc *= ! (abs (n1 - n2)  +  abs (number_nodes1 - number_nodes2));

  for (int i=1; i<=number_nodes1; i++)
    for (int j=1; j<=3; j++)
      { file5 >> x;
	file6 >> y;
	resultloc *= abs(x - y) < epsilon;
      }

  file5 >> n1;
  file6 >> n2;

  resultloc *= !abs (n1 - n2);

  for (int i=1; i<=n1; i++)
    for (int j=1; j<=3; j++)
      { file5 >> x;
	file6 >> y;
	resultloc *= abs (x - y) < epsilon;
      }

  file5.close ();
  file6.close ();
  remove ("converted_tri.dat");

  if (detail) affiche ("make_conversion2dtri for circle", resultloc);
  else result *= resultloc;

  resultloc=1;

  cout << "============================================================== \n";
  if (result) cout << green << "                     convert test passed" << reset;
  else cout << red << "                     convert test failed" << reset;
  cout << "============================================================== \n";

  return result;
}

#endif

