/***************************************************************
 *                    simula+@metz.ensam.fr                    *
 *                   GNU/linux version 2.6.0                   *
 *            software under General Public License            *
 ***************************************************************
 * copyright © 2005,2006 CREUSE Emmanuel
 * copyright © 2005,2006 SOUALEM Nadir
 * copyright © 2012 COLLARD Christophe
 * copyright © 2005,2006,2012 Centre National de la Recherche Scientifique
 * copyright © 2005,2006 Arts et Métiers ParisTech
 * copyright © 2005,2006 Université de Valenciennes et du Hainaut Cambrésis
 * copyright © 2005,2006 Laboratoire de Physique et Mécanique des Matériaux (LPMM - UMR 7554)
 * copyright © 2005,2006 Laboratoire de Mathématiques et ses Applications de Valenciennes (LAMAV - EA 4015)
 * copyright © 2012 Centre d'Elaboration de Matériaux et d'Etudes Structurales (CEMES - CNRS)
 ***************************************************************/

/*
    p1nc2d-test belongs to Mathematical Object Libraries (FEMOL++)
    FEMOL++ is part of Simula+

    Simula+ is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    Simula+ is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Simula+; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/

#ifndef __cplusplus
#error Must use C++ for the type p1nc2d-test
#endif

#if !defined(__P1NC2D_TEST_H)
#define _p1nc2d_test_h

#if !defined(__IOSTREAM_H)
#include <iostream>
#endif

#if !defined(__ASSERT_H)
#include <assert.h>
#endif

#if !defined(__TIME_H)
#include <time.h>
#endif

#if !defined(__VECTORS_H)
#include "MOL++/vectors.h"
#endif

#if !defined(__MATHS_H)
#include "MOL++/maths.h"
#endif

#if !defined(__MESH_TRI_2D_H)
#include "FEMOL++/meshes/mesh_tri_2d.h"
#endif

#if !defined(__TRIANGLE_H)
#include "FEMOL++/meshes/triangle.h"
#endif

#if !defined(__P1NC2D_H)
#include "FEMOL++/elements/p1nc2d.h"
#endif

#if !defined(__AFFICHE_H)
#include "affiche.h"
#endif


long double f_test_p1nc (long double x, long double y)
{
  return -exp(x) - exp(y);
}

long double u_test_p1nc (long double x, long double y)
{
  return exp(x) + exp(y);
}

long double dudx_test_p1nc (long double x, long double y)
{
  return exp(x);
}

long double dudy_test_p1nc (long double x, long double y)
{
  return exp(y);
}


using namespace std;
using namespace mol;
using namespace femol;


//==========================
int test_p1nc2d (int detail)
//==========================
{
int result=1;

  if (detail < 0) 
    { cout << "============================================================== \n";
      cout << blue << "                     p1nc2d test skipped" << reset;
      cout << "============================================================== \n";
      return result;
    }

  p1nc2d<long double> Th ("data/2.txt", "data/21.txt");
  p1nc2d<long double> Th2 ("data/22.txt");
  p1nc2d<long double> Uh ("data/8.txt", "data/81.txt");
  p1nc2d<long double> Uh2 ("data/82.txt");
  p1nc2d<long double> Th3, Th4, Uh3, Uh4;

  if (detail) affiche ("operator ==", Th == Th2  &&  Uh == Uh2  &&  !(Uh == Th));
  else result *= (Th == Th2  &&  Uh == Uh2  &&  !(Uh == Th));

  if (detail) affiche ("operator !=", Th != Uh  &&  !(Th != Th2));
  else result *= (Th != Uh  &&  !(Th != Th2));

  p1nc2d<long double> Vh (Uh);
  if (detail) affiche ("copy constructor", Vh == Uh);
  else result *= (Vh == Uh);

  Th3 = Th;
  Th4 = Th2;
  Uh3 = Uh;
  Uh4 = Uh2;
  if (detail) affiche ("operator =", Th==Th3 && Th4==Th2 && Uh==Uh3 && Uh4==Uh2);
  else result *= (Th==Th3 && Th4==Th2 && Uh==Uh3 && Uh4==Uh2);

  matrix<long double> MASS (3,3);
  MASS(1,1) = 1./6.;
  MASS(2,2) = 1./6.;
  MASS(3,3) = 1./6.;

  if (detail) affiche ("RefMassMatrix", MASS == Uh.RefMassMatrix());
  else result *= (MASS == Uh.RefMassMatrix());

  if (detail) affiche ("DofNumber", 3 == Uh.DofNumber());
  else result *= (3 == Uh.DofNumber());

  if (detail) affiche ("GlobalDofNumber", 208 == Uh.GlobalDofNumber());
  else result *= (208 == Uh.GlobalDofNumber());

  if (detail) affiche ("SetOfEdges", Uh.SetOfEdges() == Uh2.SetOfEdges());
  else result *= (Uh.SetOfEdges() == Uh2.SetOfEdges());

  if (detail) affiche ("Type_of_edge", Uh.Type_of_edge() == Uh2.Type_of_edge());
  else result *= (Uh.Type_of_edge() == Uh2.Type_of_edge());

  if (detail) affiche ("EdgesPerTriangle", Uh.EdgesPerTriangle() == Uh2.EdgesPerTriangle());
  else result *= (Uh.EdgesPerTriangle() == Uh2.EdgesPerTriangle());

  if (detail) affiche ("operator ()", Uh(43,1) == Uh2(43,1)  &&  Uh(43,1)  &&  Uh(23,3) == Uh2(23,3)  &&  Uh(23,3)  &&  Uh(17,2) == Uh2(17,2)  &&  Uh(17,2));
  else result *= (Uh(43,1) == Uh2(43,1)  &&  Uh(43,1)  &&  Uh(23,3) == Uh2(23,3)  &&  Uh(23,3)  &&  Uh(17,2) == Uh2(17,2)  &&  Uh(17,2));

  if (detail) affiche ("LocalMassMatrix", Uh.LocalMassMatrix(1) == (long double)(1./64.) * Uh.RefMassMatrix());
  else result *= (Uh.LocalMassMatrix(1) == (long double)(1./64.)*Uh.RefMassMatrix());

  int NbIntPts = 10;
  matrix<long double> m (Uh.GlobalDofNumber(), Uh.GlobalDofNumber());
  vector<long double> b (Uh.GlobalDofNumber());
  long double epsilon_loc = 1e-10;
  int boolean = 1;

  m(1,1) = 4; m(1,3) = -2; m(1,82) = -2;
  m(2,2) = 4; m(2,3) = -2; m(2,59) = -2;
  m(3,1) = -2; m(3,2) = -2; m(3,3) = 8; m(3,184) = -2;
  m(4,4) = 1;
  m(5,5) = 4; m(5,6) = -2; m(5,129) = -2;
  m(6,5) = -2; m(6,6) = 8; m(6,92) = -2; m(6,93) = -2;
  m(7,7) = 4; m(7,9) = -2; m(7,68) = -2;
  m(8,8) = 4; m(8,9) = -2; m(8,10) = -2;
  m(9,7) = -2; m(9,8) = -2; m(9,9) = 8; m(9,57) = -2; m(9,100) = -2;
  m(10,8) = -2; m(10,10) = 8; m(10,11) = -2; m(10,17) = -2; m(10,110) = -2;
  m(11,10) = -2; m(11,11) = 4; m(11,167) = -2;
  m(12,12) = 4; m(12,13) = -2; m(12,16) = -2;
  m(13,12) = -2; m(13,13) = 8; m(13,14) = -2; m(13,168) = -2; m(13,187) = -2;
  m(14,13) = -2; m(14,14) = 4; m(14,111) = -2;
  m(15,15) = 4; m(15,16) = -2; m(15,68) = -2;
  m(16,12) = -2; m(16,15) = -2; m(16,16) = 8; m(16,17) = -2; m(16,43) = -2;
  m(17,10) = -2; m(17,16) = -2; m(17,17) = 4;
  m(18,18) = 4; m(18,19) = -2; m(18,111) = -2;
  m(19,18) = -2; m(19,19) = 8; m(19,20) = -2; m(19,170) = -2;
  m(20,19) = -2; m(20,20) = 4; m(20,54) = -2;
  m(21,21) = 4; m(21,22) = -2; m(21,172) = -2;
  m(22,21) = -2; m(22,22) = 8; m(22,23) = -2; m(22,44) = -2; m(22,125) = -2;
  m(23,22) = -2; m(23,23) = 4; m(23,95) = -2;
  m(24,24) = 4; m(24,26) = -2; m(24,28) = -2;
  m(25,25) = 4; m(25,26) = -2; m(25,49) = -2;
  m(26,24) = -2; m(26,25) = -2; m(26,26) = 8; m(26,177) = -2;
  m(27,27) = 1;
  m(28,24) = -2; m(28,28) = 8; m(28,148) = -2; m(28,173) = -2;
  m(29,29) = 4; m(29,31) = -2; m(29,99) = -2;
  m(30,30) = 4; m(30,31) = -2; m(30,109) = -2;
  m(31,29) = -2; m(31,30) = -2; m(31,31) = 8; m(31,190) = -2; m(31,196) = -2;
  m(32,32) = 4; m(32,34) = -2; m(32,143) = -2;
  m(33,33) = 1;
  m(34,32) = -2; m(34,34) = 8; m(34,39) = -2;
  m(35,35) = 4; m(35,36) = -2; m(35,124) = -2;
  m(36,35) = -2; m(36,36) = 8; m(36,37) = -2; m(36,78) = -2; m(36,79) = -2;
  m(37,36) = -2; m(37,37) = 4; m(37,45) = -2;
  m(38,38) = 4; m(38,40) = -2; m(38,104) = -2;
  m(39,34) = -2; m(39,39) = 4; m(39,40) = -2;
  m(40,38) = -2; m(40,39) = -2; m(40,40) = 8; m(40,159) = -2;
  m(41,41) = 4; m(41,42) = -2; m(41,149) = -2;
  m(42,41) = -2; m(42,42) = 8; m(42,43) = -2; m(42,152) = -2; m(42,153) = -2;
  m(43,16) = -2; m(43,42) = -2; m(43,43) = 4;
  m(44,22) = -2; m(44,44) = 4; m(44,45) = -2;
  m(45,37) = -2; m(45,44) = -2; m(45,45) = 8; m(45,46) = -2; m(45,185) = -2;
  m(46,45) = -2; m(46,46) = 4; m(46,164) = -2;
  m(47,47) = 4; m(47,49) = -2; m(47,95) = -2;
  m(48,48) = 4; m(48,49) = -2; m(48,86) = -2;
  m(49,25) = -2; m(49,47) = -2; m(49,48) = -2; m(49,49) = 8; m(49,69) = -2;
  m(50,50) = 4; m(50,51) = -2; m(50,147) = -2;
  m(51,50) = -2; m(51,51) = 8; m(51,52) = -2; m(51,162) = -2; m(51,204) = -2;
  m(52,51) = -2; m(52,52) = 4; m(52,145) = -2;
  m(53,53) = 4; m(53,54) = -2; m(53,84) = -2;
  m(54,20) = -2; m(54,53) = -2; m(54,54) = 8; m(54,55) = -2;
  m(55,54) = -2; m(55,55) = 4; m(55,143) = -2;
  m(56,56) = 4; m(56,58) = -2; m(56,63) = -2;
  m(57,9) = -2; m(57,57) = 4; m(57,58) = -2;
  m(58,56) = -2; m(58,57) = -2; m(58,58) = 8; m(58,64) = -2; m(58,185) = -2;
  m(59,2) = -2; m(59,59) = 8; m(59,60) = -2; m(59,118) = -2; m(59,191) = -2;
  m(60,59) = -2; m(60,60) = 4; m(60,124) = -2;
  m(61,61) = 4; m(61,63) = -2; m(61,145) = -2;
  m(62,62) = 4; m(62,63) = -2; m(62,68) = -2;
  m(63,56) = -2; m(63,61) = -2; m(63,62) = -2; m(63,63) = 8; m(63,79) = -2;
  m(64,58) = -2; m(64,64) = 4; m(64,66) = -2;
  m(65,65) = 4; m(65,66) = -2; m(65,102) = -2;
  m(66,64) = -2; m(66,65) = -2; m(66,66) = 8; m(66,126) = -2; m(66,127) = -2;
  m(67,67) = 4; m(67,68) = -2; m(67,149) = -2;
  m(68,7) = -2; m(68,15) = -2; m(68,62) = -2; m(68,67) = -2; m(68,68) = 8;
  m(69,49) = -2; m(69,69) = 4; m(69,71) = -2;
  m(70,70) = 4; m(70,71) = -2; m(70,74) = -2;
  m(71,69) = -2; m(71,70) = -2; m(71,71) = 8; m(71,194) = -2;
  m(72,72) = 4; m(72,74) = -2; m(72,86) = -2;
  m(73,73) = 4; m(73,74) = -2; m(73,115) = -2;
  m(74,70) = -2; m(74,72) = -2; m(74,73) = -2; m(74,74) = 8;
  m(75,75) = 4; m(75,77) = -2; m(75,122) = -2;
  m(76,76) = 4; m(76,77) = -2; m(76,87) = -2;
  m(77,75) = -2; m(77,76) = -2; m(77,77) = 8; m(77,181) = -2;
  m(78,36) = -2; m(78,78) = 4; m(78,119) = -2;
  m(79,36) = -2; m(79,63) = -2; m(79,79) = 4;
  m(80,80) = 4; m(80,82) = -2; m(80,97) = -2;
  m(81,81) = 4; m(81,82) = -2; m(81,133) = -2;
  m(82,1) = -2; m(82,80) = -2; m(82,81) = -2; m(82,82) = 8;
  m(83,83) = 4; m(83,84) = -2; m(83,167) = -2;
  m(84,53) = -2; m(84,83) = -2; m(84,84) = 8; m(84,85) = -2; m(84,112) = -2;
  m(85,84) = -2; m(85,85) = 4; m(85,104) = -2;
  m(86,48) = -2; m(86,72) = -2; m(86,86) = 8; m(86,165) = -2; m(86,166) = -2;
  m(87,76) = -2; m(87,87) = 8; m(87,144) = -2; m(87,159) = -2;
  m(88,88) = 1;
  m(89,89) = 4; m(89,90) = -2; m(89,97) = -2;
  m(90,89) = -2; m(90,90) = 8; m(90,91) = -2; m(90,203) = -2;
  m(91,90) = -2; m(91,91) = 4; m(91,133) = -2;
  m(92,6) = -2; m(92,92) = 4; m(92,140) = -2;
  m(93,6) = -2; m(93,93) = 4; m(93,163) = -2;
  m(94,94) = 4; m(94,95) = -2; m(94,164) = -2;
  m(95,23) = -2; m(95,47) = -2; m(95,94) = -2; m(95,95) = 8; m(95,148) = -2;
  m(96,96) = 1;
  m(97,80) = -2; m(97,89) = -2; m(97,97) = 8;
  m(98,98) = 4; m(98,99) = -2; m(98,129) = -2;
  m(99,29) = -2; m(99,98) = -2; m(99,99) = 8; m(99,105) = -2;
  m(100,9) = -2; m(100,100) = 4; m(100,102) = -2;
  m(101,101) = 4; m(101,102) = -2; m(101,167) = -2;
  m(102,65) = -2; m(102,100) = -2; m(102,101) = -2; m(102,102) = 8; m(102,120) = -2;
  m(103,103) = 4; m(103,104) = -2; m(103,114) = -2;
  m(104,38) = -2; m(104,85) = -2; m(104,103) = -2; m(104,104) = 8; m(104,117) = -2;
  m(105,99) = -2; m(105,105) = 4; m(105,106) = -2;
  m(106,105) = -2; m(106,106) = 8; m(106,107) = -2;
  m(107,106) = -2; m(107,107) = 4; m(107,109) = -2;
  m(108,108) = 1;
  m(109,30) = -2; m(109,107) = -2; m(109,109) = 8; m(109,156) = -2;
  m(110,10) = -2; m(110,110) = 4; m(110,111) = -2;
  m(111,14) = -2; m(111,18) = -2; m(111,110) = -2; m(111,111) = 8; m(111,112) = -2;
  m(112,84) = -2; m(112,111) = -2; m(112,112) = 4;
  m(113,113) = 4; m(113,114) = -2; m(113,167) = -2;
  m(114,103) = -2; m(114,113) = -2; m(114,114) = 8; m(114,121) = -2; m(114,144) = -2;
  m(115,73) = -2; m(115,115) = 8; m(115,181) = -2; m(115,186) = -2;
  m(116,116) = 1;
  m(117,104) = -2; m(117,117) = 4; m(117,143) = -2;
  m(118,59) = -2; m(118,118) = 4; m(118,119) = -2;
  m(119,78) = -2; m(119,118) = -2; m(119,119) = 8; m(119,137) = -2; m(119,138) = -2;
  m(120,102) = -2; m(120,120) = 4; m(120,122) = -2;
  m(121,114) = -2; m(121,121) = 4; m(121,122) = -2;
  m(122,75) = -2; m(122,120) = -2; m(122,121) = -2; m(122,122) = 8; m(122,130) = -2;
  m(123,123) = 4; m(123,124) = -2; m(123,179) = -2;
  m(124,35) = -2; m(124,60) = -2; m(124,123) = -2; m(124,124) = 8; m(124,125) = -2;
  m(125,22) = -2; m(125,124) = -2; m(125,125) = 4;
  m(126,66) = -2; m(126,126) = 4; m(126,164) = -2;
  m(127,66) = -2; m(127,127) = 4; m(127,131) = -2;
  m(128,128) = 1;
  m(129,5) = -2; m(129,98) = -2; m(129,129) = 8; m(129,189) = -2;
  m(130,122) = -2; m(130,130) = 4; m(130,131) = -2;
  m(131,127) = -2; m(131,130) = -2; m(131,131) = 8; m(131,166) = -2; m(131,186) = -2;
  m(132,132) = 4; m(132,133) = -2; m(132,147) = -2;
  m(133,81) = -2; m(133,91) = -2; m(133,132) = -2; m(133,133) = 8; m(133,191) = -2;
  m(134,134) = 1;
  m(135,135) = 8; m(135,177) = -2; m(135,194) = -2;
  m(136,136) = 1;
  m(137,119) = -2; m(137,137) = 4; m(137,147) = -2;
  m(138,119) = -2; m(138,138) = 4; m(138,145) = -2;
  m(139,139) = 1;
  m(140,92) = -2; m(140,140) = 8; m(140,200) = -2; m(140,204) = -2;
  m(141,141) = 1;
  m(142,142) = 1;
  m(143,32) = -2; m(143,55) = -2; m(143,117) = -2; m(143,143) = 8;
  m(144,87) = -2; m(144,114) = -2; m(144,144) = 4;
  m(145,52) = -2; m(145,61) = -2; m(145,138) = -2; m(145,145) = 8; m(145,146) = -2;
  m(146,145) = -2; m(146,146) = 4; m(146,149) = -2;
  m(147,50) = -2; m(147,132) = -2; m(147,137) = -2; m(147,147) = 8; m(147,161) = -2;
  m(148,28) = -2; m(148,95) = -2; m(148,148) = 4;
  m(149,41) = -2; m(149,67) = -2; m(149,146) = -2; m(149,149) = 8; m(149,150) = -2;
  m(150,149) = -2; m(150,150) = 4; m(150,163) = -2;
  m(151,151) = 1;
  m(152,42) = -2; m(152,152) = 4; m(152,155) = -2;
  m(153,42) = -2; m(153,153) = 4; m(153,188) = -2;
  m(154,154) = 4; m(154,155) = -2; m(154,163) = -2;
  m(155,152) = -2; m(155,154) = -2; m(155,155) = 8; m(155,189) = -2; m(155,190) = -2;
  m(156,109) = -2; m(156,156) = 4; m(156,158) = -2;
  m(157,157) = 1;
  m(158,156) = -2; m(158,158) = 8; m(158,192) = -2; m(158,193) = -2;
  m(159,40) = -2; m(159,87) = -2; m(159,159) = 4;
  m(160,160) = 1;
  m(161,147) = -2; m(161,161) = 4; m(161,201) = -2;
  m(162,51) = -2; m(162,162) = 4; m(162,163) = -2;
  m(163,93) = -2; m(163,150) = -2; m(163,154) = -2; m(163,162) = -2; m(163,163) = 8;
  m(164,46) = -2; m(164,94) = -2; m(164,126) = -2; m(164,164) = 8; m(164,165) = -2;
  m(165,86) = -2; m(165,164) = -2; m(165,165) = 4;
  m(166,86) = -2; m(166,131) = -2; m(166,166) = 4;
  m(167,11) = -2; m(167,83) = -2; m(167,101) = -2; m(167,113) = -2; m(167,167) = 8;
  m(168,13) = -2; m(168,168) = 4; m(168,169) = -2;
  m(169,168) = -2; m(169,169) = 8; m(169,170) = -2; m(169,193) = -2;
  m(170,19) = -2; m(170,169) = -2; m(170,170) = 4;
  m(171,171) = 1;
  m(172,21) = -2; m(172,172) = 8; m(172,173) = -2; m(172,180) = -2;
  m(173,28) = -2; m(173,172) = -2; m(173,173) = 4;
  m(174,174) = 1;
  m(175,175) = 1;
  m(176,176) = 1;
  m(177,26) = -2; m(177,135) = -2; m(177,177) = 4;
  m(178,178) = 1;
  m(179,123) = -2; m(179,179) = 8; m(179,180) = -2; m(179,184) = -2;
  m(180,172) = -2; m(180,179) = -2; m(180,180) = 4;
  m(181,77) = -2; m(181,115) = -2; m(181,181) = 4;
  m(182,182) = 1;
  m(183,183) = 1;
  m(184,3) = -2; m(184,179) = -2; m(184,184) = 4;
  m(185,45) = -2; m(185,58) = -2; m(185,185) = 4;
  m(186,115) = -2; m(186,131) = -2; m(186,186) = 4;
  m(187,13) = -2; m(187,187) = 4; m(187,188) = -2;
  m(188,153) = -2; m(188,187) = -2; m(188,188) = 8; m(188,192) = -2; m(188,196) = -2;
  m(189,129) = -2; m(189,155) = -2; m(189,189) = 4;
  m(190,31) = -2; m(190,155) = -2; m(190,190) = 4;
  m(191,59) = -2; m(191,133) = -2; m(191,191) = 4;
  m(192,158) = -2; m(192,188) = -2; m(192,192) = 4;
  m(193,158) = -2; m(193,169) = -2; m(193,193) = 4;
  m(194,71) = -2; m(194,135) = -2; m(194,194) = 4;
  m(195,195) = 1;
  m(196,31) = -2; m(196,188) = -2; m(196,196) = 4;
  m(197,197) = 1;
  m(198,198) = 1;
  m(199,199) = 1;
  m(200,140) = -2; m(200,200) = 4; m(200,201) = -2;
  m(201,161) = -2; m(201,200) = -2; m(201,201) = 8; m(201,203) = -2;
  m(202,202) = 1;
  m(203,90) = -2; m(203,201) = -2; m(203,203) = 4;
  m(204,51) = -2; m(204,140) = -2; m(204,204) = 4;
  m(205,205) = 1;
  m(206,206) = 1;
  m(207,207) = 1;
  m(208,208) = 1;

  b[1] = -0.024322559150619968305;
  b[2] = -0.022846424524872510715;
  b[3] = 9.3903714006573803302;
  b[4] = 4.2671121270931783335;
  b[5] = -0.020877294409267600263;
  b[6] = 8.5128491370613836083;
  b[7] = -0.016650349812482651053;
  b[8] = -0.015642129314296581926;
  b[9] = -0.016139952030002040734;
  b[10] = -0.015191704852171397246;
  b[11] = -0.014693882136465938435;
  b[12] = -0.015826882670208855664;
  b[13] = -0.015429384477535047774;
  b[14] = -0.014865277437331880667;
  b[15] = -0.016716634136980359351;
  b[16] = -0.016266209674855174674;
  b[17] = -0.015702102634652007564;
  b[18] = -0.013967174934029125666;
  b[19] = 5.08404421325805468;
  b[20] = -0.013118561294506056688;
  b[21] = -0.020554346224551766378;
  b[22] = -0.019811721833002310158;
  b[23] = -0.01931389911729685135;
  b[24] = -0.019987542942496096567;
  b[25] = -0.018769273849400995998;
  b[26] = 7.8294341110102296036;
  b[27] = 4.0851197696328415982;
  b[28] = 8.1498126693185407804;
  b[29] = -0.018769273849400996;
  b[30] = -0.01763894473702939509;
  b[31] = -0.018026649457851539766;
  b[32] = -0.011443606914238600425;
  b[33] = 2.0644944589178594297;
  b[34] = 8.2468850196810167281;
  b[35] = -0.020161898878332727402;
  b[36] = -0.019506535153006562497;
  b[37] = -0.018942428112803395384;
  b[38] = -0.012182102558878355281;
  b[39] = -0.011443606914238600426;
  b[40] = 4.4006291872069006762;
  b[41] = -0.017934207614617326262;
  b[42] = -0.017483783152492141579;
  b[43] = -0.016844566132521816768;
  b[44] = -0.019087394055648949969;
  b[45] = -0.018432030330322785063;
  b[46] = -0.017934207614617326255;
  b[47] = -0.018424147650525347652;
  b[48] = -0.017302321680498179585;
  b[49] = -0.018026649457851539763;
  b[50] = -0.021464583113352729672;
  b[51] = -0.020886226655686087578;
  b[52] = -0.020161898878332727402;
  b[53] = -0.013018927756198482179;
  b[54] = 4.7210077455152118535;
  b[55] = -0.012228809827734552995;
  b[56] = -0.017724854635166428475;
  b[57] = -0.016650349812482651058;
  b[58] = -0.017214456852685818161;
  b[59] = -0.022103800133323054483;
  b[60] = -0.021464583113352729672;
  b[61] = -0.018867318133036237679;
  b[62] = -0.017724854635166428487;
  b[63] = -0.018288961675369595588;
  b[64] = -0.016716634136980359351;
  b[65] = -0.015702102634652007568;
  b[66] = -0.016266209674855174672;
  b[67] = -0.017792813310352460252;
  b[68] = -0.017214456852685818156;
  b[69] = -0.017638944737029395083;
  b[70] = -0.016563826035858424729;
  b[71] = 6.4897814206132053046;
  b[72] = -0.016259253234349869999;
  b[73] = -0.015269245290561935015;
  b[74] = 5.9615664768540514019;
  b[75] = -0.013967174934029125664;
  b[76] = -0.013118561294506056684;
  b[77] = 5.08404421325805468;
  b[78] = -0.020084891610673204584;
  b[79] = -0.018867318133036237681;
  b[80] = -0.025789511319522784718;
  b[81] = -0.024226116027552035804;
  b[82] = 9.9185863444165342324;
  b[83] = -0.013804130669694434748;
  b[84] = -0.01340663247702062686;
  b[85] = -0.012967305472374307848;
  b[86] = -0.016646957955172014676;
  b[87] = 4.7210077455152118535;
  b[88] = 2.3668379411737963628;
  b[89] = -0.025789511319522784725;
  b[90] = 9.9185863444165342324;
  b[91] = -0.0242261160275520358;
  b[92] = -0.021885514907453669392;
  b[93] = -0.020554346224551766383;
  b[94] = -0.018139146877818306486;
  b[95] = -0.018863474655171666669;
  b[96] = 5.271871286521972109;
  b[97] = 21.060874863867944358;
  b[98] = -0.01998754294249609657;
  b[99] = 7.8294341110102296036;
  b[100] = -0.015642129314296581922;
  b[101] = -0.014693882136465938437;
  b[102] = -0.015191704852171397242;
  b[103] = -0.012967305472374307848;
  b[104] = -0.012569807279700499961;
  b[105] = -0.019202340029000143998;
  b[106] = 14.653879941774480543;
  b[107] = -0.018030778204761241143;
  b[108] = 3.2535347872132085447;
  b[109] = 6.4897814206132053046;
  b[110] = -0.014752377847525078235;
  b[111] = -0.014354879654851270343;
  b[112] = -0.01385705693914581154;
  b[113] = -0.013804130669694434747;
  b[114] = -0.013406632477020626861;
  b[115] = 5.4954184250877018214;
  b[116] = 2.7550546569602985573;
  b[117] = -0.012182102558878355281;
  b[118] = -0.021379472355969694302;
  b[119] = -0.020724108630643529388;
  b[120] = -0.014752377847525078232;
  b[121] = -0.013857056939145811541;
  b[122] = -0.014354879654851270344;
  b[123] = -0.021628851047235543809;
  b[124] = -0.020886226655686087583;
  b[125] = -0.020322119615482920474;
  b[126] = -0.016844566132521816768;
  b[127] = -0.01582688267020885566;
  b[128] = 4.0851197696328415982;
  b[129] = 8.1498126693185407804;
  b[130] = -0.014865277437331880669;
  b[131] = -0.015429384477535047773;
  b[132] = -0.022759163858649219397;
  b[133] = -0.023483491636002579575;
  b[134] = 3.7827762873769046649;
  b[135] = 14.653879941774480543;
  b[136] = 3.5535894580629268733;
  b[137] = -0.021379472355969694302;
  b[138] = -0.020084891610673204586;
  b[139] = 4.4733364854193437927;
  b[140] = 8.9242233488910307493;
  b[141] = 2.0644944589178594297;
  b[142] = 2.2062302494209807106;
  b[143] = 4.4006291872069006762;
  b[144] = -0.013018927756198482179;
  b[145] = -0.019506535153006562488;
  b[146] = -0.01894242811280339538;
  b[147] = -0.02210380013332305448;
  b[148] = -0.019606099046721122898;
  b[149] = -0.018432030330322785066;
  b[150] = -0.019087394055648949969;
  b[151] = 2.3668379411737963628;
  b[152] = -0.018139146877818306482;
  b[153] = -0.017044456147845822567;
  b[154] = -0.01931389911729685135;
  b[155] = -0.018863474655171666667;
  b[156] = -0.016563826035858424733;
  b[157] = 2.988737469582291831;
  b[158] = 5.9615664768540514019;
  b[159] = -0.012228809827734552996;
  b[160] = 2.2062302494209807106;
  b[161] = -0.022846424524872510715;
  b[162] = -0.020322119615482920472;
  b[163] = -0.019811721833002310154;
  b[164] = -0.017483783152492141572;
  b[165] = -0.017044456147845822564;
  b[166] = -0.016007740935201689867;
  b[167] = -0.014243457674340753757;
  b[168] = -0.015041679756712903094;
  b[169] = 5.4954184250877018214;
  b[170] = -0.014126781792692125815;
  b[171] = 4.2671121270931783335;
  b[172] = 8.5128491370613836083;
  b[173] = -0.020877294409267600256;
  b[174] = 3.7827762873769046649;
  b[175] = 3.5535894580629268733;
  b[176] = 3.924512077880025946;
  b[177] = -0.019202340029000144002;
  b[178] = 4.4733364854193437927;
  b[179] = 8.9242233488910307493;
  b[180] = -0.021885514907453669387;
  b[181] = -0.014126781792692125816;
  b[182] = 2.5488302986341330979;
  b[183] = 4.7070192980413370666;
  b[184] = -0.02302797840532347859;
  b[185] = -0.017792813310352460257;
  b[186] = -0.015041679756712903096;
  b[187] = -0.016007740935201689865;
  b[188] = -0.01664695795517201468;
  b[189] = -0.019606099046721122896;
  b[190] = -0.018424147650525347659;
  b[191] = -0.022759163858649219387;
  b[192] = -0.016259253234349869994;
  b[193] = -0.015269245290561935014;
  b[194] = -0.018030778204761241145;
  b[195] = 3.2535347872132085447;
  b[196] = -0.017302321680498179585;
  b[197] = 3.924512077880025946;
  b[198] = 2.7550546569602985573;
  b[199] = 4.7070192980413370666;
  b[200] = -0.023027978405323478587;
  b[201] = 9.3903714006573803302;
  b[202] = 4.9718166156722537804;
  b[203] = -0.024322559150619968308;
  b[204] = -0.021628851047235543809;
  b[205] = 4.9718166156722537804;
  b[206] = 5.271871286521972109;
  b[207] = 2.988737469582291831;
  b[208] = 2.5488302986341330979;

  matrix<long double> DuDv (Uh.GlobalDofNumber(), Uh.GlobalDofNumber());
  Uh.DUDV (DuDv);
  vector<long double> s = Uh.B (f_test_p1nc, NbIntPts);

  Uh.Dirichlet (DuDv, s, u_test_p1nc);

  for (int i=1; i<=Uh.GlobalDofNumber(); i++)
    boolean *= (abs (b[i] - s[i]) <= epsilon_loc);

  if (detail) affiche ("Integration right-hand side", boolean);
  else result *= boolean;

  boolean = 1;
  for (int i=1; i<=Uh.GlobalDofNumber(); i++)
    for (int j=1; j<=Uh.GlobalDofNumber(); j++)
      boolean *= (abs (m(i,j) - DuDv(i,j)) <= epsilon_loc);

  if (detail) affiche ("Stifness Matrix", boolean);
  else result *= boolean;

  long double l2_error_loc = 0.0016889241057298052747;
  long double semi_h1_error_loc = 0.07685901543172163326;

  vector<long double> x0 (s.dim());
  vector<long double> uh (s.dim());
  int iter;
  uh = conjugate_gradient (DuDv, s, x0, iter, 1.e-12);

  boolean = (abs (l2_error_loc - Uh.error_L2 (u_test_p1nc, uh, NbIntPts)) <= epsilon_loc);
  if (detail) affiche ("l2 error", boolean);
  else result *= boolean;

  boolean = (abs (semi_h1_error_loc - Uh.error_semi_H1 (dudx_test_p1nc, dudy_test_p1nc, uh, NbIntPts)) <= epsilon_loc);
  if (detail) affiche ("semi h1 error", boolean);
  else result *= boolean;

  cout << "============================================================== \n";
  if (result) cout << green << "                      p1nc2d test passed" << reset;
  else cout << red << "                      p1nc2d test failed" << reset;
  cout << "============================================================== \n";

  return result;
}


#endif
