/***************************************************************
 *                    simula+@metz.ensam.fr                    *
 *                   GNU/linux version 0.1.2                   *
 *            software under General Public License            *
 ***************************************************************
 * copyright  2003 CREUSE Emmanuel
 * copyright  Laboratoire de Physique et Mcanique des Matriaux (LPMM - UMR 7554)
 * copyright  Laboratoire de Mathmatiques et ses Applications de Valenciennes (LAMAV - EA 4015)
 ***************************************************************/

/*
    tetrahedre-test belongs to Mathematical Object Libraries (FEMOL++)
    FEMOL++ is part of Simula+

    Simula+ is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    Simula+ is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Simula+; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/

#ifndef __cplusplus
#error Must use C++ for the type triangle-test.
#endif

#if !defined(__TETRAHEDRE_TEST_H)
#define _tetrahedre_test_h

#if !defined(__IOSTREAM_H)
#include <iostream>
#endif

#if !defined(__STDIO_H)
#include <stdio.h>
#endif

#if !defined (__STDLIB_H)
#include <stdlib.h>
#endif

#if !defined(__TETRAHEDRE_H)
#include "../../../FEMOL++/meshes/tetrahedre.h"
#endif

#if !defined(__AFFICHE_H)
#include "../../affiche.h"
#endif


//==========================
int test_tetrahedre (int detail)
//==========================
{
  int result=1;
  tetrahedre<long double> T1,T2,T3;
  node<long double> E(3),F(3),G(3),H(3);
  E[1]=0.0 ; E[2]=0.0 ; E[3]=0.0 ;
  F[1]=1.0 ; F[2]=0.0 ; F[3]=0.0 ;
  G[1]=0.0 ; G[2]=1.0 ; G[3]=0.0 ;
  H[1]=0.0 ; H[2]=0.0 ; H[3]=1.0 ;
  E.boundary_condition()=0;
  F.boundary_condition()=1;
  G.boundary_condition()=2;
  H.boundary_condition()=3;
  T1=tetrahedre<long double>(E,F,G,H);
  node<long double> ** TAB;
  TAB=new node<long double>*[4];
  TAB[0]=&E ; TAB[1]=&F ; TAB[2]=&G ; TAB[3]=&H ;
  T3=tetrahedre<long double>(TAB);

T2=T1;
if (detail) affiche("operator = for tetrahedre<long double> test1",(T2==T1));
else
result*=(T2==T1);

if (detail) affiche("operator = for tetrahedre<long double> test2",(T3==T1));
else
result*=(T3==T1);


T1[1]=E;
T1[2]=F;
T1[3]=G;
T1[4]=H;
T2[1]=E;
T2[2]=F;
T2[3]=G;
T2[4]=H;

if (detail) affiche("operator [] for tetrahedre<long double> ",(T2[1]==T1[1])&&(T2[2]==T1[2])&&(T2[3]==T1[3])&&(T2[4]==T1[4]));
else
for(int i=1;i<=4;i++)
result*=(T2[i]==T1[i]);



//Test constructeur par recopie
  tetrahedre<long double> toto(E,F,G,H);
  tetrahedre<long double> titi(toto);

if (detail) affiche ("copy constructor for tetrahedre",(titi==toto));
else result*=(titi==toto);

if (detail) affiche ("function AbsDet",abs(T1.AbsDet()-1.0)<=epsilon);
else result*=(abs(T1.AbsDet()-1.0)<=epsilon);


node<long double> I(3),J(3),K(3),L(3);

I[1]=3.0 ; I[2]=2.0 ; I[3]=1.0 ;
J[1]=1.0 ; J[2]=4.0 ; J[3]=6.0 ;
K[1]=7.0 ; K[2]=9.0 ; K[3]=12.0 ;
L[1]=0.0 ; L[2]=0.0 ; L[3]=1.0 ;
 
tetrahedre<long double> tetra(I,J,K,L);

matrix<long double> Mk_locale(3,3);
Mk_locale(1,1)=-2.0 ; 
Mk_locale(1,2)=4.0 ; 
Mk_locale(1,3)=-3.0 ; 
Mk_locale(2,1)=2.0 ; 
Mk_locale(2,2)=7.0 ;
Mk_locale(2,3)=-2.0 ; 
Mk_locale(3,1)=5.0 ; 
Mk_locale(3,2)=11.0 ; 
Mk_locale(3,3)=0.0 ; 

if (detail) affiche ("function Mk", Mk_locale==tetra.Mk());
else result*=(Mk_locale==tetra.Mk());

if (detail) affiche ("function InvMk", Mk_locale.inv()==tetra.InvMk());
else result*=(Mk_locale.inv()==tetra.InvMk());

if (detail) affiche ("function nb_nodes", 4==tetra.nb_nodes());
else result*=(4==tetra.nb_nodes());



  cout << "============================================================== \n";
  if (result) cout<< "                    tetrahedre test passed \n";
  else cout << "                    tetrahedre test failed \n";
  cout << "============================================================== \n";
  return result;
}
#endif
