/***************************************************************
 *                    simula+@metz.ensam.fr                    *
 *                   GNU/linux version 0.2.0                  *
 *            software under General Public License            *
 ***************************************************************
 * copyright  2002,2003,2004,2005,2006 CREUSE Emmanuel
 * copyright  2002,2003,2004,2005,2006 SOUALEM Nadir
 * copyright  2002,2003 COLLARD Christophe
 * copyright  2003 DJADEL Karim
 * copyright  Laboratoire de Physique et Mcanique des Matriaux (LPMM - UMR 7554)
 * copyright  Laboratoire de Mathmatiques et ses Applications de Valenciennes (LAMAV - EA 4015)
 ***************************************************************/

/*
    node-test belongs to Mathematical Object Libraries (FEMOL++)
    FEMOL++ is part of Simula+

    Simula+ is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    Simula+ is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Simula+; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/
    
#ifndef __cplusplus
#error Must use C++ for the type vector-test.
#endif

#if !defined(__NODE_TEST_H)
#define _node_test_h


#if !defined(__IOSTREAM_H)
#include <iostream>
#endif

#if !defined(__STDIO_H)
#include <stdio.h>
#endif

#if !defined (__STDLIB_H)
#include <stdlib.h>
#endif

#if !defined(__VECTORS_H)
#include "../../../MOL++/vectors.h"
#endif

#if !defined(__NODE_H)
#include "../../../FEMOL++/meshes/node.h"
#endif

#if !defined(__AFFICHE_H)
#include "../../affiche.h"
#endif


//==========================
int test_node (int detail)
//==========================
{
 int result=1;

        vector <float> u(2);
        vector <float> v;
	u[1]=0.1;
	u[2]=-0.1;
  	node <float> A(2),B(2),C1(u,1),C2(0,u),D,E(3);
	A[1]=0.1;
	A[2]=-0.1;



// Test de l'extraction (par conversion implicite) d'un vecteur  partir d'un
// noeud.
        v=vector <float>(A);
        if (detail) affiche ("vector's extraction for node", v==u);
        else result *= (v==u);

//test boundary_condition par dfaut= -1
   if (detail) affiche ("defaut boundary_condition=-1", A.boundary_condition()==-1);
        else result *= (A.boundary_condition()==-1);

//test affectation de boundary_condition 
A.boundary_condition()=1;
if (detail) affiche ("boundary_condition affectation", A.boundary_condition()-1==0);
        else result *= (A.boundary_condition()-1==0);

//Test affectation =
D=A;
if (detail) affiche ("operator =",D==A);
else result *= (D==A);

//Test operateur - sur les noeuds
node <float> C3(A-D,1);


if (detail) affiche ("operator - by conversion node vector",
(abs(C3[1])<epsilon)&&(abs(C3[2])<epsilon));
        else result *= (abs(C3[1])<epsilon)&&(abs(C3[2])<epsilon);
        
//Test constructeur par recopie
  node<int> toto(2);
  toto[1]=123;
  toto[2]=-34;
  toto.boundary_condition()=2;
  node<int> titi(toto);

if (detail) affiche ("copy constructor",(titi==toto));
else result*=(titi==toto);

cout << "============================================================== \n";
  if (result) cout<< "                    node test passed \n";
  else cout << "                    node test failed \n";
cout << "============================================================== \n";

  return result;
}


#endif


