/***************************************************************
 *                    simula+@metz.ensam.fr                    *
 *                   GNU/linux version 0.0.1                   *
 *            software under General Public License            *
 ***************************************************************
 * copyright  2006 BLANCHARD Jrmy
 * copyright  Laboratoire de Mathmatiques et ses Applications de Valenciennes (LAMAV - EA 4015)
 ***************************************************************/

/*
    mesh_tri_2d_hn-test belongs to Mathematical Object Libraries (FEMOL++)
    FEMOL++ is part of Simula+

    Simula+ is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    Simula+ is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Simula+; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/

#ifndef __cplusplus
#error Must use C++ for the type mesh-test
#endif

#if !defined(__MESH_TEST_H)
#define _mesh_test_h

#if !defined(__IOSTREAM_H)
#include <iostream>
#endif

#if !defined(__ASSERT_H)
#include <assert.h>
#endif

#if !defined(__ASSERT_H)
#include <time.h>
#endif

#if !defined(__VECTORS_H)
#include "../../../MOL++/vectors.h"
#endif

#if !defined(__MESH_TRI_2D_HN_H)
#include "../../../FEMOL++/meshes/mesh_tri_2d_hn.h"
#endif

#if !defined(__TRIANGLE_H)
#include "../../../FEMOL++/meshes/triangle.h"
#endif

#if !defined(__TETRAHEDRE_H)
#include "../../../FEMOL++/meshes/tetrahedre.h"
#endif


#if !defined(__AFFICHE_H)
#include "../../affiche.h"
#endif

#if !defined(__CONVERT_H)
#include "../../../FEMOL++/meshes/convert.h"
#endif

//==========================
int test_mesh_tri_2d_hn (int detail)
//==========================
{
int result=1;


mesh_tri_2d_hn<long double> Th("data/2hang.txt","data/21hang.txt");
//Th.visu2d();
mesh_tri_2d_hn<long double> Th2("data/22hang.txt");
//Th2.visu2d();
 mesh_tri_2d_hn<long double> Th3, Th4;
 
if (detail) affiche("operator == for mesh_tri_2d_hn ",(Th==Th2));
else
result*=(Th==Th2);

mesh_tri_2d_hn<long double> Vh(Th);
if (detail) affiche("copy constructor",(Vh==Th));
else
result*=(Vh==Th);

Th3=Th;
if (detail) affiche("operator = for mesh_tri_2d_hn test1 ",(Th3==Th));
else
result*=(Th==Th3);


Th4=Th2;
if (detail) affiche("operator = for mesh_tri_2d_hn test2 ",(Th4==Th2));
else
result*=(Th4==Th2);

vector<int> TABTRI(4); TABTRI[1]=4; TABTRI[2]=5; TABTRI[3]=8; TABTRI[4]=2;
Th.refine_mesh(TABTRI);
mesh_tri_2d_hn<long double> Th5("newfichier.txt");
//Th5.visu2d();
mesh_tri_2d_hn<long double> Th6("data/42.txt");
//Th6.visu2d();

int nbsegmentsLoc=40;
if (detail) affiche("fonction nbsegments() for mesh_tri_2d_hn ",(Th2.nbsegments()==nbsegmentsLoc));
else
result*=(Th2.nbsegments()==nbsegmentsLoc);

matrix<int> SetOfEdgesLoc(40,2);
SetOfEdgesLoc(1,1)=14; SetOfEdgesLoc(1,2)=15;
SetOfEdgesLoc(2,1)=13; SetOfEdgesLoc(2,2)=15;
SetOfEdgesLoc(3,1)=13; SetOfEdgesLoc(3,2)=14;
SetOfEdgesLoc(4,1)=3; SetOfEdgesLoc(4,2)=6;
SetOfEdgesLoc(5,1)=2; SetOfEdgesLoc(5,2)=3;
SetOfEdgesLoc(6,1)=17; SetOfEdgesLoc(6,2)=18;
SetOfEdgesLoc(7,1)=16; SetOfEdgesLoc(7,2)=18;
SetOfEdgesLoc(8,1)=16; SetOfEdgesLoc(8,2)=17;
SetOfEdgesLoc(9,1)=6; SetOfEdgesLoc(9,2)=9;
SetOfEdgesLoc(10,1)=11; SetOfEdgesLoc(10,2)=12;
SetOfEdgesLoc(11,1)=10; SetOfEdgesLoc(11,2)=12;
SetOfEdgesLoc(12,1)=10; SetOfEdgesLoc(12,2)=11;
SetOfEdgesLoc(13,1)=20; SetOfEdgesLoc(13,2)=21;
SetOfEdgesLoc(14,1)=19; SetOfEdgesLoc(14,2)=21;
SetOfEdgesLoc(15,1)=19; SetOfEdgesLoc(15,2)=20;
SetOfEdgesLoc(16,1)=1; SetOfEdgesLoc(16,2)=2;
SetOfEdgesLoc(17,1)=5; SetOfEdgesLoc(17,2)=10;
SetOfEdgesLoc(18,1)=5; SetOfEdgesLoc(18,2)=12;
SetOfEdgesLoc(19,1)=6; SetOfEdgesLoc(19,2)=11;
SetOfEdgesLoc(20,1)=6; SetOfEdgesLoc(20,2)=10;
SetOfEdgesLoc(21,1)=2; SetOfEdgesLoc(21,2)=11;
SetOfEdgesLoc(22,1)=2; SetOfEdgesLoc(22,2)=12;
SetOfEdgesLoc(23,1)=8; SetOfEdgesLoc(23,2)=15;
SetOfEdgesLoc(24,1)=8; SetOfEdgesLoc(24,2)=13;
SetOfEdgesLoc(25,1)=9; SetOfEdgesLoc(25,2)=14;
SetOfEdgesLoc(26,1)=9; SetOfEdgesLoc(26,2)=13;
SetOfEdgesLoc(27,1)=5; SetOfEdgesLoc(27,2)=15;
SetOfEdgesLoc(28,1)=5; SetOfEdgesLoc(28,2)=14;
SetOfEdgesLoc(29,1)=7; SetOfEdgesLoc(29,2)=18;
SetOfEdgesLoc(30,1)=7; SetOfEdgesLoc(30,2)=16;
SetOfEdgesLoc(31,1)=8; SetOfEdgesLoc(31,2)=17;
SetOfEdgesLoc(32,1)=8; SetOfEdgesLoc(32,2)=16;
SetOfEdgesLoc(33,1)=4; SetOfEdgesLoc(33,2)=18;
SetOfEdgesLoc(34,1)=4; SetOfEdgesLoc(34,2)=17;
SetOfEdgesLoc(35,1)=4; SetOfEdgesLoc(35,2)=19;
SetOfEdgesLoc(36,1)=4; SetOfEdgesLoc(36,2)=21;
SetOfEdgesLoc(37,1)=5; SetOfEdgesLoc(37,2)=20;
SetOfEdgesLoc(38,1)=5; SetOfEdgesLoc(38,2)=19;
SetOfEdgesLoc(39,1)=1; SetOfEdgesLoc(39,2)=21;
SetOfEdgesLoc(40,1)=1; SetOfEdgesLoc(40,2)=20;

if (detail) affiche("SetOfEdges_ for mesh_tri_2d_hn ",(Th2.SetOfEdges()==SetOfEdgesLoc));
else
result*=(Th.SetOfEdges()==SetOfEdgesLoc);

vector<int> v(20);
v[1]=3; v[2]=4; v[3]=3; v[4]=5; v[5]=6; v[6]=3; v[7]=3; v[8]=5; v[9]=3; v[10]=3;
v[11]=3; v[12]=3; v[13]=3; v[14]=3; v[15]=3; v[16]=3; v[17]=3; v[18]=3; v[19]=3; v[20]=3;
creu<int> EdgesPerTriangleLoc(v);
EdgesPerTriangleLoc[1][1]=1; EdgesPerTriangleLoc[1][2]=2; EdgesPerTriangleLoc[1][3]=3;
EdgesPerTriangleLoc[2][1]=4; EdgesPerTriangleLoc[2][2]=19; EdgesPerTriangleLoc[2][3]=5; EdgesPerTriangleLoc[2][4]=21;
EdgesPerTriangleLoc[3][1]=6; EdgesPerTriangleLoc[3][2]=7; EdgesPerTriangleLoc[3][3]=8;
EdgesPerTriangleLoc[4][1]=9; EdgesPerTriangleLoc[4][2]=25; EdgesPerTriangleLoc[4][3]=17; EdgesPerTriangleLoc[4][4]=28; EdgesPerTriangleLoc[4][5]=20;
EdgesPerTriangleLoc[5][1]=23; EdgesPerTriangleLoc[5][2]=31; EdgesPerTriangleLoc[5][3]=35; EdgesPerTriangleLoc[5][4]=27; EdgesPerTriangleLoc[5][5]=34; EdgesPerTriangleLoc[5][6]=38;
EdgesPerTriangleLoc[6][1]=10; EdgesPerTriangleLoc[6][2]=11; EdgesPerTriangleLoc[6][3]=12;
EdgesPerTriangleLoc[7][1]=13; EdgesPerTriangleLoc[7][2]=14; EdgesPerTriangleLoc[7][3]=15;
EdgesPerTriangleLoc[8][1]=18; EdgesPerTriangleLoc[8][2]=37; EdgesPerTriangleLoc[8][3]=16; EdgesPerTriangleLoc[8][4]=22; EdgesPerTriangleLoc[8][5]=40;
EdgesPerTriangleLoc[9][1]=17; EdgesPerTriangleLoc[9][2]=18; EdgesPerTriangleLoc[9][3]=11;
EdgesPerTriangleLoc[10][1]=19; EdgesPerTriangleLoc[10][2]=12; EdgesPerTriangleLoc[10][3]=20;
EdgesPerTriangleLoc[11][1]=21; EdgesPerTriangleLoc[11][2]=10; EdgesPerTriangleLoc[11][3]=22;
EdgesPerTriangleLoc[12][1]=2; EdgesPerTriangleLoc[12][2]=23; EdgesPerTriangleLoc[12][3]=24;
EdgesPerTriangleLoc[13][1]=25; EdgesPerTriangleLoc[13][2]=26; EdgesPerTriangleLoc[13][3]=3;
EdgesPerTriangleLoc[14][1]=27; EdgesPerTriangleLoc[14][2]=28; EdgesPerTriangleLoc[14][3]=1;
EdgesPerTriangleLoc[15][1]=29; EdgesPerTriangleLoc[15][2]=7; EdgesPerTriangleLoc[15][3]=30;
EdgesPerTriangleLoc[16][1]=31; EdgesPerTriangleLoc[16][2]=8; EdgesPerTriangleLoc[16][3]=32;
EdgesPerTriangleLoc[17][1]=33; EdgesPerTriangleLoc[17][2]=34; EdgesPerTriangleLoc[17][3]=6;
EdgesPerTriangleLoc[18][1]=35; EdgesPerTriangleLoc[18][2]=14; EdgesPerTriangleLoc[18][3]=36;
EdgesPerTriangleLoc[19][1]=37; EdgesPerTriangleLoc[19][2]=38; EdgesPerTriangleLoc[19][3]=15;
EdgesPerTriangleLoc[20][1]=13; EdgesPerTriangleLoc[20][2]=39; EdgesPerTriangleLoc[20][3]=40;

if (detail) affiche("EdgesPerTriangle_ for mesh_tri_2d_hn ",(Th2.EdgesPerTriangle()==EdgesPerTriangleLoc));
else
result*=(Th2.EdgesPerTriangle()==EdgesPerTriangleLoc);


cout << "============================================================== \n";
  if (result) cout<< "                    mesh_tri_2d_hn test passed \n";
  else cout << "                    mesh_tri_2d_hn test failed \n";
  cout << "============================================================== \n";
  
return(result);
}


#endif

