/***************************************************************
 *                    simula+@metz.ensam.fr                    *
 *                   GNU/linux version 0.0.3                   *
 *            software under General Public License            *
 ***************************************************************
 * copyright  2006 BLANCHARD Jrmy
 * copyright @ 2006 Laboratoire de Mathmatiques et ses Applications de Valenciennes (LAMAV - EA 4015)
 ***************************************************************/

/*
    creu-test belongs to Finite Element Object Libraries (FEMOL++)
    FEMOL++ is part of Simula+

    Simula+ is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    Simula+ is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Simula+; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/

#ifndef __cplusplus
#error Must use C++ for the type creu-test.
#endif

#if !defined(__CREU_TEST_H)
#define _creu_test_h


#if !defined(__IOSTREAM_H)
#include <iostream>
#endif

#if !defined(__STDIO_H)
#include <stdio.h>
#endif

#if !defined (__STDLIB_H)
#include <stdlib.h>
#endif

#if !defined(__CREU_H)
#include "../../../FEMOL++/meshes/creu.h"
#endif

#if !defined(__AFFICHE_H)
#include "../../affiche.h"
#endif


//==========================
int test_creu (int detail)
//==========================
{
int result=1;
  
vector<int> v(5); v[1]=2; v[2]=3; v[3]=1; v[4]=3; v[5]=6;
  
creu<long double> c(v);

c[1][1]=0.5; c[1][2]=1.2;
c[2][1]=3.0; c[2][2]=-0.4; c[2][3]=2.3;
c[3][1]=4.0; 
c[4][1]=5.72; c[4][2]=15.0; c[4][3]=-7.43; 
c[5][1]=1.0; c[5][2]=6.9; c[5][3]=9.6; c[5][4]=-3.33; c[5][5]=10.0; c[5][6]=2.1;
   

creu<long double> C(v),D(v);
for (int i=1; i<=v.dim(); i++)
  {C[i]=c[i]; D[i]=c[i];} 
D[4][3]=-7.431;
  
creu<long double> E=c;  

vector<long double> w(3); w[1]=5.72; w[2]=15.0; w[3]=-7.43;


creu<long double>* F; F=new creu<long double>(v); *F=c;
vector<int> x(5); x[1]=2; x[2]=3; x[3]=2; x[4]=3; x[5]=6;
creu<long double>* G; G=new creu<long double>(x);
(*G)[1]=c[1]; (*G)[2]=c[2]; (*G)[4]=c[4]; (*G)[5]=c[5]; (*G)[3][1]=4.0;  
ajout(F,3,1);


// starts tests

  if (detail) affiche ("operator ==", C==c && !(D==c) );
  else result *= (C==c && !(D==c));
          
  if (detail) affiche ("operator =", E==c);
  else result *= (E==c);
  
  if (detail) affiche ("operator []", c[4]==w);
  else result *= (c[4]==w);
  
  if (detail) affiche ("vect", vect(c)==v);
  else result *= (vect(c)==v);                                

  if (detail) affiche ("ajout", *G==*F);
  else result *= (*G==*F);                          
                            
  cout << endl;

  cout << "============================================================== \n";
  if (result) cout<< "                      creu test passed \n";
  else cout << "                      creu test failed \n";
  cout << "============================================================== \n";

  return result;        
          
}



#endif
