/***************************************************************
 *                    simula+@metz.ensam.fr                    *
 *                   GNU/linux version 0.0.8                   *
 *            software under General Public License            *
 ***************************************************************
 * copyright  2005 CREUSE Emmanuel
 * copyright  Laboratoire de Physique et Mcanique des Matriaux (LPMM - UMR 7554)
 * copyright  Laboratoire de Mathmatiques et ses Applications de Valenciennes (LAMAV - EA 4015)
 ***************************************************************/

/*
    rt02d-test belongs to Mathematical Object Libraries (FEMOL++)
    FEMOL++ is part of Simula+

    Simula+ is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    Simula+ is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Simula+; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/



#ifndef __cplusplus
#error Must use C++ for the type p1hp_2d
#endif

#if !defined(__RT02D_TEST_H)
#define _rt02d_test_h

#if !defined(__VECTORS_H)
#include "../../../MOL++/vectors.h"
#endif

#if !defined(__ASSERT_H)
#include <time.h>
#endif

#if !defined(__MATRIX_H)
#include "../../../MOL++/matrix.h"
#endif

#if !defined(__ASSERT_H)
#include <assert.h>
#endif

#if !defined(__SPMATRIX_H)
#include "../../../MOL++/spmatrix.h"
#endif

#if !defined(__RT02D_H)
#include "../../../FEMOL++/elements/rt02d.h"
#endif

#if !defined(__AFFICHE_H)
#include "../../affiche.h"
#endif


long double p=1.5;
long double vareps=0.05;

long double r2(long double x, long double y)
{
return(pow((x-0.5),2)+pow((y-0.5),2));
}
long double f(long double x, long double y)
{
long double d2=r2(x,y);
if (d2<=0.25)
return(
 powf(2/vareps,p-1)
*powf(sqrt(d2)*(vareps+0.25-d2),p-2)
*((vareps+0.25-d2)*(p-2*(p-1)*d2/vareps)-2*(p-1)*d2)
*exp(-(p-1)*d2/vareps)
 );
else
 return(0);
}
long double u(long double x, long double y)
{
long double d2=r2(x,y);
if (d2<=0.25)
 return((0.25-d2)*exp(-d2/vareps));
else
 return(0);
}
long double dudx(long double x, long double y)
{
long double d2=r2(x,y);
if (d2<=0.25)
return((1-2*x)*exp(-d2/vareps)*(vareps+0.25-d2)/vareps);
else
 return(0);
}
long double dudy(long double x, long double y)
{
long double d2=r2(x,y);
if (d2<=0.25)
return((1-2*y)*exp(-d2/vareps)*(vareps+0.25-d2)/vareps);
else
 return(0);
}
long double NormGradu(long double x, long double y)
{
long double d2=r2(x,y);
if (d2<=0.25)
return(2*sqrt(d2)*exp(-d2/vareps)*(vareps+0.25-d2)/vareps);
else
 return(0);
}

long double px(long double x, long double y)
{
long double d2=r2(x,y);
if (d2<=0.25)
return(((1-2*x)*exp(-d2/vareps)*(vareps+0.25-d2)/vareps)*powf(NormGradu(x,y),p-2));
else
 return(0);
}
long double py(long double x, long double y)
{
long double d2=r2(x,y);
if (d2<=0.25)
return(((1-2*y)*exp(-d2/vareps)*(vareps+0.25-d2)/vareps)*powf(NormGradu(x,y),p-2));
else
 return(0);
}


//==========================
int test_rt02d(int detail)
//==========================
{
int result=1;

rt02d<long double> Th("data/2.txt","data/21.txt");
rt02d<long double> Th2("data/22.txt");
rt02d<long double> Uh("data/8.txt","data/81.txt");
rt02d<long double> Uh2("data/82.txt");

rt02d<long double> Th3,Th4,Uh3,Uh4;

if (detail) affiche("operator == for rt02d test1 ",(Th==Th2));
else
result*=(Th==Th2);


if (detail) affiche("operator == for rt02d test2 ",(Uh==Uh2));
else
result*=(Uh==Uh2);

rt02d<long double> Vh(Uh);
if (detail) affiche("copy constructor",(Vh==Uh));
else
result*=(Vh==Uh);


Th3=Th;
if (detail) affiche("operator = for rt02d test1 ",(Th==Th3));
else
result*=(Th==Th3);


Th4=Th2;
if (detail) affiche("operator = for rt02d test2 ",(Th4==Th2));
else
result*=(Th4==Th2);


Uh3=Uh;
if (detail) affiche("operator = for rt02d test3 ",(Uh==Uh3));
else
result*=(Uh==Uh3);


Uh4=Uh2;
if (detail) affiche("operator = for rt02d test4 ",(Uh4==Uh2));
else
result*=(Uh4==Uh2);

int NbIntPts=2;
long double q=p/(p-1);
rt02d<long double> Wh("data/4.txt","data/41.txt");
spmatrix<long double> A;
vector<long double> B;
vector<long double> Lambda, X0;
vector<long double> U;
vector<long double> Pmp1,Pm;
long double erreur_p,erreur_u,erreur,erreur_max;
long double eps=1e-06;
int nbiter=0;

A.~spmatrix();
B.~vector(); 
Lambda.~vector(); 
X0.~vector();  
U.~vector();  
Pmp1.~vector(); 
Pm.~vector(); 
A=spmatrix<long double>(Wh.GlobalDofNumber(),Wh.GlobalDofNumber(),5);
B=vector<long double>(Wh.GlobalDofNumber());
Lambda=vector<long double>(Wh.GlobalDofNumber());
X0=vector<long double>(Wh.GlobalDofNumber());
U=vector<long double>(Wh.nbelement());
Pmp1=vector<long double>(Wh.GlobalDofNumber());
Pm=vector<long double>(Wh.GlobalDofNumber());

   
for(int i=1; i<=Wh.GlobalDofNumber(); i++)
Pmp1[i]=1.0; // pour entrer dans la boucle !

for (int indice_boucle=1; ((Pmp1-Pm).norm()>eps); indice_boucle++)
  {
   A.~spmatrix();
   A=spmatrix<long double>(Wh.GlobalDofNumber(),Wh.GlobalDofNumber(),5);
   Pm=Pmp1;
   for (int i=1; i<=Wh.GlobalDofNumber(); i++) B[i]=0;
   Wh.Assemble(A,B,f,Pm,q,NbIntPts);
   Wh.Dirichlet(A,B,u,p);
   Lambda=conjugate_gradient(A,B,X0,nbiter,precision);
   Wh.Compute_u(U,Lambda,f,Pm,q,NbIntPts);
   Wh.Compute_p(Pmp1,U,Lambda,Pm,q,NbIntPts);
   erreur_p=Wh.error_p(Pmp1,px,py,q,NbIntPts);
   erreur_u=Wh.error_u(U,p,u,NbIntPts);
   }
   
 long double erreur_u_hard=0.0227015;
 long double erreur_p_hard=0.308528810739517;
 
 if (detail) cout << "Rsolution du p-laplacien par mthode hybride mixte... :" << "\n" ;
 
 if (detail) affiche("erreur en u ",(abs(erreur_u-erreur_u_hard)<1e-06));
  else
 result*=(abs(erreur_u-erreur_u_hard)<1e-06);
 
  if (detail) affiche("erreur en p ",(abs(erreur_p-erreur_p_hard)<1e-06));
  else
 result*=(abs(erreur_p-erreur_p_hard)<1e-06);
 
  long double ETA1=Th.eta_1(Pm,p,2);
  long double ETA2=Th.eta_2(f,q,2);
  long double ETA1_hard=0.160702243447;
  long double ETA2_hard=3.15213227272;
  
 if (detail) cout << "Estimateurs d'erreur a posteriori... :" << "\n" ;
  
  if (detail) affiche("Estimateur eta_1 ",(abs(ETA1-ETA1_hard)<1e-08));
  else
  result*=(abs(ETA1-ETA1_hard)<1e-06);
 
  if (detail) affiche("Estimateur eta_2 ",(abs(ETA2-ETA2_hard)<1e-08));
  else
  result*=(abs(ETA2-ETA2_hard)<1e-06);
 
   
   cout << "============================================================== \n";
  if (result) cout<< "                    rt02d test passed \n";
  else cout << "                    rt02d test failed \n";
  cout << "============================================================== \n";
  
return(result);
   
}
#endif


