/***************************************************************
 *                    simula+@metz.ensam.fr                    *
 *                   GNU/linux version 0.0.8                   *
 *            software under General Public License            *
 ***************************************************************
 * copyright  2004 CREUSE Emmanuel
 * copyright  2004 KALETA Olivia
 * copyright  Laboratoire de Physique et Mcanique des Matriaux (LPMM - UMR 7554)
 * copyright  Laboratoire de Mathmatiques et ses Applications de Valenciennes (LAMAV - EA 4015)
 ***************************************************************/

/*
    rectangle-test belongs to Mathematical Object Libraries (FEMOL++)
    FEMOL++ is part of Simula+

    Simula+ is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    Simula+ is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Simula+; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/
 
#ifndef __cplusplus
#error Must use C++ for rectangle-test.
#endif

#if !defined(__RECTANGLE_TEST_H)
#define _rectangle_test_h

#if !defined(__IOSTREAM_H)
#include<iostream>
#endif

#if !defined(__STDIO_H)
#include<stdio.h>
#endif

#if !defined(__STDLIB_H)
#include<stdlib.h>
#endif

#if !defined(__RECTANGLE_H)
#include"../../../FEMOL++/meshes/rectangle.h"
#endif

#if !defined(__AFFICHE_H)
#include"../../affiche.h"
#endif





//------------------------------------------------------------------------------------------------
int test_rectangle (int detail)
{
int result=1;
rectangle<int> A1,A2,A3,A4;
rectangle<float> B1,B2,B3,B4;
rectangle<double> C1,C2,C3,C4;
rectangle<long double> D1,D2,D3,D4,E1;
node<int> O(2),A(2),B(2),C(2);
node<float> D(2),E(2),F(2),G(2);
node<double> H(2),I(2),J(2),K(2);
node<long double> L(2),M(2),N(2),P(2);
A[1]=1;B[1]=1;C[1]=0;D[1]=0.333;E[1]=9.786;F[1]=9.786;G[1]=0.333;
A[2]=0;B[2]=1;C[2]=1;D[2]=0.00006;E[2]=0.00006;F[2]=789.9;G[2]=789.9;
A.boundary_condition()=0;
B.boundary_condition()=1;
C.boundary_condition()=2;
D.boundary_condition()=2;
E.boundary_condition()=0;
F.boundary_condition()=1;
G.boundary_condition()=1;
H[1]=1.89e+06;I[1]=1.89e+06;J[1]=0.897;K[1]=0.897;
H[2]=0.98765;I[2]=-98765;J[2]=-98765;K[2]=0.98765;
H.boundary_condition()=1;
I.boundary_condition()=2;
J.boundary_condition()=1;
K.boundary_condition()=2;
L[1]=-0.7e+6;M[1]=-78965.89765443;N[1]=-78965.89765443;P[1]=-0.7e+6;
L[2]=98e-5;M[2]=98e-5;N[2]=6e+4;P[2]=6e+4;
L.boundary_condition()=2;
M.boundary_condition()=1;
N.boundary_condition()=2;
P.boundary_condition()=1;
A1=rectangle<int>(O,A,B,C);
B1=rectangle<float>(D,E,F,G);
C1=rectangle<double>(H,I,J,K);
D1=rectangle<long double>(L,M,N,P);

node<long double> **TAB;
TAB=new node<long double> *[4];
TAB[0]=&L ; TAB[1]=&M ; TAB[2]=&N ; TAB[3]=&P ;
E1=rectangle<long double>(TAB);





A2=A1;
if (detail) affiche("operator = for rectangle<int> test1",(A2==A1));
else
result*=(A2==A1);



A3=A2;
if (detail) affiche("operator = for rectangle<int> test2",(A3==A2));
else
result*=(A3==A2);


B2=B1;
if (detail) affiche("operator = for rectangle<float> test1",(B2==B1));
else
result*=(B2==B1);




B3=B2;
if (detail) affiche("operator = for rectangle<float> test2",(B3==B2));
else
result*=(B3==B2);




C2=C1;
if (detail) affiche("operator = for rectangle<double> test1",(C2==C1));
else
result*=(C2==C1);





C3=C2;
if (detail) affiche("operator = for rectangle<double> test2",(C3==C2));
else
result*=(C3==C2);





D2=D1;

if (detail) affiche("operator = for rectangle<long double> test1",(D2==D1));
else
result*=(D2==D1);





D3=D2;
if (detail) affiche("operator = for rectangle<long double> test2",(D3==D2));
else
result*=(D3==D2);

if (detail) affiche("operator = for rectangle<long double> test3",(D1==E1));
else
result*=(D1==E1);


A1[1]=B;
A1[2]=C;
A1[3]=O;
A1[4]=A;
A2[1]=B;
A2[2]=C;
A2[3]=O;
A2[4]=A;

if (detail) affiche("operator [] for rectangle<int> ",(A2[1]==A1[1])&&(A2[2]==A1[2])&&(A2[3]==A1[3])&&(A2[4]==A1[4]));
else
for(int i=1;i<=4;i++)
result*=(A2[i]==A1[i]);




B1[1]=E;
B1[2]=F;
B1[3]=G;
B1[4]=D;
B2[1]=E;
B2[2]=F;
B2[3]=G;
B2[4]=D;

if (detail) affiche("operator [] for rectangle<float> ",(B2[1]==B1[1])&&(B2[2]==B1[2])&&(B2[3]==B1[3])&&(B2[4]==B1[4]));
else
for(int i=1;i<=4;i++)
result*=(B2[i]==B1[i]);



C1[1]=J;
C1[2]=I;
C1[3]=H;
C1[4]=K;
C2[1]=J;
C2[2]=I;
C2[3]=H;
C2[4]=K;




if (detail) affiche("operator [] for rectangle<double> ",(C2[1]==C1[1])&&(C2[2]==C1[2])&&(C2[3]==C1[3])&&(C2[4]==C1[4]));
else
for(int i=1;i<=4;i++)
result*=(C2[i]==C1[i]);




D1[1]=L;
D1[2]=M;
D1[3]=N;
D1[4]=P;
D2[1]=L;
D2[2]=M;
D2[3]=N;
D2[4]=P;




if (detail) affiche("operator [] for rectangle<long double> ",(D2[1]==D1[1])&&(D2[2]==D1[2])&&(D2[3]==D1[3])&&(D2[4]==D1[4]));
else
for(int i=1;i<=4;i++)
result*=(D2[i]==D1[i]);



//Test constructeur par recopie
rectangle<long double> toto(L,M,N,P);
rectangle<long double> titi(toto);

if (detail) affiche ("copy constuctor for rectangle",(titi==toto));
else result*=(titi==toto);

node<long double> R1(2),R2(2),R3(2),R4(2);
R1[1]=0.0;R1[2]=0.0;
R2[1]=1.0;R2[2]=0.0;
R3[1]=1.0;R3[2]=1.0;
R4[1]=0.0;R4[2]=1.0;
rectangle<long double> Ref(R1,R2,R3,R4);




if (detail) affiche ("function AbsDet", abs(Ref.AbsDet()-1)<=epsilon);
else result*=(abs(Ref.AbsDet()-1)<=epsilon);




R1[1]=2.0; R1[2]=3.0;
R2[1]=5.0; R2[2]=3.0;
R3[1]=5.0; R3[2]=4.0;
R4[1]=2.0; R4[2]=4.0;
rectangle<long double> rec(R1,R2,R3,R4);

matrix<long double> Mk_locale(2,2);
Mk_locale(1,1)=3; Mk_locale(1,2)=0; Mk_locale(2,1)=0; Mk_locale(2,2)=1;

if (detail) affiche ("function Mk" , Mk_locale==rec.Mk());
else result*=(Mk_locale==rec.Mk());

if (detail) affiche ("function nb_nodes" , 4==rec.nb_nodes());
else result*=(4==rec.nb_nodes());

cout << "============================================================== \n";
  if (result) cout<< "                    rectangle test passed \n";
  else cout << "                    rectangle test failed \n";
  cout << "============================================================== \n";
  return result;

}

#endif