/***************************************************************
 *                    simula+@metz.ensam.fr                    *
 *                   GNU/linux version 0.2.4                   *
 *            software under General Public License            *
 ***************************************************************
 * copyright  2003,2004,2005,2006 CREUSE Emmanuel
 * copyright  2003,2004,2005,2006 SOUALEM Nadir
 * copyright  Laboratoire de Physique et Mcanique des Matriaux (LPMM - UMR 7554)
 * copyright  Laboratoire de Mathmatiques et ses Applications de Valenciennes (LAMAV - EA 4015)
 ***************************************************************/

/*
    p1c2d-test belongs to Mathematical Object Libraries (FEMOL++)
    FEMOL++ is part of Simula+

    Simula+ is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    Simula+ is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Simula+; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/

#ifndef __cplusplus
#error Must use C++ for the type p1c2d-test
#endif

#if !defined(__P1C2D_TEST_H)
#define _p1c2d_test_h

#if !defined(__IOSTREAM_H)
#include <iostream>
#endif

#if !defined(__ASSERT_H)
#include <assert.h>
#endif

#if !defined(__ASSERT_H)
#include <time.h>
#endif

#if !defined(__VECTORS_H)
#include "../../../MOL++/vectors.h"
#endif

#if !defined(__MATHS_H)
#include "../../../MOL++/maths.h"
#endif

#if !defined(__MESH_TRI_2D_H)
#include "../../../FEMOL++/meshes/mesh_tri_2d.h"
#endif

#if !defined(__TRIANGLE_H)
#include "../../../FEMOL++/meshes/triangle.h"
#endif

#if !defined(__AFFICHE_H)
#include "../../affiche.h"
#endif

#if !defined(__P1C2D_H)
#include "../../../FEMOL++/elements/p1c2d.h"
#endif

long double f_test_p1c(long double x, long double y)
{
return(-exp(x)-exp(y));
}

long double u_test_p1c(long double x, long double y)
{
return(exp(x)+exp(y));
}


long double dudx_test_p1c(long double x, long double y)
{
return(exp(x));
}

long double dudy_test_p1c(long double x, long double y)
{
return(exp(y));
}

long double f_equal1(long double x, long double y)
{
return(1.0);
}

//==========================
int test_p1c2d (int detail)
//==========================
{
int result=1;

p1c2d<long double> Th("data/2.txt","data/21.txt");
p1c2d<long double> Th2("data/22.txt");
p1c2d<long double> Uh("data/8.txt","data/81.txt");
p1c2d<long double> Uh2("data/82.txt");
p1c2d<long double> Th3,Th4,Uh3,Uh4;

if (detail) affiche("operator == for p1c2d test1 ",(Th==Th2));
else
result*=(Th==Th2);

if (detail) affiche("operator == for p1c2d test2 ",(Uh==Uh2));
else
result*=(Uh==Uh2);

if (detail) affiche("operator == for p1c2d test3 ",!(Uh==Th));
else
result*=!(Uh==Th);

if (detail) affiche("operator != for p1c2d test1 ",(Th!=Uh));
else
result*=(Th!=Uh);

if (detail) affiche("operator != for p1c2d test2 ",!(Th!=Th2));
else
result*=!(Th!=Th2);

p1c2d<long double> Vh(Uh);
if (detail) affiche("copy constructor",(Vh==Uh));
else
result*=(Vh==Uh);

Th3=Th;
if (detail) affiche("operator = for p1c2d test1 ",(Th==Th3));
else
result*=(Th==Th3);


Th4=Th2;
if (detail) affiche("operator = for p1c2d test2 ",(Th4==Th2));
else
result*=(Th4==Th2);


Uh3=Uh;
if (detail) affiche("operator = for p1c2d test3 ",(Uh==Uh3));
else
result*=(Uh==Uh3);


Uh4=Uh2;
if (detail) affiche("operator = for p1c2d test4 ",(Uh4==Uh2));
else
result*=(Uh4==Uh2);

matrix<long double> MASS(3,3), STIFF(3,3);

MASS(1,1)=1./12.;MASS(1,2)=1./24.;MASS(1,3)=1./24.;
MASS(2,1)=1./24.;MASS(2,2)=1./12.;MASS(2,3)=1./24.;
MASS(3,1)=1./24.;MASS(3,2)=1./24.;MASS(3,3)=1./12.;

STIFF(1,1)=1.00;STIFF(1,2)=-0.5;STIFF(1,3)=-0.5;
STIFF(2,1)=-0.5;STIFF(2,2)=0.50;STIFF(2,3)=0.0;
STIFF(3,1)=-0.5;STIFF(3,2)=0.00;STIFF(3,3)=0.5;

if (detail) affiche("function RefMassMatrix ",(MASS==Uh.RefMassMatrix()));
else
result*=(MASS==Uh.RefMassMatrix());



if (detail) affiche("function DofNumber ",(3==Uh.DofNumber()));
else
result*=(3==Uh.DofNumber());

if (detail) affiche("function GlobalDofNumber ",(81==Uh.GlobalDofNumber()));
else
result*=(81==Uh.GlobalDofNumber());

if (detail) affiche("operator() test1",(Uh(43,1)==Uh2(43,1)));
else
result*=(Uh(43,1)==Uh2(43,1));

if (detail) affiche("operator() test1bis",(Uh(43,1)!=0));
else
result*=(Uh(43,1)!=0);

if (detail) affiche("operator() test2",(Uh(23,3)==Uh2(23,3)));
else
result*=(Uh(23,3)==Uh2(23,3));

if (detail) affiche("operator() test2bis",(Uh(23,3)!=0));
else
result*=(Uh(23,3)!=0);


if (detail) affiche("operator() test3",(Uh(17,2)==Uh2(17,2)));
else
result*=(Uh(17,2)==Uh2(17,2));

if (detail) affiche("operator() test3bis",(Uh(17,2)!=0));
else
result*=(Uh(17,2)!=0);

if (detail) affiche("function LocalMassMatrix",
(Uh.LocalMassMatrix(1)==((long double)(1./64.)*Uh.RefMassMatrix())));
else
result*=(Uh.LocalMassMatrix(1)==((long double)(1./64.)*Uh.RefMassMatrix()));


int NbIntPts=10;
matrix<long double> m(81,81);
vector<long double> b(81);
long double epsilon_loc=1e-10;
int boolean=1;
m(1,1)=1;
m(2,2)=1;
m(3,3)=1;
m(4,4)=1;
m(5,5)=1;
m(6,6)=1;
m(7,7)=1;
m(8,8)=1;
m(9,9)=1;
m(10,10)=1;
m(11,11)=4;m(11,12)=-1;m(11,20)=-1;
m(12,11)=-1;m(12,12)=4;m(12,13)=-1;m(12,21)=-1;
m(13,12)=-1;m(13,13)=4;m(13,14)=-1;m(13,22)=-1;
m(14,13)=-1;m(14,14)=4;m(14,15)=-1;m(14,23)=-1;
m(15,14)=-1;m(15,15)=4;m(15,16)=-1;m(15,24)=-1;
m(16,15)=-1;m(16,16)=4;m(16,17)=-1;m(16,25)=-1;
m(17,16)=-1;m(17,17)=4;m(17,26)=-1;
m(18,18)=1;
m(19,19)=1;
m(20,11)=-1;m(20,20)=4;m(20,21)=-1;m(20,29)=-1;
m(21,12)=-1;m(21,20)=-1;m(21,21)=4;m(21,22)=-1;m(21,30)=-1;
m(22,13)=-1;m(22,21)=-1;m(22,22)=4;m(22,23)=-1;m(22,31)=-1;
m(23,14)=-1;m(23,22)=-1;m(23,23)=4;m(23,24)=-1;m(23,32)=-1;
m(24,15)=-1;m(24,23)=-1;m(24,24)=4;m(24,25)=-1;m(24,33)=-1;
m(25,16)=-1;m(25,24)=-1;m(25,25)=4;m(25,26)=-1;m(25,34)=-1;
m(26,17)=-1;m(26,25)=-1;m(26,26)=4;m(26,35)=-1;
m(27,27)=1;
m(28,28)=1;
m(29,20)=-1;m(29,29)=4;m(29,30)=-1;m(29,38)=-1;
m(30,21)=-1;m(30,29)=-1;m(30,30)=4;m(30,31)=-1;m(30,39)=-1;
m(31,22)=-1;m(31,30)=-1;m(31,31)=4;m(31,32)=-1;m(31,40)=-1;
m(32,23)=-1;m(32,31)=-1;m(32,32)=4;m(32,33)=-1;m(32,41)=-1;
m(33,24)=-1;m(33,32)=-1;m(33,33)=4;m(33,34)=-1;m(33,42)=-1;
m(34,25)=-1;m(34,33)=-1;m(34,34)=4;m(34,35)=-1;m(34,43)=-1;
m(35,26)=-1;m(35,34)=-1;m(35,35)=4;m(35,44)=-1;
m(36,36)=1;
m(37,37)=1;
m(38,29)=-1;m(38,38)=4;m(38,39)=-1;m(38,47)=-1;
m(39,30)=-1;m(39,38)=-1;m(39,39)=4;m(39,40)=-1;m(39,48)=-1;
m(40,31)=-1;m(40,39)=-1;m(40,40)=4;m(40,41)=-1;m(40,49)=-1;
m(41,32)=-1;m(41,40)=-1;m(41,41)=4;m(41,42)=-1;m(41,50)=-1;
m(42,33)=-1;m(42,41)=-1;m(42,42)=4;m(42,43)=-1;m(42,51)=-1;
m(43,34)=-1;m(43,42)=-1;m(43,43)=4;m(43,44)=-1;m(43,52)=-1;
m(44,35)=-1;m(44,43)=-1;m(44,44)=4;m(44,53)=-1;
m(45,45)=1;
m(46,46)=1;
m(47,38)=-1;m(47,47)=4;m(47,48)=-1;m(47,56)=-1;
m(48,39)=-1;m(48,47)=-1;m(48,48)=4;m(48,49)=-1;m(48,57)=-1;
m(49,40)=-1;m(49,48)=-1;m(49,49)=4;m(49,50)=-1;m(49,58)=-1;
m(50,41)=-1;m(50,49)=-1;m(50,50)=4;m(50,51)=-1;m(50,59)=-1;
m(51,42)=-1;m(51,50)=-1;m(51,51)=4;m(51,52)=-1;m(51,60)=-1;
m(52,43)=-1;m(52,51)=-1;m(52,52)=4;m(52,53)=-1;m(52,61)=-1;
m(53,44)=-1;m(53,52)=-1;m(53,53)=4;m(53,62)=-1;
m(54,54)=1;
m(55,55)=1;
m(56,47)=-1;m(56,56)=4;m(56,57)=-1;m(56,65)=-1;
m(57,48)=-1;m(57,56)=-1;m(57,57)=4;m(57,58)=-1;m(57,66)=-1;
m(58,49)=-1;m(58,57)=-1;m(58,58)=4;m(58,59)=-1;m(58,67)=-1;
m(59,50)=-1;m(59,58)=-1;m(59,59)=4;m(59,60)=-1;m(59,68)=-1;
m(60,51)=-1;m(60,59)=-1;m(60,60)=4;m(60,61)=-1;m(60,69)=-1;
m(61,52)=-1;m(61,60)=-1;m(61,61)=4;m(61,62)=-1;m(61,70)=-1;
m(62,53)=-1;m(62,61)=-1;m(62,62)=4;m(62,71)=-1;
m(63,63)=1;
m(64,64)=1;
m(65,56)=-1;m(65,65)=4;m(65,66)=-1;
m(66,57)=-1;m(66,65)=-1;m(66,66)=4;m(66,67)=-1;
m(67,58)=-1;m(67,66)=-1;m(67,67)=4;m(67,68)=-1;
m(68,59)=-1;m(68,67)=-1;m(68,68)=4;m(68,69)=-1;
m(69,60)=-1;m(69,68)=-1;m(69,69)=4;m(69,70)=-1;
m(70,61)=-1;m(70,69)=-1;m(70,70)=4;m(70,71)=-1;
m(71,62)=-1;m(71,70)=-1;m(71,71)=4;
m(72,72)=1;
m(73,73)=1;
m(74,74)=1;
m(75,75)=1;
m(76,76)=1;
m(77,77)=1;
m(78,78)=1;
m(79,79)=1;
m(80,80)=1;
m(81,81)=1;
b[1]=2;
b[2]=2.1331484530668263168;
b[3]=2.2840254166877414842;
b[4]=2.4549914146182013361;
b[5]=2.6487212707001281469;
b[6]=2.8682459574322224064;
b[7]=3.1170000166126746685;
b[8]=3.3988752939670979147;
b[9]=3.7182818284590452354;
b[10]=2.1331484530668263168;
b[11]=4.2308398850254749328;
b[12]=2.246207871824107949;
b[13]=2.4144990459126455268;
b[14]=2.6051979294958718476;
b[15]=2.8212880744297755536;
b[16]=3.066150287884614834;
b[17]=7.1950458078013565417;
b[18]=3.8514302815258715522;
b[19]=2.2840254166877414842;
b[20]=2.246207871824107949;
b[21]=-0.040178068619089369466;
b[22]=-0.042852892461011643549;
b[23]=-0.045883864959712133594;
b[24]=-0.049318406757902687126;
b[25]=-0.053210252483515668836;
b[26]=3.9446869536997179601;
b[27]=4.0023072451467867194;
b[28]=2.4549914146182013361;
b[29]=2.4144990459126455268;
b[30]=-0.042852892461011643545;
b[31]=-0.045527716302933917628;
b[32]=-0.048558688801634407676;
b[33]=-0.051993230599824961206;
b[34]=-0.055885076325437942915;
b[35]=4.1129781277882555383;
b[36]=4.1732732430772465715;
b[37]=2.6487212707001281469;
b[38]=2.6051979294958718476;
b[39]=-0.045883864959712133594;
b[40]=-0.048558688801634407683;
b[41]=-0.051589661300334897725;
b[42]=-0.055024203098525451244;
b[43]=-0.058916048824138432963;
b[44]=4.3036770113714818589;
b[45]=4.3670030991591733821;
b[46]=2.8682459574322224064;
b[47]=2.8212880744297755536;
b[48]=-0.049318406757902687123;
b[49]=-0.051993230599824961199;
b[50]=-0.055024203098525451251;
b[51]=-0.058458744896716004783;
b[52]=-0.062350590622328986499;
b[53]=4.5197671563053855651;
b[54]=4.586527785891267642;
b[55]=3.1170000166126746685;
b[56]=3.066150287884614834;
b[57]=-0.053210252483515668832;
b[58]=-0.055885076325437942912;
b[59]=-0.058916048824138432957;
b[60]=-0.062350590622328986493;
b[61]=-0.066242436347941968192;
b[62]=4.764629369760224845;
b[63]=4.8352818450717199037;
b[64]=3.3988752939670979147;
b[65]=7.1950458078013565417;
b[66]=3.9446869536997179601;
b[67]=4.1129781277882555383;
b[68]=4.3036770113714818589;
b[69]=4.5197671563053855651;
b[70]=4.764629369760224845;
b[71]=10.159251730577238151;
b[72]=5.1171571224261431501;
b[73]=3.7182818284590452354;
b[74]=3.8514302815258715522;
b[75]=4.0023072451467867194;
b[76]=4.1732732430772465715;
b[77]=4.3670030991591733821;
b[78]=4.586527785891267642;
b[79]=4.8352818450717199037;
b[80]=5.1171571224261431501;
b[81]=5.4365636569180904709;

//matrix<long double> DuDv=Uh.DUDV();
matrix<long double> DuDv(Uh.GlobalDofNumber(),Uh.GlobalDofNumber());
Uh.DUDV(DuDv);
vector<long double> s=Uh.B(f_test_p1c,NbIntPts);
Uh.Dirichlet(DuDv,s,u_test_p1c);

for(int i=1;i<=Uh.GlobalDofNumber();i++)
boolean*=(abs(b[i]-s[i])<=epsilon_loc);

if (detail) affiche("Integration right-hand side",boolean);
else
result*=boolean;


boolean=1;
for(int i=1;i<=Uh.GlobalDofNumber();i++)
for(int j=1;j<=Uh.GlobalDofNumber();j++)
boolean*=(abs(m(i,j)-DuDv(i,j))<=epsilon_loc);



if (detail) affiche("Stifness Matrix",boolean);
else
result*=boolean;


long double l2_error_loc=0.0047938978570588282012;
long double semi_h1_error_loc=0.091137837443127545243;


vector<long double> x0(s.dim());
vector<long double> uh(s.dim());
int iter;
 uh=conjugate_gradient(DuDv,s,x0,iter,1.e-12);


boolean=(abs(l2_error_loc-Uh.error_L2(u_test_p1c,uh,NbIntPts))<=epsilon_loc);
if (detail) affiche("l2 error",boolean);
else
result*=boolean;

boolean=(abs(semi_h1_error_loc-Uh.error_semi_H1(dudx_test_p1c,dudy_test_p1c,uh,NbIntPts))<=epsilon_loc);
if (detail) affiche("semi h1 error",boolean);
else
result*=boolean;

boolean=(abs(0.25-Th.Laplacian_Residual_L2(f_equal1,1))<=epsilon_loc);
if (detail) affiche("Laplacian_Residual_L2",boolean);
else
result*=boolean;

p1c2d<long double> Test_Th("data/8.txt","data/81.txt");
matrix<long double> Test_DuDv(Test_Th.GlobalDofNumber(),Test_Th.GlobalDofNumber());
Test_Th.DUDV(Test_DuDv);
vector<long double> Test_s=Test_Th.B(f_test_p1c,NbIntPts);
Test_Th.Dirichlet(Test_DuDv,Test_s,u_test_p1c);
vector<long double> Test_x0(Test_s.dim());
vector<long double> Test_uh(Test_s.dim());
int Test_iter;
Test_uh=conjugate_gradient(Test_DuDv,Test_s,Test_x0,Test_iter,1.e-12);
long double Test_erreur_L2=Test_Th.error_L2(u_test_p1c,Test_uh,NbIntPts);
long double Test_erreur_semi_H1=Test_Th.error_semi_H1(dudx_test_p1c,dudy_test_p1c,Test_uh,NbIntPts);
long double estiloc,estiglob=0;
for (int numelement=1; numelement<=Test_Th.nbelement();numelement++)
{
estiloc=Test_Th.Laplacian_Residual_L2(f_test_p1c,numelement)+Test_Th.Grad_Normal_Jump_L2(Test_uh,numelement);
estiglob+=pow(estiloc,2);
}
estiglob=sqrt(estiglob);
// On doit trouver :
// Erreur L2 = 0.00479389785706
// Erreur semi H1 = 0.0911378374431
// Estimateur Global= 1.12497171659

boolean=(abs(0.00479389785706-Test_erreur_L2)<=epsilon_loc);
if (detail) affiche("L2 error test 2",boolean);
else
result*=boolean;

boolean=(abs(0.0911378374431-Test_erreur_semi_H1)<=epsilon_loc);
if (detail) affiche("semi h1 error test 2",boolean);
else
result*=boolean;

boolean=(abs(1.12497171659-estiglob)<=epsilon_loc);
if (detail) affiche("Estimateur global",boolean);
else
result*=boolean;




cout << "============================================================== \n";
  if (result) cout<< "                    p1c2d test passed \n";
  else cout << "                    p1c2d test failed \n";
  cout << "============================================================== \n";

return result;
}
#endif


