/***************************************************************
 *                    simula+@metz.ensam.fr                    *
 *                   GNU/linux version 0.0.2                   *
 *            software under General Public License            *
 ***************************************************************
 * copyright  2006 CREUSE Emmanuel
 * copyright  Laboratoire de Physique et Mcanique des Matriaux (LPMM - UMR 7554)
 * copyright  Laboratoire de Mathmatiques et ses Applications de Valenciennes (LAMAV - EA 4015)
 ***************************************************************/

/*
    convert_triangle_to_simula+.cpp belongs to Mathematical Object Libraries (FEMOL++)
    FEMOL++ is part of Simula+

    Simula+ is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    Simula+ is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Simula+; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/
#include <iomanip.h>
#include <iostream.h>
#include <fstream.h>
#include <assert.h>
#include <string.h>

main()
{

  ifstream in_file_node("PartOfCircle.1.node");
  ifstream in_file_ele("PartOfCircle.1.ele");
  assert (!in_file_node.fail());
  assert (!in_file_ele.fail());
  // opening of the output file : if it does not exit, it is created. Else, it is overwritten.
  ofstream out_file("PartOfCircle4.txt",ios::trunc);
  assert (!out_file.fail());
  
  int ns,nt,entier0,entier1,entier2,boundary;
  int neu1,neu2,neu3;
  long double x,y;
  
  out_file << 2 << endl;
  in_file_node >> ns >> entier0 >> entier1 >> entier2;
  out_file << ns << endl;
  for (int i=1; i<=ns; i++)
   {
   in_file_node >> entier0 >> x >> y >> boundary;
   out_file << setprecision(12) << x << "  " << setprecision(12) << y << "  " << boundary << endl;
    } 
  in_file_ele >> nt >> entier0 >> entier1 ;
  out_file << nt << endl;   
  for (int i=1; i<=nt; i++)
   {
   in_file_ele >> entier0 >> neu1 >> neu2 >> neu3 >> entier1;
   out_file << neu1 << "  " << neu2 << "  " << neu3 << endl;
    } 
}
