/***************************************************************
 *                 Finite Element Method Object Library        *
 *           class mesh_tri_2d : declaration for mesh_tri_2d   *
 *                    simula+@metz.ensam.fr                    *
 *	             GNU/linux version 0.1.0	               *
 *            software under General Public License            *
 ***************************************************************
 * copyright  2005,2006 CREUSE Emmanuel
 * copyright  2005,2006 SOUALEM Nadir
 * copyright  2006 COCHEZ Sarah
 * copyright  2006 BOULAAJINE Lahcen
 * copyright  Laboratoire de Physique et Mcanique des Matriaux (LPMM - UMR 7554)
 * copyright  Laboratoire de Mathmatiques et ses Applications de Valenciennes (LAMAV - EA 4015)
 ***************************************************************/

/*! \class mesh_tri_2d
    \brief mesh_tri_2d library \n

    \htmlonly 
    <FONT color="#838383">

    mesh_tri_2d belongs to Finite Element Method Object Libraries (FEMOL++) </br>
    FEMOL++ is part of Simula+ <br><br>

    Simula+ is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version. <br><br>

    Simula+ is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details. <br><br>

    You should have received a copy of the GNU General Public License
    along with Simula+; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA

    </FONT>
    \endhtmlonly

    \authors copyright \htmlonly &#169; \endhtmlonly  2005,2006 CREUSE Emmanuel \n
	     copyright \htmlonly &#169; \endhtmlonly  2005,2006 SOUALEM Nadir \n
	     copyright \htmlonly &#169; \endhtmlonly  2006 COCHEZ Sarah \n
	     copyright \htmlonly &#169; \endhtmlonly  2006 BOULAAJINE Lahcen \n
	     copyright \htmlonly &#169; \endhtmlonly Laboratoire de Physique et Mcanique des Matriaux (LPMM - UMR 7554) \n
	     copyright \htmlonly &#169; \endhtmlonly Laboratoire de Mathmatiques et ses Applications de Valenciennes (LAMAV - EA 4015)
    \version 0.2.4
    \date 2002-2006
    \bug none
    \warning none
*/


#ifndef __cplusplus
#error Must use C++ for the type mesh_tri_2d
#endif

#ifndef _mesh_tri_2d_h
#define _mesh_tri_2d_h

#if !defined(__VECTORS_H)
#include "../../MOL++/vectors.h"
#endif

#if !defined(__MATRIX_H)
#include "../../MOL++/matrix.h"
#endif

#if !defined(__ASSERT_H)
#include <assert.h>
#endif

#if !defined(__MESH_H)
#include "mesh.h"
#endif

#if !defined(__INTEGRATION_H)
#include "../../MOL++/integration.h"
#endif


using namespace std;

//=============================
template <class T> class mesh_tri_2d:public mesh<triangle,T>
//=============================

{
  //protected :
  protected :
  int nbsegments_;
  matrix<int> SetOfEdges_;
  vector<int> Type_of_edge_;
  matrix<int> EdgesPerTriangle_;
  vector<int> NbTrianglesPerEdge_;
  matrix<int> TrianglesPerEdge_;
  matrix<int> TrianglesPerTriangle_;
  vector<int> NumberOfNeighboorOfTriangles_;
  matrix<int> NumLocNodeInTriangle_;
  matrix<int> NormalDirection_;
  vector<T> hminT_;
  vector<T> hE_;
  vector<T> hminE_;
  void remplir_descripteurs_anisotropes();
  vector<T> NormEdge_;
  matrix<T> NormalUnitVector_;
  // Nadir et Manu 240106
  int NbMaxSegmentsPerNode_;
  vector<int> NbSegmentsPerNode_;
  public :
  mesh_tri_2d();
  mesh_tri_2d(const char*, const char*);
  mesh_tri_2d(const char*);
  mesh_tri_2d(const mesh_tri_2d<T>&);
  ~mesh_tri_2d();//
  mesh_tri_2d<T>& operator=(const mesh_tri_2d<T>&);
  void refine_mesh(vector<int>&); // refine the mesh
  void refine_mesh_angle(vector<int>&, T); // refine the mesh
  int nbsegments()const{return(nbsegments_);};
  matrix<int> SetOfEdges()const{return(SetOfEdges_);};
  vector<int> Type_of_edge()const{return(Type_of_edge_);};
  matrix<int> EdgesPerTriangle()const{return(EdgesPerTriangle_);};
  vector<int> NbTrianglesPerEdge()const {return(NbTrianglesPerEdge_);};
  matrix<int> TrianglesPerEdge()const {return(TrianglesPerEdge_);};
  matrix<int> TrianglesPerTriangle()const {return(TrianglesPerTriangle_);};
  vector<int> NumberOfNeighboorOfTriangles() const {return(NumberOfNeighboorOfTriangles_);};
  matrix<int> NumLocNodeInTriangle() const {return(NumLocNodeInTriangle_);};
  matrix<int> NormalDirection() const {return(NormalDirection_);};
  vector<T> hminT()const{return(hminT_);};
  vector<T> hE()const{return(hE_);};
  vector<T> hminE()const{return(hminE_);};
  vector<T> NormEdge()const{return(NormEdge_);};
  matrix<T> NormalUnitVector()const{return(NormalUnitVector_);};
  int NbMaxSegmentsPerNode()const{return(NbMaxSegmentsPerNode_);};
  vector<int> NbSegmentsPerNode()const{return(NbSegmentsPerNode_);};
  friend  int operator == <T> (const mesh_tri_2d<T>&,const mesh_tri_2d<T>&);
  friend  int operator != <T> (const mesh_tri_2d<T>&,const mesh_tri_2d<T>&);
  int num_loc(int, int) const;
};


/*!
  \brief default constructor of the mesh_tri_2d class
*/
//=============================
template <class T>
mesh_tri_2d<T>::mesh_tri_2d() :mesh<triangle,T>()
//=============================
{
nbsegments_=0;
}

//=============================
template <class T>
mesh_tri_2d<T>::mesh_tri_2d(const char*file1, const char*file2) :mesh<triangle,T>(file1,file2)
//=============================
{

EdgesPerTriangle_=matrix<int>(nbelement_,3);
matrix<int> VertexOfEdge(3,2);
VertexOfEdge(1,1)=2;VertexOfEdge(1,2)=3;
VertexOfEdge(2,1)=3;VertexOfEdge(2,2)=1;
VertexOfEdge(3,1)=1;VertexOfEdge(3,2)=2;

int tmp,p;
nbsegments_=0;
vector<int> head(nbvertex_);

int nbe=nbvertex_+nbelement_;
vector<int> next(nbe);
matrix<int> HypSetOfedges(nbe,2);
vector<int> HypType_of_edge_(nbe);
for(int i=1;i<=nbe;i++)
HypType_of_edge_[i]=1;

for(int k=1;k<=nbelement_;k++)
	for(int edge_number=1;edge_number<=3;edge_number++)
	{
	int i=number(element[k-1][VertexOfEdge(edge_number,1)]);
	int j=number(element[k-1][VertexOfEdge(edge_number,2)]);
	if(j<i)
		{tmp=i;i=j;j=tmp;}
	int exists=0;
	for(int e=head[i];e!=0;e=next[e])
		if(HypSetOfedges(e,2)==j)
		{
		exists=1;
		HypType_of_edge_[e]=0;
		p=1;
			while((p<=3) && (EdgesPerTriangle_(k,p)!=0))
			++p;
		EdgesPerTriangle_(k,p)=e;
		break;
		}
		if(exists==0)
		{
		nbsegments_++;
		assert(nbsegments_<nbe);
		HypSetOfedges(nbsegments_,1)=i;
		HypSetOfedges(nbsegments_,2)=j;
		next[nbsegments_]=head[i];
		p=1;
			while((p<=3) && (EdgesPerTriangle_(k,p)!=0))
			++p;
		head[i]=EdgesPerTriangle_(k,p)=nbsegments_;
	}
}

SetOfEdges_=matrix<int>(nbsegments_,2);
Type_of_edge_=vector<int>(nbsegments_);
for(int i=1;i<=nbsegments_;i++)
{
SetOfEdges_[i]=HypSetOfedges[i];
Type_of_edge_[i]=HypType_of_edge_[i];
}

NbSegmentsPerNode_=vector<int>(nbvertex_);
for (int numseg=1; numseg<=nbsegments_;numseg++)
{
 NbSegmentsPerNode_[SetOfEdges_(numseg,1)]++;
 NbSegmentsPerNode_[SetOfEdges_(numseg,2)]++;
} 
NbMaxSegmentsPerNode_=NbSegmentsPerNode_.norminf();

//---------------------------------------------------------------------------------------------------
// Remplissage de NbTrianglesPerEdge_ et de TrianglesPerEdge_
// Remplissage de NormalDirection_ (29 Mars 2005 - Emmanuel Creus) : on rappelle que le jeme segment
// local  la maille K est en face du jeme noeud local  la maille K !!!
// Ici, dans le cas d'un segment frontalier jseg, c'est toujours TrianglesPerEdge(jseg,2) qui est nul
//---------------------------------------------------------------------------------------------------
NbTrianglesPerEdge_=vector<int>(nbsegments_);
TrianglesPerEdge_=matrix<int>(nbsegments_,2);
NormalDirection_=matrix<int>(nbelement_,3);
int numseg;
int num_node_1,num_node_2,num_node_in_front ;
for (int jt=1; jt<=nbelement_; jt++)
{
 for (int j=1; j<=3; j++)
  {
   numseg=EdgesPerTriangle_(jt,j);
   num_node_1=SetOfEdges_(numseg,1);
   num_node_2=SetOfEdges_(numseg,2);
   num_node_in_front=number(element[jt-1][j]);
   if (((vertices[num_node_2-1]-vertices[num_node_1-1]).ortho2D()*(vertices[num_node_in_front-1]-vertices[num_node_1-1]))>0)
    {NormalDirection_(jt,j)=-1;}
   else
    {NormalDirection_(jt,j)=1;}
   NbTrianglesPerEdge_[numseg]++;
   TrianglesPerEdge_(numseg,NbTrianglesPerEdge_[numseg])=jt;
  }
}

//---------------------------------------------------------------------------------------------------
// Remplissage de  NumberOfNeighboorOfTriangles_,TrianglesPerTriangle_ et NumLocNodeInTriangle_
//---------------------------------------------------------------------------------------------------
// Modif 04/01/06 pour descripteur TrianglesPerTriangle_ (SC,LB,EC)
  int NumNoeudA,NumNoeudB;

  NumberOfNeighboorOfTriangles_=vector<int>(nbelement_); // Nb de mailles voisines  chaque maille.
  TrianglesPerTriangle_=matrix<int>(nbelement_,3); // Numro des mailles voisines  chaque maille.
  int NumMaille1, NumMaille2;
  int NumLocSegInTriangle1, NumLocSegInTriangle2;
  NumLocNodeInTriangle_=matrix<int>(nbsegments_,4);

  for (int i=1; i<=nbsegments_;i++)
  {
    //cout <<"-----------------------------------------------\n";
    //cout << "nsegment= " << i << "\n";
    NumMaille1=TrianglesPerEdge_(i,1); // c'est K+
    NumMaille2=TrianglesPerEdge_(i,2); // c'est K-
    //cout << "NumMaille1= " << NumMaille1 << "\n";
    //cout << "NumMaille2= " << NumMaille2 << "\n";
    
    NumNoeudA=SetOfEdges_(i,1);
    NumNoeudB=SetOfEdges_(i,2);
    //cout << "NumNoeudA= " << NumNoeudA << "\n";
    //cout << "NumNoeudB= " << NumNoeudB << "\n";

    
    if (NumMaille1!=0)
     {
      NumLocNodeInTriangle_(i,1)=num_loc(NumMaille1,NumNoeudA);
      NumLocNodeInTriangle_(i,2)=num_loc(NumMaille1,NumNoeudB);
      NumLocSegInTriangle1=6-NumLocNodeInTriangle_(i,1)-NumLocNodeInTriangle_(i,2);
      //cout << "NumLocNodeInTriangle_(" << i << ",1)= " << NumLocNodeInTriangle_(i,1)<<"\n";
      //cout << "NumLocNodeInTriangle_(" << i << ",2)= " << NumLocNodeInTriangle_(i,2)<<"\n";
     
     }

     if (NumMaille2!=0)
     {
      NumLocNodeInTriangle_(i,3)=num_loc(NumMaille2,NumNoeudA);
      NumLocNodeInTriangle_(i,4)=num_loc(NumMaille2,NumNoeudB);
      NumLocSegInTriangle2=6-NumLocNodeInTriangle_(i,3)-NumLocNodeInTriangle_(i,4);
      //cout << "NumLocNodeInTriangle_(" << i << ",3)= " << NumLocNodeInTriangle_(i,3)<<"\n";
      //cout << "NumLocNodeInTriangle_(" << i << ",4)= " << NumLocNodeInTriangle_(i,4)<<"\n";
     
     }

    if ((NumMaille1!=0)&&(NumMaille2!=0))
     {
      NumberOfNeighboorOfTriangles_[NumMaille2]++;
//      TrianglesPerTriangle_(NumMaille2,NumberOfNeighboorOfTriangles_[NumMaille2])=NumMaille1;
      TrianglesPerTriangle_(NumMaille2,NumLocSegInTriangle2)=NumMaille1;
      //cout << "TrianglesPerTriangle_(" << NumMaille2 << "," << NumLocSegInTriangle2 << ")= " << NumMaille1 << "\n";
      NumberOfNeighboorOfTriangles_[NumMaille1]++;
//      TrianglesPerTriangle_(NumMaille1,NumberOfNeighboorOfTriangles_[NumMaille1])=NumMaille2;
      TrianglesPerTriangle_(NumMaille1,NumLocSegInTriangle1)=NumMaille2;
      //cout << "TrianglesPerTriangle_(" << NumMaille1 << "," << NumLocSegInTriangle1 << ")= " << NumMaille2 << "\n";
     }
  }
     hminT_=vector<T>(nbelement_);
     hE_=vector<T>(nbsegments_);
     hminE_=vector<T>(nbsegments_);
     remplir_descripteurs_anisotropes();
//------------------------------------------------------------------
// Remplissage de NormEdge_ et NormalUnitVector_
//------------------------------------------------------------------
    NormEdge_=vector<T>(nbsegments_);
    NormalUnitVector_=matrix<T>(nbsegments_,2);

    for (int num_seg=1; num_seg<=nbsegments_; num_seg++)
    {
     NumNoeudA=SetOfEdges_(num_seg,1);
     NumNoeudB=SetOfEdges_(num_seg,2);
     vector<T> AB(vertices[NumNoeudB-1]-vertices[NumNoeudA-1]);
     T E=AB.norm();
     NormEdge_[num_seg]=E;
     NormalUnitVector_[num_seg]=AB.ortho2D()/E;
    }
}

//=============================
template <class T>
mesh_tri_2d<T>::mesh_tri_2d(const char*file1) :mesh<triangle,T>(file1)
//=============================
{
EdgesPerTriangle_=matrix<int>(nbelement_,3);
matrix<int> VertexOfEdge(3,2);
VertexOfEdge(1,1)=2;VertexOfEdge(1,2)=3;
VertexOfEdge(2,1)=3;VertexOfEdge(2,2)=1;
VertexOfEdge(3,1)=1;VertexOfEdge(3,2)=2;

int tmp,p;
nbsegments_=0;
vector<int> head(nbvertex_);

int nbe=nbvertex_+nbelement_;
vector<int> next(nbe);
matrix<int> HypSetOfedges(nbe,2);
vector<int> HypType_of_edge_(nbe);
for(int i=1;i<=nbe;i++)
HypType_of_edge_[i]=1;

for(int k=1;k<=nbelement_;k++)
	for(int edge_number=1;edge_number<=3;edge_number++)
	{
	int i=number(element[k-1][VertexOfEdge(edge_number,1)]);
	int j=number(element[k-1][VertexOfEdge(edge_number,2)]);
	if(j<i)
		{tmp=i;i=j;j=tmp;}
	int exists=0;
	for(int e=head[i];e!=0;e=next[e])
		if(HypSetOfedges(e,2)==j)
		{
		exists=1;
		HypType_of_edge_[e]=0;
		p=1;
			while((p<=3) && (EdgesPerTriangle_(k,p)!=0))
			++p;
		EdgesPerTriangle_(k,p)=e;
		break;
		}
		if(exists==0)
		{
		nbsegments_++;
		assert(nbsegments_<nbe);
		HypSetOfedges(nbsegments_,1)=i;
		HypSetOfedges(nbsegments_,2)=j;
		next[nbsegments_]=head[i];
		p=1;
			while((p<=3) && (EdgesPerTriangle_(k,p)!=0))
			++p;
		head[i]=EdgesPerTriangle_(k,p)=nbsegments_;
	}
}

SetOfEdges_=matrix<int>(nbsegments_,2);
Type_of_edge_=vector<int>(nbsegments_);
for(int i=1;i<=nbsegments_;i++)
{
SetOfEdges_[i]=HypSetOfedges[i];
Type_of_edge_[i]=HypType_of_edge_[i];
}

NbSegmentsPerNode_=vector<int>(nbvertex_);
for (int numseg=1; numseg<=nbsegments_;numseg++)
{
 NbSegmentsPerNode_[SetOfEdges_(numseg,1)]++;
 NbSegmentsPerNode_[SetOfEdges_(numseg,2)]++;
} 
NbMaxSegmentsPerNode_=NbSegmentsPerNode_.norminf();

//---------------------------------------------------------------------------------------------------
// Remplissage de NbTrianglesPerEdge_ et de TrianglesPerEdge_
// Remplissage de NormalDirection_ (29 Mars 2005 - Emmanuel Creus) : on rappelle que le jeme segment
// local  la maille K est en face du jeme noeud local  la maille K !!!
// Ici, dans le cas d'un segment frontalier jseg, c'est toujours TrianglesPerEdge(jseg,2) qui est nul
//---------------------------------------------------------------------------------------------------
NbTrianglesPerEdge_=vector<int>(nbsegments_);
TrianglesPerEdge_=matrix<int>(nbsegments_,2);
NormalDirection_=matrix<int>(nbelement_,3);
int numseg;
int num_node_1,num_node_2,num_node_in_front ;
for (int jt=1; jt<=nbelement_; jt++)
{
 for (int j=1; j<=3; j++)
  {
   numseg=EdgesPerTriangle_(jt,j);
   num_node_1=SetOfEdges_(numseg,1);
   num_node_2=SetOfEdges_(numseg,2);
   num_node_in_front=number(element[jt-1][j]);
   if (((vertices[num_node_2-1]-vertices[num_node_1-1]).ortho2D()*(vertices[num_node_in_front-1]-vertices[num_node_1-1]))>0)
    {NormalDirection_(jt,j)=-1;}
   else
    {NormalDirection_(jt,j)=1;}
   NbTrianglesPerEdge_[numseg]++;
   TrianglesPerEdge_(numseg,NbTrianglesPerEdge_[numseg])=jt;
  }
}

//---------------------------------------------------------------------------------------------------
// Remplissage de  NumberOfNeighboorOfTriangles_,TrianglesPerTriangle_ et NumLocNodeInTriangle_
//---------------------------------------------------------------------------------------------------
// Modif 04/01/06 pour descripteur TrianglesPerTriangle_ (SC,LB,EC)
  int NumNoeudA,NumNoeudB;

  NumberOfNeighboorOfTriangles_=vector<int>(nbelement_); // Nb de mailles voisines  chaque maille.
  TrianglesPerTriangle_=matrix<int>(nbelement_,3); // Numro des mailles voisines  chaque maille.
  int NumMaille1, NumMaille2;
  int NumLocSegInTriangle1, NumLocSegInTriangle2;
  NumLocNodeInTriangle_=matrix<int>(nbsegments_,4);

  for (int i=1; i<=nbsegments_;i++)
  {
    //cout <<"-----------------------------------------------\n";
    //cout << "nsegment= " << i << "\n";
    NumMaille1=TrianglesPerEdge_(i,1); // c'est K+
    NumMaille2=TrianglesPerEdge_(i,2); // c'est K-
    //cout << "NumMaille1= " << NumMaille1 << "\n";
    //cout << "NumMaille2= " << NumMaille2 << "\n";
    
    NumNoeudA=SetOfEdges_(i,1);
    NumNoeudB=SetOfEdges_(i,2);
    //cout << "NumNoeudA= " << NumNoeudA << "\n";
    //cout << "NumNoeudB= " << NumNoeudB << "\n";

    
    if (NumMaille1!=0)
     {
      NumLocNodeInTriangle_(i,1)=num_loc(NumMaille1,NumNoeudA);
      NumLocNodeInTriangle_(i,2)=num_loc(NumMaille1,NumNoeudB);
      NumLocSegInTriangle1=6-NumLocNodeInTriangle_(i,1)-NumLocNodeInTriangle_(i,2);
      //cout << "NumLocNodeInTriangle_(" << i << ",1)= " << NumLocNodeInTriangle_(i,1)<<"\n";
      //cout << "NumLocNodeInTriangle_(" << i << ",2)= " << NumLocNodeInTriangle_(i,2)<<"\n";
     
     }

     if (NumMaille2!=0)
     {
      NumLocNodeInTriangle_(i,3)=num_loc(NumMaille2,NumNoeudA);
      NumLocNodeInTriangle_(i,4)=num_loc(NumMaille2,NumNoeudB);
      NumLocSegInTriangle2=6-NumLocNodeInTriangle_(i,3)-NumLocNodeInTriangle_(i,4);
      //cout << "NumLocNodeInTriangle_(" << i << ",3)= " << NumLocNodeInTriangle_(i,3)<<"\n";
      //cout << "NumLocNodeInTriangle_(" << i << ",4)= " << NumLocNodeInTriangle_(i,4)<<"\n";
     
     }

    if ((NumMaille1!=0)&&(NumMaille2!=0))
     {
      NumberOfNeighboorOfTriangles_[NumMaille2]++;
//      TrianglesPerTriangle_(NumMaille2,NumberOfNeighboorOfTriangles_[NumMaille2])=NumMaille1;
      TrianglesPerTriangle_(NumMaille2,NumLocSegInTriangle2)=NumMaille1;
      //cout << "TrianglesPerTriangle_(" << NumMaille2 << "," << NumLocSegInTriangle2 << ")= " << NumMaille1 << "\n";
      NumberOfNeighboorOfTriangles_[NumMaille1]++;
//      TrianglesPerTriangle_(NumMaille1,NumberOfNeighboorOfTriangles_[NumMaille1])=NumMaille2;
      TrianglesPerTriangle_(NumMaille1,NumLocSegInTriangle1)=NumMaille2;
      //cout << "TrianglesPerTriangle_(" << NumMaille1 << "," << NumLocSegInTriangle1 << ")= " << NumMaille2 << "\n";
     }
  }
     hminT_=vector<T>(nbelement_);
     hE_=vector<T>(nbsegments_);
     hminE_=vector<T>(nbsegments_);
     remplir_descripteurs_anisotropes();
//------------------------------------------------------------------
// Remplissage de NormEdge_ et NormalUnitVector_
//------------------------------------------------------------------
    NormEdge_=vector<T>(nbsegments_);
    NormalUnitVector_=matrix<T>(nbsegments_,2);

    for (int num_seg=1; num_seg<=nbsegments_; num_seg++)
    {
     NumNoeudA=SetOfEdges_(num_seg,1);
     NumNoeudB=SetOfEdges_(num_seg,2);
     vector<T> AB(vertices[NumNoeudB-1]-vertices[NumNoeudA-1]);
     T E=AB.norm();
     NormEdge_[num_seg]=E;
     NormalUnitVector_[num_seg]=AB.ortho2D()/E;
    }

}


//=============================
template <class T>
mesh_tri_2d<T>::mesh_tri_2d(const mesh_tri_2d<T>& EF) :mesh<triangle,T>(EF)
//=============================
{
  nbsegments_=EF.nbsegments_;
  SetOfEdges_=EF.SetOfEdges_;
  Type_of_edge_=EF.Type_of_edge_;
  EdgesPerTriangle_=EF.EdgesPerTriangle_;
  NbTrianglesPerEdge_=EF.NbTrianglesPerEdge_;
  TrianglesPerEdge_=EF.TrianglesPerEdge_;
  TrianglesPerTriangle_=EF.TrianglesPerTriangle_;
  NumberOfNeighboorOfTriangles_=EF.NumberOfNeighboorOfTriangles_;
  NumLocNodeInTriangle_=EF.NumLocNodeInTriangle_;
  NormalDirection_=EF.NormalDirection_;
  hminT_=EF.hminT_;
  hminE_=EF.hminE_;
  hE_=EF.hE_;
  NormEdge_=EF.NormEdge_;
  NormalUnitVector_=EF.NormalUnitVector_;
  NbSegmentsPerNode_=EF.NbSegmentsPerNode_;
  NbMaxSegmentsPerNode_=EF.NbMaxSegmentsPerNode_;
}

//=============================
template <class T>
mesh_tri_2d<T>:: ~mesh_tri_2d()
//=============================
{
  //    mesh<triangle,T>((*this)).~mesh<triangle,T>();
  // (*this).~mesh<triangle,T>();
    SetOfEdges_.~matrix<int>();
    Type_of_edge_.~vector<int>();
    EdgesPerTriangle_.~matrix<int>();
    NbTrianglesPerEdge_.~vector<int>();
    TrianglesPerEdge_.~matrix<int>();
    //NbTrianglesPerTriangle_.~vector<int>();
    TrianglesPerTriangle_.~matrix<int>();
    NumberOfNeighboorOfTriangles_.~vector<int>();
    NumLocNodeInTriangle_.~matrix<int>();
    NormalDirection_.~matrix<int>();
    hminT_.~vector<T>();
    hminE_.~vector<T>();
    hE_.~vector<T>();
    NormEdge_.~vector<T>();
    NormalUnitVector_.~matrix<T>();    
    NbSegmentsPerNode_.~vector<int>();
    NbMaxSegmentsPerNode_=0;
    nbsegments_=0;
}

//========================================================
template <class T>
mesh_tri_2d<T>& mesh_tri_2d<T>::operator =(const mesh_tri_2d<T>& EF)
//========================================================
{
 (*this).mesh<triangle,T>::operator=(EF);
  nbsegments_=EF.nbsegments_;
  SetOfEdges_=EF.SetOfEdges_;
  Type_of_edge_=EF.Type_of_edge_;
  EdgesPerTriangle_=EF.EdgesPerTriangle_;
  NbTrianglesPerEdge_=EF.NbTrianglesPerEdge_;
  TrianglesPerEdge_=EF.TrianglesPerEdge_;
  TrianglesPerTriangle_=EF.TrianglesPerTriangle_;
  NumberOfNeighboorOfTriangles_=EF.NumberOfNeighboorOfTriangles_;
  NumLocNodeInTriangle_=EF.NumLocNodeInTriangle_;
  NormalDirection_=EF.NormalDirection_;
  hminT_=EF.hminT_;
  hminE_=EF.hminE_;
  hE_=EF.hE_;
  NormEdge_=EF.NormEdge_;
  NormalUnitVector_=EF.NormalUnitVector_;
  NbSegmentsPerNode_=EF.NbSegmentsPerNode_;
  NbMaxSegmentsPerNode_=EF.NbMaxSegmentsPerNode_;
  return(*this);
}

//==========================================================================
template <class T>
int operator ==(const mesh_tri_2d<T>& EF1,const mesh_tri_2d<T>& EF2)
//==========================================================================
{
  int boolean=1;
  boolean*=(mesh<triangle,T>(EF1)==mesh<triangle,T>(EF2));
  boolean*=(EF1.nbsegments_==EF2.nbsegments_);
  boolean*=(EF1.SetOfEdges_==EF2.SetOfEdges_);
  boolean*=(EF1.Type_of_edge_==EF2.Type_of_edge_);
  boolean*=(EF1.EdgesPerTriangle_==EF2.EdgesPerTriangle_);
  boolean*=(EF1.NbTrianglesPerEdge_==EF2.NbTrianglesPerEdge_);
  boolean*=(EF1.TrianglesPerEdge_==EF2.TrianglesPerEdge_);
  boolean*=(EF1.TrianglesPerTriangle_==EF2.TrianglesPerTriangle_);
  boolean*=(EF1.NumberOfNeighboorOfTriangles_==EF2.NumberOfNeighboorOfTriangles_);
  boolean*=(EF1.NumLocNodeInTriangle_==EF2.NumLocNodeInTriangle_);
  boolean*=(EF1.NormalDirection_==EF2.NormalDirection_);
  boolean*=(EF1.hminT_==EF2.hminT_);
  boolean*=(EF1.hminE_==EF2.hminE_);
  boolean*=(EF1.hE_==EF2.hE_);
  boolean*=(EF1.NormEdge_==EF2.NormEdge_);
  boolean*=(EF1.NormalUnitVector_==EF2.NormalUnitVector_);
  boolean*=(EF1.NbSegmentsPerNode_==EF2.NbSegmentsPerNode_);
  boolean*=(EF1.NbMaxSegmentsPerNode_==EF2.NbMaxSegmentsPerNode_);
  return(boolean);
}

//==========================================================================
template <class T>
int operator !=(const mesh_tri_2d<T>& EF1,const mesh_tri_2d<T>& EF2)
//==========================================================================
{
  return(!(EF1==EF2));
}


//=============================
template <class T>
int mesh_tri_2d<T>::num_loc(int num_element,int num_node) const
//=============================
// return the local number of node num_node in the element num_element.
{
int num=0;
for (int j=1; j<=3 ; j++)
  {
    if (number(element[num_element-1][j])==num_node)
      {
        num=j;
        return(num);
      }
  }
 assert(num);
 // if its fails here, that means that the node num_node does not belong to
 // the element num_element.
}


//=============================
template <class T>
void mesh_tri_2d<T>::remplir_descripteurs_anisotropes()
//=============================
{

T deuxfoissurf, basemax, longueur_segment;
int num_seg, NumNoeudA, NumNoeudB;
vector<T> AB(2);


for (int i=1; i<=nbelement_; i++)

 {
    deuxfoissurf=element[i-1].AbsDet();
    basemax=0.0;
    for (int j=1; j<=3; j++)
      {
        num_seg=EdgesPerTriangle_(i,j);
        NumNoeudA=SetOfEdges_(num_seg,1);
        NumNoeudB=SetOfEdges_(num_seg,2);
        AB=vertices[NumNoeudB-1]-vertices[NumNoeudA-1];
        longueur_segment=AB.norm();
        if (Type_of_edge_[num_seg])
        {
         hE_[num_seg]=deuxfoissurf/longueur_segment;
        }
        else
        {
         hE_[num_seg]+=0.5*deuxfoissurf/longueur_segment;
        }
        if (longueur_segment>basemax) {basemax=longueur_segment;}
      }
    hminT_[i]=deuxfoissurf/basemax;
  }

//hminE_=vector<T>(nbsegments());
for (int i=1; i<=nbelement_; i++)
  {
   for (int j=1; j<=3; j++)
      {
        num_seg=EdgesPerTriangle_(i,j);
        if (Type_of_edge_[num_seg])
        {
         hminE_[num_seg]=hminT_[i];
        }
        else
        {
         hminE_[num_seg]+=0.5*hminT_[i];
        } 
      }
  }
}


//=============================
template <class T>
void mesh_tri_2d<T>::refine_mesh(vector<int> & TABTRI)
// rem : Phase 5 : it is possible to write on a file the new mesh obtained...
// to do it, remove the /* and */ marks of the phase 5.
//=============================
{
// Phase 1 : On modifie TABTRI pour affecter un statut  chaque triangle du maillage :
//   -1 : Maille  couper en quatre
//    1 : Maille  couper en deux
//    0 : Maille  ne pas couper
// TABSEG recense les segments qui seront coups en deux

vector<int> TABSEG(nbsegments_);
for (int jt=1; jt<=nbelement_; jt++)
 {
  if (TABTRI[jt]==-1)
   {
     for (int j=1; j<=3; j++)
     {
       if (TrianglesPerTriangle_(jt,j)) // Cette ligne rajoute le 11/02/05
        if (TABTRI[TrianglesPerTriangle_(jt,j)]!=-1) TABTRI[TrianglesPerTriangle_(jt,j)]++;
       TABSEG[EdgesPerTriangle_(jt,j)]=-1;
     }
   } 
 }


for (int RESTART=1 ; RESTART ; )
 {
  RESTART=0;
  for (int jt=1; jt<=nbelement_; jt++)
  {
   if (TABTRI[jt]>=2)
    {
     TABTRI[jt]=-1;
     for (int j=1; j<=3; j++)
      {
        if (TrianglesPerTriangle_(jt,j)) // Cette ligne rajoute le 11/02/05
       if (TABTRI[TrianglesPerTriangle_(jt,j)]!=-1) TABTRI[TrianglesPerTriangle_(jt,j)]++;
       TABSEG[EdgesPerTriangle_(jt,j)]=-1;
        if (TrianglesPerTriangle_(jt,j)) // Cette ligne rajoute le 11/02/05
       if ((TABTRI[TrianglesPerTriangle_(jt,j)]>=2)&&(TrianglesPerTriangle_(jt,j)<jt)) RESTART=1;
      }
    }
  }
 }
//------------------------------------------------------------------------- 
// Phase 2 : Dtermination du nouveau nombre de sommets et de triangles //
//-------------------------------------------------------------------------

int nbvertex_new=nbvertex_;
int nbelement_new=nbelement_;
vector<int> TABSEGLOC(nbsegments_);
TABSEGLOC=TABSEG;

for (int jt=1; jt<=nbelement_; jt++)
{
 if (TABTRI[jt]==-1)
  {
   nbelement_new+=3;
   for (int j=1; j<=3; j++)
    {
     if (TABSEGLOC[EdgesPerTriangle_(jt,j)]==-1)
     {
      nbvertex_new++;
      TABSEGLOC[EdgesPerTriangle_(jt,j)]=0;
     }
    }
   }
  else if (TABTRI[jt]==1)
   {
    nbelement_new++;
    for (int j=1; j<=3; j++)
    {
     if (TABSEGLOC[EdgesPerTriangle_(jt,j)]==-1)
     {
      nbvertex_new++;
      TABSEGLOC[EdgesPerTriangle_(jt,j)]=0;
     }
    }
   } 
  }

//---------------------------------------------------------------------------------
// Phase 3 : Cration et remplissage des tableaux contenant le nouveau maillage //
//---------------------------------------------------------------------------------
node<T>* vertices_new;
triangle<T>* element_new;
vertices_new=new node<T>[nbvertex_new](2);
element_new=new triangle<T>[nbelement_new];

node<T> ** nodes_of_element;
nodes_of_element=new node<T>*[3];

for (int i=0; i<nbvertex_; i++)
 vertices_new[i]=vertices[i];
 
 for(int i=0;i<nbelement_;i++)
  {
    for (int j=0;j<3;j++)
      {
       nodes_of_element[j]=&vertices_new[&(element[i][j+1])-vertices];
      }
    element_new[i]=triangle<T>(nodes_of_element);
  }

int num_current_triangle=nbelement_+1;
int num_current_vertex=nbvertex_+1;
T xnoeud,ynoeud;
int typenoeud;
vector<int> suiv(3),prec(3);
suiv[1]=2; suiv[2]=3; suiv[3]=1;
prec[1]=3; prec[2]=1; prec[3]=2;
int jloc;


for (int jt=1; jt<=nbelement_; jt++)
{

 if (TABTRI[jt]==-1)
  {
   for (int j=1; j<=3; j++)
    {
     if (TABSEG[EdgesPerTriangle_(jt,j)]==-1)
      {
       xnoeud=((*this)[jt][prec[j]][1]+(*this)[jt][suiv[j]][1])/2.0;
       ynoeud=((*this)[jt][prec[j]][2]+(*this)[jt][suiv[j]][2])/2.0;
       if (Type_of_edge_[EdgesPerTriangle_(jt,j)]) typenoeud=1; else typenoeud=0;
       vertices_new[num_current_vertex-1][1]=xnoeud;
       vertices_new[num_current_vertex-1][2]=ynoeud;
       vertices_new[num_current_vertex-1].boundary_condition()=typenoeud;
       TABSEG[EdgesPerTriangle_(jt,j)]=num_current_vertex;
       num_current_vertex++;
      }
     }  

// Cration des quatre nouvelles mailles
// D'abord la maille du milieu, que l'on stocke  la place de l'ancienne

    for (int j=0; j<=2; j++)
        {
        nodes_of_element[j]=&vertices_new[TABSEG[EdgesPerTriangle_(jt,j+1)]-1];
	}
        element_new[jt-1]=triangle<T>(nodes_of_element);
// Puis chacune des trois autres, que l'on stocke en queue de tableau
    for (int j=1; j<=3; j++)
       {
         //cout << "jt= "  << jt << "number= " << &(element_new[jt-1][j])-vertices_new << endl;
         //nodes_of_element[0]=&vertices_new[number((*this)[jt][j])-1];
	 nodes_of_element[0]=&vertices_new[&(element[jt-1][j])-vertices];
	 nodes_of_element[1]=&vertices_new[TABSEG[EdgesPerTriangle_(jt,prec[j])]-1];
	 nodes_of_element[2]=&vertices_new[TABSEG[EdgesPerTriangle_(jt,suiv[j])]-1];
	 
	 element_new[num_current_triangle-1]=triangle<T>(nodes_of_element);
	 num_current_triangle++;
       }
      }
  else if (TABTRI[jt]==1)
  {

   if (TABSEG[EdgesPerTriangle_(jt,1)]!=0) jloc=1;
   else if (TABSEG[EdgesPerTriangle_(jt,2)]!=0) jloc=2;
   else if (TABSEG[EdgesPerTriangle_(jt,3)]!=0) jloc=3;

// Cration ventuelle du noeud   
   if (TABSEG[EdgesPerTriangle_(jt,jloc)]==-1)
      {
       xnoeud=((*this)[jt][prec[jloc]][1]+(*this)[jt][suiv[jloc]][1])/2.0;
       ynoeud=((*this)[jt][prec[jloc]][2]+(*this)[jt][suiv[jloc]][2])/2.0;
       if (Type_of_edge_[EdgesPerTriangle_(jt,jloc)]) typenoeud=1; else typenoeud=0;
       vertices_new[num_current_vertex-1][1]=xnoeud;
       vertices_new[num_current_vertex-1][2]=ynoeud;
       vertices_new[num_current_vertex-1].boundary_condition()=typenoeud;
       //cout << vertices_new[num_current_vertex-1] << "\n";
       TABSEG[EdgesPerTriangle_(jt,jloc)]=num_current_vertex;
       num_current_vertex++;
      }
 
// Cration des deux mailles : la premire est stocke  la place de l'ancienne, la seconde en queue de tableau.
       nodes_of_element[0]=&vertices_new[TABSEG[EdgesPerTriangle_(jt,jloc)]-1];
       //nodes_of_element[1]=&vertices_new[number((*this)[jt][jloc])-1];
       //nodes_of_element[2]=&vertices_new[number((*this)[jt][prec[jloc]])-1];
       nodes_of_element[1]=&vertices_new[&(element[jt-1][jloc])-vertices];
       nodes_of_element[2]=&vertices_new[&(element[jt-1][prec[jloc]])-vertices];
       element_new[jt-1]=triangle<T>(nodes_of_element);
       //nodes_of_element[2]=&vertices_new[number((*this)[jt][suiv[jloc]])-1];
       nodes_of_element[2]=&vertices_new[&(element[jt-1][suiv[jloc]])-vertices];
       element_new[num_current_triangle-1]=triangle<T>(nodes_of_element);
       num_current_triangle++;
  }    
}


//------------------------------------------------------------
// Phase 4 : Modification du maillage initial
//------------------------------------------------------------

nbvertex_=nbvertex_new;
delete [] vertices;
vertices=new node<T>[nbvertex_](dimspace_);

for(int i=0;i<nbvertex_;i++)
      vertices[i]=vertices_new[i];

nbelement_=nbelement_new;
delete [] element;
element=new triangle<T>[nbelement_];

for(int i=0;i<nbelement_;i++)
  {

    for (int j=0;j<3;j++)
      {
	// Pour Nadir : le bug tait l !!!
        nodes_of_element[j]=&vertices[&(element_new[i][j+1])-vertices_new];
       }
    element[i]=triangle<T>(nodes_of_element);

  }
delete[] nodes_of_element;

// ---------------------------------------------------------------------------------------------------------
// Phase 5 : gnration du fichier de sortie pour sauvegarde du nouveau maillage (par defaut, non effectu)
//----------------------------------------------------------------------------------------------------------
/*
ofstream out_file("fichier_mesh.txt",ios::trunc);
  assert (!out_file.fail());

  out_file<<2<<endl;
  out_file<<nbvertex_<<endl;
  for (int i=1; i<= nbvertex_; i++)
   {
    for (int j=1; j<= 2; j++)
    {
     out_file<<vertices[i-1][j] << "   ";
    };
   out_file<<vertices[i-1].boundary_condition() <<endl; 
  };

out_file<<nbelement_<<endl;

for (int i=1; i<= nbelement_; i++)
{
 for (int j=1; j<=3; j++)
{
  out_file<<&element[i-1][j]-vertices+1 << "   "; 
}
out_file<<endl; 
}
out_file<<endl; 
out_file.close();
*/

EdgesPerTriangle_.~matrix();
EdgesPerTriangle_=matrix<int>(nbelement_,3);
matrix<int> VertexOfEdge(3,2);
VertexOfEdge(1,1)=2;VertexOfEdge(1,2)=3;
VertexOfEdge(2,1)=3;VertexOfEdge(2,2)=1;
VertexOfEdge(3,1)=1;VertexOfEdge(3,2)=2;

int tmp,p;
nbsegments_=0;
vector<int> head(nbvertex_);

int nbe=nbvertex_+nbelement_;
vector<int> next(nbe);
matrix<int> HypSetOfedges(nbe,2);
vector<int> HypType_of_edge_(nbe);
for(int i=1;i<=nbe;i++)
HypType_of_edge_[i]=1;

for(int k=1;k<=nbelement_;k++)
	for(int edge_number=1;edge_number<=3;edge_number++)
	{
	int i=number(element[k-1][VertexOfEdge(edge_number,1)]);
	int j=number(element[k-1][VertexOfEdge(edge_number,2)]);
	if(j<i)
		{tmp=i;i=j;j=tmp;}
	int exists=0;
	for(int e=head[i];e!=0;e=next[e])
		if(HypSetOfedges(e,2)==j)
		{
		exists=1;
		HypType_of_edge_[e]=0;
		p=1;
			while((p<=3) && (EdgesPerTriangle_(k,p)!=0))
			++p;
		EdgesPerTriangle_(k,p)=e;
		break;
		}
		if(exists==0)
		{
		nbsegments_++;
		assert(nbsegments_<nbe);
		HypSetOfedges(nbsegments_,1)=i;
		HypSetOfedges(nbsegments_,2)=j;
		next[nbsegments_]=head[i];
		p=1;
			while((p<=3) && (EdgesPerTriangle_(k,p)!=0))
			++p;
		head[i]=EdgesPerTriangle_(k,p)=nbsegments_;
	}
}

SetOfEdges_.~matrix();
SetOfEdges_=matrix<int>(nbsegments_,2);
Type_of_edge_.~vector();
Type_of_edge_=vector<int>(nbsegments_);
for(int i=1;i<=nbsegments_;i++)
{
SetOfEdges_[i]=HypSetOfedges[i];
Type_of_edge_[i]=HypType_of_edge_[i];
}
NbSegmentsPerNode_.~vector();
NbMaxSegmentsPerNode_=0;
NbSegmentsPerNode_=vector<int>(nbvertex_);
for (int numseg=1; numseg<=nbsegments_;numseg++)
{
 NbSegmentsPerNode_[SetOfEdges_(numseg,1)]++;
 NbSegmentsPerNode_[SetOfEdges_(numseg,2)]++;
} 
NbMaxSegmentsPerNode_=NbSegmentsPerNode_.norminf();

//---------------------------------------------------------------------------------------------------
// Remplissage de NbTrianglesPerEdge_ et de TrianglesPerEdge_
// Remplissage de NormalDirection_ (29 Mars 2005 - Emmanuel Creus) : on rappelle que le jeme segment
// local  la maille K est en face du jeme noeud local  la maille K !!!
// Ici, dans le cas d'un segment frontalier jseg, c'est toujours TrianglesPerEdge(jseg,2) qui est nul
//---------------------------------------------------------------------------------------------------
NbTrianglesPerEdge_.~vector();
NbTrianglesPerEdge_=vector<int>(nbsegments_);
TrianglesPerEdge_.~matrix();
TrianglesPerEdge_=matrix<int>(nbsegments_,2);
NormalDirection_.~matrix();
NormalDirection_=matrix<int>(nbelement_,3); 
int numseg;
int num_node_1,num_node_2,num_node_in_front ;
for (int jt=1; jt<=nbelement_; jt++)
{
 for (int j=1; j<=3; j++)
  {
   numseg=EdgesPerTriangle_(jt,j);
   num_node_1=SetOfEdges_(numseg,1);
   num_node_2=SetOfEdges_(numseg,2);
   num_node_in_front=number(element[jt-1][j]);  
   if (((vertices[num_node_2-1]-vertices[num_node_1-1]).ortho2D()*(vertices[num_node_in_front-1]-vertices[num_node_1-1]))>0)
    {NormalDirection_(jt,j)=-1;}
   else
    {NormalDirection_(jt,j)=1;}
   NbTrianglesPerEdge_[numseg]++;
   TrianglesPerEdge_(numseg,NbTrianglesPerEdge_[numseg])=jt;
  }
}

//---------------------------------------------------------------------------------------------------
// Remplissage de  NumberOfNeighboorOfTriangles_,TrianglesPerTriangle_ et NumLocNodeInTriangle_
//---------------------------------------------------------------------------------------------------
 
  int NumNoeudA,NumNoeudB;
  
  NumberOfNeighboorOfTriangles_.~vector();
  NumberOfNeighboorOfTriangles_=vector<int>(nbelement_); // Nb de mailles voisines  chaque maille.
  TrianglesPerTriangle_.~matrix();
  TrianglesPerTriangle_=matrix<int>(nbelement_,3); // Numro des mailles voisines  chaque maille.
  int NumMaille1, NumMaille2;
  int NumLocSegInTriangle1, NumLocSegInTriangle2;
  NumLocNodeInTriangle_.~matrix();
  NumLocNodeInTriangle_=matrix<int>(nbsegments_,4);

  for (int i=1; i<=nbsegments_;i++)
  {
    //cout <<"-----------------------------------------------\n";
    //cout << "nsegment= " << i << "\n";
    NumMaille1=TrianglesPerEdge_(i,1); // c'est K+
    NumMaille2=TrianglesPerEdge_(i,2); // c'est K-
    //cout << "NumMaille1= " << NumMaille1 << "\n";
    //cout << "NumMaille2= " << NumMaille2 << "\n";
    
    NumNoeudA=SetOfEdges_(i,1);
    NumNoeudB=SetOfEdges_(i,2);
    //cout << "NumNoeudA= " << NumNoeudA << "\n";
    //cout << "NumNoeudB= " << NumNoeudB << "\n";

    
    if (NumMaille1!=0)
     {
      NumLocNodeInTriangle_(i,1)=num_loc(NumMaille1,NumNoeudA);
      NumLocNodeInTriangle_(i,2)=num_loc(NumMaille1,NumNoeudB);
      NumLocSegInTriangle1=6-NumLocNodeInTriangle_(i,1)-NumLocNodeInTriangle_(i,2);
      //cout << "NumLocNodeInTriangle_(" << i << ",1)= " << NumLocNodeInTriangle_(i,1)<<"\n";
      //cout << "NumLocNodeInTriangle_(" << i << ",2)= " << NumLocNodeInTriangle_(i,2)<<"\n";
     
     }

     if (NumMaille2!=0)
     {
      NumLocNodeInTriangle_(i,3)=num_loc(NumMaille2,NumNoeudA);
      NumLocNodeInTriangle_(i,4)=num_loc(NumMaille2,NumNoeudB);
      NumLocSegInTriangle2=6-NumLocNodeInTriangle_(i,3)-NumLocNodeInTriangle_(i,4);
      //cout << "NumLocNodeInTriangle_(" << i << ",3)= " << NumLocNodeInTriangle_(i,3)<<"\n";
      //cout << "NumLocNodeInTriangle_(" << i << ",4)= " << NumLocNodeInTriangle_(i,4)<<"\n";
     
     }

    if ((NumMaille1!=0)&&(NumMaille2!=0))
     {
      NumberOfNeighboorOfTriangles_[NumMaille2]++;
//      TrianglesPerTriangle_(NumMaille2,NumberOfNeighboorOfTriangles_[NumMaille2])=NumMaille1;
      TrianglesPerTriangle_(NumMaille2,NumLocSegInTriangle2)=NumMaille1;
      //cout << "TrianglesPerTriangle_(" << NumMaille2 << "," << NumLocSegInTriangle2 << ")= " << NumMaille1 << "\n";
      NumberOfNeighboorOfTriangles_[NumMaille1]++;
//      TrianglesPerTriangle_(NumMaille1,NumberOfNeighboorOfTriangles_[NumMaille1])=NumMaille2;
      TrianglesPerTriangle_(NumMaille1,NumLocSegInTriangle1)=NumMaille2;
      //cout << "TrianglesPerTriangle_(" << NumMaille1 << "," << NumLocSegInTriangle1 << ")= " << NumMaille2 << "\n";
     }
  }

     hminT_.~vector();
     hE_.~vector();
     hminE_.~vector();
     hminT_=vector<T>(nbelement_);
     hE_=vector<T>(nbsegments_);
     hminE_=vector<T>(nbsegments_);

     remplir_descripteurs_anisotropes();

     NormEdge_.~vector();
     NormalUnitVector_.~matrix();

     NormEdge_=vector<T>(nbsegments_);
     NormalUnitVector_=matrix<T>(nbsegments_,2);

     for (int num_seg=1; num_seg<=nbsegments_; num_seg++)
    {
     NumNoeudA=SetOfEdges_(num_seg,1);
     NumNoeudB=SetOfEdges_(num_seg,2);
     vector<T> AB(vertices[NumNoeudB-1]-vertices[NumNoeudA-1]);
     T E=AB.norm();
     NormEdge_[num_seg]=E;
     NormalUnitVector_[num_seg]=AB.ortho2D()/E;
    }


}
//=============================
template <class T>
void mesh_tri_2d<T>::refine_mesh_angle(vector<int> & TABTRI, T MinAngle)
// rem : Phase 5 : it is possible to write on a file the new mesh obtained...
// to do it, remove the /* and */ marks of the phase 5.
//=============================
{


// Phase 1 : On modifie TABTRI pour affecter un statut  chaque triangle du maillage :
//   -1 : Maille  couper en quatre
//    -2 : Maille  couper en trois
//    1 : Maille  couper en deux
//    0 : Maille  ne pas couper
// TABSEG recense les segments qui seront coups en deux

vector<int> TABSEG(nbsegments_);
for (int jt=1; jt<=nbelement_; jt++)
 {
  if (TABTRI[jt]==-1)
   {
     for (int j=1; j<=3; j++)
     {
       if (TrianglesPerTriangle_(jt,j)) // Cette ligne rajoute le 11/02/05
        if (TABTRI[TrianglesPerTriangle_(jt,j)]!=-1) TABTRI[TrianglesPerTriangle_(jt,j)]++;
       TABSEG[EdgesPerTriangle_(jt,j)]=-1;
     }
   }
 }

//=========je mes ces ligne plutot ici=========
vector<int> suiv(3),prec(3);
suiv[1]=2; suiv[2]=3; suiv[3]=1;
prec[1]=3; prec[2]=1; prec[3]=2;
int numtr, edge1, edge2, edge3;
//=============================================
for (int RESTART=1 ; RESTART ; )
 { 
  
  RESTART=0;
  for (int jt=1; jt<=nbelement_; jt++)
  {
  //=============================================================
  //===============Ammelioration_1=========================
  //==============================================================

   if (TABTRI[jt]==1)
    		{
		           int num=0;
      			   for (int j=1; j<=3; j++)
           			{
            			   if (TABSEG[EdgesPerTriangle_(jt,j)]==-1)
				   {
	       		  	   num = j;
				   break;
				   }
	    			}
			

     			vector<T> u((*this)[jt][num]-(*this)[jt][prec[num]]);
     			vector<T> v((*this)[jt][num]-(*this)[jt][suiv[num]]);
     			vector<T> w((*this)[jt][prec[num]]-(*this)[jt][suiv[num]]);
                       

     			double alpha_prec, alpha_suiv, alpha;
     			alpha_prec = acos(-(u*w)/(u.norm()*w.norm()));
     			alpha_suiv = acos(v*w/(v.norm()*w.norm()));
     			alpha      = acos(u*v/(u.norm()*v.norm()));
                        

     			if (alpha >= 2.0*MinAngle){}
			else if (alpha_prec >= 2.0*MinAngle)
					{
                                          
			             TABTRI[jt] = -2;

				       if (TrianglesPerTriangle_(jt,prec[num]))

				          { numtr =  TrianglesPerTriangle_(jt,prec[num]);
					  
					     if (TABTRI[numtr]!=-1 && TABSEG[EdgesPerTriangle_(jt,prec[num])]!=-1)
					      {
					 	TABTRI[numtr]++;
						TABSEG[EdgesPerTriangle_(jt,prec[num])]=-1;
						}
					     //if ((TABTRI[numtr]>=2)&&(numtr<jt))
					     if ((TABTRI[numtr]>=1)&&(numtr<jt)) // Modif Manu 250106
						 RESTART=1;
					  }
					  // Ajout Manu 210106
					 else
					   if (TABSEG[EdgesPerTriangle_(jt,prec[num])]!=-1)
					   {
					    TABSEG[EdgesPerTriangle_(jt,prec[num])]=-1;
					   }
					 // Fin Ajout Manu 210106

					}
			else if (alpha_suiv >= 2.0*MinAngle)
					{
					 
					  
			             TABTRI[jt] = -2;

				       if (TrianglesPerTriangle_(jt,suiv[num]))

				          { numtr =  TrianglesPerTriangle_(jt,suiv[num]);

					     if (TABTRI[numtr]!=-1 && TABSEG[EdgesPerTriangle_(jt,suiv[num])]!=-1)
					     {
					 	TABTRI[numtr]++;
						TABSEG[EdgesPerTriangle_(jt,suiv[num])]=-1;
						}
					     //if ((TABTRI[numtr]>=2)&&(numtr<jt))
					       if ((TABTRI[numtr]>=1)&&(numtr<jt)) // Modif Manu 250106  
				                 RESTART=1;
					  }
					  // Ajout Manu 210106
					 else
					   if (TABSEG[EdgesPerTriangle_(jt,suiv[num])]!=-1)
					   {
					    TABSEG[EdgesPerTriangle_(jt,suiv[num])]=-1;
					   }
					 // Fin Ajout Manu 210106
					}
			// Ajout Manu 210106 : Aucune des 3 possibilits ne permet d'avoir
			// la condition de l'angle minimum respecte... Dans ce cas il faut couper la maille en quatre !!!
			else
			    {
			     TABTRI[jt]=-1;
			     for (int j=1; j<=3; j++)
     				{       numtr=TrianglesPerTriangle_(jt,j);
       					if (numtr)
					{
        				if (TABTRI[numtr]!=-1 && TABSEG[EdgesPerTriangle_(jt,j)]!=-1)
					 {  
					    TABTRI[numtr]++;
       					    TABSEG[EdgesPerTriangle_(jt,j)]=-1;
					 }
					//if ((TABTRI[numtr]>=2)&&(numtr<jt))
					if ((TABTRI[numtr]>=1)&&(numtr<jt)) // Modif Manu 250106
				                 RESTART=1;
					 }
					 else
					   if (TABSEG[EdgesPerTriangle_(jt,j)]!=-1)
					   {
					    TABSEG[EdgesPerTriangle_(jt,j)]=-1;
					   }
     				}
		            }
			// Fin Ajout Manu 210106
           
     	       }
   else if (TABTRI[jt]==2)
     		{
        		   vector<int> num_loc(2);
			   int num=1, local;
	 		   for (int j=1; j<=3; j++)
	     			{
             			  if (TABSEG[EdgesPerTriangle_(jt,j)]==-1)
	        			{
	          			  num_loc[num] = j;
		  			  num++;
	        			}
				  else local  = j;
	      			}
			   

     			vector<T> w;
			      if (local==2)   w = ((*this)[jt][num_loc[2]] - (*this)[jt][num_loc[1]]);
			      else            w = ((*this)[jt][num_loc[1]] - (*this)[jt][num_loc[2]]);
			vector<T> u((*this)[jt][prec[num_loc[1]]] - (*this)[jt][suiv[num_loc[1]]]);
     			vector<T> v((*this)[jt][prec[num_loc[2]]] - (*this)[jt][suiv[num_loc[2]]]);

                       

     			double alpha_numloc0, alpha_numloc1;
     			alpha_numloc1 = acos((u*w)/(u.norm()*w.norm()));
     			alpha_numloc0 = acos((v*w)/(v.norm()*w.norm()));
                        
			if ((alpha_numloc0 < 2.0*MinAngle)&&(alpha_numloc1 < 2.0*MinAngle))
			{
			TABTRI[jt]=-1;
		 	for (int j=1; j<=3; j++)
                  		{
        			  if (TrianglesPerTriangle_(jt,j))
				    //if (TABTRI[TrianglesPerTriangle_(jt,j)]!=-1) TABTRI[TrianglesPerTriangle_(jt,j)]++;
                                   if (TABSEG[EdgesPerTriangle_(jt,j)]!=-1)  TABTRI[TrianglesPerTriangle_(jt,j)]++; // Modif Manu 250106
       				  TABSEG[EdgesPerTriangle_(jt,j)]=-1;
        			  if (TrianglesPerTriangle_(jt,j))
				    //if ((TABTRI[TrianglesPerTriangle_(jt,j)]>=2)&&(TrianglesPerTriangle_(jt,j)<jt)) RESTART=1;
				    if ((TABTRI[TrianglesPerTriangle_(jt,j)]>=1)&&(TrianglesPerTriangle_(jt,j)<jt)) RESTART=1; // Modif Manu 250106
      		  		}
			}
	                else  TABTRI[jt]=-2;

		}

    else if (TABTRI[jt]==3)
                {
             
                  	   TABTRI[jt]=-1;
		           for (int j=1; j<=3; j++)
                     		{
        			  if (TrianglesPerTriangle_(jt,j))
       				  //if (TABTRI[TrianglesPerTriangle_(jt,j)]!=-1 && TABTRI[TrianglesPerTriangle_(jt,j)]!=-2
				  // Modif Manu 240106 :
				   if (TABTRI[TrianglesPerTriangle_(jt,j)]!=-1 && TABSEG[EdgesPerTriangle_(jt,j)]!=-1)
				   TABTRI[TrianglesPerTriangle_(jt,j)]++;
				  
       				  TABSEG[EdgesPerTriangle_(jt,j)]=-1;
				  
        			  if (TrianglesPerTriangle_(jt,j))
				    //if ((TABTRI[TrianglesPerTriangle_(jt,j)]>=2)&&(TrianglesPerTriangle_(jt,j)<jt)) RESTART=1;
				    if ((TABTRI[TrianglesPerTriangle_(jt,j)]>=1)&&(TrianglesPerTriangle_(jt,j)<jt)) RESTART=1; // Modif Manu 250106
      		     		}

		}
		//Ajout Manu 230106
    else if (TABTRI[jt]==-1)
    {
     for (int j=1; j<=3; j++)
                     		{
       				  TABSEG[EdgesPerTriangle_(jt,j)]=-1;
      		     		}
    }
    // Fin Ajout Manu 230106

  //=============================================================
  //=================Fin Ammelioration_1=========================
  //==============================================================
 }
 }
  
//-------------------------------------------------------------------------
// Phase 2 : Dtermination du nouveau nombre de sommets et de triangles //
//-------------------------------------------------------------------------

int nbvertex_new=nbvertex_;
int nbelement_new=nbelement_;
vector<int> TABSEGLOC(nbsegments_);
TABSEGLOC=TABSEG;

for (int jt=1; jt<=nbelement_; jt++)
{
//cout << "----------------------------------------------";
//cout << "jt= " << jt << endl;
//cout << "TABTRI[" << jt << "]= " <<  TABTRI[jt] << endl;

 if (TABTRI[jt]==-1)
  {
   nbelement_new+=3;
   for (int j=1; j<=3; j++)
    {
  //   cout << "TABSEGLOC[" << EdgesPerTriangle_(jt,j) << "]= " << TABSEGLOC[EdgesPerTriangle_(jt,j)] << endl;
     if (TABSEGLOC[EdgesPerTriangle_(jt,j)]==-1)
     {
      nbvertex_new++;
      TABSEGLOC[EdgesPerTriangle_(jt,j)]=0;
     }
    }
   }
   //===================Ammelioration_2===============================
   //=========================================================================
   else if (TABTRI[jt]==-2)
   {
    nbelement_new+=2;
    for (int j=1; j<=3; j++)
    {
    // cout << "TABSEGLOC[" << EdgesPerTriangle_(jt,j) << "]= " << TABSEGLOC[EdgesPerTriangle_(jt,j)] << endl;
     if (TABSEGLOC[EdgesPerTriangle_(jt,j)]==-1)
     {
      nbvertex_new++;
      TABSEGLOC[EdgesPerTriangle_(jt,j)]=0;
     }
    }
   }
     //===================Fin Ammelioration_2===================================
     //=========================================================================
  else if (TABTRI[jt]==1)
   {
    nbelement_new++;
    for (int j=1; j<=3; j++)
    {
     //cout << "TABSEGLOC[" << EdgesPerTriangle_(jt,j) << "]= " << TABSEGLOC[EdgesPerTriangle_(jt,j)] << endl;
     if (TABSEGLOC[EdgesPerTriangle_(jt,j)]==-1)
     {
      nbvertex_new++;
      TABSEGLOC[EdgesPerTriangle_(jt,j)]=0;
     }
    }
   }
   //cout << "nbvertex_new= " << nbvertex_new << endl;
   //cout << "---------------------------------------";
  }

//cout << "Avant la phase 3, nbvertex_new= " << nbvertex_new << " nbelement_new= " << nbelement_new << endl;
//---------------------------------------------------------------------------------
// Phase 3 : Cration et remplissage des tableaux contenant le nouveau maillage //
//---------------------------------------------------------------------------------

node<T>* vertices_new;
triangle<T>* element_new;
vertices_new=new node<T>[nbvertex_new](2);
element_new=new triangle<T>[nbelement_new];

node<T> ** nodes_of_element;
nodes_of_element=new node<T>*[3];

for (int i=0; i<nbvertex_; i++)
 vertices_new[i]=vertices[i];

 for(int i=0;i<nbelement_;i++)
  {
    for (int j=0;j<3;j++)
      {
       nodes_of_element[j]=&vertices_new[&(element[i][j+1])-vertices];
      }
    element_new[i]=triangle<T>(nodes_of_element);
  }

int num_current_triangle=nbelement_+1;
int num_current_vertex=nbvertex_+1;
T xnoeud,ynoeud;
int typenoeud;
int jloc;


for (int jt=1; jt<=nbelement_; jt++)
{
  //cout << "------------------------------------------------------------";
  //cout << "jt= " << jt << "TABTRI[" << jt << "]= " << TABTRI[jt] << endl;
 if (TABTRI[jt]==-1)
  {
   for (int j=1; j<=3; j++)
    {
     if (TABSEG[EdgesPerTriangle_(jt,j)]==-1)
      {
       xnoeud=((*this)[jt][prec[j]][1]+(*this)[jt][suiv[j]][1])/2.0;
       ynoeud=((*this)[jt][prec[j]][2]+(*this)[jt][suiv[j]][2])/2.0;
       if (Type_of_edge_[EdgesPerTriangle_(jt,j)]) typenoeud=1; else typenoeud=0;
       vertices_new[num_current_vertex-1][1]=xnoeud;
       vertices_new[num_current_vertex-1][2]=ynoeud;
       vertices_new[num_current_vertex-1].boundary_condition()=typenoeud;
       TABSEG[EdgesPerTriangle_(jt,j)]=num_current_vertex;
       num_current_vertex++;
      }
     }

// Cration des quatre nouvelles mailles
// D'abord la maille du milieu, que l'on stocke  la place de l'ancienne

    for (int j=0; j<=2; j++)
        {
	//cout << "j= " << j << endl;
	//cout << "EdgesPerTriangle_(jt,j+1)= " << EdgesPerTriangle_(jt,j+1) << endl;
	//cout << "TABSEG[EdgesPerTriangle_(jt,j+1)]= " << TABSEG[EdgesPerTriangle_(jt,j+1)] << endl;
        nodes_of_element[j]=&vertices_new[TABSEG[EdgesPerTriangle_(jt,j+1)]-1];
	}
        element_new[jt-1]=triangle<T>(nodes_of_element);
	//cout << "nouvelle maille jt= " << jt << "maille : " << element_new[jt-1] << endl;
// Puis chacune des trois autres, que l'on stocke en queue de tableau
    for (int j=1; j<=3; j++)
       {
         //cout << "jt= "  << jt << "number= " << &(element_new[jt-1][j])-vertices_new << endl;
         //nodes_of_element[0]=&vertices_new[number((*this)[jt][j])-1];
	 nodes_of_element[0]=&vertices_new[&(element[jt-1][j])-vertices];
	 nodes_of_element[1]=&vertices_new[TABSEG[EdgesPerTriangle_(jt,prec[j])]-1];
	 nodes_of_element[2]=&vertices_new[TABSEG[EdgesPerTriangle_(jt,suiv[j])]-1];

	 element_new[num_current_triangle-1]=triangle<T>(nodes_of_element);
	 //cout << "nouvelle maille jt= " <<  num_current_triangle << "maille : " << element_new[num_current_triangle-1] << endl;
	 num_current_triangle++;
       }
      }

      //===============================Ammelioration_3===========================
      //=========================================================================

    else if (TABTRI[jt]==-2)
  {

   if (TABSEG[EdgesPerTriangle_(jt,1)]==0) jloc=1;
   else if (TABSEG[EdgesPerTriangle_(jt,2)]==0) jloc=2;
   else if (TABSEG[EdgesPerTriangle_(jt,3)]==0) jloc=3;
  			vector<T> u((*this)[jt][jloc] - (*this)[jt][prec[jloc]]);
     			vector<T> v((*this)[jt][jloc] - (*this)[jt][suiv[jloc]]);
     			vector<T> w((*this)[jt][prec[jloc]] - (*this)[jt][suiv[jloc]]);
     			double alpha_prec, alpha_suiv;
     			alpha_prec = acos(-(u*w)/(u.norm()*w.norm()));
     			alpha_suiv = acos((v*w)/(v.norm()*w.norm()));
     		//cout << "alpha_prec= "<< alpha_prec<< "alpha_suiv= "<< alpha_suiv<<"\n";
// Cration ventuelle du 1er noeud
   if (TABSEG[EdgesPerTriangle_(jt,suiv[jloc])]==-1)
      {
       xnoeud=((*this)[jt][jloc][1]+(*this)[jt][prec[jloc]][1])/2.0;
       ynoeud=((*this)[jt][jloc][2]+(*this)[jt][prec[jloc]][2])/2.0;
       if (Type_of_edge_[EdgesPerTriangle_(jt,suiv[jloc])]) typenoeud=1; else typenoeud=0;
       vertices_new[num_current_vertex-1][1]=xnoeud;
       vertices_new[num_current_vertex-1][2]=ynoeud;
       vertices_new[num_current_vertex-1].boundary_condition()=typenoeud;
      // cout <<"1er"<< vertices_new[num_current_vertex-1] << "\n";
       TABSEG[EdgesPerTriangle_(jt,suiv[jloc])]=num_current_vertex;
       num_current_vertex++;
      }

  // Cration ventuelle du 2emme noeud

        if (TABSEG[EdgesPerTriangle_(jt,prec[jloc])]==-1)
      {
       xnoeud=((*this)[jt][jloc][1]+(*this)[jt][suiv[jloc]][1])/2.0;
       ynoeud=((*this)[jt][jloc][2]+(*this)[jt][suiv[jloc]][2])/2.0;
       if (Type_of_edge_[EdgesPerTriangle_(jt,prec[jloc])]) typenoeud=1; else typenoeud=0;
       vertices_new[num_current_vertex-1][1]=xnoeud;
       vertices_new[num_current_vertex-1][2]=ynoeud;
       vertices_new[num_current_vertex-1].boundary_condition()=typenoeud;
       //cout <<"2emme"<< vertices_new[num_current_vertex-1] << "\n";
       TABSEG[EdgesPerTriangle_(jt,prec[jloc])]=num_current_vertex;
       num_current_vertex++;
      }
 //cout<<TABSEG[EdgesPerTriangle_(jt,1)]<<"  "<<TABSEG[EdgesPerTriangle_(jt,2)]<<"   "<<TABSEG[EdgesPerTriangle_(jt,3)]<<"\n";
// Cration des trois mailles : la premire est stocke  la place de
//l'ancienne, les deux autres en queue de tableau.
       nodes_of_element[0]=&vertices_new[&(element[jt-1][jloc])-vertices];
       nodes_of_element[1]=&vertices_new[TABSEG[EdgesPerTriangle_(jt,prec[jloc])]-1];
       nodes_of_element[2]=&vertices_new[TABSEG[EdgesPerTriangle_(jt,suiv[jloc])]-1];
       element_new[jt-1]=triangle<T>(nodes_of_element);
       //cout << "nouvelle maille jt= " << jt << "maille : " << element_new[jt-1] << endl;
       //nodes_of_element[1]=&vertices_new[number((*this)[jt][jloc])-1];
       //nodes_of_element[2]=&vertices_new[number((*this)[jt][prec[jloc]])-1];
       if (alpha_prec >= 2.0*MinAngle)
       {
       nodes_of_element[0]=&vertices_new[TABSEG[EdgesPerTriangle_(jt,prec[jloc])]-1];
       nodes_of_element[1]=&vertices_new[&(element[jt-1][suiv[jloc]])-vertices];
       nodes_of_element[2]=&vertices_new[&(element[jt-1][prec[jloc]])-vertices];
       element_new[num_current_triangle-1]=triangle<T>(nodes_of_element);
       //cout << "nouvelle maille jt= " << num_current_triangle << "maille : " << element_new[num_current_triangle-1] << endl;
       num_current_triangle++;
       nodes_of_element[0]=&vertices_new[TABSEG[EdgesPerTriangle_(jt,prec[jloc])]-1];
       nodes_of_element[1]=&vertices_new[&(element[jt-1][prec[jloc]])-vertices];
       // ligne modifie EC 180106 (il y avait une erreur : nodes_of_element[0] a la place de nodes_of_element[2])
       nodes_of_element[2]=&vertices_new[TABSEG[EdgesPerTriangle_(jt,suiv[jloc])]-1];
       // fin de ligne modifie
       element_new[num_current_triangle-1]=triangle<T>(nodes_of_element);
       //cout << "nouvelle maille jt= " << num_current_triangle << "maille : " << element_new[num_current_triangle-1] << endl;
       num_current_triangle++;

       }
       else   if (alpha_suiv >= 2.0*MinAngle)
       {
       nodes_of_element[0]=&vertices_new[TABSEG[EdgesPerTriangle_(jt,prec[jloc])]-1];
       nodes_of_element[1]=&vertices_new[&(element[jt-1][suiv[jloc]])-vertices];
       nodes_of_element[2]=&vertices_new[TABSEG[EdgesPerTriangle_(jt,suiv[jloc])]-1];
       element_new[num_current_triangle-1]=triangle<T>(nodes_of_element);
       //cout << "nouvelle maille jt= " << num_current_triangle << "maille : " << element_new[num_current_triangle-1] << endl;
       num_current_triangle++;
       nodes_of_element[0]=&vertices_new[TABSEG[EdgesPerTriangle_(jt,suiv[jloc])]-1];
       nodes_of_element[1]=&vertices_new[&(element[jt-1][suiv[jloc]])-vertices];
       // ligne modifie EC 180106 (il y avait une erreur : nodes_of_element[0] a la place de nodes_of_element[2])
       nodes_of_element[2]=&vertices_new[&(element[jt-1][prec[jloc]])-vertices];
       // fin de ligne modifie
       element_new[num_current_triangle-1]=triangle<T>(nodes_of_element);
       //cout << "nouvelle maille jt= " << num_current_triangle << "maille : " << element_new[num_current_triangle-1] << endl;
       num_current_triangle++;

       }
      }
      //===============================fin Ammelioration_3=========================
      //===========================================================================
  else if (TABTRI[jt]==1)
  {
   if (TABSEG[EdgesPerTriangle_(jt,1)]!=0) jloc=1;
   else if (TABSEG[EdgesPerTriangle_(jt,2)]!=0) jloc=2;
   else if (TABSEG[EdgesPerTriangle_(jt,3)]!=0) jloc=3;

// Cration ventuelle du noeud
   if (TABSEG[EdgesPerTriangle_(jt,jloc)]==-1)
      {
       xnoeud=((*this)[jt][prec[jloc]][1]+(*this)[jt][suiv[jloc]][1])/2.0;
       ynoeud=((*this)[jt][prec[jloc]][2]+(*this)[jt][suiv[jloc]][2])/2.0;
       if (Type_of_edge_[EdgesPerTriangle_(jt,jloc)]) typenoeud=1; else typenoeud=0;
       vertices_new[num_current_vertex-1][1]=xnoeud;
       vertices_new[num_current_vertex-1][2]=ynoeud;
       vertices_new[num_current_vertex-1].boundary_condition()=typenoeud;
       ////cout << vertices_new[num_current_vertex-1] << "\n";
       TABSEG[EdgesPerTriangle_(jt,jloc)]=num_current_vertex;
       num_current_vertex++;
      }

// Cration des deux mailles : la premire est stocke  la place de l'ancienne, la seconde en queue de tableau.
       nodes_of_element[0]=&vertices_new[TABSEG[EdgesPerTriangle_(jt,jloc)]-1];
       //nodes_of_element[1]=&vertices_new[number((*this)[jt][jloc])-1];
       //nodes_of_element[2]=&vertices_new[number((*this)[jt][prec[jloc]])-1];
       nodes_of_element[1]=&vertices_new[&(element[jt-1][jloc])-vertices];
       nodes_of_element[2]=&vertices_new[&(element[jt-1][prec[jloc]])-vertices];
       element_new[jt-1]=triangle<T>(nodes_of_element);
       //cout << "nouvelle maille jt= " << jt << "maille : " << element_new[jt-1] << endl;
       //nodes_of_element[2]=&vertices_new[number((*this)[jt][suiv[jloc]])-1];
       nodes_of_element[2]=&vertices_new[&(element[jt-1][suiv[jloc]])-vertices];
       element_new[num_current_triangle-1]=triangle<T>(nodes_of_element);
       //cout << "nouvelle maille jt= " << num_current_triangle << "maille : " << element_new[num_current_triangle-1] << endl;
       num_current_triangle++;
 // cout<<TABSEG[EdgesPerTriangle_(jt,1)]<<" " <<  TABSEG[EdgesPerTriangle_(jt,2)] <<" " << TABSEG[EdgesPerTriangle_(jt,3)]  <<"\n";
  }

}

//cout << "Aprs phase 3,  num_current_vertex=" << num_current_vertex << " num_current_triangle= " << num_current_triangle <<endl;
//cout << "Aprs phase 3, element_new[26]= " << element_new[26] << endl;
//------------------------------------------------------------
// Phase 4 : Modification du maillage initial
//------------------------------------------------------------

nbvertex_=nbvertex_new;
delete [] vertices;
vertices=new node<T>[nbvertex_](dimspace_);

for(int i=0;i<nbvertex_;i++)
      vertices[i]=vertices_new[i];

nbelement_=nbelement_new;
delete [] element;
element=new triangle<T>[nbelement_];


for(int i=0;i<nbelement_;i++)
  {

    for (int j=0;j<3;j++)
      {

	// Pour Nadir : le bug tait l !!!
        nodes_of_element[j]=&vertices[&(element_new[i][j+1])-vertices_new];
       }
    element[i]=triangle<T>(nodes_of_element);

  }
delete[] nodes_of_element;
//cout << "Fin phase 4" << endl;

// ---------------------------------------------------------------------------------------------------------
// Phase 5 : gnration du fichier de sortie pour sauvegarde du nouveau maillage (par defaut, non effectu)
//----------------------------------------------------------------------------------------------------------

/*
//ATTENTION VRAI COMMENTAIRE
ofstream out_file("fichier_mesh.txt",ios::trunc);
  assert (!out_file.fail());

  out_file<<2<<endl;
  out_file<<nbvertex_<<endl;
  for (int i=1; i<= nbvertex_; i++)
   {
    for (int j=1; j<= 2; j++)
    {
     out_file<<vertices[i-1][j] << "   ";
    };
   out_file<<vertices[i-1].boundary_condition() <<endl;
  };

out_file<<nbelement_<<endl;

for (int i=1; i<= nbelement_; i++)
{
 for (int j=1; j<=3; j++)
{
  out_file<<&element[i-1][j]-vertices+1 << "   ";
}
out_file<<endl;
}
out_file<<endl;
out_file.close();
*/
/*
for (int i=1; i<=nbelement_; i++)
 {
 cout << "Element i= " << i << endl;
 cout << element[i-1] << endl;
 cout << endl;
 }
 */
EdgesPerTriangle_.~matrix();
EdgesPerTriangle_=matrix<int>(nbelement_,3);
matrix<int> VertexOfEdge(3,2);
VertexOfEdge(1,1)=2;VertexOfEdge(1,2)=3;
VertexOfEdge(2,1)=3;VertexOfEdge(2,2)=1;
VertexOfEdge(3,1)=1;VertexOfEdge(3,2)=2;

//cout << "coucou 1 " << endl;

int tmp,p;
nbsegments_=0;
vector<int> head(nbvertex_);
//cout << "coucou 2 " << endl;
int nbe=nbvertex_+nbelement_;
vector<int> next(nbe);
matrix<int> HypSetOfedges(nbe,2);
vector<int> HypType_of_edge_(nbe);
for(int i=1;i<=nbe;i++)
HypType_of_edge_[i]=1;
//cout << "coucou 3 " << endl;

for(int k=1;k<=nbelement_;k++)
{   //    cout << "---------------------------------" << endl ;
        //cout << "k= " << k << endl;
	for(int edge_number=1;edge_number<=3;edge_number++)
	{
	//cout << "edge_number= " << edge_number << endl;
	//cout << "VertexOfEdge(edge_number,1)= " << VertexOfEdge(edge_number,1) << endl;
	//cout << "VertexOfEdge(edge_number,2)= " << VertexOfEdge(edge_number,2) << endl;
	int i=number(element[k-1][VertexOfEdge(edge_number,1)]);
	int j=number(element[k-1][VertexOfEdge(edge_number,2)]);
	//cout << "i= " << i << " j= " << j << endl;
	if(j<i)
		{tmp=i;i=j;j=tmp;}
	int exists=0;
	for(int e=head[i];e!=0;e=next[e])
		if(HypSetOfedges(e,2)==j)
		{
		exists=1;
		HypType_of_edge_[e]=0;
		p=1;
			while((p<=3) && (EdgesPerTriangle_(k,p)!=0))
			++p;
		EdgesPerTriangle_(k,p)=e;
		break;
		}
		if(exists==0)
		{
		nbsegments_++;
		assert(nbsegments_<nbe);
		HypSetOfedges(nbsegments_,1)=i;
		HypSetOfedges(nbsegments_,2)=j;
		next[nbsegments_]=head[i];
		p=1;
			while((p<=3) && (EdgesPerTriangle_(k,p)!=0))
			++p;
		head[i]=EdgesPerTriangle_(k,p)=nbsegments_;
	}
}
//cout << "fin k= " << k << endl;
}
//cout << "coucou 4 " << endl;
SetOfEdges_.~matrix();
SetOfEdges_=matrix<int>(nbsegments_,2);
Type_of_edge_.~vector();
Type_of_edge_=vector<int>(nbsegments_);
//cout << "coucou 5 " << endl;
for(int i=1;i<=nbsegments_;i++)
{
SetOfEdges_[i]=HypSetOfedges[i];
Type_of_edge_[i]=HypType_of_edge_[i];
}

NbSegmentsPerNode_.~vector();
NbMaxSegmentsPerNode_=0;
NbSegmentsPerNode_=vector<int>(nbvertex_);
for (int numseg=1; numseg<=nbsegments_;numseg++)
{
 NbSegmentsPerNode_[SetOfEdges_(numseg,1)]++;
 NbSegmentsPerNode_[SetOfEdges_(numseg,2)]++;
} 
NbMaxSegmentsPerNode_=NbSegmentsPerNode_.norminf();
//cout << "Avant remplissage NbTrianglesPerEdge et al" << endl;
//---------------------------------------------------------------------------------------------------
// Remplissage de NbTrianglesPerEdge_ et de TrianglesPerEdge_
// Remplissage de NormalDirection_ (29 Mars 2005 - Emmanuel Creus) : on rappelle que le jeme segment
// local  la maille K est en face du jeme noeud local  la maille K !!!
// Ici, dans le cas d'un segment frontalier jseg, c'est toujours TrianglesPerEdge(jseg,2) qui est nul
//---------------------------------------------------------------------------------------------------
NbTrianglesPerEdge_.~vector();
NbTrianglesPerEdge_=vector<int>(nbsegments_);
TrianglesPerEdge_.~matrix();
TrianglesPerEdge_=matrix<int>(nbsegments_,2);
NormalDirection_.~matrix();
NormalDirection_=matrix<int>(nbelement_,3);
int numseg;
int num_node_1,num_node_2,num_node_in_front ;
for (int jt=1; jt<=nbelement_; jt++)
{
 for (int j=1; j<=3; j++)
  {
   numseg=EdgesPerTriangle_(jt,j);
   num_node_1=SetOfEdges_(numseg,1);
   num_node_2=SetOfEdges_(numseg,2);
   num_node_in_front=number(element[jt-1][j]);
   if (((vertices[num_node_2-1]-vertices[num_node_1-1]).ortho2D()*(vertices[num_node_in_front-1]-vertices[num_node_1-1]))>0)
    {NormalDirection_(jt,j)=-1;}
   else
    {NormalDirection_(jt,j)=1;}
   NbTrianglesPerEdge_[numseg]++;
   TrianglesPerEdge_(numseg,NbTrianglesPerEdge_[numseg])=jt;
  }
}
//cout << "Fin remplissage NbTrianglesPerEdge et al" << endl;
//---------------------------------------------------------------------------------------------------
// Remplissage de  NumberOfNeighboorOfTriangles_,TrianglesPerTriangle_ et NumLocNodeInTriangle_
//---------------------------------------------------------------------------------------------------

  int NumNoeudA,NumNoeudB;

  NumberOfNeighboorOfTriangles_.~vector();
  NumberOfNeighboorOfTriangles_=vector<int>(nbelement_); // Nb de mailles voisines  chaque maille.
  TrianglesPerTriangle_.~matrix();
  TrianglesPerTriangle_=matrix<int>(nbelement_,3); // Numro des mailles voisines  chaque maille.
  int NumMaille1, NumMaille2;
  int NumLocSegInTriangle1, NumLocSegInTriangle2;
  NumLocNodeInTriangle_.~matrix();
  NumLocNodeInTriangle_=matrix<int>(nbsegments_,4);

  for (int i=1; i<=nbsegments_;i++)
  {
    //cout <<"-----------------------------------------------\n";
    //cout << "nsegment= " << i << "\n";
    NumMaille1=TrianglesPerEdge_(i,1); // c'est K+
    NumMaille2=TrianglesPerEdge_(i,2); // c'est K-
    //cout << "NumMaille1= " << NumMaille1 << "\n";
    //cout << "NumMaille2= " << NumMaille2 << "\n";
    
    NumNoeudA=SetOfEdges_(i,1);
    NumNoeudB=SetOfEdges_(i,2);
    //cout << "NumNoeudA= " << NumNoeudA << "\n";
    //cout << "NumNoeudB= " << NumNoeudB << "\n";

    
    if (NumMaille1!=0)
     {
      NumLocNodeInTriangle_(i,1)=num_loc(NumMaille1,NumNoeudA);
      NumLocNodeInTriangle_(i,2)=num_loc(NumMaille1,NumNoeudB);
      NumLocSegInTriangle1=6-NumLocNodeInTriangle_(i,1)-NumLocNodeInTriangle_(i,2);
      //cout << "NumLocNodeInTriangle_(" << i << ",1)= " << NumLocNodeInTriangle_(i,1)<<"\n";
      //cout << "NumLocNodeInTriangle_(" << i << ",2)= " << NumLocNodeInTriangle_(i,2)<<"\n";
     
     }

     if (NumMaille2!=0)
     {
      NumLocNodeInTriangle_(i,3)=num_loc(NumMaille2,NumNoeudA);
      NumLocNodeInTriangle_(i,4)=num_loc(NumMaille2,NumNoeudB);
      NumLocSegInTriangle2=6-NumLocNodeInTriangle_(i,3)-NumLocNodeInTriangle_(i,4);
      //cout << "NumLocNodeInTriangle_(" << i << ",3)= " << NumLocNodeInTriangle_(i,3)<<"\n";
      //cout << "NumLocNodeInTriangle_(" << i << ",4)= " << NumLocNodeInTriangle_(i,4)<<"\n";
     
     }

    if ((NumMaille1!=0)&&(NumMaille2!=0))
     {
      NumberOfNeighboorOfTriangles_[NumMaille2]++;
//      TrianglesPerTriangle_(NumMaille2,NumberOfNeighboorOfTriangles_[NumMaille2])=NumMaille1;
      TrianglesPerTriangle_(NumMaille2,NumLocSegInTriangle2)=NumMaille1;
      //cout << "TrianglesPerTriangle_(" << NumMaille2 << "," << NumLocSegInTriangle2 << ")= " << NumMaille1 << "\n";
      NumberOfNeighboorOfTriangles_[NumMaille1]++;
//      TrianglesPerTriangle_(NumMaille1,NumberOfNeighboorOfTriangles_[NumMaille1])=NumMaille2;
      TrianglesPerTriangle_(NumMaille1,NumLocSegInTriangle1)=NumMaille2;
      //cout << "TrianglesPerTriangle_(" << NumMaille1 << "," << NumLocSegInTriangle1 << ")= " << NumMaille2 << "\n";
     }
  }

     hminT_.~vector();
     hE_.~vector();
     hminE_.~vector();
     hminT_=vector<T>(nbelement_);
     hE_=vector<T>(nbsegments_);
     hminE_=vector<T>(nbsegments_);

     remplir_descripteurs_anisotropes();

     NormEdge_.~vector();
     NormalUnitVector_.~matrix();

     NormEdge_=vector<T>(nbsegments_);
     NormalUnitVector_=matrix<T>(nbsegments_,2);

     for (int num_seg=1; num_seg<=nbsegments_; num_seg++)
    {
     NumNoeudA=SetOfEdges_(num_seg,1);
     NumNoeudB=SetOfEdges_(num_seg,2);
     vector<T> AB(vertices[NumNoeudB-1]-vertices[NumNoeudA-1]);
     T E=AB.norm();
     NormEdge_[num_seg]=E;
     NormalUnitVector_[num_seg]=AB.ortho2D()/E;
    }


 }

#endif

