/***************************************************************************
 *   Copyright (C) 2005 by Maurizio Monge                                  *
 *   monge@sns.it                                                          *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <sys/ptrace.h>
#include <linux/user.h>
#include <sys/types.h>
#include <sys/wait.h>
#include <sys/un.h>
#include <sys/socket.h>
#include <sys/mman.h>
#include <fcntl.h>
#include <errno.h>
#include <netinet/in.h>
#include <sys/socket.h>
#include <netdb.h>

/**********************************************************************************************
    linux syscalls:
    in amd64 syscalls (syscall), with NR in rax and args in rdi, rsi, rdx, r10, r8, r9
        (i dunno why in this strange order)
    in x86 syscalls (int 0x80), with NR in eax and args in ebx, ecx, edx, esi, edi, ebp(pushed)
    socket and friends are not syscalls, but one syscall with different switches in R1.
    anyway i wrote a macro to emulate different syscalls, so it is easer to code :-)
**********************************************************************************************/
#ifdef __x86_64__

#define R0 "%rax"
#define R1 "%rdi"
#define R2 "%rsi"
#define R3 "%rdx"
#define R4 "%r10"
#define R5 "%r8"
#define R6 "%r9"
#define RSP "%rsp"
#define RBP "%rbp"
#define Nmmap     "$9"
#define Nmunmap   "$11"
#define Nread     "$0"
#define Nwrite    "$1"
#define Nclose    "$3"
#define Nchdir    "$80"
#define Nfcntl    "$72"
#define Nopen     "$2"
#define Nsocket   "$41"
#define Nsendmsg  "$46"
#define Nrecvmsg  "$47"
#define Nbind     "$49"
#define Ndup2     "$33"
#define Nconnect  "$42"
#define Nlisten   "$50"
#define Naccept   "$43"
#define Nrt_sigaction   "$13"
#define Nsetuid   "$105"
#define Nsetuid   "$106"
#define DO_SYSCALL "syscall\n\t"
#define DO_SOCKETCALL DO_SYSCALL
#define L1        "8"
#define L2        "16"
#define L3        "24"
#define L4        "32"
#define L5        "40"

#elif defined __i386__

#define orig_rax orig_eax
#define rax eax
#define rbx ebx
#define rcx ecx
#define rdx edx
#define rbp ebp
#define rip eip
#define rsp esp
#define R0 "%eax"
#define R1 "%ebx"
#define R2 "%ecx"
#define R3 "%edx"
#define R4 "%esi"
#define R5 "%edi"
#define R6 "%ebp"
#define RSP "%esp"
#define RBP "%ebp"
//#define Nmmap     "$90" don't use this, this requires a pointer to the args
#define Nmmap     "$192" 
#define Nmunmap   "$91"
#define Nread     "$3"
#define Nwrite    "$4"
#define Nclose    "$6"
#define Nchdir    "$12"
#define Nfcntl    "$55"
#define Nopen     "$5"
#define Ndup2     "$63"

/**********************************************************************************************
   since x86 is a fucking architecture for linux, this is the socketcall request,
   see /usr/include/linux/net.h
**********************************************************************************************/
#define Nsocket   "$1"
#define Nsendmsg  "$16"
#define Nrecvmsg  "$17"
#define Nbind     "$2"
#define Nconnect  "$3"
#define Nlisten   "$4"
#define Naccept   "$5"
#define Nrt_sigaction   "$174"
#define Nsetuid   "$23"
#define Nsetgid   "$46"
#define DO_SYSCALL "int $0x80\n\t"
#define DO_SOCKETCALL   "mov %ebp,4092(%esp)\n\t" \
                        "mov %edi,4088(%esp)\n\t"  \
                        "mov %esi,4084(%esp)\n\t"  \
                        "mov %edx,4080(%esp)\n\t"  \
                        "mov %ecx,4076(%esp)\n\t"  \
                        "mov %ebx,4072(%esp)\n\t"  \
                        "lea 4072(%esp),%ecx\n\t" \
                        "mov %eax,%ebx\n\t" \
                        "mov $102,%eax\n\t" \
                        DO_SYSCALL
#define L1        "4"
#define L2        "8"
#define L3        "12"
#define L4        "16"
#define L5        "20"

#else

#error "Unsupported platform. Since this program uses a lot of assembler code,"
#error "you'll have to do some work to make it work on your architecture. Good luck!"

#endif

typedef struct _hook_info
{
    int pid;
    char buf[4096];
    char stack[4096];
    char oldbuf[4096];
    char oldstack[4096];
    struct user_regs_struct oldreg;
    struct user_regs_struct newreg;
    struct _hook_info* next;
}
hook_info;

/**********************************************************************************************
    Some global vars
**********************************************************************************************/
hook_info *thiz;
hook_info *stoppedpr = NULL;
int vb = 3;
int stopped = 0;
int debug = -1;

/**********************************************************************************************
    write code and structs to pass an fd to someone else
**********************************************************************************************/
void fillbuf_pass_fd(hook_info *h, const char ***syscalls, int fd, const char* filename)
{
    static const char * __syscalls[] = {
            "socket", "sendmsg", "close"  };
    *syscalls = __syscalls;

    if(!h->buf)
    {
    from2:
        asm volatile(
            "mov $0,"RBP"\n\t"

            /*socket(PF_UNIX=1, SOCK_DGRAM=2, 0);*/
            "mov $1,"R1"\n\t"                 /* PF_UNIX */
            "mov $2,"R2"\n\t"                 /* SOCK_DGRAM */
            "mov $0,"R3"\n\t"
            "mov "Nsocket","R0"\n\t"
            DO_SOCKETCALL
            "mov "R0","R5"\n\t"
            "inc "RBP"\n\tcmp $-127,"R0"\n\tjae .end2\n\t"

            /* sendmsg(iofd, msg, 0); */
            "mov "R5","R1"\n\t"
            "mov "RSP","R2"\n\t"              /* msg structure */
            "mov $0,"R3"\n\t"
            "mov "Nsendmsg","R0"\n\t"
            DO_SOCKETCALL
            "inc "RBP"\n\tcmp $-127,"R0"\n\tjae .end2\n\t"

            /* close(iofd) */
            "mov "R5","R1"\n\t"               /* iofd */
            "mov "Nclose","R0"\n\t"
            DO_SYSCALL                        /*    close     */
            "inc "RBP"\n\tcmp $-127,"R0"\n\tjae .end2\n\t"

            "mov $0,"R0"\n\t"
            ".end2:\n\t"
            "int3\n\t"
        );
    to2:;
    }

    /*
    Yes, i'm using gcc extensions to do this.
    Too bad you won't be able to compile this with
    your new copy of MS VisualC Professional Power
    Edition! :-)
    */
    memcpy(h->buf,&&from2,&&to2-&&from2);

    /*
    Who decided that to pass a fd i have to do this madness?
    this almost looks like windows api where 99% of
    parameters are NULL's or need to be empty structs (or crash)
    */
    char *mem = h->stack;
    struct msghdr *msg = (struct msghdr*)mem; mem+=sizeof(struct msghdr);
    struct sockaddr_un *addr = (struct sockaddr_un*)mem; mem+=sizeof(struct sockaddr_un);
    char *ccmsg = mem; mem+=CMSG_SPACE(sizeof(long));
    struct cmsghdr *cmsg;
    struct iovec *vec = (struct iovec*)mem; mem+=sizeof(struct cmsghdr);

    addr->sun_family = AF_UNIX;
    strcpy(addr->sun_path, filename);
    msg->msg_name = (struct sockaddr*)(((long)addr)-((long)h->stack)+h->newreg.rsp);
    msg->msg_namelen = sizeof(struct sockaddr_un);
    vec->iov_base = NULL;
    vec->iov_len = 0;
    msg->msg_iov = (struct iovec*)(((long)vec)-((long)h->stack)+h->newreg.rsp);
    msg->msg_iovlen = 1;
    /* do not translate the address here because this
    fucking pointer is used in the macros (CMSG_FIRSTHDR) */
    msg->msg_control = ccmsg;
    msg->msg_controllen = CMSG_SPACE(sizeof(int));
    cmsg = CMSG_FIRSTHDR(msg);
    cmsg->cmsg_level = SOL_SOCKET;
    cmsg->cmsg_type = SCM_RIGHTS;
    cmsg->cmsg_len = CMSG_LEN(sizeof(int));
    /* this MUST be an int32, or the kernel will send 3 copies of the fd on x86-64 */
    *(int*)CMSG_DATA(cmsg) = fd;
    /* not put the correct address here */
    msg->msg_control = (char*)(((long)ccmsg)-((long)h->stack)+h->newreg.rsp);
    msg->msg_controllen = cmsg->cmsg_len;
    msg->msg_flags = 0;
}

/**********************************************************************************************
    write code and structs to get an fd from someone else (in 2 calls from the debugger)
**********************************************************************************************/
void fillbuf_receive_fd(hook_info *h, const char ***syscalls,
              int fd, const char* filename)
{
    static const char * __syscalls[] = {
            "socket", "bind", "recvmsg", "close",
            "fcntl", "fcntl", "fcntl", "fcntl",
            "dup2", "close"  };
    *syscalls = __syscalls;

    if(!h->buf)
    {
    from3:
        asm volatile(
            "mov $0,"RBP"\n\t"

            /*socket(PF_UNIX=1, SOCK_DGRAM=2, 0);*/
            "mov "Nsocket","R0"\n\t"        /* socket */
            "mov $1,"R1"\n\t"               /*  UNIX    */
            "mov $2,"R2"\n\t"               /*  DGRAM */
            "mov $0,"R3"\n\t"               /*  0 */
            DO_SOCKETCALL
            "inc "RBP"\n\tcmp $-127,"R0"\n\tjae .end3a\n\t"
            "mov "R0","R5"\n\t"             /* save newly created socket in R5 */

            /*bind(iofd, (struct sockaddr *)&unix_socket_name, sizeof(unix_socket_name))*/
            "mov "R5","R1"\n\t"
            "lea "L3"("RSP"),"R2"\n\t"
            "mov "L1"("RSP"),"R3"\n\t"      /* sizeof(sockaddr_un) */
            "mov "Nbind","R0"\n\t"          /* bind */
            DO_SOCKETCALL
            "inc "RBP"\n\tcmp $-127,"R0"\n\tjae .end3a\n\t"

            "mov $0,"R0"\n\t"
            ".end3a:\n\t"
            "int3\n\t"

            /*
                second part of code
              */
            /* recvmsg(iofd, msg, 0); */
            "mov "R5","R1"\n\t"
            "mov "L1"("RSP"),"R0"\n\t"      /* sizeof(sockaddr_un) */
            "lea "L3"("RSP","R0"),"R2"\n\t" /* 24+sizeof(sockaddr_un) */
            "mov $0,"R3"\n\t"
            "mov "Nrecvmsg","R0"\n\t"
            DO_SOCKETCALL
            "inc "RBP"\n\tcmp $-127,"R0"\n\tjae .end3b\n\t"

            /* close(iofd) */
            "mov "R5","R1"\n\t"             /* iofd */
            "mov "Nclose","R0"\n\t"
            DO_SYSCALL                      /*    close     */
            "inc "RBP"\n\tcmp $-127,"R0"\n\tjae .end3b\n\t"

            /* fetch the new file descriptor */
            "mov "L2"("RSP"),"R0"\n\t"      /* pointer to the fd */
#ifdef __x86_64__
            "movslq ("R0"),"R5"\n\t"        /* passed fd (it is an int32) */
#else
            "mov ("R0"),"R5"\n\t"           /* passed fd */
#endif

            /* fcntl(oldfd,F_GETFD) */
            "mov ("RSP"),"R1"\n\t"           /* fd to replace */
            "mov "Nfcntl","R0"\n\t"
            "mov $1,"R2"\n\t"                /* F_GETFD */
            DO_SYSCALL                       /* fcntl   */
            "inc "RBP"\n\tcmp $-127,"R0"\n\tjae .end3b\n\t"

            /* fcntl(newfd,F_SETFD) */
            "mov "R0","R3"\n\t"              /* clo-exec flag */
            "mov "R5","R1"\n\t"              /* new fd */
            "mov "Nfcntl","R0"\n\t"
            "mov $2,"R2"\n\t"                /* F_SETFD */
            DO_SYSCALL                       /* fcntl   */
            "inc "RBP"\n\tcmp $-127,"R0"\n\tjae .end3b\n\t"

            /* fcntl(oldfd,F_GETFL) */
            "mov ("RSP"),"R1"\n\t"           /* fd to replace */
            "mov "Nfcntl","R0"\n\t"
            "mov $3,"R2"\n\t"                /* F_GETFL */
            DO_SYSCALL                       /* fcntl   */
            "inc "RBP"\n\tcmp $-127,"R0"\n\tjae .end3b\n\t"

            /* fcntl(newfd,F_SETFL) */
            "mov "R0","R3"\n\t"              /* flags */
            "mov "R5","R1"\n\t"              /* new fd */
            "mov "Nfcntl","R0"\n\t"
            "mov $4,"R2"\n\t"                /* F_SETFL */
            DO_SYSCALL                       /* fcntl   */
            "inc "RBP"\n\tcmp $-127,"R0"\n\tjae .end3b\n\t"

            /* dup2(newfd,oldfd)*/
            "mov ("RSP"),"R2"\n\t"           /* the fd to replace  */
            "mov "R5","R1"\n\t"              /* passed fd */
            "mov "Ndup2","R0"\n\t"           /* __NR_dup2 */
            DO_SYSCALL                       /*    dup2     */
            "inc "RBP"\n\tcmp $-127,"R0"\n\tjae .end3b\n\t"

            /* close(newfd) */
            "mov "Nclose","R0"\n\t"
            DO_SYSCALL                       /*    close     */
            "inc "RBP"\n\tcmp $-127,"R0"\n\tjae .end3b\n\t"

            "mov $0,"R0"\n\t"
            ".end3b:\n\t"
            "int3\n\t"
        );
    to3:;
    }

    /*
    Yes, i'm using gcc extensions to do this.
    Too bad you won't be able to compile this with
    your new copy of MS VisualC Professional Power
    Edition! :-)
    */
    memcpy(h->buf,&&from3,&&to3-&&from3);

    /*
    Who decided that to pass a fd i have to do this madness?
    this almost looks like windows api where 99% of
    parameters are NULL's or need to be empty structs (or crash)
    */
    char *mem = h->stack+sizeof(long)*3;
    struct sockaddr_un *addr = (struct sockaddr_un*)mem; mem+=sizeof(struct sockaddr_un);
    struct msghdr *msg = (struct msghdr*)mem; mem+=sizeof(struct msghdr);
    char *ccmsg = mem; mem+=CMSG_SPACE(sizeof(int));
    struct cmsghdr *cmsg;
    struct iovec *vec = (struct iovec*)mem; mem+=sizeof(struct cmsghdr);

    addr->sun_family = AF_UNIX;
    strcpy(addr->sun_path, filename);
    msg->msg_name = NULL;
    msg->msg_namelen = 0;
    vec->iov_base = NULL;
    vec->iov_len = 0;
    msg->msg_iov = (struct iovec*)(((long)vec)-((long)h->stack)+h->newreg.rsp);
    msg->msg_iovlen = 1;
    msg->msg_controllen = CMSG_LEN(sizeof(int));
    msg->msg_control = ccmsg; /* untraslated address */
    cmsg = CMSG_FIRSTHDR(msg);
    msg->msg_control = (char*)(((long)ccmsg)-((long)h->stack)+h->newreg.rsp); /* traslated address */

    *((long*)h->stack) = fd;
    *((long*)(h->stack+sizeof(long))) = sizeof(struct sockaddr_un);
    *((long*)(h->stack+sizeof(long)*2)) = ((long)CMSG_DATA(cmsg))-((long)h->stack)+h->newreg.rsp;
}

/**********************************************************************************************
    write code and structs to open a simple file (append or trunc mode)
**********************************************************************************************/
void fillbuf_open_file(hook_info *h, const char ***syscalls, long fd, long noflags,
             long flags, const char* filename)
{
    static const char * __syscalls[] = {
            "fcntl", "fcntl", "open",
            "fcntl", "dup2", "close"   };
    *syscalls = __syscalls;

    if(!h->buf)
    {
    from:
        asm volatile(
            "mov $0,"RBP"\n\t"

            /* fcntl(oldfd,F_GETFD) */
            "mov ("RSP"),"R1"\n\t"     /* fd to replace */
            "mov "Nfcntl","R0"\n\t"
            "mov $1,"R2"\n\t"          /* F_GETFD */
            DO_SYSCALL                 /* fcntl   */
            "cmp $-9,"R0"\n\t"         /* bad file descriptor? */
            "jne notok1\n\t"
            "mov $0,"R0"\n\t"
            "notok1:"
            "inc "RBP"\n\tcmp $-127,"R0"\n\tjae .end\n\t"
            "mov "R0","R4"\n\t"        /* save clo-exec flag */

            /* fcntl(oldfd,F_GETFL) */
            "mov "Nfcntl","R0"\n\t"
            "mov $3,"R2"\n\t"          /* F_GETFL */
            DO_SYSCALL                 /* fcntl   */
            "cmp $-9,"R0"\n\t"         /* bad file descriptor? */
            "jne notok2\n\t"
            "mov $2,"R0"\n\t"          /* RDRW */
            "notok2:"
            "inc "RBP"\n\tcmp $-127,"R0"\n\tjae .end\n\t"

            /* open(fname,flags,mode) */
            "and "L1"("RSP"),"R0"\n\t" /* my flags to remove (O_WRITE) */
            "or "L2"("RSP"),"R0"\n\t"  /* my flags O_TRUNC|O_APPEND */
            "or $64,"R0"\n\t"          /* |= O_CREAT */
            "mov "R0","R2"\n\t"        /* flags */
            "lea "L3"("RSP"),"R1"\n\t" /* filename */
            "mov "Nopen","R0"\n\t"
            "mov $0x1b6,"R3"\n\t"      /* mode 0666 */
            DO_SYSCALL                 /* open   */
            "inc "RBP"\n\tcmp $-127,"R0"\n\tjae .end\n\t"

            /* fcntl(newfd,F_SETFD) */
            "mov "R0","R1"\n\t"        /* new fd */
            "mov "Nfcntl","R0"\n\t"
            "mov $2,"R2"\n\t"          /* F_SETFD */
            "mov "R4","R3"\n\t"        /* clo-exec flag */
            DO_SYSCALL                 /* fcntl   */
            "inc "RBP"\n\tcmp $-127,"R0"\n\tjae .end\n\t"

            /* dup2(newfd,oldfd) */
            "mov "Ndup2","R0"\n\t"
            "mov ("RSP"),"R2"\n\t"     /* fd to replace */
            DO_SYSCALL                 /*    dup2     */
            "inc "RBP"\n\tcmp $-127,"R0"\n\tjae .end\n\t"

            /* close(newfd) */
            "mov "Nclose","R0"\n\t"
            DO_SYSCALL                 /*    close     */
            "inc "RBP"\n\tcmp $-127,"R0"\n\tjae .end\n\t"

            "mov $0,"R0"\n\t"
            ".end:\n\t"
            "int3\n\t"
        );
    to:;
    }

    /*
        Yes, i'm using gcc extensions to do this.
        Too bad you won't be able to compile this with
        your new copy of MS VisualC Professional Power
        Edition! :-)
    */
    memcpy(h->buf,&&from,&&to-&&from);
    *((long*)(h->stack)) = fd;
    *((long*)(h->stack+sizeof(long))) = ~noflags;
    *((long*)(h->stack+sizeof(long)*2)) = flags;
    strncpy(h->stack+sizeof(long)*3,filename,4000);
}

/**********************************************************************************************
    make fd1 a copy of fd2
**********************************************************************************************/
void fillbuf_dup2(hook_info *h, const char ***syscalls, long fd1, long fd2)
{
    static const char * __syscalls[] = {
            "fcntl", "dup2", "fcntl"  };
    *syscalls = __syscalls;

    if(!h->buf)
    {
    from4:
        asm volatile(
            "mov $0,"RBP"\n\t"

            /* fcntl(fd1,F_GETFD) */
            "mov ("RSP"),"R1"\n\t"           /* fd to replace */
            "mov "Nfcntl","R0"\n\t"
            "mov $1,"R2"\n\t"                /* F_GETFD */
            DO_SYSCALL                       /* fcntl   */
            "cmp $-9,"R0"\n\t"               /* bad file descriptor? */
            "jne notok\n\t"
            "mov $0,"R0"\n\t"
            "notok:"
            "inc "RBP"\n\tcmp $-127,"R0"\n\tjae .end4\n\t"
            "mov "R0","R3"\n\t"              /* clo-exec flag */

            /* dup2(fd2,fd1)*/
            "mov ("RSP"),"R2"\n\t"           /* the fd to replace  */
            "mov "L1"("RSP"),"R1"\n\t"       /* new fd */
            "mov "Ndup2","R0"\n\t"           /* __NR_dup2 */
            DO_SYSCALL                       /*    dup2     */
            "inc "RBP"\n\tcmp $-127,"R0"\n\tjae .end4\n\t"

            /* fcntl(fd1,F_SETFD) */
            "mov ("RSP"),"R1"\n\t"           /* new fd */
            "mov "Nfcntl","R0"\n\t"
            "mov $2,"R2"\n\t"                /* F_SETFD */
            DO_SYSCALL                       /* fcntl   */
            "inc "RBP"\n\tcmp $-127,"R0"\n\tjae .end4\n\t"

            "mov $0,"R0"\n\t"
            ".end4:\n\t"
            "int3\n\t"
        );
    to4:;
    }

    /*
    Yes, i'm using gcc extensions to do this.
    Too bad you won't be able to compile this with
    your new copy of MS VisualC Professional Power
    Edition! :-)
    */
    memcpy(h->buf,&&from4,&&to4-&&from4);
    *((long*)(h->stack)) = fd1;
    *((long*)(h->stack+sizeof(long))) = fd2;
}

/**********************************************************************************************
    close fd1
**********************************************************************************************/
void fillbuf_close(hook_info *h, const char ***syscalls, long fd1)
{
    static const char * __syscalls[] = {
            "close" };
    *syscalls = __syscalls;

    if(!h->buf)
    {
    from5:
        asm volatile(
            "mov $0,"RBP"\n\t"

            /* fcntl(fd1,F_GETFD) */
            "mov ("RSP"),"R1"\n\t"           /* fd to close */
            "mov "Nclose","R0"\n\t"
            DO_SYSCALL                       /* close */
            "inc "RBP"\n\tcmp $-127,"R0"\n\tjae .end5\n\t"

            "mov $0,"R0"\n\t"
            ".end5:\n\t"
            "int3\n\t"
        );
    to5:;
    }

    /*
    Yes, i'm using gcc extensions to do this.
    Too bad you won't be able to compile this with
    your new copy of MS VisualC Professional Power
    Edition! :-)
    */
    memcpy(h->buf,&&from5,&&to5-&&from5);
    *((long*)(h->stack)) = fd1;
}

/**********************************************************************************************
    chdir
**********************************************************************************************/
void fillbuf_chdir(hook_info *h, const char ***syscalls, const char *dir)
{
    static const char * __syscalls[] = {
        "chdir" };
        *syscalls = __syscalls;

        if(!h->buf)
        {
    from:
            asm volatile(
            "fnop\n\t"
            "mov $0,"RBP"\n\t"

            /* fcntl(fd1,F_GETFD) */
            "lea ("RSP"),"R1"\n\t"           /* fd to close */
            "mov "Nchdir","R0"\n\t"
            DO_SYSCALL                       /* close */
            "inc "RBP"\n\tcmp $-127,"R0"\n\tjae .end16\n\t"

            "mov $0,"R0"\n\t"
            ".end16:\n\t"
            "int3\n\t"
                        );
    to:;
        }

    /*
        Yes, i'm using gcc extensions to do this.
        Too bad you won't be able to compile this with
        your new copy of MS VisualC Professional Power
        Edition! :-)
    */
    memcpy(h->buf,&&from,&&to-&&from);
    strcpy( h->stack, dir );
}

/**********************************************************************************************
    ignore signal s1
**********************************************************************************************/
void fillbuf_signal(hook_info *h, const char ***syscalls, long s1,int ignore)
{
    static const char * __syscalls[] = {
            "rt_sigaction" };
    *syscalls = __syscalls;

    if(!h->buf)
    {
    from:
        asm volatile(
            "mov $0,"RBP"\n\t"

            /* rt_sigaction(s1,sig,NULL,sizeof(sigset_t)) */
            "mov ("RSP"),"R1"\n\t"                /* signum */
            "lea "L2"("RSP"),"R2"\n\t"           /* sigset*/
            "mov $0,"R3"\n\t"                          /* NULL */
            "mov "L1"("RSP"),"R4"\n\t"                /* sizeof(sigset_T) */
            "mov "Nrt_sigaction","R0"\n\t"
            DO_SYSCALL                       /* close */
            "inc "RBP"\n\tcmp $-127,"R0"\n\tjae .end10\n\t"

            "mov $0,"R0"\n\t"
            ".end10:\n\t"
            "int3\n\t"
        );
    to:;
    }

    /*
    Yes, i'm using gcc extensions to do this.
    Too bad you won't be able to compile this with
    your new copy of MS VisualC Professional Power
    Edition! :-)
    */
    memcpy(h->buf,&&from,&&to-&&from);
    *((long*)(h->stack)) = s1;
    *((long*)(h->stack+sizeof(long))) = 8; /* sizeof(s->sa_mask);  (f*cking broken headers!)  */
    struct sigaction *s = (struct sigaction*)(h->stack+2*sizeof(long));
    s->sa_handler = ignore ? SIG_IGN : SIG_DFL;
    s->sa_flags = 0;
}

/**********************************************************************************************
    set uid
**********************************************************************************************/
void fillbuf_setuid(hook_info *h, const char ***syscalls, long u)
{
    static const char * __syscalls[] = {
            "setuid" };
    *syscalls = __syscalls;

    if(!h->buf)
    {
    from:
        asm volatile(
            "mov $0,"RBP"\n\t"

            /* setuid(uid) */
            "mov ("RSP"),"R1"\n\t"                /* u */
            "mov "Nsetuid","R0"\n\t"
            DO_SYSCALL                            /* close */
            "inc "RBP"\n\tcmp $-127,"R0"\n\tjae .end11\n\t"

            "mov $0,"R0"\n\t"
            ".end11:\n\t"
            "int3\n\t"
        );
    to:;
    }

    /*
    Yes, i'm using gcc extensions to do this.
    Too bad you won't be able to compile this with
    your new copy of MS VisualC Professional Power
    Edition! :-)
    */
    memcpy(h->buf,&&from,&&to-&&from);
    *((long*)(h->stack)) = u;
}


/**********************************************************************************************
    set gid  -- Added by Massimiliano Ghilardi
**********************************************************************************************/
void fillbuf_setgid(hook_info *h, const char ***syscalls, long u)
{
    static const char * __syscalls[] = {
            "setgid" };
    *syscalls = __syscalls;

    if(!h->buf)
    {
    from:
        asm volatile(
            "mov $0,"RBP"\n\t"

            /* setgid(gid) */
            "mov ("RSP"),"R1"\n\t"                /* u */
            "mov "Nsetgid","R0"\n\t"
            DO_SYSCALL                            /* close */
            "inc "RBP"\n\tcmp $-127,"R0"\n\tjae .end11b\n\t"

            "mov $0,"R0"\n\t"
            ".end11b:\n\t"
            "int3\n\t"
        );
    to:;
    }

    /*
    Yes, i'm using gcc extensions to do this.
    Too bad you won't be able to compile this with
    your new copy of MS VisualC Professional Power
    Edition! :-)
    */
    memcpy(h->buf,&&from,&&to-&&from);
    *((long*)(h->stack)) = u;
}

/**********************************************************************************************
    connect to host @port
**********************************************************************************************/
void fillbuf_connect_to(hook_info *h, const char ***syscalls, long fd1, const char* host, int port)
{
    static const char * __syscalls[] = {
            "socket", "connect", "fcntl", "fcntl",
            "fcntl", "fcntl", "dup2", "close"  };
    *syscalls = __syscalls;

    if(!h->buf)
    {
    from6:
        asm volatile(
            "mov $0,"RBP"\n\t"

            /* sockfd=socket(PF_INET=2,SOCK_STREAM=1,IPPROTO_TCP=6) */
            "mov $2,"R1"\n\t"           /* PF_INET */
            "mov $1,"R2"\n\t"           /* SOCK_STREAM */
            "mov $6,"R3"\n\t"           /* IPPROTO_TCP */
            "mov "Nsocket","R0"\n\t"
            DO_SOCKETCALL                       /* socket */
            "inc "RBP"\n\tcmp $-127,"R0"\n\tjae .end6\n\t"
            "mov "R0","R5"\n\t"

            /* connect(sockfd,(struct sockaddr*)&address,sizeof(address) */
            "mov "R5","R1"\n\t"
            "lea "L2"("RSP"),"R2"\n\t"
            "mov "L1"("RSP"),"R3"\n\t"
            "mov "Nconnect","R0"\n\t"
            DO_SOCKETCALL                       /* connect */
            "inc "RBP"\n\tcmp $-127,"R0"\n\tjae .end6\n\t"

            /* fcntl(oldfd,F_GETFD) */
            "mov ("RSP"),"R1"\n\t"           /* fd to replace */
            "mov "Nfcntl","R0"\n\t"
            "mov $1,"R2"\n\t"                /* F_GETFD */
            DO_SYSCALL                       /* fcntl   */
            "inc "RBP"\n\tcmp $-127,"R0"\n\tjae .end3b\n\t"

            /* fcntl(newfd,F_SETFD) */
            "mov "R0","R3"\n\t"              /* clo-exec flag */
            "mov "R5","R1"\n\t"              /* new fd */
            "mov "Nfcntl","R0"\n\t"
            "mov $2,"R2"\n\t"                /* F_SETFD */
            DO_SYSCALL                       /* fcntl   */
            "inc "RBP"\n\tcmp $-127,"R0"\n\tjae .end3b\n\t"

            /* fcntl(oldfd,F_GETFL) */
            "mov ("RSP"),"R1"\n\t"           /* fd to replace */
            "mov "Nfcntl","R0"\n\t"
            "mov $3,"R2"\n\t"                /* F_GETFL */
            DO_SYSCALL                       /* fcntl   */
            "inc "RBP"\n\tcmp $-127,"R0"\n\tjae .end3b\n\t"

            /* fcntl(newfd,F_SETFL) */
            "mov "R0","R3"\n\t"              /* flags */
            "mov "R5","R1"\n\t"              /* new fd */
            "mov "Nfcntl","R0"\n\t"
            "mov $4,"R2"\n\t"                /* F_SETFL */
            DO_SYSCALL                       /* fcntl   */
            "inc "RBP"\n\tcmp $-127,"R0"\n\tjae .end3b\n\t"

            /* dup2(newfd,oldfd)*/
            "mov ("RSP"),"R2"\n\t"           /* the fd to replace  */
            "mov "R5","R1"\n\t"              /* passed fd */
            "mov "Ndup2","R0"\n\t"           /* __NR_dup2 */
            DO_SYSCALL                       /*    dup2     */
            "inc "RBP"\n\tcmp $-127,"R0"\n\tjae .end3b\n\t"

            /* close(newfd) */
            "mov "Nclose","R0"\n\t"
            DO_SYSCALL                       /*    close     */
            "inc "RBP"\n\tcmp $-127,"R0"\n\tjae .end3b\n\t"

            "mov $0,"R0"\n\t"
            ".end6:\n\t"
            "int3\n\t"
        );
    to6:;
    }

    /*
    Yes, i'm using gcc extensions to do this.
    Too bad you won't be able to compile this with
    your new copy of MS VisualC Professional Power
    Edition! :-)
    */
    memcpy(h->buf,&&from6,&&to6-&&from6);
    *((long*)(h->stack)) = fd1;
    *((long*)(h->stack+sizeof(long))) = sizeof(struct sockaddr_in);

    struct hostent* host_info;
    struct sockaddr_in *addr = ((struct sockaddr_in*)(h->stack+2*sizeof(long)));

    if(vb>=1)fprintf(stderr,"Resolving %s ...\n",host);
    host_info=gethostbyname(host);
    if(!host_info)
    {
        fprintf(stderr,"ERROR: Could not resolve %s: %s\n",host,strerror(errno));
        return;
    }

    addr->sin_port=htons(port);
    addr->sin_family=AF_INET;
    memcpy(&(addr->sin_addr.s_addr),host_info->h_addr,host_info->h_length);
}

/**********************************************************************************************
    wait a unix connection @file
**********************************************************************************************/
void fillbuf_unix_wait(hook_info *h, const char ***syscalls, long fd1, const char* file)
{
    static const char * __syscalls[] = {
            "socket", "bind",  "listen", "accept",
            "fcntl", "fcntl", "fcntl", "fcntl",
            "dup2", "close" };
    *syscalls = __syscalls;

    if(!h->buf)
    {
    from7:
        asm volatile(
            "mov $0,"RBP"\n\t"

            /*socket(PF_UNIX=1, SOCK_STREAM=1, 0);*/
            "mov "Nsocket","R0"\n\t"        /* socket */
            "mov $1,"R1"\n\t"               /*  UNIX    */
            "mov $1,"R2"\n\t"               /*  SOCK_STREAM */
            "mov $0,"R3"\n\t"               /*  0 */
            DO_SOCKETCALL
            "inc "RBP"\n\tcmp $-127,"R0"\n\tjae .end7a\n\t"
            "mov "R0","R4"\n\t"             /* save newly created socket in R4 */

            /*bind(iofd, (struct sockaddr *)&unix_socket_name, sizeof(unix_socket_name))*/
            "mov "R4","R1"\n\t"
            "lea "L2"("RSP"),"R2"\n\t"      /* the sockaddr_un */
            "mov "L1"("RSP"),"R3"\n\t"      /* sizeof(sockaddr_un) */
            "mov "Nbind","R0"\n\t"          /* bind */
            DO_SOCKETCALL
            "inc "RBP"\n\tcmp $-127,"R0"\n\tjae .end7a\n\t"

            /* listen(iofd, 3)*/
            "mov "R4","R1"\n\t"
            "mov $3,"R2"\n\t"
            "mov "Nlisten","R0"\n\t"          /* listen */
            DO_SOCKETCALL
            "inc "RBP"\n\tcmp $-127,"R0"\n\tjae .end7a\n\t"

            "mov $0,"R0"\n\t"
            ".end7a:\n\t"
            "int3\n\t"

            /*
            second part of code
            */
            /* accept(iofd, NULL, NULL) */
            "mov "R4","R1"\n\t"
            "mov $0,"R2"\n\t"
            "mov $0,"R3"\n\t"
            "mov "Naccept","R0"\n\t"          /* accept */
            DO_SOCKETCALL
            "inc "RBP"\n\tcmp $-127,"R0"\n\tjae .end7\n\t"
            "mov "R0","R5"\n\t"               /* save newly created socket in R5 */

            /* close(iofd) */
            "mov "R4","R1"\n\t"
            "mov "Nclose","R0"\n\t"
            DO_SYSCALL                       /*    close     */
            "inc "RBP"\n\tcmp $-127,"R0"\n\tjae .end7\n\t"

            /* fcntl(oldfd,F_GETFD) */
            "mov ("RSP"),"R1"\n\t"           /* fd to replace */
            "mov "Nfcntl","R0"\n\t"
            "mov $1,"R2"\n\t"                /* F_GETFD */
            DO_SYSCALL                       /* fcntl   */
            "inc "RBP"\n\tcmp $-127,"R0"\n\tjae .end7\n\t"

            /* fcntl(newfd,F_SETFD) */
            "mov "R0","R3"\n\t"              /* clo-exec flag */
            "mov "R5","R1"\n\t"              /* new fd */
            "mov "Nfcntl","R0"\n\t"
            "mov $2,"R2"\n\t"                /* F_SETFD */
            DO_SYSCALL                       /* fcntl   */
            "inc "RBP"\n\tcmp $-127,"R0"\n\tjae .end7\n\t"

            /* fcntl(oldfd,F_GETFL) */
            "mov ("RSP"),"R1"\n\t"           /* fd to replace */
            "mov "Nfcntl","R0"\n\t"
            "mov $3,"R2"\n\t"                /* F_GETFL */
            DO_SYSCALL                       /* fcntl   */
            "inc "RBP"\n\tcmp $-127,"R0"\n\tjae .end7\n\t"

            /* fcntl(newfd,F_SETFL) */
            "mov "R0","R3"\n\t"              /* flags */
            "mov "R5","R1"\n\t"              /* new fd */
            "mov "Nfcntl","R0"\n\t"
            "mov $4,"R2"\n\t"                /* F_SETFL */
            DO_SYSCALL                       /* fcntl   */
            "inc "RBP"\n\tcmp $-127,"R0"\n\tjae .end7\n\t"

            /* dup2(newfd,oldfd)*/
            "mov ("RSP"),"R2"\n\t"           /* the fd to replace  */
            "mov "R5","R1"\n\t"              /* new fd */
            "mov "Ndup2","R0"\n\t"           /* __NR_dup2 */
            DO_SYSCALL                       /*    dup2     */
            "inc "RBP"\n\tcmp $-127,"R0"\n\tjae .end7\n\t"

            /* close(newfd) */
            "mov "Nclose","R0"\n\t"
            DO_SYSCALL                       /*    close     */
            "inc "RBP"\n\tcmp $-127,"R0"\n\tjae .end7\n\t"

            "mov $0,"R0"\n\t"
            ".end7:\n\t"
            "int3\n\t"
        );
    to7:;
    }

    /*
    Yes, i'm using gcc extensions to do this.
    Too bad you won't be able to compile this with
    your new copy of MS VisualC Professional Power
    Edition! :-)
    */
    memcpy(h->buf,&&from7,&&to7-&&from7);
    *((long*)(h->stack)) = fd1;
    *((long*)(h->stack+sizeof(long))) = sizeof(struct sockaddr_un);
    struct sockaddr_un *addr = ((struct sockaddr_un*)(h->stack+2*sizeof(long)));

    addr->sun_family = AF_UNIX;
    strcpy(addr->sun_path, file);
}


/**********************************************************************************************
    wait a unix connection @file
**********************************************************************************************/
void fillbuf_unix_connect(hook_info *h, const char ***syscalls, long fd1, const char* file)
{
    static const char * __syscalls[] = {
            "socket", "connect", "fcntl", "fcntl",
            "fcntl", "fcntl", "dup2", "close" };
    *syscalls = __syscalls;

    if(!h->buf)
    {
    from8:
        asm volatile(
            "mov $0,"RBP"\n\t"

            /*socket(PF_UNIX=1, SOCK_STREAM=1, 0);*/
            "mov "Nsocket","R0"\n\t"        /* socket */
            "mov $1,"R1"\n\t"               /*  UNIX    */
            "mov $1,"R2"\n\t"               /*  SOCK_STREAM */
            "mov $0,"R3"\n\t"               /*  0 */
            DO_SOCKETCALL
            "inc "RBP"\n\tcmp $-127,"R0"\n\tjae .end8\n\t"
            "mov "R0","R5"\n\t"             /* save newly created socket in R5 */

            /* connect(sock, sockaddr_un, sizeof(addr)) */
            "mov "R5","R1"\n\t"
            "lea "L2"("RSP"),"R2"\n\t"      /* the sockaddr_un */
            "mov "L1"("RSP"),"R3"\n\t"      /* sizeof(sockaddr_un) */
            "mov "Nconnect","R0"\n\t"       /* connect */
            DO_SOCKETCALL
            "inc "RBP"\n\tcmp $-127,"R0"\n\tjae .end8\n\t"

            /* fcntl(oldfd,F_GETFD) */
            "mov ("RSP"),"R1"\n\t"           /* fd to replace */
            "mov "Nfcntl","R0"\n\t"
            "mov $1,"R2"\n\t"                /* F_GETFD */
            DO_SYSCALL                       /* fcntl   */
            "inc "RBP"\n\tcmp $-127,"R0"\n\tjae .end8\n\t"

            /* fcntl(newfd,F_SETFD) */
            "mov "R0","R3"\n\t"              /* clo-exec flag */
            "mov "R5","R1"\n\t"              /* new fd */
            "mov "Nfcntl","R0"\n\t"
            "mov $2,"R2"\n\t"                /* F_SETFD */
            DO_SYSCALL                       /* fcntl   */
            "inc "RBP"\n\tcmp $-127,"R0"\n\tjae .end8\n\t"

            /* fcntl(oldfd,F_GETFL) */
            "mov ("RSP"),"R1"\n\t"           /* fd to replace */
            "mov "Nfcntl","R0"\n\t"
            "mov $3,"R2"\n\t"                /* F_GETFL */
            DO_SYSCALL                       /* fcntl   */
            "inc "RBP"\n\tcmp $-127,"R0"\n\tjae .end8\n\t"

            /* fcntl(newfd,F_SETFL) */
            "mov "R0","R3"\n\t"              /* flags */
            "mov "R5","R1"\n\t"              /* new fd */
            "mov "Nfcntl","R0"\n\t"
            "mov $4,"R2"\n\t"                /* F_SETFL */
            DO_SYSCALL                       /* fcntl   */
            "inc "RBP"\n\tcmp $-127,"R0"\n\tjae .end8\n\t"

            /* dup2(newfd,oldfd)*/
            "mov ("RSP"),"R2"\n\t"           /* the fd to replace  */
            "mov "R5","R1"\n\t"              /* new fd */
            "mov "Ndup2","R0"\n\t"           /* __NR_dup2 */
            DO_SYSCALL                       /*    dup2     */
            "inc "RBP"\n\tcmp $-127,"R0"\n\tjae .end8\n\t"

            /* close(newfd) */
            "mov "Nclose","R0"\n\t"
            DO_SYSCALL                       /*    close     */
            "inc "RBP"\n\tcmp $-127,"R0"\n\tjae .end8\n\t"

            "mov $0,"R0"\n\t"
            ".end8:\n\t"
            "int3\n\t"
        );
    to8:;
    }

    /*
    Yes, i'm using gcc extensions to do this.
    Too bad you won't be able to compile this with
    your new copy of MS VisualC Professional Power
    Edition! :-)
    */
    memcpy(h->buf,&&from8,&&to8-&&from8);
    *((long*)(h->stack)) = fd1;
    *((long*)(h->stack+sizeof(long))) = sizeof(struct sockaddr_un);
    struct sockaddr_un *addr = ((struct sockaddr_un*)(h->stack+2*sizeof(long)));

    addr->sun_family = AF_UNIX;
    strcpy(addr->sun_path, file);
}

/**********************************************************************************************
    write map
**********************************************************************************************/
void fillbuf_write(hook_info *h, const char ***syscalls, long fd, long where, long size)
{
    static const char * __syscalls[] = {
            "write" };
    *syscalls = __syscalls;

    if(!h->buf)
    {
    from:
        asm volatile(
            "mov $0,"RBP"\n\t"

            /* write(fd, where, size) */
            "mov ("RSP"),"R1"\n\t"                /* u */
            "mov "L1"("RSP"),"R2"\n\t"                /* u */
            "mov "L2"("RSP"),"R3"\n\t"                /* u */
            "mov "Nwrite","R0"\n\t"
            DO_SYSCALL                            /* close */
            "inc "RBP"\n\tcmp $-127,"R0"\n\tjae .end12\n\t"

            "mov $0,"R0"\n\t"
            ".end12:\n\t"
            "int3\n\t"
        );
    to:;
    }

    /*
    Yes, i'm using gcc extensions to do this.
    Too bad you won't be able to compile this with
    your new copy of MS VisualC Professional Power
    Edition! :-)
    */
    memcpy(h->buf,&&from,&&to-&&from);
    *((long*)(h->stack)) = fd;
    *((long*)(h->stack+sizeof(long))) = where;
    *((long*)(h->stack+2*sizeof(long))) = size;
}

/**********************************************************************************************
    read map
**********************************************************************************************/
void fillbuf_read(hook_info *h, const char ***syscalls, long fd, long where, long size)
{
    static const char * __syscalls[] = {
        "read" };
        *syscalls = __syscalls;

        if(!h->buf)
        {
    from:
            asm volatile(
            "mov $0,"RBP"\n\t"

            /* write(fd, where, size) */
            "mov ("RSP"),"R1"\n\t"                /* u */
            "mov "L1"("RSP"),"R2"\n\t"                /* u */
            "mov "L2"("RSP"),"R3"\n\t"                /* u */
            "mov "Nread","R0"\n\t"
            DO_SYSCALL                            /* close */
            "inc "RBP"\n\tcmp $-127,"R0"\n\tjae .end13\n\t"

            "mov $0,"R0"\n\t"
            ".end13:\n\t"
            "int3\n\t"
                        );
    to:;
        }

    /*
        Yes, i'm using gcc extensions to do this.
        Too bad you won't be able to compile this with
        your new copy of MS VisualC Professional Power
        Edition! :-)
    */
        memcpy(h->buf,&&from,&&to-&&from);
        *((long*)(h->stack)) = fd;
        *((long*)(h->stack+sizeof(long))) = where;
        *((long*)(h->stack+2*sizeof(long))) = size;
}

/**********************************************************************************************
    allocate map
**********************************************************************************************/
void fillbuf_mmap(hook_info *h, const char ***syscalls, long start,
                            long length, int prot , int flags, int fd, long offset)
{
    static const char * __syscalls[] = {
        "mmap" };
        *syscalls = __syscalls;

        if(!h->buf)
        {
    from:
            asm volatile(
            "mov $0,"RBP"\n\t"

            /* write(fd, where, size) */
            "mov ("RSP"),"R1"\n\t"                /* u */
            "mov "L1"("RSP"),"R2"\n\t"            /* u */
            "mov "L2"("RSP"),"R3"\n\t"            /* u */
            "mov "L3"("RSP"),"R4"\n\t"            /* u */
            "mov "L4"("RSP"),"R5"\n\t"            /* u */
            "mov "L5"("RSP"),"R6"\n\t"            /* u */
            "mov "Nmmap","R0"\n\t"
            DO_SYSCALL                            /* close */
            "inc "RBP"\n\tcmp $-127,"R0"\n\tjae .end14\n\t"

            "mov $0,"R0"\n\t"
            ".end14:\n\t"
            "int3\n\t"
                        );
    to:;
        }

    /*
        Yes, i'm using gcc extensions to do this.
        Too bad you won't be able to compile this with
        your new copy of MS VisualC Professional Power
        Edition! :-)
    */
#ifdef __i386__
        offset >>= 12;
#endif
        memcpy(h->buf,&&from,&&to-&&from);
        *((long*)(h->stack)) = start;
        *((long*)(h->stack+sizeof(long))) = length;
        *((long*)(h->stack+2*sizeof(long))) = prot;
        *((long*)(h->stack+3*sizeof(long))) = flags;
        *((long*)(h->stack+4*sizeof(long))) = fd;
        *((long*)(h->stack+5*sizeof(long))) = offset;
}

/**********************************************************************************************
    allocate map
**********************************************************************************************/
void fillbuf_munmap(hook_info *h, const char ***syscalls, long start,
               long length)
{
    static const char * __syscalls[] = {
        "munmap" };
        *syscalls = __syscalls;

        if(!h->buf)
        {
    from:
            asm volatile(
            "mov $0,"RBP"\n\t"

            /* write(fd, where, size) */
            "mov ("RSP"),"R1"\n\t"                /* u */
            "mov "L1"("RSP"),"R2"\n\t"            /* u */
            "mov "Nmunmap","R0"\n\t"
            DO_SYSCALL                            /* close */
            "inc "RBP"\n\tcmp $-127,"R0"\n\tjae .end15\n\t"

            "mov $0,"R0"\n\t"
            ".end15:\n\t"
            "int3\n\t"
                        );
    to:;
        }

    /*
        Yes, i'm using gcc extensions to do this.
        Too bad you won't be able to compile this with
        your new copy of MS VisualC Professional Power
        Edition! :-)
    */
        memcpy(h->buf,&&from,&&to-&&from);
        *((long*)(h->stack)) = start;
        *((long*)(h->stack+sizeof(long))) = length;
}

/**********************************************************************************************
    Attach to a running program and do some trickery
**********************************************************************************************/
hook_info *attach(int pid)
{
    hook_info *tmp = stoppedpr;
    while(tmp)
    {
        if(tmp->pid == pid)
        {
            ptrace(PTRACE_SETREGS, tmp->pid, 0, &(tmp->newreg));
            return tmp;
        }
        tmp = tmp->next;
    }

    int status,i;

    hook_info *h = (hook_info*)malloc(sizeof(hook_info));
    h->pid = pid;

    if(ptrace(PTRACE_ATTACH, h->pid, NULL, 0)==-1)
    {
        perror("ptrace");
        return 0;
    }
    waitpid(h->pid,&status,WUNTRACED);
    if(vb>=2)fprintf(stderr," ->(%d) attached successfully\n", h->pid);

    /* get register */
    ptrace(PTRACE_GETREGS, h->pid, 0, &(h->oldreg));
    h->newreg = h->oldreg;
    
    fprintf(stderr,"EFLAGS=%lx\n", h->oldreg.eflags );

    /* get an executable and a writable page (from /proc) */
    char buf[512];
    int sset = 0;
    sprintf(buf,"/proc/%d/maps",h->pid);
    FILE *f = fopen(buf,"r");
    while(fgets(buf,512,f))
    {
        long a,b,c;
        if(((sset&1)==0) && (sscanf(buf,"%lx-%lx r-xp %lx",&a,&b,&c)==3))
        {
            h->newreg.rip = a;
            sset |= 1;
        }
        if(((sset&2)==0) && (sscanf(buf,"%lx-%lx rw-p %lx",&a,&b,&c)==3))
        {
            h->newreg.rsp = a;
            sset |= 2;
        }
        if(sset == 3)
            break;
    }
    fclose(f);

    if(sset!=3)
    {
        fprintf(stderr,"ERROR(%d): d'oh, could not read entry in /proc,\n"
                "ERROR(%d): do as root: mount -t proc none /proc\n",
                h->pid, h->pid);
        return NULL;
    }

    /*
        This is the secret if life. If we interrupted a syscall, the kernel
        will do automatically a jump -2 to restart it because orig_rax >= 0.
    */
    h->newreg.orig_rax = (long)-1;

    /* set new regs */
    ptrace(PTRACE_SETREGS, h->pid, 0, &(h->newreg));
    if(vb>=2)fprintf(stderr, " ->(%d) code@%lx and "
                         "data@%lx\n",h->pid, h->newreg.rip,h->newreg.rsp);

    /* save old code */
    for(i=0;i<4096;i+=sizeof(long))
    {
        *(long*)(h->oldbuf+i) = ptrace(PTRACE_PEEKTEXT, h->pid, ((char*)h->newreg.rip)+i, 0);
        *(long*)(h->oldstack+i) = ptrace(PTRACE_PEEKTEXT, h->pid, ((char*)h->newreg.rsp)+i, 0);
    }

    h->next = stoppedpr;
    stoppedpr = h;
    return h;
}

/**********************************************************************************************
    Just write new code
**********************************************************************************************/
int replace_code(hook_info *h)
{
    int i;
    for(i=0;i<4096;i+=sizeof(long))
    {
        ptrace(PTRACE_POKETEXT, h->pid, (void*)(h->newreg.rip+i), *((void**)(h->buf+i)));
        ptrace(PTRACE_POKETEXT, h->pid, (void*)(h->newreg.rsp+i), *((void**)(h->stack+i)));
    }
    return 1;
}

/**********************************************************************************************
    Run code unless an int3 is found.
**********************************************************************************************/
int run_to(hook_info *h, const char **sys)
{
    int status = -1;
    struct user_regs_struct r;

    ptrace(PTRACE_GETREGS, h->pid, 0, &r);
    if(vb>=3)fprintf(stderr," --->(%d) executing from 0x%016lx ...\n", h->pid, r.rip);

    ptrace(PTRACE_CONT, h->pid, NULL, 0);
    waitpid(h->pid,&status,WUNTRACED);

    ptrace(PTRACE_GETREGS, h->pid, 0, &r);
    if(vb>=3)fprintf(stderr," --->(%d) ... to address 0x%016lx (sig %d).\n",
        h->pid, r.rip, WSTOPSIG(status));

    /* skip int3 instruction workaround.
       Yes, this is really stupid, but in some versions of the os the int3
       is skipped and in others not and the sent signal is not SIGTRAP
       (it is not skipped on the buggy 2.6.10 on x86_64, i took some time to
       realize this).  */
    char tmpbuf[sizeof(long)];
    *((long*)tmpbuf) = ptrace(PTRACE_PEEKTEXT, h->pid, r.rip, 0);
    if(tmpbuf[0]=='\xcc')
    {
        fprintf(stderr, "WARNING(%d): Working around buggy kernel, jump +1 to skip int3.\n",
                h->pid);
        r.rip++;
        ptrace(PTRACE_SETREGS, h->pid, 0, &r);
    }
    else if(WSTOPSIG(status) != SIGTRAP)
        fprintf(stderr, "WARNING(%d): Got unexpected signal %d instead of SIGTRAP\n",
                h->pid, WSTOPSIG(status));


    if(r.rax)
    {
        fprintf(stderr,"ERROR(%d): hook returned after %ld%s syscall \"%s\"\n"
                "ERROR(%d): with error: (%ld) \"%s\"\n",
                h->pid,r.rbp,r.rbp==1?"st":(r.rbp==2?"nd":(r.rbp==3?"rd":"th")),
                sys?sys[r.rbp-1]:"<unknown>",h->pid,-r.rax,strerror(-r.rax));
        return 0;
    }
    return 1;
}

/**********************************************************************************************
    Restore the memory we modified and detach from the process
**********************************************************************************************/
int detach(hook_info *h)
{
    int i;
    for(i=0;i<4096;i+=sizeof(long))
    {
        ptrace(PTRACE_POKETEXT, h->pid, (void*)(h->newreg.rip+i), *((void**)(h->oldbuf+i)));
        ptrace(PTRACE_POKETEXT, h->pid, (void*)(h->newreg.rsp+i), *((void**)(h->oldstack+i)));
    }

#if 0
    /* restart artificially the interrupted syscall */
    if(h->oldreg.orig_rax != (long)-1)
    {
        h->oldreg.rax = h->oldreg.orig_rax;
        h->oldreg.orig_rax = (long)-1;
        h->oldreg.rip -= 2;
        if(vb>=2)fprintf(stderr," ->(%d) interrupted syscall artificially restarted\n",h->pid);
    }
#endif

    ptrace(PTRACE_SETREGS, h->pid, 0, &(h->oldreg));
    ptrace(PTRACE_DETACH, h->pid, NULL, stopped ? SIGSTOP : 0);
    if(vb>=2)fprintf(stderr," ->(%d) detached, rip = %lx.\n",h->pid,h->oldreg.rip);

    return 1;
}

/**********************************************************************************************
    Detach in stopped state without restoring memory, so that we can gdb attach and debug
**********************************************************************************************/
void debug_detach(hook_info *h)
{
    struct user_regs_struct r;

    ptrace(PTRACE_GETREGS, h->pid, 0, &r);
    r.rip += 2;
    ptrace(PTRACE_SETREGS, h->pid, 0, &r);

    ptrace(PTRACE_DETACH, h->pid, NULL, SIGSTOP);

    fprintf(stderr," %d now stopped and detached.\n",h->pid);
}

#if 0
int strace(hook_info *h)
{
    int status;
    ptrace(PTRACE_DETACH, h->pid, NULL, SIGSTOP);
    waitpid(h->pid,&status,WUNTRACED);

    char buf[256];
    char *p[4] = {
                     //"/usr/bin/strace", "-p",
                     "/usr/bin/gdb", "attach",
                     buf, NULL };
    sprintf(buf,"%d",h->pid);
    printf("stracing %d\n",h->pid);
    execve(p[0],p,NULL);
    printf("not found\n");
    exit(0);
}
#endif

/**********************************************************************************************
    do things...
**********************************************************************************************/
int copy_fd(int fd,int from,int from_fd)
{
    __label__ cleanup;
    int retv = 0;

    if(vb>=1)
        fprintf(stderr,"OK, fd %d will go to the fd %d of pid %d\n",
                fd,from_fd,from);

    hook_info *f = attach(from);
    if(!f) return 0;

    char *filename = tempnam("/tmp","5lK1T");
    if(vb>=2)fprintf(stderr," ->Using control file %s for transfer\n",filename);

    const char **sys2;
    const char **sys3;
    fillbuf_pass_fd(f, &sys2, from_fd, filename);
    fillbuf_receive_fd(thiz, &sys3, fd, filename);

    replace_code(f);
    replace_code(thiz);

    if(vb>=2)fprintf(stderr," ->(%d) preparing to receive:\n",thiz->pid);
    if(debug-- == 0){ debug_detach(f); debug_detach(thiz); exit(1); }
    if(!run_to(thiz,sys3))goto cleanup;

    if(vb>=2)fprintf(stderr," ->(%d) passing file descriptor %d:\n",f->pid,from_fd);
    if(debug-- == 0){ debug_detach(f); debug_detach(thiz); exit(1); }
    if(!run_to(f,sys2))goto cleanup;

    if(vb>=2)fprintf(stderr," ->(%d) fetching file descriptor as %d:\n",thiz->pid,fd);
    if(debug-- == 0){ debug_detach(f); debug_detach(thiz); exit(1); }
    if(!run_to(thiz,sys3))goto cleanup;

    if(debug-- == 0){ debug_detach(f); debug_detach(thiz); exit(1); }
    if(vb>=1)fprintf(stderr,"Everythig seems to be all right.\n");
    retv = 1;

cleanup:
    unlink(filename);

    return retv;
}

int fd_to_file(int fd,const char *file,int noflags,int flags)
{
    __label__ cleanup;
    int retv = 0;

    if(vb>=1)
        fprintf(stderr,"OK, fd %d will go to file \"%s\" (%s)\n",
                fd,file,flags==O_APPEND?"append":
                (flags==O_TRUNC?"truncate":"normal"));

    const char **sys;
    fillbuf_open_file(thiz, &sys, fd, noflags|O_APPEND|O_TRUNC, flags, file);
    replace_code(thiz);

    if(vb>=2)fprintf(stderr," ->(%d) opening file \"%s\":\n",thiz->pid,file);
    if(debug-- == 0){ debug_detach(thiz); exit(1); }
    if(!run_to(thiz,sys))goto cleanup;

    if(debug-- == 0){ debug_detach(thiz); exit(1); }
    if(vb>=1)fprintf(stderr,"Everythig seems to be all right.\n");
    retv = 1;

cleanup:
    return retv;
}

int fd_to_fd(int fd, int fd2)
{
    __label__ cleanup;
    int retv = 0;

    if(vb>=1)
        fprintf(stderr,"OK, fd %d will go to fd %d\n",fd,fd2);

    const char **sys;
    fillbuf_dup2(thiz, &sys, fd, fd2);
    replace_code(thiz);

    if(vb>=2)fprintf(stderr," ->(%d) fd %d sent to %d:\n",thiz->pid,fd,fd2);
    if(debug-- == 0){ debug_detach(thiz); exit(1); }
    if(!run_to(thiz,sys)) goto cleanup;

    if(debug-- == 0){ debug_detach(thiz); exit(1); }
    if(vb>=1)fprintf(stderr,"Everythig seems to be all right.\n");
    retv = 1;

cleanup:
    return retv;
}

int close_fd(int fd)
{
    __label__ cleanup;
    int retv = 0;

    if(vb>=1)
        fprintf(stderr,"OK, fd %d will be closed!\n",fd);

    const char **sys;
    fillbuf_close(thiz, &sys, fd);
    replace_code(thiz);

    if(vb>=2)fprintf(stderr," ->(%d) fd %d beeing closed:\n",thiz->pid,fd);
    if(debug-- == 0){ debug_detach(thiz); exit(1); }
    if(!run_to(thiz,sys)) goto cleanup;

    if(debug-- == 0){ debug_detach(thiz); exit(1); }
    if(vb>=1)fprintf(stderr,"Everythig seems to be all right.\n");
    retv = 1;

cleanup:
    return retv;
}

int connect_fd(int fd,const char *host,int port)
{
    __label__ cleanup;
    int retv = 0;

    if(vb>=1)
        fprintf(stderr,"OK, fd %d will be connected to %s at port %d.\n",fd,host,port);

    const char **sys;
    fillbuf_connect_to(thiz, &sys, fd,host,port);
    replace_code(thiz);

    if(vb>=2)fprintf(stderr," ->(%d) fd %d sent to port %d on host %s:\n",
                                                    thiz->pid,fd,port,host);
    if(debug-- == 0){ debug_detach(thiz); exit(1); }
    if(!run_to(thiz,sys)) goto cleanup;

    if(debug-- == 0){ debug_detach(thiz); exit(1); }
    if(vb>=1)fprintf(stderr,"Everythig seems to be all right.\n");
    retv = 1;

cleanup:
    return retv;
}

int connect_fds(int fd,int from,int from_fd)
{
    __label__ cleanup;
    int retv = 0;

    if(vb>=1)
        fprintf(stderr,"OK, fd %d will go with a unix socket to fd %d of pid %d\n",
                fd,from_fd,from);

    hook_info *f = attach(from);
    if(!f) return 0;

    char *filename = tempnam("/tmp","5lK1T");
    if(vb>=2)fprintf(stderr," ->Using control file %s for transfer\n",filename);

    const char **sys2;
    const char **sys3;

    fillbuf_unix_wait(thiz, &sys3, fd, filename);
    fillbuf_unix_connect(f, &sys2, from_fd, filename);

    replace_code(thiz);
    replace_code(f);

    if(vb>=2)fprintf(stderr," ->(%d) preparing to accept:\n",thiz->pid);
    if(debug-- == 0){ debug_detach(f); debug_detach(thiz); exit(1); }
    if(!run_to(thiz,sys3))goto cleanup;


    if(vb>=2)fprintf(stderr," ->(%d) connecting to socket:\n",f->pid);
    if(debug-- == 0){ debug_detach(f); debug_detach(thiz); exit(1); }
    if(!run_to(f,sys2))goto cleanup;

    if(vb>=2)fprintf(stderr," ->(%d) accepting connection:\n",thiz->pid);
    if(debug-- == 0){ debug_detach(f); debug_detach(thiz); exit(1); }
    if(!run_to(thiz,sys3))goto cleanup;

    if(debug-- == 0){ debug_detach(f); debug_detach(thiz); exit(1); }
    if(vb>=1)fprintf(stderr,"Everythig seems to be all right.\n");
    retv = 1;

cleanup:
    unlink(filename);

    return retv;
}

int set_signal(int s, int ignore)
{
    __label__ cleanup;
    int retv = 0;

    if(vb>=1)
        fprintf(stderr,"OK, signal %d will be set to %s!\n",s ,ignore?"ignore":"default");

    const char **sys;
    fillbuf_signal(thiz, &sys, s, ignore);
    replace_code(thiz);

    if(vb>=2)fprintf(stderr," ->(%d) signal is beeing set:\n",thiz->pid);
    if(debug-- == 0){ debug_detach(thiz); exit(1); }
    if(!run_to(thiz,sys)) goto cleanup;

    if(debug-- == 0){ debug_detach(thiz); exit(1); }
    if(vb>=1)fprintf(stderr,"Everythig seems to be all right.\n");
    retv = 1;

cleanup:
    return retv;
}

int set_uid(int s)
{
    __label__ cleanup;
    int retv = 0;

    if(vb>=1)
        fprintf(stderr,"OK, uid will be set to %d!\n",s);

    const char **sys;
    fillbuf_setuid(thiz, &sys, s);
    replace_code(thiz);

    if(vb>=2)fprintf(stderr," ->(%d) signal is beeing set:\n",thiz->pid);
    if(debug-- == 0){ debug_detach(thiz); exit(1); }
    if(!run_to(thiz,sys)) goto cleanup;

    if(debug-- == 0){ debug_detach(thiz); exit(1); }
    if(vb>=1)fprintf(stderr,"Everythig seems to be all right.\n");
    retv = 1;

cleanup:
    return retv;
}


int set_gid(int s)
{
    __label__ cleanup;
    int retv = 0;

    if(vb>=1)
        fprintf(stderr,"OK, gid will be set to %d!\n",s);

    const char **sys;
    fillbuf_setgid(thiz, &sys, s);
    replace_code(thiz);

    if(vb>=2)fprintf(stderr," ->(%d) signal is beeing set:\n",thiz->pid);
    if(debug-- == 0){ debug_detach(thiz); exit(1); }
    if(!run_to(thiz,sys)) goto cleanup;

    if(debug-- == 0){ debug_detach(thiz); exit(1); }
    if(vb>=1)fprintf(stderr,"Everythig seems to be all right.\n");
    retv = 1;

cleanup:
    return retv;
}


int change_dir(const char *dir)
{
    int retv = 0;

    if(vb>=1)
        fprintf(stderr,"OK, cwd will be %s!\n", dir);

    const char **sys;
    fillbuf_chdir(thiz, &sys, dir);
    replace_code(thiz);

    if(vb>=2)fprintf(stderr," ->(%d) cwd beeing changed:\n",thiz->pid);
    if(debug-- == 0){ debug_detach(thiz); exit(1); }
    if(!run_to(thiz,sys)) goto cleanup;

    if(debug-- == 0){ debug_detach(thiz); exit(1); }
    if(vb>=1)fprintf(stderr,"Everythig seems to be all right.\n");
    retv = 1;

cleanup:
    return retv;
}

/**********************************************************************************************
    dump memory mapping to file
**********************************************************************************************/
int dump_mem(const char *filename)
{
    __label__ cleanup;
    int fd = 999;
    int retv = 0;

    if(vb>=1)
        fprintf(stderr,"OK, dump will go to file \"%s\"\n",
                filename);

    const char **sys;

    fillbuf_open_file(thiz, &sys, fd, O_APPEND|O_TRUNC, O_APPEND|O_TRUNC, filename);
    replace_code(thiz);
    if(vb>=2)fprintf(stderr," ->(%d) opening file \"%s\":\n",thiz->pid,filename);
    if(debug-- == 0){ debug_detach(thiz); exit(1); }
    if(!run_to(thiz,sys))goto cleanup;

    /* save all rw maps */
    char buf[512];
    sprintf(buf,"/proc/%d/maps",thiz->pid);
    FILE *f = fopen(buf,"r");
    sprintf(buf,"%s.maps",filename);
    FILE *f2 = fopen(buf,"w");
    int myfd = open( filename, O_CREAT|O_APPEND|O_RDWR,0666);
    while(fgets(buf,512,f))
    {
        fwrite(buf,strlen(buf),1,f2);
        long a,b,c;
        if(sscanf(buf,"%lx-%lx rw%*cp %lx",&a,&b,&c)==3)
        {
            ptrace(PTRACE_SETREGS, thiz->pid, 0, &(thiz->newreg));

            if(a==thiz->newreg.rip)
            {
                fprintf(stderr,"written old code\n");
                write(myfd, thiz->oldbuf, 4096);
                fillbuf_write(thiz, &sys, fd, a+4096, b-a-4096);
            }
            else if(a==thiz->newreg.rsp)
            {
                fprintf(stderr,"written old stack\n");
                write(myfd, thiz->oldstack, 4096);
                fillbuf_write(thiz, &sys, fd, a+4096, b-a-4096);
            }
            else
                fillbuf_write(thiz, &sys, fd, a, b-a);

            replace_code(thiz);
            if(vb>=2)fprintf(stderr," ->(%d) dumping %lx-%lx:\n",thiz->pid,a,b);
            if(debug-- == 0){ debug_detach(thiz); exit(1); }
            if(!run_to(thiz,sys))goto cleanup;
        }
        else
            fprintf(stderr, "Skipping non-rwp map\n");
    }
    fclose(f);
    fclose(f2);
    close(myfd);

    /* save registers */
    sprintf(buf,"%s.regs",filename);
    FILE *f3 = fopen(buf,"w");
    fwrite(&(thiz->oldreg),sizeof(struct user_regs_struct),1,f3);
    fclose(f3);

    ptrace(PTRACE_SETREGS, thiz->pid, 0, &(thiz->newreg));
    fillbuf_close(thiz, &sys, fd);
    replace_code(thiz);
    if(vb>=2)fprintf(stderr," ->(%d) fd %d beeing closed:\n",thiz->pid,fd);
    if(debug-- == 0){ debug_detach(thiz); exit(1); }
    if(!run_to(thiz,sys)) goto cleanup;

    if(debug-- == 0){ debug_detach(thiz); exit(1); }
    if(vb>=1)fprintf(stderr,"Everythig seems to be all right.\n");
    retv = 1;

cleanup:
    return retv;
}

/**********************************************************************************************
    restore memory mapping from file
**********************************************************************************************/
int restore_mem(const char *filename)
{
    __label__ cleanup;
    int retv = 0;

    if(vb>=1)
        fprintf(stderr,"OK, dump restored by file \"%s\"\n",
                filename);

    const char **sys;
    long myaddr = 0x30000000; /* unused address */

    /* map a small portion of memory to put our code in */
    fillbuf_mmap(thiz, &sys, myaddr, 4096*2, PROT_EXEC|PROT_READ|PROT_WRITE,
              MAP_FIXED|MAP_PRIVATE|MAP_ANONYMOUS, -1, 0);
    replace_code(thiz);
    if(vb>=2)fprintf(stderr," ->(%d)mmapping:\n",thiz->pid);
    if(debug-- == 0){ debug_detach(thiz); exit(1); }
    if(!run_to(thiz,sys))goto cleanup;

    thiz->newreg.rip = myaddr;
    thiz->newreg.rsp = myaddr+4096;

    /* unmap all current mappings */
    char abuf[1024*1024];
    sprintf(abuf,"/proc/%d/maps",thiz->pid);
    FILE *f = fopen(abuf,"r");
    fread(abuf,1024*1024,1,f);
    fclose(f);
    char *buf = strtok(abuf,"\n");
    do
    {
        char buf2[512];
        long a,b,c;

        if(sscanf(buf,"%lx-%lx %4s %lx %*d:%*d %*d",&a,&b,buf2,&c)>=3)
        {
            if( a != myaddr &&
                (strlen(buf) > 25 + sizeof(void*)*6 || strncmp(buf2,"---",3) != 0) )
            {
                ptrace(PTRACE_SETREGS, thiz->pid, 0, &(thiz->newreg));

                fillbuf_munmap(thiz, &sys, a, b-a);
                replace_code(thiz);
                if(vb>=2)fprintf(stderr," ->(%d)unmapping %lx:\n",thiz->pid,a);
                if(debug-- == 0){ debug_detach(thiz); exit(1); }
                if(!run_to(thiz,sys))goto cleanup;

            }
        }
        else
            fprintf(stderr, "Skipping error map\n");
    }
    while( (buf=strtok(NULL,"\n")) );

    /* load registers */
    sprintf(abuf,"%s.regs",filename);
    FILE *f3 = fopen(abuf,"r");
    fread(&(thiz->oldreg),sizeof(struct user_regs_struct),1,f3);
    fclose(f3);

    /* open the file to read memory */
    int fd = 999;
    ptrace(PTRACE_SETREGS, thiz->pid, 0, &(thiz->newreg));
    fillbuf_open_file(thiz, &sys, fd, O_ACCMODE|O_APPEND|O_TRUNC, O_RDONLY, filename);
    replace_code(thiz);
    if(vb>=2)fprintf(stderr," ->(%d) opening memory file \"%s\":\n",thiz->pid,filename);
    if(debug-- == 0){ debug_detach(thiz); exit(1); }
    if(!run_to(thiz,sys))goto cleanup;

    /* map new memory */
    char bbuf[1024*1024];
    sprintf(bbuf,"%s.maps",filename);
    f = fopen(bbuf,"r");
    fread(bbuf,1024*1024,1,f);
    fclose(f);
    buf = strtok(bbuf,"\n");
    long future_rip = 0;
    long future_rsp = 0;
    do
    {
        char buf2[512];
        long a,b,c;
        int retv = sscanf(buf,"%lx-%lx %4s %lx %*d:%*d %*d",&a,&b,buf2,&c);

        /* skip syscall */
        if(strlen(buf) <= 25 + sizeof(void*)*6 && strncmp(buf2,"---",3) == 0)
            continue;

        if(retv<3)
        {
            fprintf(stderr, "Skipping error map\n");
            continue;
        }

        ptrace(PTRACE_SETREGS, thiz->pid, 0, &(thiz->newreg));

        int prot = (buf2[0]=='r'?PROT_READ:0)|
                (buf2[1]=='w'?PROT_WRITE:0)|
                (buf2[2]=='x'?PROT_EXEC:0);
        int flags = MAP_FIXED|
                (buf2[3]=='s'?MAP_SHARED:MAP_PRIVATE);
        if(thiz->oldreg.rsp>= a && thiz->oldreg.rsp<b) /* stack? */
            flags |= MAP_GROWSDOWN;

        /* find a place to put future code for future changes */
        if(!future_rip && buf2[0]=='r' && buf2[2]=='x')
            future_rip = a;
        if(!future_rsp && buf2[0]=='r' && buf2[1]=='w')
            future_rsp = a;

        char *fmap = NULL;
        if(strlen(buf) > 25 + sizeof(void*)*6)
        {
            fmap = buf + 25 + sizeof(void*)*6;
            while(*fmap == ' ')fmap++;
        }

        /* anonymous? */
        if(fmap == NULL)
        {
            /* do mmap */
            ptrace(PTRACE_SETREGS, thiz->pid, 0, &(thiz->newreg));
            fillbuf_mmap(thiz, &sys, a, b-a, prot, flags|MAP_ANONYMOUS, -1, c);
            replace_code(thiz);
            if(vb>=2)fprintf(stderr," ->(%d)remapping %lx:\n",thiz->pid,a);
            if(debug-- == 0){ debug_detach(thiz); exit(1); }
            if(!run_to(thiz,sys))goto cleanup;
        }
        else
        {
            int fd2 = 998;

            /* open file to map */
            ptrace(PTRACE_SETREGS, thiz->pid, 0, &(thiz->newreg));
            fillbuf_open_file(thiz, &sys, fd2, O_ACCMODE|O_APPEND|O_TRUNC,
                    (buf2[1]=='w' && buf2[3]=='s')?O_RDWR:O_RDONLY, fmap);
            replace_code(thiz);
            if(vb>=2)fprintf(stderr," ->(%d) opening file \"%s\":\n", thiz->pid, fmap);
            if(debug-- == 0){ debug_detach(thiz); exit(1); }
            if(!run_to(thiz,sys))goto cleanup;

            /* do mmap */
            ptrace(PTRACE_SETREGS, thiz->pid, 0, &(thiz->newreg));
            fillbuf_mmap(thiz, &sys, a, b-a, prot, flags, fd2, c);
            replace_code(thiz);
            if(vb>=2)fprintf(stderr," ->(%d)remapping %lx:\n",thiz->pid,a);
            if(debug-- == 0){ debug_detach(thiz); exit(1); }
            if(!run_to(thiz,sys))goto cleanup;

            ptrace(PTRACE_SETREGS, thiz->pid, 0, &(thiz->newreg));
            fillbuf_close(thiz, &sys, fd2);
            replace_code(thiz);
            if(vb>=2)fprintf(stderr," ->(%d) fd %d beeing closed:\n",thiz->pid,fd2);
            if(debug-- == 0){ debug_detach(thiz); exit(1); }
            if(!run_to(thiz,sys)) goto cleanup;

        }

        /* load memory from file */
        if(buf2[0]=='r' && buf2[1]=='w' && buf2[3]=='p')
        {
            ptrace(PTRACE_SETREGS, thiz->pid, 0, &(thiz->newreg));
            fillbuf_read(thiz, &sys, fd, a, b-a);
            replace_code(thiz);
            if(vb>=2)fprintf(stderr," ->(%d) restoring %lx-%lx:\n",thiz->pid,a,b);
            if(debug-- == 0){ debug_detach(thiz); exit(1); }
            if(!run_to(thiz,sys))goto cleanup;
        }
    }
    while( (buf=strtok(NULL,"\n")) );

    /* close memfd */
    ptrace(PTRACE_SETREGS, thiz->pid, 0, &(thiz->newreg));
    fillbuf_close(thiz, &sys, fd);
    replace_code(thiz);
    if(vb>=2)fprintf(stderr," ->(%d) fd %d beeing closed:\n",thiz->pid,fd);
    if(debug-- == 0){ debug_detach(thiz); exit(1); }
    if(!run_to(thiz,sys)) goto cleanup;

    thiz->newreg.rip = future_rip;
    thiz->newreg.rsp = future_rsp;

    /* save old code */
    int i;
    for(i=0;i<4096;i+=sizeof(long))
    {
        *(long*)(thiz->oldbuf+i) = ptrace(PTRACE_PEEKTEXT,
                    thiz->pid, ((char*)thiz->newreg.rip)+i, 0);
        *(long*)(thiz->oldstack+i) = ptrace(PTRACE_PEEKTEXT,
                    thiz->pid, ((char*)thiz->newreg.rsp)+i, 0);
    }

    /* cleanup */
    ptrace(PTRACE_SETREGS, thiz->pid, 0, &(thiz->newreg));
    fillbuf_munmap(thiz, &sys, myaddr, 4096*2);
    replace_code(thiz);
    if(vb>=2)fprintf(stderr," ->(%d)unmapping %lx:\n",thiz->pid, myaddr);
    if(debug-- == 0){ debug_detach(thiz); exit(1); }
    if(!run_to(thiz,sys))goto cleanup;
    
    /* hola!, set new regs! */
    ptrace(PTRACE_SETREGS, thiz->pid, 0, &(thiz->oldreg));
    
    ptrace(PTRACE_GETREGS, thiz->pid, 0, &(thiz->oldreg));
    fprintf(stderr,"EFLAGS=%lx\n", thiz->oldreg.eflags );
    
    if(debug-- == 0){ debug_detach(thiz); exit(1); }
    if(vb>=1)fprintf(stderr,"Everythig seems to be all right.\n");
                retv = 1;

cleanup:
        return retv;
}

void usage()
{
    printf(
        "Usage: fdmess [options] [pid] [commands]\n"
        "    this program redirects file descriptors or tweaks a running process.\n"
        "    The fd can be redirected to a file, a socket or a file descriptor of an\n"
        "    other process. The syntax is somewhat bash-like.\n"
        "\n"
        "Options:\n"
        "    -v --verbose <level>    : verbosity level (0-3, default 1)\n"
        "    -d --debug <x>          : execute <x> hooks and then leave all programs\n"
        "                              in stopped state, so that you can debug them.\n"
        "    -s --stopped            : restore original code, but leave detached\n"
        "                              programs in stopped state, so that you can\n"
        "                              debug them.\n"
        "    -h --help               : print this help\n"
        "\n"
        "Commands:\n"
        "    \"{fd}>&-\"               : close fd (be very careful!)\n"
        "    \"{fd}>&{fd2}\"           : fd will be a copy of fd2\n"
        "    \"{fd}:={pid2}:{fd2}\"    : set fd to the same as fd2 of pid2\n"
        "                              (the file descriptor is passed)\n"
        "    \"{fd}=={pid2}:{fd2}\"    : make a unix socket connection of fd and fd2.\n"
        "                              This is very different from := since what is\n"
        "                              written in fd will go to fd2 and viceversa.\n"
        "    \"{fd}@={server}:{port}\" : send via tcp to server at port\n"
        "    \"{fd}>*{filename}\"      : open file truncating\n"
        "    \"{fd}>>{filename}\"      : open file in append mode\n"
        "    \"{fd}<>{filename}\"      : open file for reading and writing\n"
        "    \"{fd}<<{filename}\"      : open file for reading only\n"
        "    \"chdir={dirname}\"       : change current directory\n"
        "    \"sigign={sig}\"          : ignore signal\n"
        "    \"sigdfl={sig}\"          : set signal to default\n"
        "    \"setuid={uid}\"          : set userid\n"
        "    \"setgid={gid}\"          : set groupid\n"
        "\n"
        "    WARNING: use at your own risk, it is VERY likely that the process\n"
        "    crashes or data are lost. If you decide to use it, remember that\n"
        "    signals may be lost, that if a file opened readonly is passed and the\n"
        "    second program tryies to write in the file it will very likely crash,\n"
        "    the same if you replace a device with a non-device or a socket with a\n"
        "    non-socket; that for a socket the file state could not be exactly the\n"
        "    same and that you cannot change fd's of a running 32bits process with\n"
        "    the 64bits compiled version of this program on an x86_64 machine.\n"
        "    JUST SIMPLY NEVER USE THIS PROGRAM ON EVEN REMOTELY IMPORTANT APPS.\n"
        "    Have fun!\n"
        "\n"
        "   AUTHOR: Maurizio Monge <monge@sns.it>, licence is GPL\n"
        "\n"
    );
}

/*
    Todo:
    chroot, rlimit, umask
    1) Put the architecture dependent part in a separate file
        and give decent names to fillbufx
    2) Write a nice frontend for this program with Gtk or Qt :-)
        How trash would it be? a nice and easy-to-use interface for
        one of the most hackish and dirty programs ever written!
*/
int main(int argc, char *argv[])
{
    int pid,i = 1;
    int a1,a2,a3;
    char fl[1025];

    if(argc <= 2){ usage(); return 0; }

    while(1)
    {
        if(!strcmp(argv[i],"--verbose") || !strcmp(argv[i],"-v"))
        {
            i++;
            vb = atoi(argv[i]);
        }
        else if(!strcmp(argv[i],"--stopped") || !strcmp(argv[i],"-s"))
            stopped = 1;
        else if(!strcmp(argv[i],"--debug") || !strcmp(argv[i],"-d"))
        {
            i++;
            debug = atoi(argv[i]);
        }
        else if(!strcmp(argv[i],"--help") || !strcmp(argv[i],"-h"))
        {
            usage();
            return 0;
        }
        else
            break;
        i++;
    }

    pid = atoi(argv[i]);
    thiz = attach(pid);
    if(!thiz)
        return 1;

    i++;
    for(;i<argc;i++)
    {
        int retv = 0;
        ptrace(PTRACE_SETREGS, thiz->pid, 0, &(thiz->newreg));

        if(sscanf(argv[i],"%d>&%d",&a1,&a2)==2)
            retv = fd_to_fd(a1,a2);
        else if(sscanf(argv[i],"%d:=%d:%d",&a1,&a2,&a3)==3)
        {
            if(pid != a2)
                retv = copy_fd(a1,a2,a3);
            else
                retv = fd_to_fd(a1,a3);
        }
        else if(sscanf(argv[i],"%d==%d:%d",&a1,&a2,&a3)==3)
            retv = connect_fds(a1,a2,a3);
        else if(sscanf(argv[i],"%d@=%1024[^:]:%d",&a1,fl,&a2)==3)
            retv = connect_fd(a1,fl,a2);
        else if(sscanf(argv[i],"%d>*%1024s",&a1,fl)==2)
            retv = fd_to_file(a1,fl,0,O_TRUNC);
        else if(sscanf(argv[i],"%d>>%1024s",&a1,fl)==2)
            retv = fd_to_file(a1,fl,0,O_APPEND);
        else if(sscanf(argv[i],"%d<>%1024s",&a1,fl)==2)
            retv = fd_to_file(a1,fl,0,0);
        else if(sscanf(argv[i],"%d<<%1024s",&a1,fl)==2)
            retv = fd_to_file(a1,fl,O_ACCMODE,0);
        else if(sscanf(argv[i],"%d>&%16s",&a1,fl)==2 && !strcmp(fl,"-"))
            retv = close_fd(a1);
        else if(sscanf(argv[i],"sigign=%d",&a1)==1)
            retv = set_signal(a1,1);
        else if(sscanf(argv[i],"sigdfl=%d",&a1)==1)
            retv = set_signal(a1,0);
        else if(sscanf(argv[i],"setuid=%d",&a1)==1)
            retv = set_uid(a1);
        else if(sscanf(argv[i],"setgid=%d",&a1)==1)
            retv = set_gid(a1);
        else if(sscanf(argv[i],"chdir=%1024s",fl)==1)
            retv = change_dir(fl);
        else if(sscanf(argv[i],"dump=%1024s",fl)==1)
            retv = dump_mem(fl);
        else if(sscanf(argv[i],"restore=%1024s",fl)==1)
            retv = restore_mem(fl);
        else
            fprintf( stderr, "ERROR: Could not understand arg %d \"%s\"\n", i, argv[i]);

        if(!retv)
        {
            fprintf( stderr, "Exiting because of errors...\n");
            break;
        }
    }

    hook_info *tmp = stoppedpr;
    while(tmp)
    {
        detach( tmp );
        tmp = tmp->next;
    }

    return 0;
}
