.c $Id: fim.man 48 2007-06-13 10:36:24Z dezperado $
.TH fim 1 "(c) 2006-2007 dezperado"
.SH NAME
fim - \fBf\fPbi (linux \fBf\fPrame\fBb\fPuffer \fBi\fPmageviewer) \fBim\fPproved
.SH SYNOPSIS
.B fim [ options ] [--] file ...
.SH DESCRIPTION
.B fim
displays the specified file(s) on the linux console using the
framebuffer device.  jpeg, ppm, gif, tiff, xwd, bmp and png
are supported directly.  For other formats fim tries to use
ImageMagick's convert.

Please note that the full documentation of
.B fim
is in the FIM.TXT file distributed in the source package.
.SH OPTIONS
.TP
.B -h
print usage info
.TP
.B -d device
framebuffer device to use.  Default is the one your vc is
mapped to.
.TP
.B -m mode
name of the video mode to use video mode (must be listed in
/etc/fb.modes).  Default is not to change the video mode.
.c .TP
.c .B -q
.c be quiet: don't print anything.
.TP
.B -h
display help and terminate the program
.TP
.B -V
display version and terminate the program
.TP
.B -v
be verbose: show status bar.
.TP
.B -P
Enable textreading mode.  This has the effect that fim will display
images scaled to the width of the screen, and aligned to the top.
Useful if the images you are watching text pages, all you have to do
to get the next piece of text is to press space (in the default
key configuration, of course).
.c .TP
.c .B -t sec
.c timeout: load next image after >sec< seconds without any keypress
.c .TP
.c .B -g gamma
.c gamma correction.  Can also be put into the FBGAMMA environment
.c variable.  Default is 1.0.  Requires Pseudocolor or Directcolor
.c visual, doesn't work for Truecolor.
.c .TP
.c .B -r n
.c select resolution.  PhotoCD only, n = 1..5.
.TP
.B -s {n}
set scroll steps in pixels (default is 50).
.TP
.B -c {commands}
The \fBcommands\fP string will be executed before entering the interactive loop.
Please note that if your commands are more complicated than a simple 'next' or 'pornview'
command, they must be quoted and escaped in a manner suitable for your shell!!

For example,
-c '*2;2pan_up;display;while(1){bottom_align;sleep "1" ; top_align}'

(with the single quotes) will tell fim to first double the displayed image 
size, then pan two times up, then display the image ; and then 
do an endless loop consisting of bottom and top aligning, alternated.
.TP
.B -F {commands}
The \fBcommands\fP string will be executed after exiting the interactive loop
of the program (right before terminating the program).
.TP
.B -E {scriptfile}
The \fBscriptfile\fP will be executed right after the default initialization file is executed.
.TP
.B -N
No initialization file will be read (default is ~/.fimrc) at startup.
.c .TP
.c .B -f font
.c Set font.  This can be either a pcf console font file or a X11 font
.c spec.  Using X11 fonts requires a font server (The one specified in
.c the environment variable FONTSERVER or on localhost).  The FBFONT
.c environment variable is used as default.  If unset, fim will
.c fallback to 10x20 (X11) / lat1u-16.psf (console).
.TP
.B -a
Enable autozoom.  fim will automagically pick a reasonable zoom factor
when loading a new image.
.TP
.B -
Reads file list from stdin.

So, you can use fim in such a fashion:
$ find /mnt/media/ -name *.jpg | fim -
.TP
.B --autoup
Like autozoom, but scale up only.
.TP
.B --autodown
Like autozoom, but scale down only.
.c .TP
.c .B -u
.c Randomize the order of the filenames.
.c .TP
.c .B -e
.c Enable editing commands.
.c .TP
.c .B -b
.c create backup files (when editing images).
.c .TP
.c .B -p
.c preserve timestamps (when editing images).
.c .TP
.B --comments
.c Display comment tags (if present) instead of the filename.  Probaby
.c only useful if you added reasonable comments yourself (using wrjpgcom
.c for example), otherwise you likely just find texts pointing to the
.c software which created the image.
.SH COMMON KEYS
.nf
cursor keys     scroll large images
h,j,k,l		scroll large images left,down,up,right
+, -            zoom in/out
ESC, Q          quit
PgUp,p            previous image
PgDn,n, Space     next image
Return          next image, write the filename of the current
                image to stdout on exit from the program.
m		mirror
f		flip
r		rotate by 90  degrees
d,x,D.X		diagonal scroll
C-w		scale to the screen width
C-h		scale to the screen heigth
m		mark the current file for printing its name when terminating fim

.c P               pause the slideshow (if started with -t, toggle)
.c {number}g    jump to image {number}
:{number}       jump to {number}^th image in the list
:*{factor}      scale the image by {factor}
:{scale}%       scale the image to the desired {scale}
.fi
.P
The Return vs. Space key thing can be used to create a file list while
reviewing the images and use the list for batch processing later on.

All of the key bindings are reconfigurable; please see the default 
.B fimrc
file for examples on this, or read the complete manual: the FIM.TXT file
distributed with fim.
.c .SH EDIT IMAGE
.c fim also provides some very basic image editing facilities.  You have
.c to start fim with the -e switch to use them.
.c .P
.c .nf
.c Shift+D         delete image
.c R               rotate 90 clockwise
.c L               rotate 90 counter-clock wise
.c .fi
.c .P
.c The delete function actually wants a capital letter 'D', thus you have
.c to type Shift+D.  This is done to avoid deleting images by mistake
.c because there are no safety bells:  If you ask fim to delete the image,
.c it will be deleted without questions asked.
.c .P
.c The rotate function actually works for JPEG images only because it
.c calls the jpegtran command to perform a lossless rotation if the image.
.c It is especially useful if you review the images of your digital
.c camera.
.SH COMMON PROBLEMS
.B fim
needs read-write access to the framebuffer devices (/dev/fbN or /dev/fb/N), i.e you (our
your admin) have to make sure fim can open the devices in rw mode.
The IMHO most elegant way is to use pam_console (see
/etc/security/console.perms) to chown the devices to the user logged
in on the console.  Another way is to create some group, chown the
special files to that group and put the users which are allowed to use
the framebuffer device into the group.  You can also make the special
files world writable, but be aware of the security implications this
has.  On a private box it might be fine to handle it this way
through.

If using udev, you can edit :
/etc/udev/permissions.d/50-udev.permissions
and set these lines like here :
 # fb devices
 fb:root:root:0600
 fb[0-9]*:root:root:0600
 fb/*:root:root:0600
.P

.B fim
also needs access to the linux console (i.e. /dev/ttyN) for sane
console switch handling.  That is obviously no problem for console
logins, but any kind of a pseudo tty (xterm, ssh, screen, ...) will
.B not
work.
.SH SEE ALSO
fimgs(1), fbset(1), convert(1), vim(1), fb.modes(8), fbset(8), fbgrab(1), fbdev(4)
.c , jpegtran(1)
.SH AUTHOR
dezperado <dezperado _ GUESS _ autistici.org> is the author of fim, "fbi improved".

Gerd Knorr <kraxel _ GUESS _ bytesex.org> is the original author of fbi, upon which this code is based.
.SH COPYRIGHT
Copyright (C) 2006-2007 dezperado <dezperado _ GUESS _ autistici.org>

Copyright (C) 1999-2000 Gerd Knorr <kraxel _ GUESS _ bytesex.org>
.P
This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2 of the License, or
(at your option) any later version.
.P
This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.
.P
You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
