#!/usr/bin/python
# -*- coding: cp1252 -*-
#
#Copyright 2005 MatthewWarren.
# Permission to copy is hereby granted so long as all actions taken
# remain within the terms specified by the GNU General Public License.
#
# This file is part of 'The FatController'
#
#    'The FatController' is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
#
#    'The FatController' is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with 'The FatController'; if not, write to the Free Software
#    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
#
#FatController
#v1f8r3a 14/09/05
fcversion="v1f8r3a"
#
#
# Version History
# 21/09/05  v1f8r3a Enhanced alerting mechanism.
#                   repackage new file structure. (migrate away from monlith)
#		    minor version string issue fixed
#
# 15/09/05  v1f8r2a packaging fixup
#
# 14/09/05  v1f8r1s Added ENTITYGROUP entity type
#      		    removed GUI code
#
# 28/05/05  v1f7r1a Bought under GNU public license.
#           DaemonManager class incorporated and code updated.
#
# 09/02/05  v1f6r1a Woo! up to version1 - the GUI.. or what there is of it!
#                   featureset still v6
#                   release 1 alpha
#
# 08/02/05  v0f6r2a fixed load IOErrors
# 08/02/05  v0f6r1a Switched Versioning Scheme to
#                   version()featureset()release()a/b/-
#                   Added new entity LOCAL, execs local cmds
#
# 02/02/05  v0.1.5a Added new options;
#                       FATCONTROLLER   VERBOSE yes/no
#                       TSM             DATAONLY yes/no
#                       FATCONTROLLER   DEVELOPER yes/no
#                       FATCONTROLLER   DEVELOPERPATH {path}
#
# 28/01/05  v0.1.4a Added scripting capability commands
#                       addline
#                       insline
#                       delline
#                       run
#
#v0.1.3a   	Collectors now write data to file if filename!=none
#	   	collectors work with un-rooted filenames. IE; 
#			a filename will have /opt/yab/FatController/data/ or c:\ 
#			pre-pended to them depending on the type of system being used.
#	   	schedules are now shown in local-times rather than seconds-since-the-epoch. 
#	   	now+x notation now works for schedule start and end times.
#	   	Updated manual with entity reference.
#
#v0.1.2a	Now it really does work under unix!
#		fixed #dbg() TRACE bug.
#		fixed shell escaping issues. escaped substitutions will have 
#		the \s removed when executing from non-posix 
#		environment.
#
#v0.1.1	a	Now runs under unix and windows!
#		installers for unix and windows included!
#
#v0.1.0	a	Implementation of daemon framework
#
#v0.0.1a  v0.0.9a
#		Base implementation. (CLI / ENTITES / Commands)
#M.Warren
#
###########

__version__ = fcversion
import os,sys,telnetlib,re,shutil,time,threading,pprint
import FC_entity,FC_daemonschedule,FC_daemontask,FC_daemon,FC_ScheduledTask,FC_ScheduledTaskHandler,FC_ThreadedScheduler,FC_entitymanager,FC_daemonmanager
import FC_ENTITYGROUP,FC_LOCAL,FC_DUMB,FC_TSM,FC_TELNET

###########
#

def dbg(Msg,Fn,execclass=None):
    try:
	if (TRACE[Fn] or TRACE["ALL"]):
	    print 'DBG:'+Fn+': '+Msg
    except KeyError: 
	pass
#
#
###########

###########
# START OF FatController FUNCTIONS
#

def cmdreport(msg):
    if Opts.has_key('VERBOSE') and Opts['VERBOSE']=='yes':
	print msg
	print

def showalertqueue():
    print '\nCurrent alerts:-'
    generatedalerts=DaemonManager.getOutstandingAlerts()

    ctr=0
    for alert in generatedalerts:
	print str(ctr)+' : '+alert
	ctr=ctr+1
    print
    print
    
def showactivedaemons():
    print '\nCurrently active daemons:-'
    print
    for active in DaemonManager.getactivedaemons():
	print 'Daemon '+active
    print
    print
    
def showdaemons():
    outlines=DaemonManager.getprettydaemons()
    print '\nCurrently defined daemons/tasks/schedules and associated entities:-'
    for line in outlines:
        print line
    print
    #print
	     
def createdaemon(name):
    DaemonManager.addDaemon(name)
    print '\nDaemon\n\t'+name+'\nDefined.\n\n'
def removedaemon(name):
    DaemonManager.deleteDaemon(name)
    cmdreport('\Daemon\n\t'+name+'\nDeleted.')

def scheduledaemon(name,begin,end,period):
    DaemonManager.setdaemonschedule(name,begin,end,period)
    cmdreport('\nSchedule for daemon '+name+'\n\tBegin='+begin+' end='+end+' period='+period+'\nSet.')
	
def adddaemontask(daemonname,taskname,command):
    DaemonManager.addTask(daemonname,taskname,command)
    cmdreport('\nTask '+taskname+' for daemon '+daemonname+'\n\t'+' '.join(command)+'\nDefined.')

def removedaemontask(daemonname,taskname):
    DaemonManager.deleteTask(daemonname,taskname)
    cmdreport('\nDaemon '+daemonname+'\n\tTask '+taskname+'\nDeleted.')

def adddaemontaskcollector(daemonname,taskname,collectorname,tag,skip,format,file):
    DaemonManager.addCollector(daemonname,taskname,collectorname,tag,skip,format,file)
    cmdreport('\nCollector '+collectorname+' for task '+taskname+' owned by daemon '+daemonname+'\n\tDatatag '+tag+' Skip '+skip+' Format '+format+' File '+file+'\nDefined.')

def removedaemontaskcollector(daemonname,taskname,collectorname):
    DaemonManager.deleteCollector(daemonname,taskname,collectorname)
    cmdreport('\nDaemon '+daemonname+' task '+taskname+'\n\tCollector '+collectorname+'\nDeleted.')

def adddaemontaskentity(daemonname,taskname,entityname):
    DaemonManager.subscribeEntity(daemonname,taskname,entityname)
    cmdreport('\nDaemon '+daemonname+' task '+taskname+'\n\tEntity '+entityname+'\nSubscribed.')

def removedaemontaskentity(daemonname,taskname,entityname):
    DaemonManager.unsubscribeEntity(daemonname,taskname,entityname)
    cmdreport('Daemon '+daemonname+' task '+taskname+'\n\tEntity '+entityname+'\nDeleted.')

def adddaemontaskcollectoralert(daemonname,taskname,collectorname,minval,maxval,textmessage):
    DaemonManager.addAlert(daemonname,taskname,collectorname,minval,maxval,textmessage)
    cmdreport('\nDaemon '+daemonname+' task '+taskname+' collector '+collectorname+'\n\t Alert '+str(minval)+' '+str(maxval)+' '+textmessage+'\nDefined.')

def makedaemonlive(daemonname):
    DBGBN='FCmakedaemonlive'
    #dbg('Making daemon live.',DBGBN)
    #be carefull with the task naming here... what about removing from the middle of the list? will it pop() the same?
    #...and dont confuse scheduer tasks with daemon tasks...
    DaemonManager.makeLive(daemonname)
    cmdreport('\nDaemon\n\t'+daemonname+'\nActivated.')

def updatedaemontask(daemonname,taskname,command):
    DaemonManager.updateTask(daemonname,taskname,command)
    cmdreport('\nTask\n\t'+taskname+'\nUpdated.')

def killdaemon(daemonname):
    DBGBN='FCkilldaemon'
    DaemonManager.killDaemon(daemonname)
    cmdreport('\nDaemon\n\t'+daemonname+'\nDeactivated.')

def IsDaemon(daemonname):
    return DaemonManager.isDaemon(daemonname)

def getaliasdefines(AliasDict):
    DefinitionList=[]
    for a in AliasDict:
	DefinitionList.append('alias '+a+' '+' '.join(AliasDict[a]))
    return DefinitionList

def getsubstitutedefines(SubstituteDict):
    DefinitionList=[]
    for s in SubstituteDict:
	DefinitionList.append('substitute '+s+' '+' '.join(Substitutions[s]))
    return DefinitionList

def savelistaslineswithcr(Filename,AList,clobber=0):
    if clobber:
	SaveToFile=file(Filename,'w')
    else:
	SaveToFile=file(Filename,'a')
    for Line in AList:
	SaveToFile.write(Line+'\n')
    SaveToFile.close()

def savedata(pathandname):
    #save entities, then aliases, then options
    DBGBN='savedata'
    EntityDefinitionList=EntityManager.getdefines()
    AliasDefinitionList=getaliasdefines(Aliases)
    SubstituteDefinitionList=getsubstitutedefines(Substitutions)
    classoptionlists=EntityManager.getclassoptiondefines()
    #dbg('classoptionlists is '+str(len(classoptionlists))+' elements',DBGBN)
    fatcontrolleroptionlist=getfatcontrolleroptiondefines()
    scriptdefinitions=getscriptdefines()
    #
    #This block saves daemons and activestates #############################
    daemondefines=DaemonManager.getdaemondefines() #FC function returns list
    scheduledefines=DaemonManager.getscheduledefines() #FC function returns a list
    taskdefines=DaemonManager.gettaskdefines() # FC function returns a list
    collectordefines=DaemonManager.getcollectordefines() #
    alertdefines=DaemonManager.getalertdefines()
    subscriptiondefines=DaemonManager.getsubscriberdefines() # FC function returns a list
    activates=DaemonManager.getactivatedefines() # FC Function returns a list
    ########################################################################
    #
    savelistaslineswithcr(pathandname,EntityDefinitionList,1)
    savelistaslineswithcr(pathandname,AliasDefinitionList,0)
    savelistaslineswithcr(pathandname,SubstituteDefinitionList,0)
    for optlist in classoptionlists:
	savelistaslineswithcr(pathandname,optlist,0)
    savelistaslineswithcr(pathandname,fatcontrolleroptionlist)
    savelistaslineswithcr(pathandname,daemondefines,0)
    savelistaslineswithcr(pathandname,scheduledefines,0)
    savelistaslineswithcr(pathandname,taskdefines,0)
    savelistaslineswithcr(pathandname,collectordefines,0)
    savelistaslineswithcr(pathandname,alertdefines,0)
    savelistaslineswithcr(pathandname,subscriptiondefines,0)
    savelistaslineswithcr(pathandname,scriptdefinitions,0)
    savelistaslineswithcr(pathandname,activates,0)

    
def save(WhatToSave,ProfileName):
    DBGBN='FCsave'
    if WhatToSave=='all':
	#DEVELOPR TOOLS MAKES THE SAVES INTO THE INSTALL PACKAGE
	# set FATCONTROLLER DEVELOPER yes
	# set FATCONTROLLER DEVELOPERPATH .....
	if Opts.has_key('DEVELOPER') and Opts['DEVELOPER']=='yes':
	    pathandname=Opts['DEVELOPERPATH']+ProfileName+'.sav'
	    savedata(pathandname)
	    pathandname=installroot+ProfileName+'.sav'
            #dbg('FATCONTROLLER DEVELOPER is yes. Doing save to DEVELOPERPATH',DBGBN)
            #dbg('-pathandname is '+pathandname,DBGBN)
	    savedata(pathandname)
	else:
	    pathandname=installroot+ProfileName+'.sav'
	    #dbg('doing straight save. pathandname is '+pathandname,DBGBN)
	    savedata(pathandname)
	#
    else:
	print 'Error: Don\'t know how to save '+WhatToSave  +'.'
    cmdreport('\nSaved\n\t'+WhatToSave+'\nSuccesfully.')

def definealias(Name,List):
    Aliases[Name]=List
    cmdreport('\nAlias:\n\t'+Name+' '+' '.join(List)+'\nDefined.')

def showaliases():
    print ''
    for a in Aliases:
	print a,'\t',' '.join(Aliases[a])
    print ''

def delalias(AliasName):
    del Aliases[AliasName]
    cmdreport('\nAlias\n\t'+AliasName+'\nDeleted.')

def isalias(Name):
    try:
	Aliases[Name]
	return 1
    except KeyError:
	return 0

def inserttoscript(scriptname,linenumber,cmdtokens):
    linenumber=int(linenumber)
    cmdlist=Scripts[scriptname]
    lowerlist=cmdlist[:linenumber]
    lowerlist.append(' '.join(cmdtokens))
    for ul in cmdlist[linenumber:]:
	lowerlist.append(ul)
    Scripts[scriptname]=lowerlist
    return 0

def delfromscript(scriptname,linenumber):
    print "NOT IMPLEMENTED"
    return 0

def appendtoscript(scriptname,cmdtokens):
    cmdstring=' '.join(cmdtokens)
    if scriptname not in Scripts:
	Scripts[scriptname]=[]
	Scripts[scriptname].append(cmdstring)
    else:
	Scripts[scriptname].append(cmdstring)
    cmdreport('\nLine\n\t'+cmdstring+'\nAppended.')

def delscript(scriptname):
    if isScript(scriptname):
	del Scripts[scriptname]
	cmdreport('\nScript\n\t'+scriptname+'\nDeleted.')
    else:
	cmdreport('\nINFO:\tCould not find script '+scriptname+'\n')

def runscript(scriptname,parmlist):
    num=1
    for parmsub in parmlist:
	processcommand('sub '+str(num)+' '+parmsub)
	num=num+1
    cmdlist=Scripts[scriptname]
    for cmd in cmdlist:
	processcommand(cmd)
    num=1
    for parmsub in parmlist:
	processcommand('del sub '+str(num))
	num=num+1


def isScript(scriptname):
	if scriptname not in Scripts:
	    return 0
	else:
	    return 1

def showscripts(scriptname):
    DBGBN='showscripts'
    if scriptname=='all':
	scriptlist=Scripts.keys()
    else:
	scriptlist=[scriptname]
    #for script in scriptlist:
	#dbg('script '+script+' is in scriptlist to display',DBGBN)
    for script in scriptlist:
	print '\n\t'+script+'\n'
	ctr=1
	for cmds in Scripts[script]:
	    print str(ctr)+' : '+cmds
	    ctr=ctr+1
	print '\n'

def getscriptdefines():
    definelist=[]
    for scriptname in Scripts:
	for scriptline in Scripts[scriptname]:
	    definelist.append('addline '+scriptname+' '+scriptline)
    return definelist

def message(msg):
    print ' '.join(msg)
	    

def definesubstitution(SubName,SubList):
    Substitutions[SubName]=SubList
    cmdreport('\nSubstitution\n\t'+SubName+'\nDefined.')

def delsubstitution(SubName):
    del Substitutions[SubName]
    cmdreport('\nSubstitution\n\t'+SubName+'\nDeleted.')

def showsubstitutions():
    print ''
    for s in Substitutions:
	if len(s)<8:
	    tabs='\t\t'
	else:
	    tabs='\t'
	print s+tabs+' '.join(Substitutions[s])
    print

def issubstitute(SubName):
    try:
	Substitutions[SubName]
	return 1
    except KeyError:
	return 0
	
def processsubstitutions(RawCmd):
    DBGBN='processsubstitutions'
    infprotect=1
    subhit=1
    while subhit==1:
	subhit=0
	for sub in Substitutions:
	    SubCheck=RawCmd
	    RawCmd=re.sub('~'+sub,' '.join(Substitutions[sub]),RawCmd)
	    if SubCheck!=RawCmd:
		#dbg('Made Substitution '+sub+' to get '+RawCmd,DBGBN)
		subhit=1
	infprotect=infprotect+1
	if infprotect>100:
	    return "ERROR: Infinitely deep substitution levels detected."
    return RawCmd

def displayhelp():
    helpfile=file(installroot+'FatController.hlp','r')
    for lines in helpfile:
	print lines#.strip()
    print '\n\nDefined Entities:-' 
    processcommand('show entities')
    print '\nAliases:-'
    processcommand('show aliases')
    print '\nSubstitutions:-'
    processcommand('show substitutions')
    processcommand('show options')
    processcommand('show daemons')
    processcommand('show active daemons')
    processcommand('show scripts')

def displayopts():
    print '\nCurrent Set Options:-\n'
    EntityManager.displayclassoptions()
    fcopts=getfatcontrolleroptiondefines()
    for d in fcopts:
	dl=d.split()
	d=' '.join(dl[1:])
	print d # twiddle becasue need to remove the set

def toggletrace(Fn):
    try:
	if TRACE[Fn]:
	    TRACE[Fn]=0
	    cmdreport('\nStop tracing block '+Fn+'\n')
	else:
	    TRACE[Fn]=1
	    cmdreport('\nStart tracing block '+Fn+'\n')
    except KeyError:
	TRACE[Fn]=1
	cmdreport('\nStart tracing block '+Fn+'\n')


def SetOption(EntityClass,Opt,Val):
    if EntityClass=='FATCONTROLLER':
	#dbg('Trapped OK',DBGBN)
	Opts[Opt]=Val
    else:
	EntityManager.SetClassOption(EntityClass,Opt,Val)
	cmdreport('\nOption\n\t'+EntityClass+' '+Opt+' '+Val+'\nHas been set.')

def getfatcontrolleroptiondefines():
    optlist=[]
    for opt in Opts:
	optlist.append('set FATCONTROLLER '+opt+' '+Opts[opt])
    return optlist


def processcommand(Command): #CODE PROBABLY NOT SAFE. USES EVAL()
    DBGBN='processcommand'
    dbg('Before Substitution: '+Command,DBGBN)
    Command=processsubstitutions(Command)  #  if ! aliascmd then flow is,  RawCmd->subbed->executed
			    # is IS aliascmd then flow is   RawCmd->Subbed->aliashit->subbed->executed
    dbg('After Substitution: '+Command,DBGBN)
    AliasHit=0
    CommandHit=0
    SplitCmd=Command.split()
    SplitLen=len(SplitCmd)
    Cmd=SplitCmd[0]
    InEtcRun=0
    Error=0
    CommandDefs=file(installroot+'FatControllerCommands.sav','r')
    for Def in CommandDefs:
	dbg("Scanning cdef ::"+Def,DBGBN)
	if Def!='ENDCOMMANDDEFS':
	    DefTokens=Def.split()
	    ctr=0
	    for Token in DefTokens:
		dbg("Doing token "+Token,DBGBN)
		if re.search('input:',Token):
		    if SplitLen>ctr:
			dbg("Is an input tag. ValExp=",DBGBN)
			ValidateExpression=Token.replace('input:','').replace('<<',SplitCmd[ctr]).replace('::SPACE::',' ')
			dbg(ValidateExpression,DBGBN)
		    else:
			Error=1
			ErrorText='Error: Missing parameter.'
			break
		    if not eval(ValidateExpression):##NOT SAFE NOT SAFE. Need to come up with entirely new
                                                    ##way to do all this
			Error=1
			ErrorText='Error: Parameter incorrect.'
			break
		elif re.search('create:',Token):
		    CreateExpression=Token.replace('create:','').replace('::SPACE::',' ')
		elif Token!='+*':
		    if ctr>=SplitLen:
			Error=1
			ErrorText='Error: Bad command.'
			break
		    if Token!=SplitCmd[ctr]:
			Error=1
			ErrorText='Error: Bad command.'
			break
		ctr+=1
		CommandHit=1
	    else: #{EndOf for Token} all tokens found for else
		eval(CreateExpression)
		break
    else:   #{EndOf for Def} Check aliases
	for AliasName in Aliases:
	    if Cmd==AliasName: #then, make cmdstring alias cmd string and re-process
		AliasCmd=' '.join(Aliases[AliasName])
		AliasHit=1
		dbg('Made alias hit to get '+AliasCmd,DBGBN)
		break
	else: #FOR loop else  not an alias, so try execute as last entity command
	    if not CommandHit:
		global LastExecutedEntity
		if LastExecutedEntity!='':
		    #global LastExecutedEntity
		    EntityManager.execute(LastExecutedEntity,SplitCmd[0:])
		else:
		    print '\nError: Dont know which entity to use.\n'
	    else:
		print '\nError: Bad command.\n'
	if AliasHit==1:
	    AliasHit=0
	    CommandDefs.close()
	    processcommand(AliasCmd)
    CommandDefs.close()
	    

def load(Profile):#will be load(profile)
    EntityManager=FC_entitymanager.entitymanager()
    Aliases={}
    try:
        FileToLoad=file(installroot+Profile+'.sav')
        for Line in FileToLoad:
            processcommand(Line)
    except IOError,(errno,strerror):
        print "\nError: ["+str(errno)+"] "+strerror+"\n\t"+installroot+Profile+".sav\n"
    #makeObjectBrowser()

def handlealertrange(fromalert,toalert):
	DaemonManager.handlealert(fromalert,toalert+1)
	




    
##################
# START OF __main__()
#
def main():        
    processcommand('load general')
    print startmessage 
    while 1:
	if len(AlertQueue)>0:
	    prompt='\nFC:*:'+LastExecutedEntity+'> '
	else:
	    prompt='\nFC:'+LastExecutedEntity+'> '
	UserCmd=raw_input(prompt)
	if UserCmd!='':
	    processcommand(UserCmd)
#
# END OF  __main__
###################

###########
# Some POSIX / winos setups
#
# Sets up disk 'root', point where all filenames
# for collector output etc.. are generated from.
# will make configurable option at some point...

if os.name=='posix':
    system='UNIX'
    installroot='/opt/yab/FatController/'
    copycmd='cp'
    driveroot=installroot
else:
    system='WINDOWS'
    installroot='c:\\program files\\yab\\FatController\\'
    copycmd='copy'
    driveroot='c:\\'
#
#
#####################

###############################################################################################################################################################################################################################################################################################################################
# START OF FATCONTROLLER GLOBALS
#
EntityManager=FC_entitymanager.entitymanager()
Aliases={}  #Dictionary of aliasname/command 
Substitutions={}
Scripts={}
TRACE={}
FCScheduler=FC_ThreadedScheduler.ThreadedScheduler()
FCScheduler.start()
DaemonManager=FC_daemonmanager.daemonmanager(EntityManager,FCScheduler)
AlertQueue={} # name:alerttext
Opts={}
LastExecutedEntity=''

startmessage='\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\
\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\
FatController '+fcversion+'\n'

GUIPaths={} #GUI paths plaintext->guipath
GUIObjects={} #GUIPath->object

#
# END OF FATCONTROLLER GLOBALS
###########################################################
###########################################################
#
#                           G O !!
#
###########################################################
###########################################################
main()
