import FC_LOCAL,FC_TSM,FC_TELNET,FC_DUMB,FC_ENTITYGROUP

###########
# START OF CLASS entitymanager
#

class entitymanager:

#
#Method functions
#
    def __init__(self):
	self.Entities={} #dict of entity objects

    def getentitytype(self,EntityName):
	return self.Entities[EntityName].getentitytype()
    
    def getentitylist(self):
        return self.Entities
    
    def getentityparms(self,EntityName):
	return self.Entities[EntityName].getparameterstring()

    def define(self,type,typeparms):                #TSMServer tpyeparms;  ['name','adminuser','adminpass']
	if type=='TSM':                 #becomes Entites{'name',['adminuser','adminpass']}
	    if len(typeparms)==6:
		EntityName=typeparms[0]
		self.Entities[EntityName]=FC_TSM.TSM(EntityName,typeparms[1],typeparms[2],typeparms[3],typeparms[4],typeparms[5]) # {'name',<TSM object>}
		print '\nEntity:'
		print '\tTSM:',self.Entities[EntityName].getname(),self.Entities[EntityName].getparameterstring()
		print 'Defined.\n'
	    else:
		print '\nError: Wrong number parameters for TSM entity.\n'
	elif type=='TELNET':
	    if len(typeparms)==5:
		EntityName=typeparms[0]
		self.Entities[EntityName]=FC_TELNET.TELNET(EntityName,typeparms[1],typeparms[2],typeparms[3],typeparms[4])
		print '\nEntity:'
		print '\tTELNET:'+' '+self.Entities[EntityName].getname()+' '+self.Entities[EntityName].getparameterstring()
		print 'Defined.\n'
	    else:
		print '\nError: Wrong number of parameters for TELNET entity.\n'
	elif type=='DUMB':
	    if len(typeparms)==1:
		EntityName=typeparms[0]
		self.Entities[EntityName]=FC_DUMB.DUMB(EntityName)
		print '\nEntity:'
		print '\tDUMB:'+self.Entities[EntityName].getname()
		print 'Defined\n'
	    else:
                print '\nError: Wrong number of parameters for DUMB entity.\n'
	elif type=='LOCAL':
            if len(typeparms)==1:
                EntityName=typeparms[0]
                self.Entities[EntityName]=FC_LOCAL.LOCAL(EntityName)
                print '\nEntity:'
		print '\tLOCAL:'+self.Entities[EntityName].getname()
		print 'Defined\n'
	    else:
                print '\nError: Wrong number of parameters for LOCAL entity.\n'
        elif type=='ENTITYGROUP':
            EntityName=typeparms[0]
            self.Entities[EntityName]=FC_ENTITYGROUP.ENTITYGROUP(EntityName,typeparms[1:],self)
            print '\nEntity:'
	    print '\tENTITYGROUP: '+self.Entities[EntityName].getname()+' '+self.Entities[EntityName].getparameterstring()
	    print 'Defined\n'
	else:
	    print '\nError: Don\'t know how to define '+type+' entities.\n'

    def execute(self,EntityName,CmdList):
	DBGBN='entitymanagerexecute'
	#executes CmdList depending on exec procedure for entitytype for named entity
	try:
	    EntityType=self.Entities[EntityName].getentitytype()
	    #dbg('entity type is '+EntityType,DBGBN)
	    output=self.Entities[EntityName].execute(CmdList) #list of output returned
	    global LastExecutedEntity
	    LastExecutedEntity=EntityName
	    self.Entities[EntityName].display(output)
	except KeyError:
	    print 'Error:  Don\'t know how to execute commands for '+EntityName+'.'

    def scheduledexecute(self,EntityName,CmdList):
	DBGBN='entitymanagerscheduledexecute'
	#dbg('entering...',DBGBN)
	try:
	    EntityType=self.Entities[EntityName].getentitytype()
	    output=self.Entities[EntityName].execute(CmdList) #list of output returned
	    #global LastExecutedEntity
	    #LastExecutedEntity=EntityName
	    return output
	except KeyError:
	    print 'Error:  Don\'t know how to execute commands for '+EntityName+'.'

    def display(self,EntityName,OutputList):
	self.Entities[EntityName].display(OutputList)

    def show(self):
	print ''
	for e in self.Entities:
	    print self.Entities[e].getentitytype(),'\t',e,'\t',self.Entities[e].getparameterstring()
	print ''

    def getdefines(self): #Returns a list of strings, each string returned is the define command for the entity
        DBGBN='entitymanagergetdefines'
	DefineList=[]
	#dbg('starting to loop through self.entities',DBGBN)
	for e in self.Entities:
            #dbg('doing entity '+self.Entities[e].getname(),DBGBN)
	    EntityType=self.Entities[e].getentitytype()
	    ParmList=self.Entities[e].getparameterstring()
	    DefineList.append('define entity '+EntityType+' '+e+' '+ParmList)
	#dbg('leaving entitymanagergetdefines',DBGBN)
	return DefineList

    def delete(self,EntityName):
	del self.Entities[EntityName]
	cmdreport('\nEntity\n\t'+EntityName+'\nDeleted.\n')

    def isEntity(self,EntityName):
	try:
	    self.Entities[EntityName]
	    return 1
	except KeyError:
	    return 0

    def getEntity(self,EntityName):
	return self.Entities[EntityName]

    def SetClassOption(self,EntityClass,option,value):
	DBGBN='entitymanagersetclassoption'
	#dbg('option '+option+' value '+value+' for entity class '+EntityClass,DBGBN)
	for e in self.Entities:
	    if self.Entities[e].getentitytype()==EntityClass: #CHANGED INCIDENTALLY FRMO gettype() WARNING!!!!!!!!!
		#dbg('setting option >|'+option+'|< to value >|'+value+'|< for entity class >|'+EntityClass+'|<',DBGBN)
		self.Entities[e].setoption(option,value)
		break #only do one
	    
    def getentitytypes(self):
        types=[]
        for e in self.Entities:
            etype=self.Entities[e].getentitytype()
            if etype not in types:
                types.append(etype)
        return types

    def displayclassoptions(self):
	doneclasses={}
	for e in self.Entities:
	    try:
		if doneclasses[self.Entities[e].getentitytype()]:
		    pass
	    except KeyError:
		doneclasses[self.Entities[e].getentitytype()]='done'
		for option in self.Entities[e].getoptions():
		    print self.Entities[e].getentitytype()+' '+option

    def getclassoptiondefines(self):
	DBGBN='entitymanagergetclassoptiondefines'
	doneclasses={}
	OptList=[]
	formattedlist=[]
	for e in self.Entities:
	    try:
		#dbg('Checking if have got classoptiondefines for entitytype '+self.Entities[e].getentitytype(),DBGBN)
		if doneclasses[self.Entities[e].getentitytype()]:
		    #dbg('key found in doneclasses, I Have!',DBGBN)
		    pass
	    except KeyError:
		#dbg('Havent got them for this entity type yet. Getting....',DBGBN)
		#dbg('setting doneclasses[self.Entities[e].getentitytype() {'+self.Entities[e].getentitytype()+'} to done',DBGBN)
		doneclasses[self.Entities[e].getentitytype()]='done'
		rawlist=self.Entities[e].getoptions()
		if len(rawlist)>0:
		    #dbg('formatting the rawlist options',DBGBN)
		    for l in rawlist:
			#dbg('l is '+l,DBGBN)
			#dbg('adding \'set '+self.Entities[e].getentitytype()+' '+l+'\'',DBGBN)
			formattedlist.append('set '+self.Entities[e].getentitytype()+' '+l)
		    #dbg('appending formatted list to optlist',DBGBN)
		    OptList.append(formattedlist)
		    formattedlist=[]
	return OptList # list of lists
	
	
#
# END OF CLASS entitymanager
###########
