#!/bin/python
# -*- coding: cp1252 -*-
#
#Copyright 2005 MatthewWarren.
# Permission to copy is hereby granted so long as all actions taken
# remain within the terms specified by the GNU General Public License.
#
# This file is part of 'The FatController'
#
#    'The FatController' is free software; you can redistribute it and/or modify
#    it under the terms of the GNU General Public License as published by
#    the Free Software Foundation; either version 2 of the License, or
#    (at your option) any later version.
#
#    'The FatController' is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#    GNU General Public License for more details.
#
#    You should have received a copy of the GNU General Public License
#    along with 'The FatController'; if not, write to the Free Software
#    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
#
#FatController
#v1f8r1a 14/09/05
#
#
# Version History
#
# 14/09/05  v1f8r1s Added ENTITYGROUP entity type
#
# 28/05/05  v1f7r1a Bought under GNU public license.
#           DaemonManager class incorporated and code updated.
#
# 09/02/05  v1f6r1a Woo! up to version1 - the GUI.. or what there is of it!
#                   featureset still v6
#                   release 1 alpha
#
# 08/02/05  v0f6r2a fixed load IOErrors
# 08/02/05  v0f6r1a Switched Versioning Scheme to
#                   version()featureset()release()a/b/-
#                   Added new entity LOCAL, execs local cmds
#
# 02/02/05  v0.1.5a Added new options;
#                       FATCONTROLLER   VERBOSE yes/no
#                       TSM             DATAONLY yes/no
#                       FATCONTROLLER   DEVELOPER yes/no
#                       FATCONTROLLER   DEVELOPERPATH {path}
#
# 28/01/05  v0.1.4a Added scripting capability commands
#                       addline
#                       insline
#                       delline
#                       run
#
# prior features added,  telnet,dumb,tsm entities. alerting, daemons & collecting.
#                           filewrites of historydata
#                           substitions and aliases. save / load. cmd execution.
#M.Warren
#
###########
__version__ = "v1f7r1a"
import os,utils,sys,telnetlib,re,shutil,time,threading,pprint
from Tkinter import *
import Tix
from Tkconstants import *

###########
#
# put debug up here at the top so everything else can use it

def dbg(Msg,Fn,execclass=None):
    try:
	if (TRACE[Fn] or TRACE["ALL"]):
	    print 'DBG:'+Fn+': '+Msg
    except KeyError: 
	pass
#
#
###########

###########
# START OF INTERFACE Entity
#

class entity:
    '''This is a dummy class intended for subclassing by entities.

	An entity is defined with class entitytype(entity):
	It must implement the following functions:-'''
    Opts={} #for holding settable entity options

    def execute(self,CmdList):
	'''Generic method.

	CmdList should be parsed and executed against the given entity (self).
	The return value should be a list of output elements readable by
	entity.display()'''    
	return # List of lines readable by display() method

    def getparameterdefs(self):
        '''Should return a list of parms for the GUI
        to build a config box, should be in same order as list and strings returned by
        getparameterstring/list '''
        return

    def display(self,LineList):
	'''Generic method for displaying output from entity.execute().

	This method should be implmented by the subclasser and translate
	the given LineList to human-readable output.'''
	return # print LineList, LineList is (minimally) output from execute() method

    def getname(self):
	'''Convenience method for getting entity name.

	should return a string representing the entity uniquely'''
	return # string that is entity name

    def getparameterstring(self):
	'''Method to determine how the entity was defined.

	Should return a string that can be prepended with \'def entity (entity) \' and
	fed to FatController.processcommand()
	that will re-define this entity in its entirety'''
	return

    def getparameterlist(self):
        '''returns a list of the value given as string by getparameterstring'''
        parmstring=self.getparameterstring()
        list=parmstring.split()
        return list

    def getentitytype(self):
	'''Get the type of entity.

	Should return qa string indicating the entities type (TELNET , TSM , BROCADE etc..)'''
	return

    def gettype(self):
	'''Return the kind of instance of a given entity.

	For example, TSM entities have an entitytype of 'TSM'
	but a type of single or configmanger. This should
	return a string indicating the kind of entity this is'''
	return

    def setoption(self,option,value):
	'''Set a global option.

	this method should take option and value pair and report on them
	as requried. (IE: TELNET.setoption(self,ShowRawTelnet,yes instructs
	the TELNET entities to begin displaying their raw telnet dialogues)'''
	return

    def getoptions(self):
	'''Get a list of set options.

	Should return a list of the format
	CLASS OPTION VALUE'''
	return

#
# END OF INTERFACE Entity
###########


###########
# START OF CLASS SCHEDULEDTASK
# ((subclassed by Daemon))
#
#
# ** Recognition to Tom Schwaller & the WebWare group for the base scheduling code **
# For more info on WebWare,
#
# [1] Webware: http://webware.sourceforge.net/ 
# [2] Ganymede: http://www.arlut.utexas.edu/gash2/
#
# For more info on the code snippets used here
#
# http://webware.sourceforge.net/Webware-0.7/TaskKit/Docs/QuickStart.html
#

class ScheduledTask(threading.Thread):

    def __init__(self):
	threading.Thread.__init__(self)
	''' Subclasses should invoke super for this method. '''
	# Nothing for now, but we might do something in the future.
	pass

    def run(self):
	'''
	Override this method for you own tasks. Long running tasks can periodically 
	use the proceed() method to check if a task should stop. 
	'''
	raise SubclassResponsibilityError
    
	
    ## Utility method ##    
    
    def proceed(self):
	"""
	Should this task continue running?
	Should be called periodically by long tasks to check if the system wants them to exit.
	Returns 1 if its OK to continue, 0 if its time to quit
	"""
	return self._handle._isRunning
	
	
    ## Attributes ##
    
    def handle(self):
	'''
	A task is scheduled by wrapping a handler around it. It knows
	everything about the scheduling (periodicity and the like).
	Under normal circumstances you should not need the handler,
	but if you want to write period modifying run() methods, 
	it is useful to have access to the handler. Use it with care.
	'''
	return self._handle

    def name(self):
	'''
	Returns the unique name under which the task was scheduled.
	'''
	return self._name


    ## Private method ##

    def _run(self, handle):
	'''
	This is the actual run method for the Task thread. It is a private method which
	should not be overriden.
	'''
	DBGBN='scheduledtask_run'
	dbg('Entering ...',DBGBN)
	self._name = handle.name()
	self._handle = handle
	dbg('handing over to self.run()',DBGBN)
	self.run()
	dbg('Now going to notify completion',DBGBN)
	handle.notifyCompletion()

#
# END OF CLASS SCHEDULEDTASK
###########
###########
# START OF CLASS SCHEDULEDTASKHANDLER
#

#from time import time, sleep
from threading import Event, Thread


class ScheduledTaskHandler:
    """
    While the Task class only knows what task to perform with the run()-method, 
    the TaskHandler has all the knowledge about the periodicity of the task.
    Instances of this class are managed by the Scheduler in the
    scheduled, running and onDemand dictionaries.
    """

    ## Init ##

    def __init__(self, scheduler, start, period, task, name):
	DBGBN='scheduledtaskhandler__init__'
	dbg('Entering... start is '+str(start)+' period '+str(period)+' task '+str(task)+' name '+str(name),DBGBN)
	self._scheduler = scheduler
	self._task = task
	self._name = name
	self._thread = None
	self._isRunning = 0
	self._suspend = 0
	self._lastTime = None
	self._startTime = start
	self._registerTime = time.time()
	self._reregister = 1
	self._rerun = 0
	self._period = abs(period)

    
    ## Scheduling ##
    
    def reset(self, start, period, task, reregister):
	self._startTime = start
	self._period = abs(period)
	self._task = task
	self._reregister = reregister

    def runTask(self):
	"""
	Runs this task in a background thread.
	"""
	if self._suspend:
	    self._scheduler.notifyCompletion(self)
	    return
	self._rerurn = 0
	self._thread = Thread(None, self._task._run, self.name(), (self,))
	self._isRunning = 1
	self._thread.start()

    def reschedule(self):
	"""
	Method to determine whether this task should be rescheduled. Increments the 
	startTime and returns 1 if this is a periodically executed task.
	"""
	if self._period == 0:
	    return 0
	else:
	    if self._lastTime - self._startTime > self._period:  #if the time taken to run the task exceeds the period
		self._startTime = self._lastTime + self._period
	    else:
		self._startTime = self._startTime + self._period
	    return 1

    def notifyCompletion(self):
	self._isRunning = 0
	self._lastTime =time.time()
	self._scheduler.notifyCompletion(self)
	
	
    ## Attributes ##
    
    def isRunning(self):
	return self._isRunning
    
    def runAgain(self):
	"""
	This method lets the Scheduler check to see whether this task should be 
	re-run when it terminates
	"""
	return self._rerun

    def isOnDemand(self):
	"""
	Returns 1 if this task is not scheduled for periodic execution.
	"""
	return self._period == 1

    def runOnCompletion(self):
	"""
	Method to request that this task be re-run after its current completion. 
	Intended for on-demand tasks that are requested by the Scheduler while 
	they are already running.
	"""
	self._rerun = 1

    def unregister(self):
	"""
	Method to request that this task not be kept after its current completion. 
	Used to remove a task from the scheduler
	"""
	self._reregister = 0
	self._rerun = 0

    def disable(self):
	"""
	Method to disable future invocations of this task.
	"""
	self._suspend = 1

    def enable(self):
	"""
	Method to enable future invocations of this task.
	"""
	self._suspend = 0

    def period(self):
	"""
	Returns the period of this task.
	"""
	return self._period

    def setPeriod(self, period):
	"""
	Mmethod to change the period for this task.
	"""
	self._period = period

    def stop(self):
	self._isRunning = 0

    def name(self):
	return self._name

    def startTime(self, newTime=None):
	if newTime:
	    self._startTime = newTime
	return self._startTime

#
# END OF CLASS SCHEDULEDTASKMANAGER
###########
###########
#CLASS THREADEDSCHEDULER
#


"""
This is the TaskManager python package.  It provides a system for running any number of
predefined tasks in separate threads in an organized and controlled manner.

A task in this package is a class derived from the Task class.  The task should have a run
method that, when called, performs some task.

The Scheduler class is the organizing object.  It manages the addition, execution, deletion,
and well being of a number of tasks.  Once you have created your task class, you call the Scheduler to
get it added to the tasks to be run.

"""



#from threading import Thread, Event
#from time import time, sleep
from exceptions import IOError

class ThreadedScheduler(Thread):
    """
    The top level class of the TaskManager system.  The Scheduler is a thread that 
    handles organizing and running tasks.  The Sheduler class should be instantiated 
    to start a TaskManager sessions.  It's run method should be called to start the 
    TaskManager.  It's stop method should be called to end the TaskManager session.
    """

    ## Init ##

    def __init__(self, daemon=1):
	DBGBN='threadedscheduler__init__'
	dbg('Entering...',DBGBN)
	Thread.__init__(self)
	self._notifyEvent = Event()
	self._nextTime = None
	self._scheduled = {}
	self._running = {}
	self._onDemand = {}
	self._isRunning = 0
	if daemon: self.setDaemon(1)


    ## Event Methods ##

    def wait(self, seconds=None):
	"""
	Our own version of wait.
	When called, it waits for the specified number of seconds, or until it is
	notified that it needs to wake up, through the notify event.
	"""
	try:
	    self._notifyEvent.wait(seconds)
	except IOError, e:
	    pass
	self._notifyEvent.clear()


    ## Attributes ##
    
    def runningTasks(self):
	return self._running

    def running(self, name, default=None):
	"""
	Returns a task with the given name from the "running" list, 
	if it is present there.
	"""
	return self._running.get(name, default)
	    
    def hasRunning(self, name):
	"""
	Check to see if a task with the given name is currently running.
	"""
	return self._running.has_key(name)

    def setRunning(self, handle):
	"""
	Add a task to the running dictionary.
	Used internally only.
	"""
	self._running[handle.name()] = handle

    def delRunning(self, name):
	"""
	Delete a task from the running list.
	Used Internally.
	"""
	try:
	    handle = self._running[name]
	    del self._running[name]
	    return handle
	except:
	    return None

    def scheduledTasks(self):
	return self._scheduled

    def scheduled(self, name, default=None):
	"""
	Returns a task from the scheduled list.
	"""         
	return self._scheduled.get(name, default)
		    
    def hasScheduled(self, name):
	"""
	Is the task with he given name in the scheduled list?
	"""
	return self._scheduled.has_key(name)

    def setScheduled(self, handle):
	"""
	Add the given task to the scheduled list.
	"""
	self._scheduled[handle.name()] = handle

    def delScheduled(self, name):
	"""
	Deleted a task with the given name from the scheduled list.
	"""
	try:
	    handle = self._scheduled[name]
	    del self._scheduled[name]
	    return handle
	except:
	    return None

    def onDemandTasks(self):
	return self._onDemand
	
    def onDemand(self, name, default=None):
	"""
	Returns a task from the onDemand list.
	"""
	return self._onDemand.get(name, default)

    def hasOnDemand(self, name):
	"""
	Is the task with he given name in the onDemand list?
	"""     
	return self._onDemand.has_key(name)

    def setOnDemand(self, handle):
	"""
	Add the given task to the onDemand list.
	"""
	self._onDemand[handle.name()] = handle

    def delOnDemand(self, name):
	"""
	Deleted a task with the given name from the onDemand list.
	"""
	try:
	    handle = self._onDemand[name]
	    del self._onDemand[name]
	    return handle
	except:
	    return None

    def nextTime(self):
	return self._nextTime

    def setNextTime(self, time):
	self._nextTime = time

    def isRunning(self):
	return self._isRunning


    ## Adding Tasks ##

    def addTimedAction(self, time, task, name):
	"""
	This method is used to add an action to be run once, at a specific time.
	"""
	handle = self.unregisterTask(name)
	if not handle:
	    handle =ScheduledTaskHandler(self, time, 0, task, name)
	else:
	    handle.reset(time, 0, task, 1)
	self.scheduleTask(handle)

    def addActionOnDemand(self, task, name):
	"""
	This method is used to add a task to the scheduler that will not be scheduled 
	until specifically requested.
	"""
	handle = self.unregisterTask(name)
	if not handle:
	    handle =ScheduledTaskHandler(self,time.time(), 0, task, name)
	else:
	    handle.reset(time(), 0, task, 1)
	self.setOnDemand(handle)

    def addDailyAction(self, hour, minute, task, name):
	"""     
	This method is used to add an action to be run every day at a specific time.
	If a task with the given name is already registered with the scheduler, that task 
	will be removed from the scheduling queue and registered anew as a periodic task.
	    
	Can we make this addCalendarAction?  What if we want to run something once a week?
	We probably don't need that for Webware, but this is a more generally useful module.
	This could be a difficult function, though.  Particularly without mxDateTime.
	"""
	import time
	current = time.localtime(time.time())
	currHour = current[3]
	currMin = current[4]

	#minute difference
	if minute > currMin:
	    minuteDifference = minute - currMin
	elif minute < currMin:
	    minuteDifference = 60 - currMin + minute
	else: #equal
	    minuteDifference = 0

	#hourDifference
	if hour > currHour:
	    hourDifference = hour - currHour
	elif hour < currHour:
	    hourDifference = 24 - currHour + hour
	else: #equal
	    hourDifference = 0

	delay = (minuteDifference + (hourDifference * 60)) * 60
	self.addPeriodicAction(time.time()+delay, 24*60*60, task, name)


    def addPeriodicAction(self, start, period, task, name):
	"""
	This method is used to add an action to be run at a specific initial time, 
	and every period thereafter.

	The scheduler will not reschedule a task until the last scheduled instance 
	of the task has completed.

	If a task with the given name is already registered with the scheduler, 
	that task will be removed from the scheduling queue and registered
	anew as a periodic task.
	"""
	DBGBN='threadedscheduleraddperiodicaction'
	dbg('adding periodic action; '+str(self)+' start '+str(start)+' period '+str(period)+' task '+str(task)+' name '+str(name),DBGBN)
	handle = self.unregisterTask(name)
	if not handle:
	    handle =ScheduledTaskHandler(self, start, period, task, name)
	else:
	    handle.reset(start, period, task, 1)
	self.scheduleTask(handle)


    ## Task methods ##

    def unregisterTask(self, name):
	"""
	This method unregisters the named task so that it can be rescheduled with 
	different parameters, or simply removed.
	"""
	DBGBN='threadedschedulerunregistertask'
	dbg('unregistering...',DBGBN)
	handle = None
	if self.hasScheduled(name):
	    dbg('self.hasScheduled is 1',DBGBN)
	    handle = self.delScheduled(name)
	if self.hasOnDemand(name):
	    dbg('self.hasOnDemand is 1',DBGBN)
	    handle = self.delOnDemand(name)
	if handle:
	    dbg('dont appear to have a schedule?? so just handle.unregistering',DBGBN)
	    handle.unregister()
	return handle

    def runTaskNow(self, name):
	"""
	This method is provided to allow a registered task to be immediately executed.
	
	Returns 1 if the task is either currently running or was started, or 0 if the 
	task could not be found in the list of currently registered tasks.
	"""
	if self.hasRunning(name):
	    return 1
	handle = self.scheduled(name)
	if not handle:
	    handle = self.onDemand(name)
	if not handle:
	    return 0
	self.runTask(handle)
	return 1
    
    def demandTask(self, name):
	"""
	This method is provided to allow the server to request that a task listed as being 
	registered on-demand be run as soon as possible.
	
	If the task is currently running, it will be flagged to run again as soon as the 
	current run completes. 

	Returns 0 if the task name could not be found on the on-demand or currently running lists.
	"""
	if  not self.hasRunning(name) and not self.hasOnDemand(name):
	    return 0
	else:
	    handle = self.running(name)
	    if handle:
		handle.runOnCompletion()
		return 1
	    handle = self.onDemand(name)
	    if not handle:
		return 0            
	    self.runTask(handle)
	    return 1

    def stopTask(self, name):
	"""
	This method is provided to put an immediate halt to a running background task.
	
	Returns 1 if the task was either not running, or was running and was told to stop.
	"""
	handle = self.running(name)
	if not handle:
	    return 0
	handle.stop()
	return 1


    def stopAllTasks(self):
	"""
	Terminate all running tasks.
	"""
	for i in self._running.keys():
	    print "Stopping ",i
	    self.stopTask(i)

    def disableTask(self, name):
	"""
	This method is provided to specify that a task be suspended. Suspended tasks will 
	not be scheduled until later enabled. If the task is currently running, it will 
	not be interfered with, but the task will not be scheduled for execution in future 
	until re-enabled.
	
	Returns 1 if the task was found and disabled.
	"""
	handle = self.running(name)
	if not handle:
	    handle = self.scheduled(name)
	if not handle:
	    return 0
	handle.disable()
	return 1

    def enableTask(self, name):
	"""
	This method is provided to specify that a task be re-enabled after a suspension.
	A re-enabled task will be scheduled for execution according to its original schedule, 
	with any runtimes that would have been issued during the time the task was suspended 
	simply skipped.

	Returns 1 if the task was found and enabled
	"""
	
	handle = self.running(name)
	if not handle:
	    handle = self.scheduled(name)
	if not handle:
	    return 0
	handle.enable()
	return 1

    def runTask(self, handle):
	"""
	This method is used by the Scheduler thread's main loop to put a task in 
	the scheduled hash onto the run hash.
	"""
	name = handle.name()
	if self.delScheduled(name) or self.delOnDemand(name):
	    self.setRunning(handle)
	    handle.runTask()

    def scheduleTask(self, handle):
	"""
	This method takes a task that needs to be scheduled and adds it to the scheduler. 
	All scheduling additions or changes are handled by this method. This is the only 
	Scheduler method that can notify the run() method that it may need to wake up early 
	to handle a newly registered task.
	"""
	self.setScheduled(handle)
	if not self.nextTime() or handle.startTime() < self.nextTime():
	    self.setNextTime(handle.startTime())
	    self.notify()


    ## Misc Methods ##

    def notifyCompletion(self, handle):
	"""
	This method is used by instances of TaskHandler to let the Scheduler thread know 
	when their tasks have run to completion.
	This method is responsible for rescheduling the task if it is a periodic task.
	"""
	name = handle.name()
	if self.hasRunning(name):
	    self.delRunning(name)
	    if handle.startTime() and handle.startTime() >time.time():
		self.scheduleTask(handle)
	    else:
		if handle.reschedule():
		    self.scheduleTask(handle)
		elif not handle.startTime():
		    self.setOnDemand(handle)
		    if handle.runAgain():
			self.runTask(handle)

    def notify(self):
	self._notifyEvent.set()

    def stop(self):
	"""
	This method terminates the scheduler and its associated tasks.
	"""
	self._isRunning = 0
	self.notify()
	self.stopAllTasks()



    ## Main Method ##

    def run(self):
	"""
	This method is responsible for carrying out the scheduling work of this class 
	on a background thread. The basic logic is to wait until the next action is due to 
	run, move the task from our scheduled list to our running list, and run it. Other
	synchronized methods such as runTask(), scheduleTask(), and notifyCompletion(), may 
	be called while this method is waiting for something to happen. These methods modify 
	the data structures that run() uses to determine its scheduling needs.
	"""
	self._isRunning = 1
	while 1:
	    if not self._isRunning:
		return
	    if not self.nextTime():
		self.wait()
	    else:
		nextTime = self.nextTime()
		currentTime = time.time()
		if currentTime < nextTime:
		    sleepTime = nextTime - currentTime
		    self.wait(sleepTime)
		if not self._isRunning: return
		currentTime = time.time()
		if currentTime >= nextTime:
		    toRun = []
		    nextRun = None
		    for handle in self._scheduled.values():
			startTime = handle.startTime()
			if startTime <= currentTime:
			    toRun.append(handle)
			else:
			    if not nextRun:
				nextRun = startTime
			    elif startTime < nextRun:
				nextRun = startTime
		    self.setNextTime(nextRun)
		    for handle in toRun:
			self.runTask(handle)

#
#END OF CLASS THREADEDSCHEDULER
##########        

###########
# START OF CLASS daemonschedule
#
class daemonschedule:
    '''Data structure holding information on the schedule for the daemon.

	Every daemon has a daemonschedule. The daemon runs according
	to this schedule, each time executing each task it owns
	against the entites for that task, and processing the output
	from that execution by all collectors attatched to the task.'''
    
    def __init__(self,start=0.0,end=0.0,period=0.0):
	self.starttime=start
	self.endtime=end
	self.period=period

    def updateschedule(self,start,end,period):
	'''Implements the 'now+' method of specifying times.'''
	if re.match('^now\+',start):
	    start=time.time()+int(start[4:])
	self.starttime=start
	if re.match('^now\+',end):
	    end=time.time()+int(end[4:])
	self.endtime=end
	self.period=period

    def getperiod(self):
	return self.period

    def getstart(self):
        DBGBN="daemonschedulegetstart"
        dbg("returning "+str(self.starttime),DBGBN)
	return self.starttime

    def getend(self):
	return self.endtime

    def tostring(self):
	return str(self.starttime)+' '+str(self.endtime)+' '+str(self.period)

    def todatestring(self):
	return 'START::'+time.ctime(float(self.starttime))+'\t\tEND::'+time.ctime(float(self.endtime))+'\t\tPERIOD::'+str(self.period)
#
# END OF CLASS daemonschedule
###########

###########
# START OF CLASS daemontask
#
class daemontask:
    ''' Data structure holding information on a single task.

	A task consists of a command, a group of entities and a group
	of collectors. Each time the scheduler invokes the daemon
	the daemon runs cmd against each entity in the group
	collects the output and runs that through each collector in
	the group.'''
    
    def __init__(self,cmd):
	self.command=cmd
	self.entities={} # dict of entity onjects
	self.collectors={} # dict (name:object) of collectors objects

    def getcommand(self):
	return self.command

    def setcommand(self,newcommand):
	self.command=newcommand

    def getentities(self):
	return self.entities 

    def addentity(self,entityobject): #pass an entity object to add it
	self.entities[entityobject.getname()]=entityobject

    def getsubscribers(self):
        return self.entities

    def removeentity(self,entityobject):
	del self.entities[entityobject.getname()] #pass an entity object to remove

    def addcollector(self,name,tag,skip,format,file): #add a named collector to the task
	self.collectors[name]=daemoncollector(tag,skip,format,file)

    def addcollectoralert(self,name,minval,maxval,alertmessage):
	self.collectors[name].addalert(minval,maxval,alertmessage)

    def removecollector(self,name): # remove a named collector from the task
	del self.collectors[name]

    def tostring(self):
	return utils.listtostring(self.command)

    def getcollectors(self):
	return self.collectors
	    
#
# END OF CLASS daemontask
###########

###########
# START OF CLASS daemoncollector
#
class daemoncollector:
    '''Data structure defining how to collect and an alert level.

	A daemoncollector is passed the output of a scheduled execution
	of a command against an entity. tag/skip/format/file define
	how to identify which piece of data, data is written to file
	and optionally tested against an alert.'''
	
    def __init__(self,tag,skip,format,file):
	dbg('Going to re.compile() the tag :'+tag+':','daemoncollectorread')
	self.datatag=re.compile(tag)
	dbg('tag compiled','daemoncollectorread')
	self.texttag=tag
	self.skipforward=skip
	self.outformat=format
	self.outfile=file
	self.alert=daemonalert(0,0,'Alert Not Set')
	self.lastoutline=''

    def gettag(self):
	return self.texttag

    def getskip(self):
	return self.skipforward

    def getformat(self):
	return self.outformat

    def getfile(self):
	return self.outfile

    def getalert(self):
	return utils.listtostring(self.alert.getalert())

    def read(self,DataList):
	DBGBN='daemoncollectorread'
	dbg('entering',DBGBN)
	dbg('length of DataList is '+str(len(DataList)),DBGBN)
	#
	#uses tsm_watchme style approach
	#
	# tag - identifies 'hitline(s)' can be regexp
	# skip - lines to skip forward from hitline before collecting data
	#           or COUNT to count number of taged lines instead
	#           skip context of multiline hit's will miss the first x lines
	#
	#   in general multiline hits collect data from each line and test for it
	#
	matchtag=self.datatag
	hitcount=0
	skiplines=self.skipforward
	switchmode=0
	alertedvalue=0
	outline=''
	generatealert=0
	for line in DataList:
	    #
	    dbg('collector got line \n'+line+'\n from output',DBGBN)
	    if switchmode>0:
		switchmode=switchmode-1
	    else:
		#
		dbg('switchmode is <=0 looking for tag '+self.texttag,DBGBN)
		if re.search(self.datatag,line):
		    #we have a hit, shall I count it?
		    dbg('it matched',DBGBN)
		    if str(skiplines)=='COUNT':
			hitcount=hitcount+1
			#
			dbg('i am counting, hitcount is '+str(hitcount),DBGBN)
		    else:#not counting it.
			#if skiplines=0 then collect data, otherwise switch to skip mode
			dbg('I am not counting...',DBGBN)
			if int(skiplines)==0:
			    #
			    # split the line into fields, use format to order and concatenate
			    #
			    dbg('skiplines is 0, splitting',DBGBN)
			    outline=''
			    formatfields=self.outformat.split()
			    linefields=line.split()
			    for fieldtoken in formatfields:
				tokens=str.split(fieldtoken,'^')
				lbl=tokens[0]
				label=lbl.replace('_',' ')
				fieldnum=tokens[1]
								#ok, alert on value, build output line, write to file if required
				value=linefields[int(fieldnum)-1]
				if self.alert.isset() and self.alert.check(value):
				    #post an alert to the queue 
				    #AlertQueue[str(len(AlertQueue)+1)]=self.alert.getmessage()
				    generatealert=1
				    alertedvalue=value
				outline=outline+label+str(value)
				#
				dbg('collector here, I just generated an outline of '+outline,DBGBN)
			else:
			    dbg('skiplines is set, setting switchmode to '+str(skiplines),DBGBN)
			    switchmode=skiplines
			    skiplines=0
	if hitcount>0:
	    formattokens=str.split(self.outformat,'^')
	    label=formattokens[0]
	    outline=label+str(hitcount)
	    dbg('collector here, I just generated an outline of '+outline,DBGBN)
	    if self.alert.isset() and self.alert.check(hitcount):
		generatealert=1
	self.lastoutline=outline
	if generatealert:
	    return '~DAEMON task ~TASK\n\tEntity   : ~ENTITY\n\tCollector: ~COLLECTOR\n\t\t '+self.alert.getmessage()+' VALUE: '+str(alertedvalue)
	else:
	    return None

    def addalert(self,min,max,alertmessage):
	self.alert.setmin(min)
	self.alert.setmax(max)
	self.alert.setmessage(alertmessage)
	
	    
    def tostring(self):
	return str(self.texttag)+' '+str(self.skipforward)+' '+str(self.outformat)+' '+str(self.outfile)
#
# END OF CLASS daemoncollector
###########

###########
# START OF CLASS daemonalert
#
class daemonalert:
    def __init__(self,minval,maxval,alertmessage):
	self.minimum=float(minval)
	self.maximum=float(maxval)
	self.message=alertmessage # @ is xlated as field label/value
	self.set=0

    def setmin(self,min):
	self.minimum=float(min)
	self.set=1

    def setmax(self,max):
	self.maximum=float(max)
	self.set=1

    def setmessage(self,alertmessage):
	self.message=alertmessage
	self.set=1

    def getmessage(self):
	return self.message

    def check(self,value):
	DBGBN='daemonalertcheck'
	value=float(value)
	dbg('Entering alert check. Value is '+str(value),DBGBN)
	if self.set:
	    if(value<self.minimum or value>self.maximum):
		dbg('MinLimit is '+str(self.minimum)+' MaxLimit is '+str(self.maximum)+' VALUE IS OUTSIDE OF RANGE',DBGBN)
		return 1
	dbg('MinLimit is '+str(self.minimum)+' MaxLimit is '+str(self.maximum)+' VALUE IS INSIDE RANGE',DBGBN)
	return 0

    def getalert(self):
	return [str(self.minimum),str(self.maximum),self.message]

    def isset(self):
	return self.set

#
#END OF CLASS daemonalert
###########

###########
# START OF CLASS daemon
#

class daemon(ScheduledTask):
    '''A top level object holding info for scheduled commands.

	A daemon consists of a schedule and a group of tasks. each
	task is a group of entities and collectors and a command. Each
	collector is a set of rules for extracting data from the results
	of cmd run against each entity, and an optional alert set on that data.'''
    
    def __init__(self,entitymanager,Name):
	ScheduledTask.__init__(self)
	'''Parms.
	

	entitymanager is an entitymanager object the daemon can ask to execute the command
	using the scheduledexecute(EntityName,Cmd) method
	scheduler is the scheduler handling the executions, needed so
	daemon can rescheule itself for period units in the future'''
	self.name=Name
	self.processor=entitymanager
	self.tasks={}
	self.schedule=daemonschedule()
	
		
    def run(adaemon): #adaemon
	DBGBN='daemonruntasks'
	for tsk in adaemon.tasks:
	    for ent in adaemon.tasks[tsk].getentities():
		dbg('collecting info for task entity '+ent,DBGBN)
		dbg('command to run is '+utils.listtostring(adaemon.tasks[tsk].getcommand()),DBGBN)
		output=adaemon.processor.scheduledexecute(ent,adaemon.tasks[tsk].getcommand())
		#process output.....
		collectors=adaemon.tasks[tsk].getcollectors()
		for collector in collectors:
		    dbg('collector '+collector+' doing a read()',DBGBN)
		    alertstring=collectors[collector].read(output) # will collect and return alert back if generated
		    if alertstring!=None:
			#Alert replacement tokens.
			# ~DAEMON = daemon
			# ~ENTITY
			# ~COLLECTOR
			# ~TASK
			# ~TIME
			alertstring=alertstring.replace('~DAEMON',adaemon.getname())
			alertstring=alertstring.replace('~TASK',tsk)
			alertstring=alertstring.replace('~ENTITY',ent)
			alertstring=alertstring.replace('~COLLECTOR',collector)
			
			#alertstring=alertstring.replace('~DAEMON',adaemon.getname())
			dbg('Posting alert to queue',DBGBN)
			AlertQueue[str(len(AlertQueue)+1)]=alertstring
		    #now save to file
		    collectorfile=collectors[collector].getfile()
		    dbg('Starting write to file. filename is '+collectorfile,DBGBN)
		    if os.name=='posix':
			collectorfile=collectorfile.replace('\\','/')
		    else:
			collectorfile=collectorfile.replace('/','\\')
		    dbg('After posix / winos switching it is '+collectorfile,DBGBN)
		    if collectorfile!='none':
			dbg('file is not \'none\' so will write to it',DBGBN)
			global driveroot
			outfile=file(driveroot+collectorfile+'_'+adaemon.getname()+tsk+ent+collector,'a')
			dbg('will write '+collectors[collector].lastoutline,DBGBN)
			outfile.write(str(time.time())+','+collectors[collector].lastoutline+'\n')
			outfile.close()
	dbg('exiting...',DBGBN)
	

    def setschedule(self,start,end,period):
	self.schedule.updateschedule(start,end,period)

    def getschedule(self):
	return self.schedule

    def addtask(self,name,command):
	self.tasks[name]=daemontask(command)

    def gettasks(self):
	return self.tasks #returns dict of tasks

    def gettask(self,name):
	return self.tasks[name] #returns single task
	
    def removetask(self,name):
	del self.tasks[name]

    def addtaskcollector(self,taskname,collectorname,tag,skip,format,file):
	self.tasks[taskname].addcollector(collectorname,tag,skip,format,file)

    def addtaskcollectoralert(self,taskname,collectorname,minval,maxval,alertmessage):
	self.tasks[taskname].addcollectoralert(collectorname,minval,maxval,alertmessage)

    def removetaskcollector(self,taskname,collectorname):
	self.tasks[taskname].removecollector(collectorname)

    def addtaskentity(self,taskname,entity):
	self.tasks[taskname].addentity(entity)

    def removetaskentity(self,taskname,entity):
	self.tasks[taskname].removeentity(entity)

    def getnumtasks(self):
	return len(self.tasks)

    def getname(self):
	return self.name
		
	
#
# END OF CLASS DAEMON
###########
###########
# START OF CLASS ENTITYGROUP

class ENTITYGROUP(entity):
    '''Implentation of a 'meta' entity, which is groups of other entites'''
    def __init__(self,name,EntityNameList,EntityManagerInstance):
        self.Name=name
        self.Entities=EntityNameList
        self.EntityManager=EntityManagerInstance

    ##########
    # START OF INTERFACE ENTITY
    #

    Opts={}

    def execute(self,CmdList):
        for Entity in self.Entities:
            self.EntityManager.execute(Entity,CmdList)
        return ['\nEntityGroup executed command.\n']

    def display(self,LineList):
        for line in LineList:
            print line.rstrip()
        return

    def getparameterdefs(self):
        EntityParmFields=["Name"]
        for Entity in self.Entities:
            EntityParmFields.append(Entity)
        return EntityParmFields

    def getname(self):
        return self.Name

    
    def getparameterstring(self):
        parmstring=''
        for Entity in self.Entities:
            if parmstring=='':
                parmstring=Entity
            else:
                parmstring=parmstring+" "+Entity
        return parmstring
    
    def getparameterlist(self):
        parmstring=self.getparameterstring()
        lst=parmstring.split()
        return lst

    def getentitytype(self):
        return 'ENTITYGROUP'

    def gettype(self):
        return 'simple'

    def setoption(self,option,value):
        ENTITYGROUP.Opts[option]=value
        return
    
    def getoptions(self):
        OptList=[]
        for o in LOCAL.Opts:
            OptList.append(o+' '+LOCAL.Opts[o])
        return OptList
    
    #
    # END OF INTERFACE ENTITY
    ##########
#
# END OF CLASS ENTITYGROUP
###########
###########
# START OF CLASS LOCAL
#

class LOCAL(entity):
    '''Implementation of an entity that executes commands on the local machine'''
    def __init__(self,name):
	self.Name=name
	pass

    ##########
    # START OF INTERFACE ENTITY
    #


    Opts={}

    def execute(self,CmdList):
        din,dout,derr=os.popen3(utils.listtostring(CmdList))
        output=dout.readlines()
        errout=derr.readlines()
        dummy=[output.append(err) for err in errout]  
        return output# List of lines readable by display() method

    def display(self,LineList):
	'''Generic method for displaying output from entity.execute().

	This method should be implmented by the subclasser and translate
	the given LineList to human-readable output.'''
	for line in LineList:
            print line.rstrip()
	return # print LineList, LineList is (minimally) output from execute() method
    
    def getparameterdefs(self):
        '''Should return a dict of parm:parmtype pairs for the GUI
        to build a config box'''
        return ["Name"]
    
    def getname(self):
	'''Convenience method for getting entity name.

	should return a string representing the entity uniquely'''
	return self.Name # string that is entity name

    def getparameterstring(self):
        DBGBN='localgetparameterstring'
	'''Method to determine how the entity was defined.

	Should return a string that can be fed to FatController.processcommand()#outdate see aboce
	that will re-define this entity in its entirety'''
	dbg('returning define entity LOCAL '+self.Name,DBGBN)
	return ''

    def getparameterlist(self):
        '''returns a list of the value given as string by getparameterstring'''
        parmstring=self.getparameterstring()
        lst=parmstring.split()
        return lst

    def getentitytype(self):
	'''Get the type of entity.

	Should return qa string indicating the entities type (TELNET , TSM , BROCADE etc..)'''
	return 'LOCAL'

    def gettype(self):
	'''Return the kind of instance of a given entity.

	For example, TSM entities have an entitytype of 'TSM'
	but a type of single or configmanger. This should
	return a string indicating the kind of entity this is'''
	return 'simple'

    def setoption(self,option,value):
	'''Set a global option.

	this method should take option and value pair and set them
	as requried. (IE: TELNET.setoption(self,ShowRawTelnet,yes instructs
	the TELNET entities to begin displaying their raw telnet dialogues)'''
	LOCAL.Opts[option]=value
	return

    def getoptions(self):
	'''Get a list of set options.

	Should return a list of the format
	CLASS OPTION VALUE'''
	OptList=[]
	for o in LOCAL.Opts:
	    OptList.append(o+' '+LOCAL.Opts[o])
	return OptList

    #
    # END OF INTERFACE Entity
    ###########
#
# END OF CLASS LOCAL
############

###########
# START OF CLASS DUMB
# a dumb entity

class DUMB(entity):
    '''implementation of a very simple entity.'''
    def __init__(self,name):
	self.Name=name
	pass
    

    ###########
    # Start of interface ENTITY
    #


    Opts={} #for holding settable entity options

    def execute(self,CmdList):
	'''Generic method.

	CmdList should be parsed and executed against the given entity (self).
	The return value should be a list of output elements readable by
	entity.display()'''
	CmdList.insert(0,'I would have executed this\n')
	return CmdList # List of lines readable by display() method

    def display(self,LineList):
	'''Generic method for displaying output from entity.execute().

	This method should be implmented by the subclasser and translate
	the given LineList to human-readable output.'''
	for line in LineList:
	    print line
	return # print LineList, LineList is (minimally) output from execute() method
    
    def getparameterdefs(self):
        '''Should return a dict of parm:parmtype pairs for the GUI
        to build a config box. 'parm' will be displayed name for input boxes'''
        return ["Name"]
    

    def getname(self):
	'''Convenience method for getting entity name.

	should return a string representing the entity uniquely'''
	return self.Name # string that is entity name

    def getparameterstring(self):
	'''Method to determine how the entity was defined.

	Should return a string that can be fed to FatController.processcommand()
	that will re-define this entity in its entirety'''
	return ''

    def getparameterlist(self):
        '''returns a list of the value given as string by getparameterstring'''
        parmstring=self.getparameterstring()
        list=parmstring.split()
        return list


    def getentitytype(self):
	'''Get the type of entity.

	Should return qa string indicating the entities type (TELNET , TSM , BROCADE etc..)'''
	return 'DUMB'

    def gettype(self):
	'''Return the kind of instance of a given entity.

	For example, TSM entities have an entitytype of 'TSM'
	but a type of single or configmanger. This should
	return a string indicating the kind of entity this is'''
	return 'simple'

    def setoption(self,option,value):
	'''Set a global option.

	this method should take option and value pair and report on them
	as requried. (IE: TELNET.setoption(self,ShowRawTelnet,yes instructs
	the TELNET entities to begin displaying their raw telnet dialogues)'''
	DUMB.Opts[option]=value
	return

    def getoptions(self):
	'''Get a list of set options.

	Should return a list of the format
	class (entity) option (option) (value) '''
	optlist=[]
	for opt in DUMB.Opts:
	    optlist.append('DUMB '+opt+' '+DUMB.Opts[opt])
	return optlist

    #
    # END OF INTERFACE Entity
    ###########

#
# END OF CLASS DUMB
###########
###########
# START OF CLASS TSM
# implements entity()
#

class TSM(entity):


    ConfigManagers={} #{'name':'group'}
    
    if os.name=='posix':
	din,dout,derr=os.popen3('uname -a | awk \'{print $1}\'')
	output=dout.readlines()
	output=utils.listtostring(output)
	output=output.rstrip()
	if output=='AIX':
	    tsmroot='/usr/tivoli/tsm/client/ba/bin/'
	else:
	    tsmroot='/opt/tivoli/tsm/client/ba/bin/'
	optroot='FC_OPT/'
	tsmadmincmd='dsmadmc'
	tsmcleanadmincmd='dsmadmc -dataonly=yes'
    else:
	tsmroot='c:\\program files\\tivoli\\tsm\\baclient\\'
	optroot='FC_OPT\\'
	tsmadmincmd='dsmadmc.exe'
	tsmcleanadmincmd='dsmadmc.exe -dataonly=yes'

    def __init__(self,Name,Type,LL,HL,AdminUser,AdminPass):
	self.Name=Name
	self.Type=Type
	self.LL=LL
	self.HL=HL
	self.AdminUser=AdminUser
	self.AdminPass=AdminPass
	if self.Type=='single':
	    self.dosingleserversetup()
	else:
	    #type is configmanager()
	    self.doconfigmanagersetup()   # automatically sets up a group of TSM server entities
			    # of disocvered servers.
			    #  with configmanager as group primary.

    def dosingleserversetup(self):
	return

    def doconfigmanagersetup(self):
	TSM.ConfigManagers[self.Name]=self.Name+'_ConfigManager'
	#find other servers
	#define 'em as entities
	#group 'em up here for excecute shennanigans later
	return

    ###########
    #Begin Interface entity()
    #

    Opts={}

    def execute(self,CmdList):
	DBGBN='tsmexecute'
	dbg('Entering tsm_execute block Cmd is ->  '+utils.listtostring(CmdList)+'  <-',DBGBN)
	#if config exists for entity name (dsm_NAME.opt) rename current, replace dsm.opt, do cmd, replace current
	dbg('about to do copyfile for dsm renaming using popen3',DBGBN)
	#popen3 kludge as shutil appears to block
	if os.name=='posix':
	    try:
		dbg('using POSIX paths. Command is;\n\t'+copycmd+' \"'+TSM.tsmroot+TSM.optroot+self.Name+'.opt\" \"'+TSM.tsmroot+'dsm.opt\"',DBGBN)
		Dummy,Dummyout,Dummyerr=os.popen3(copycmd+' \"'+TSM.tsmroot+TSM.optroot+self.Name+'.opt\" \"'+TSM.tsmroot+'dsm.opt\"')
		Dummy.close()
		Dummyout.close()
		Dummyerr.close()
		dbg('using POSIX paths. Command is;\n\t'+copycmd+' \"'+TSM.tsmroot+TSM.optroot+self.Name+'.sys\" \"'+TSM.tsmroot+'dsm.sys\"',DBGBN)
		Dummy,Dummyout,Dummyerr=os.popen3(copycmd+' \"'+TSM.tsmroot+TSM.optroot+self.Name+'.sys\" \"'+TSM.tsmroot+'dsm.sys\"')
		Dummy.close()
		Dummyout.close()
		Dummyerr.close()
	    except OSError:
		print 'ERROR: System error on popen3() cannot copy TSM optfile - Have you created your FC_OPT dir and .opt files?'
	else:
	    try:
		dbg('Using non-posix paths. Command is;\n\t'+copycmd+' \"'+TSM.tsmroot+TSM.optroot+self.Name+'.opt\" \"'+TSM.tsmroot+'dsm.opt\"',DBGBN)
		Dummy,Dummyout,Dummyerr=os.popen3(copycmd+' \"'+TSM.tsmroot+TSM.optroot+self.Name+'.opt\" \"'+TSM.tsmroot+'dsm.opt\"')
		Dummy.close()
		Dummyout.close()
		Dummyerr.close()
	    except OSError:
		print 'ERROR: System error on popen3() cannot copy TSM optfile - Have you created your FC_OPT dir and .opt files?'

	dbg('done copyfile for dsm renaming',DBGBN)
	#PROCESS CLASS OPTIONS SPECIFIC TO EXECUTION
	if TSM.Opts.has_key('DATAONLY') and TSM.Opts['DATAONLY']=='yes':
	    dbg('got YES for DATAONLY option',DBGBN)
	    runcmd=TSM.tsmcleanadmincmd
	else:
	    runcmd=TSM.tsmadmincmd
	    dbg('got NO or No Key for DATAONLY option',DBGBN)
	dbg('runcmd is '+runcmd,DBGBN)
	CmdString=runcmd+' -id='+self.AdminUser+' -pa='+self.AdminPass+' '+utils.listtostring(CmdList)
	if os.name!='posix':
	    dbg('Doing non-posix escape removal.',DBGBN)
	    CmdString=CmdString.replace('\\','')
	dbg('Final command string is ->  '+CmdString+'  <-',DBGBN)
	os.chdir(TSM.tsmroot)
	try:
	    Dummy,CmdOut,CmdErr=os.popen3(CmdString)
	    Dummy.close()
	    outputlines=CmdOut.readlines()
	    CmdOut.close()
	    errorlines=CmdErr.readlines()
	    CmdErr.close()
	    for line in errorlines:
		print line
	except OSError:
	    print 'Warning: System error on popen(), TSM entity '+self.Name+' failed command.'
	    return ['']
	return outputlines
    
    def getparameterdefs(self):
        '''Should return a dict of parm:parmtype pairs for the GUI
        to build a config box'''
        #tsm parms are name,type,host,port,user,pwd
        return ["Name","Type","Host","Port","User","Pwd"]
    

    def display(self,LineList):
	for line in LineList:
	    print line.rstrip()#print adds a \n after printing

    def getname(self):
	return self.Name

    def getparameterstring(self):
	return self.Type+' '+self.LL+' '+self.HL+' '+self.AdminUser+' '+self.AdminPass

    def getparameterlist(self):
        '''returns a list of the value given as string by getparameterstring'''
        parmstring=self.getparameterstring()
        list=parmstring.split()
        return list


    def getentitytype(self):
	return 'TSM'

    def gettype(self):
	return self.Type

    def setoption(self,option,value):
	DBGBN='tsmsetoption'
	dbg('setting option '+option+' to '+value,DBGBN)
	TSM.Opts[option]=value

    def getoptions(self):
	DBGBN='tsmgetoptions'
	OptList=[]
	for o in TSM.Opts:
	    dbg('Found option '+o+' with value :'+TSM.Opts[o]+': in class TSM',DBGBN)
	    OptList.append(o+' '+TSM.Opts[o])
	return OptList

    #
    #End Interface Entity
    ###########
#
# END OF CLASS TSM(entity)
###########
###########
# START OF CLASS TELNET
# implements entity()
#

class TELNET(entity):

    Connections={} # {'name':telnetlib.Telnet()}


    def __init__(self,Name,TCPAddress,TCPPort,TELNETUser,TELNETPass):
	self.Name=Name
	self.TCPAddress=TCPAddress
	self.TCPPort=TCPPort
	self.TELNETUser=TELNETUser
	self.TELNETPass=TELNETPass
	self.Connection=self.openconnection()

    def openconnection(self):
	DBGBN='telnetopenconnection'
	global system
	platform=system
	try:
	    C=telnetlib.Telnet(self.TCPAddress)
	    try:
		if TELNET.Opts['SHOWRAWTELNET'] =='yes':
		    C.set_debuglevel(65535)
	    except KeyError:
		pass
	    dbg('expecting [lL]ogin: ',DBGBN)
	    index,match,text=C.expect(['[Ll]ogin: '],10)
	    if index != -1:
		dbg('gotit',DBGBN)
	    else:
		dbg('missed',DBGBN)
	    dbg('writing self.TELNETUser\\r',DBGBN)
	    C.write(self.TELNETUser+'\r')
	    dbg('expecting [pP]assword: ',DBGBN)
	    index,match,text=C.expect(['[Pp]assword: '],10)
	    if index != -1:
		dbg('gotit',DBGBN)
	    else:
		dbg('missed',DBGBN)
	    promptexpect=['.*'+self.TELNETUser+'.*']
	    dbg('writing self.TELNETPass\\r',DBGBN)
	    C.write(self.TELNETPass+'\r')
	    dbg('expecting '+utils.listtostring(promptexpect),DBGBN)
	    index,match,text=C.expect(promptexpect,10)
	    if index != -1:
		dbg('gotit',DBGBN)
	    else:
		dbg('missed',DBGBN)
	    dbg('writing PS1=\'_FC_>\'\\r',DBGBN)
	    C.write('PS1=\'_FC_>\'\r')
	    dbg('expecting _FC_>',DBGBN)
	    index,match,text=C.expect(['_FC_>'],10)
	    if index != -1:
		dbg('gotit',DBGBN)
	    else:
		dbg('missed',DBGBN)
	    dbg('writing export PS1\\r',DBGBN)
	    C.write('export PS1\r')
	    dbg('expecting _FC_>',DBGBN)
	    index,match,text=C.expect(['_FC_>'],10)
	    if index != -1:
		dbg('gotit',DBGBN)
	    else:
		dbg('missed',DBGBN)
	    try:
		if TELNET.Opts['ShowRawTelnet'] =='yes':
		    C.set_debuglevel(0)
	    except KeyError:
		pass
	    return C
	except (telnetlib.socket.gaierror, telnetlib.socket.error):
	    TELNET.Connections[self.Name]=self.Name
	    print 'Warning: TELNET entity '+self.Name+' could not open telnet connection to '+self.TCPAddress+':'+self.TCPPort
	    return self.Name
	
    ###########
    # START OF INTERFACE entity()
    #

    Opts={} #dict of options

    def execute(self,CmdList):
	DBGBN='telnetexecute'
	dbg('entered TELNET.execute with '+utils.listtostring(CmdList),DBGBN)
	if CmdList:
	    #C=TELNET.Connections[self.Name]
            C=self.Connection
	    if C!=self.Name:
		#special bit here to handle telnetlib's 'INTERACT' ability
		if utils.listtostring(CmdList)=='__interact':
                    retkey=''
                    global system
                    if system=='UNIX':
                            retkey='^D'
                    else:
                            retkey='^Z'
		    print '\nTELNET entity '+self.Name+' entering INTERACT mode. Use '+retkey+' to come back\n'
		    C.mt_interact()
		    return ['']
		else:
		    try:
			dbg('checking for Opt SHOWRAWTELNET got '+TELNET.Opts['SHOWRAWTELNET'],DBGBN)
			if TELNET.Opts['SHOWRAWTELNET'] =='yes':
			    C.set_debuglevel(65535)
		    except KeyError:
			pass
		    Abort=0
		    while Abort<2:
			try:
			    C.write(utils.listtostring(CmdList)+'\r')
			    dbg('expecting _FC_> ',DBGBN)
			    index,match,text=C.expect(['_FC_>'],10)
			    if index != -1:
				dbg('gotit',DBGBN)
			    else:
				dbg('missed',DBGBN)
			    Abort=2
			except (telnetlib.socket.error, EOFError):
			    print 'Info: TELNET entity '+self.Name+' had trouble. Reseting connection.'
			    if Abort:
				print 'Warning: TELNET entity '+self.Name+' connection aborted.'
				C=self.Name
				return ['']
			    C=TELNET.Connections[self.Name]=self.openconnection()
			    Abort+=1
		    Output=text.split('\n')
		    return  Output
		if TELNET.Opts['ShowRawTelnet'] =='yes':
		    C.set_debuglevel(0)
	    else:
		print 'Info: Entity failed to initialise telnet; retrying'
	    try:
		dbg('making connection...',DBGBN)
		C=TELNET.Connections[self.Name]=telnetlib.Telnet(self.TCPAddress)
		dbg('expecting [lL]ogin: ',DBGBN)
		index,match,text=C.expect(['[lL]ogin: '],10)
		if index != -1:
		    dbg('gotit',DBGBN)
		else:
		    dbg('missed',DBGBN)
		C.write(self.TELNETUser+'\r')
		dbg('expecting [pP]assword: ',DBGBN)
		index,match,text=C.expect(['[pP]assword: '],10)
		if index != -1:
		    dbg('gotit',DBGBN)
		else:
		    dbg('missed',DBGBN)
		C.write(self.TELNETPass+'\r')
		dbg('expecting \\r\\n[a-eA-E]:\\\\\\\\.*> ',DBGBN)
		index,match,text=C.expect(['\r\n[a-eA-E]:\\\\.*>'],10)
		if index != -1:
		    dbg('gotit',DBGBN)
		else:
		    dbg('missed',DBGBN)
		C.write('PS1=\'_FC_>\'\r')
		dbg('expecting _FC_> ',DBGBN)
		index,match,text=C.expect(['_FC_>'],10)
		if index != -1:
		    dbg('gotit',DBGBN)
		else:
		    dbg('missed',DBGBN)
		C.write('export PS1\r')
		dbg('expecting _FC_> ',DBGBN)
		index,match,text=C.expect(['_FC_>'],10)
		if index != -1:
		    dbg('gotit',DBGBN)
		else:
		    dbg('missed',DBGBN)
		C.write(utils.listtostring(CmdList)+'\r')
		dbg('expecting _FC_> ',DBGBN)
		index,match,text=C.expect(['_FC_>'],30)
		if index != -1:
		    dbg('gotit',DBGBN)
		else:
		    dbg('missed',DBGBN)
		Output=text.split('\n')
		try:
		    if TELNET.Opts['ShowRawTelnet'] =='yes':
			C.set_debuglevel(0)
		except KeyError:
		    pass
		return  Output
	    except (telnetlib.socket.gaierror, telnetlib.socket.error):
		TELNET.Connections[self.Name]=self.Name
		print 'Warning: TELNET entity '+self.Name+' could not open telnet connection to '+self.TCPAddress+':'+self.TCPPort
		return ['']
	    
    def display(self,LineList):
	if LineList:
	    for Line in LineList:
		print Line
    
    def getparameterdefs(self):
        '''Should return a dict of parm:parmtype pairs for the GUI
        to build a config box'''
        #telnet parms are name,host,port,user,pwd
        return ["Name","Host","Port","User","Pwd"]
    

    def getname(self):
	return self.Name

    def getparameterstring(self):
	return self.TCPAddress+' '+self.TCPPort+' '+self.TELNETUser+' '+self.TELNETPass

    def getparameterlist(self):
        '''returns a list of the value given as string by getparameterstring'''
        parmstring=self.getparameterstring()
        list=parmstring.split()
        return list


    def getentitytype(self):
	return 'TELNET'

    def gettype(self):
	return 'simple'

    def setoption(self,option,value):
	DBGBN='telnetsetoption'
	TELNET.Opts[option]=value
	dbg('Have set opt >|'+option+'|< to >|'+value+'|<',DBGBN)

    def getoptions(self):
	OptList=[]
	for o in TELNET.Opts:
	    OptList.append(o+' '+TELNET.Opts[o])
	return OptList

    #
    # END OF INTERFACE entity()
    ###########

#
# END OF CLASS TELNET
###########
###########
# START OF CLASS entitymanager
#

class entitymanager:

#
#Method functions
#
    def __init__(self):
	self.Entities={} #dict of entity objects

    def getentitytype(self,EntityName):
	return self.Entities[EntityName].getentitytype()
    
    def getentitylist(self):
        return self.Entities
    
    def getentityparms(self,EntityName):
	return self.Entities[EntityName].getparameterstring()

    def define(self,type,typeparms):                #TSMServer tpyeparms;  ['name','adminuser','adminpass']
	if type=='TSM':                 #becomes Entites{'name',['adminuser','adminpass']}
	    if len(typeparms)==6:
		EntityName=typeparms[0]
		self.Entities[EntityName]=TSM(EntityName,typeparms[1],typeparms[2],typeparms[3],typeparms[4],typeparms[5]) # {'name',<TSM object>}
		print '\nEntity:'
		print '\tTSM:',self.Entities[EntityName].getname(),self.Entities[EntityName].getparameterstring()
		print 'Defined.\n'
	    else:
		print '\nError: Wrong number parameters for TSM entity.\n'
	elif type=='TELNET':
	    if len(typeparms)==5:
		EntityName=typeparms[0]
		self.Entities[EntityName]=TELNET(EntityName,typeparms[1],typeparms[2],typeparms[3],typeparms[4])
		print '\nEntity:'
		print '\tTELNET:'+' '+self.Entities[EntityName].getname()+' '+self.Entities[EntityName].getparameterstring()
		print 'Defined.\n'
	    else:
		print '\nError: Wrong number of parameters for TELNET entity.\n'
	elif type=='DUMB':
	    if len(typeparms)==1:
		EntityName=typeparms[0]
		self.Entities[EntityName]=DUMB(EntityName)
		print '\nEntity:'
		print '\tDUMB:'+self.Entities[EntityName].getname()
		print 'Defined\n'
	    else:
                print '\nError: Wrong number of parameters for DUMB entity.\n'
	elif type=='LOCAL':
            if len(typeparms)==1:
                EntityName=typeparms[0]
                self.Entities[EntityName]=LOCAL(EntityName)
                print '\nEntity:'
		print '\tLOCAL:'+self.Entities[EntityName].getname()
		print 'Defined\n'
	    else:
                print '\nError: Wrong number of parameters for LOCAL entity.\n'
        elif type=='ENTITYGROUP':
            EntityName=typeparms[0]
            self.Entities[EntityName]=ENTITYGROUP(EntityName,typeparms[1:],self)
            print '\nEntity:'
	    print '\tENTITYGROUP: '+self.Entities[EntityName].getname()+' '+self.Entities[EntityName].getparameterstring()
	    print 'Defined\n'
	else:
	    print '\nError: Don\'t know how to define '+type+' entities.\n'

    def execute(self,EntityName,CmdList):
	DBGBN='entitymanagerexecute'
	#executes CmdList depending on exec procedure for entitytype for named entity
	try:
	    EntityType=self.Entities[EntityName].getentitytype()
	    dbg('entity type is '+EntityType,DBGBN)
	    output=self.Entities[EntityName].execute(CmdList) #list of output returned
	    global LastExecutedEntity
	    LastExecutedEntity=EntityName
	    self.Entities[EntityName].display(output)
	except KeyError:
	    print 'Error:  Don\'t know how to execute commands for '+EntityName+'.'

    def scheduledexecute(self,EntityName,CmdList):
	DBGBN='entitymanagerscheduledexecute'
	dbg('entering...',DBGBN)
	try:
	    EntityType=self.Entities[EntityName].getentitytype()
	    output=self.Entities[EntityName].execute(CmdList) #list of output returned
	    #global LastExecutedEntity
	    #LastExecutedEntity=EntityName
	    return output
	except KeyError:
	    print 'Error:  Don\'t know how to execute commands for '+EntityName+'.'

    def display(self,EntityName,OutputList):
	self.Entities[EntityName].display(OutputList)

    def show(self):
	print ''
	for e in self.Entities:
	    print self.Entities[e].getentitytype(),'\t',e,'\t',self.Entities[e].getparameterstring()
	print ''

    def getdefines(self): #Returns a list of strings, each string returned is the define command for the entity
        DBGBN='entitymanagergetdefines'
	DefineList=[]
	dbg('starting to loop through self.entities',DBGBN)
	for e in self.Entities:
            dbg('doing entity '+self.Entities[e].getname(),DBGBN)
	    EntityType=self.Entities[e].getentitytype()
	    ParmList=self.Entities[e].getparameterstring()
	    DefineList.append('define entity '+EntityType+' '+e+' '+ParmList)
	dbg('leaving entitymanagergetdefines',DBGBN)
	return DefineList

    def delete(self,EntityName):
	del self.Entities[EntityName]
	cmdreport('\nEntity\n\t'+EntityName+'\nDeleted.\n')

    def isEntity(self,EntityName):
	try:
	    self.Entities[EntityName]
	    return 1
	except KeyError:
	    return 0

    def getEntity(self,EntityName):
	return self.Entities[EntityName]

    def SetClassOption(self,EntityClass,option,value):
	DBGBN='entitymanagersetclassoption'
	dbg('option '+option+' value '+value+' for entity class '+EntityClass,DBGBN)
	for e in self.Entities:
	    if self.Entities[e].getentitytype()==EntityClass: #CHANGED INCIDENTALLY FRMO gettype() WARNING!!!!!!!!!
		dbg('setting option >|'+option+'|< to value >|'+value+'|< for entity class >|'+EntityClass+'|<',DBGBN)
		self.Entities[e].setoption(option,value)
		break #only do one
	    
    def getentitytypes(self):
        types=[]
        for e in self.Entities:
            etype=self.Entities[e].getentitytype()
            if etype not in types:
                types.append(etype)
        return types

    def displayclassoptions(self):
	doneclasses={}
	for e in self.Entities:
	    try:
		if doneclasses[self.Entities[e].getentitytype()]:
		    pass
	    except KeyError:
		doneclasses[self.Entities[e].getentitytype()]='done'
		for option in self.Entities[e].getoptions():
		    print self.Entities[e].getentitytype()+' '+option

    def getclassoptiondefines(self):
	DBGBN='entitymanagergetclassoptiondefines'
	doneclasses={}
	OptList=[]
	formattedlist=[]
	for e in self.Entities:
	    try:
		dbg('Checking if have got classoptiondefines for entitytype '+self.Entities[e].getentitytype(),DBGBN)
		if doneclasses[self.Entities[e].getentitytype()]:
		    dbg('key found in doneclasses, I Have!',DBGBN)
		    pass
	    except KeyError:
		dbg('Havent got them for this entity type yet. Getting....',DBGBN)
		dbg('setting doneclasses[self.Entities[e].getentitytype() {'+self.Entities[e].getentitytype()+'} to done',DBGBN)
		doneclasses[self.Entities[e].getentitytype()]='done'
		rawlist=self.Entities[e].getoptions()
		if len(rawlist)>0:
		    dbg('formatting the rawlist options',DBGBN)
		    for l in rawlist:
			dbg('l is '+l,DBGBN)
			dbg('adding \'set '+self.Entities[e].getentitytype()+' '+l+'\'',DBGBN)
			formattedlist.append('set '+self.Entities[e].getentitytype()+' '+l)
		    dbg('appending formatted list to optlist',DBGBN)
		    OptList.append(formattedlist)
		    formattedlist=[]
	return OptList # list of lists
	
	
#
# END OF CLASS entitymanager
###########
###########
#START OF CLASS daemonmanager
#

class daemonmanager:

    
    def __init__(self,entitymanager,scheduler):
        self.daemons={}
        self.activedaemons={}
        self.EntityManager=entitymanager
        self.Scheduler=scheduler

    def getactivedaemons(self):
        """ return a list of active daemon names"""
        return self.activedaemons.keys()

    def getprettydaemons(self):
        """ return a list of lines, formatted daemon definitions """
        prettydaemons=[]
        for daemon in self.daemons:
            daemontasks=self.daemons[daemon].gettasks()
            prettydaemons.append('\nDaemon:\t'+daemon+'\n\n\t'+self.daemons[daemon].getschedule().todatestring())
            for task in daemontasks:
                prettydaemons.append('\n\tTask:-')
                taskentities=daemontasks[task].getentities()
                prettydaemons.append( '\t\t'+task+'\t'+daemontasks[task].tostring()+'\n')
                prettydaemons.append( '\t\tEntities:-\t')
                for entity in taskentities:
                    prettydaemons.append(taskentities[entity].getname()+', ')
                prettydaemons.append( '\n\t\tCollectors:-\t')
                taskcollectors=daemontasks[task].getcollectors()
                for collector in taskcollectors:
                    prettydaemons.append( '\t\t\t'+collector+'->\n\t\t\t\tTAG '+taskcollectors[collector].gettag()+'\n\t\t\t\tSKIP '+taskcollectors[collector].getskip()+'\n\t\t\t\tFORMAT '+taskcollectors[collector].getformat()+'\n\t\t\t\tFILE '+taskcollectors[collector].getfile()+'\n\t\t\t\tALERT '+taskcollectors[collector].getalert())
        return prettydaemons

    def addDaemon(self,name):
        self.daemons[name]=daemon(self.EntityManager,name)
        
    def isDaemon(self,name):
        try:
            self.daemons[name]
            return 1
        except KeyError:
            return 0

    def setdaemonschedule(self,name,begin,end,period):
        self.daemons[name].setschedule(begin,end,period)

    def deleteDaemon(self,name):
        del self.daemons[name]

    def addTask(self,daemon,task,command):
        self.daemons[daemon].addtask(task,command)

    def updateTask(self,daemon,task,command):
        self.daemons[daemon].gettask(task).setcommand(command)

    def deleteTask(self,daemon,task):
        self.daemons[daemon].removetask(task)

    def addCollector(self,daemon,task,collector,tag,skip,format,file):
        self.daemons[daemon].addtaskcollector(task,collector,tag,skip,format,file)

    def deleteCollector(self,daemon,task,collector):
        self.daemons[daemon].removetaskcollector(task,collector)

    def subscribeEntity(self,daemon,task,entity):
        self.daemons[daemon].addtaskentity(task,self.EntityManager.getEntity(entity))

    def unsubscribeEntity(self,daemon,task,entity):
        self.daemons[daemon].removetaskentity(task,self.EntityManager.getEntity(entity))

    def addAlert(self,daemon,task,collector,minval,maxval,message):
        self.daemons[daemon].addtaskcollectoralert(task,collector,minval,maxval,message)

    def makeLive(self,daemon):
        self.Scheduler.addPeriodicAction(float(self.daemons[daemon].getschedule().getstart()),int(self.daemons[daemon].getschedule().getperiod()),self.daemons[daemon],daemon)
        self.activedaemons[daemon]='Active'

    def killDaemon(self,daemon):
        del self.activedaemons[daemon]
        self.Scheduler.unregisterTask(daemon)

    def getdaemondefines(self):
        definelist=[]
        for daemon in self.daemons:
            definelist.append('define daemon '+daemon)
        return definelist

    def getscheduledefines(self):
        definelist=[]
        for daemon in self.daemons:
            schedule=self.daemons[daemon].getschedule()
            definelist.append('define schedule '+daemon+' '+str(schedule.getstart())+' '+str(schedule.getend())+' '+str(schedule.getperiod()))
        return definelist

    def gettaskdefines(self):
        definelist=[]
        for daemon in self.daemons:
            tasks=self.daemons[daemon].gettasks()
            for task in tasks:
                command=tasks[task].getcommand()
                definelist.append('define task '+daemon+' '+task+' '+utils.listtostring(command))
        return definelist

    def getcollectordefines(self):
        definelist=[]
        for daemon in self.daemons:
            tasks=self.daemons[daemon].gettasks()
            for task in tasks:
                collectors=tasks[task].getcollectors()
                for collector in collectors:
                    definelist.append('define collector '+daemon+' '+task+' '+collector+' '+collectors[collector].tostring())
        return definelist

    def getalertdefines(self):
        definelist=[]
        for daemon in self.daemons:
            tasks=self.daemons[daemon].gettasks()
            for task in tasks:
                collectors=tasks[task].getcollectors()
                for collector in collectors:
                    definelist.append('define alert '+daemon+' '+task+' '+collector+' '+collectors[collector].getalert())
        return definelist
            

    def getsubscriberdefines(self):
        definelist=[]
        for daemon in self.daemons:
            tasks=self.daemons[daemon].gettasks()
            for task in tasks:
                entities=tasks[task].getentities()
                for entity in entities:
                    definelist.append('subscribe entity '+daemon+' '+task+' '+entity)
        return definelist

    def getactivatedefines(self):
        definelist=[]
        for active in self.activedaemons:
            definelist.append('activate daemon '+active)
        return definelist

    def getDaemons(self):
        return self.daemons

    def getDaemon(self,name):
        return self.daemons[name]


###########
# START OF FatController FUNCTIONS
#

def cmdreport(msg):
    if Opts.has_key('VERBOSE') and Opts['VERBOSE']=='yes':
	print msg
	print

def showalertqueue():
    print '\nCurrent alerts:-'
    for alert in AlertQueue:
	print '\nAlert '+alert+'\n.....'+AlertQueue[alert]
    print
    print
    
def showactivedaemons():
    print '\nCurrently active daemons:-'
    print
    for active in DaemonManager.getactivedaemons():
	print 'Daemon '+active
    print
    print
    
def showdaemons():
    outlines=DaemonManager.getprettydaemons()
    print '\nCurrently defined daemons/tasks/schedules and associated entities:-'
    for line in outlines:
        print line
    print
    #print
	     
def createdaemon(name):
    DaemonManager.addDaemon(name)
    print '\nDaemon\n\t'+name+'\nDefined.\n\n'
def removedaemon(name):
    DaemonManager.deleteDaemon(name)
    cmdreport('\Daemon\n\t'+name+'\nDeleted.')

def scheduledaemon(name,begin,end,period):
    DaemonManager.setdaemonschedule(name,begin,end,period)
    cmdreport('\nSchedule for daemon '+name+'\n\tBegin='+begin+' end='+end+' period='+period+'\nSet.')
	
def adddaemontask(daemonname,taskname,command):
    DaemonManager.addTask(daemonname,taskname,command)
    cmdreport('\nTask '+taskname+' for daemon '+daemonname+'\n\t'+utils.listtostring(command)+'\nDefined.')

def removedaemontask(daemonname,taskname):
    DaemonManager.deleteTask(daemonname,taskname)
    cmdreport('\nDaemon '+daemonname+'\n\tTask '+taskname+'\nDeleted.')

def adddaemontaskcollector(daemonname,taskname,collectorname,tag,skip,format,file):
    DaemonManager.addCollector(daemonname,taskname,collectorname,tag,skip,format,file)
    cmdreport('\nCollector '+collectorname+' for task '+taskname+' owned by daemon '+daemonname+'\n\tDatatag '+tag+' Skip '+skip+' Format '+format+' File '+file+'\nDefined.')

def removedaemontaskcollector(daemonname,taskname,collectorname):
    DaemonManager.deleteCollector(daemonname,taskname,collectorname)
    cmdreport('\nDaemon '+daemonname+' task '+taskname+'\n\tCollector '+collectorname+'\nDeleted.')

def adddaemontaskentity(daemonname,taskname,entityname):
    DaemonManager.subscribeEntity(daemonname,taskname,entityname)
    cmdreport('\nDaemon '+daemonname+' task '+taskname+'\n\tEntity '+entityname+'\nSubscribed.')

def removedaemontaskentity(daemonname,taskname,entityname):
    DaemonManager.unsubscribeEntity(daemonname,taskname,entityname)
    cmdreport('Daemon '+daemonname+' task '+taskname+'\n\tEntity '+entityname+'\nDeleted.')

def adddaemontaskcollectoralert(daemonname,taskname,collectorname,minval,maxval,textmessage):
    DaemonManager.addAlert(daemonname,taskname,collectorname,minval,maxval,textmessage)
    cmdreport('\nDaemon '+daemonname+' task '+taskname+' collector '+collectorname+'\n\t Alert '+str(minval)+' '+str(maxval)+' '+textmessage+'\nDefined.')

def makedaemonlive(daemonname):
    DBGBN='FCmakedaemonlive'
    dbg('Making daemon live.',DBGBN)
    #be carefull with the task naming here... what about removing from the middle of the list? will it pop() the same?
    #...and dont confuse scheduer tasks with daemon tasks...
    DaemonManager.makeLive(daemonname)
    cmdreport('\nDaemon\n\t'+daemonname+'\nActivated.')

def updatedaemontask(daemonname,taskname,command):
    DaemonManager.updateTask(daemonname,taskname,command)
    cmdreport('\nTask\n\t'+taskname+'\nUpdated.')

def killdaemon(daemonname):
    DBGBN='FCkilldaemon'
    DaemonManager.killDaemon(daemonname)
    cmdreport('\nDaemon\n\t'+daemonname+'\nDeactivated.')

def IsDaemon(daemonname):
    return DaemonManager.isDaemon(daemonname)

def getaliasdefines(AliasDict):
    DefinitionList=[]
    for a in AliasDict:
	DefinitionList.append('alias '+a+' '+utils.listtostring(AliasDict[a]))
    return DefinitionList

def getsubstitutedefines(SubstituteDict):
    DefinitionList=[]
    for s in SubstituteDict:
	DefinitionList.append('substitute '+s+' '+utils.listtostring(Substitutions[s]))
    return DefinitionList

def savelistaslineswithcr(Filename,AList,clobber=0):
    if clobber:
	SaveToFile=file(Filename,'w')
    else:
	SaveToFile=file(Filename,'a')
    for Line in AList:
	SaveToFile.write(Line+'\n')
    SaveToFile.close()

def savedata(pathandname):
    #save entities, then aliases, then options
    DBGBN='savedata'
    EntityDefinitionList=EntityManager.getdefines()
    AliasDefinitionList=getaliasdefines(Aliases)
    SubstituteDefinitionList=getsubstitutedefines(Substitutions)
    classoptionlists=EntityManager.getclassoptiondefines()
    dbg('classoptionlists is '+str(len(classoptionlists))+' elements',DBGBN)
    fatcontrolleroptionlist=getfatcontrolleroptiondefines()
    scriptdefinitions=getscriptdefines()
    #
    #This block saves daemons and activestates #############################
    daemondefines=DaemonManager.getdaemondefines() #FC function returns list
    scheduledefines=DaemonManager.getscheduledefines() #FC function returns a list
    taskdefines=DaemonManager.gettaskdefines() # FC function returns a list
    collectordefines=DaemonManager.getcollectordefines() #
    alertdefines=DaemonManager.getalertdefines()
    subscriptiondefines=DaemonManager.getsubscriberdefines() # FC function returns a list
    activates=DaemonManager.getactivatedefines() # FC Function returns a list
    ########################################################################
    #
    savelistaslineswithcr(pathandname,EntityDefinitionList,1)
    savelistaslineswithcr(pathandname,AliasDefinitionList,0)
    savelistaslineswithcr(pathandname,SubstituteDefinitionList,0)
    for optlist in classoptionlists:
	savelistaslineswithcr(pathandname,optlist,0)
    savelistaslineswithcr(pathandname,fatcontrolleroptionlist)
    savelistaslineswithcr(pathandname,daemondefines,0)
    savelistaslineswithcr(pathandname,scheduledefines,0)
    savelistaslineswithcr(pathandname,taskdefines,0)
    savelistaslineswithcr(pathandname,collectordefines,0)
    savelistaslineswithcr(pathandname,alertdefines,0)
    savelistaslineswithcr(pathandname,subscriptiondefines,0)
    savelistaslineswithcr(pathandname,scriptdefinitions,0)
    savelistaslineswithcr(pathandname,activates,0)

    
def save(WhatToSave,ProfileName):
    DBGBN='FCsave'
    if WhatToSave=='all':
	#DEVELOPR TOOLS MAKES THE SAVES INTO THE INSTALL PACKAGE
	# set FATCONTROLLER DEVELOPER yes
	# set FATCONTROLLER DEVELOPERPATH .....
	if Opts.has_key('DEVELOPER') and Opts['DEVELOPER']=='yes':
	    pathandname=Opts['DEVELOPERPATH']+ProfileName+'.sav'
	    savedata(pathandname)
	    pathandname=installroot+ProfileName+'.sav'
            dbg('FATCONTROLLER DEVELOPER is yes. Doing save to DEVELOPERPATH',DBGBN)
            dbg('-pathandname is '+pathandname,DBGBN)
	    savedata(pathandname)
	else:
	    pathandname=installroot+ProfileName+'.sav'
	    dbg('doing straight save. pathandname is '+pathandname,DBGBN)
	    savedata(pathandname)
	#
    else:
	print 'Error: Don\'t know how to save '+WhatToSave  +'.'
    cmdreport('\nSaved\n\t'+WhatToSave+'\nSuccesfully.')

def definealias(Name,List):
    Aliases[Name]=List
    cmdreport('\nAlias:\n\t'+Name+' '+utils.listtostring(List)+'\nDefined.')

def showaliases():
    print ''
    for a in Aliases:
	print a,'\t',utils.listtostring(Aliases[a])
    print ''

def delalias(AliasName):
    del Aliases[AliasName]
    cmdreport('\nAlias\n\t'+AliasName+'\nDeleted.')

def isalias(Name):
    try:
	Aliases[Name]
	return 1
    except KeyError:
	return 0

def inserttoscript(scriptname,linenumber,cmdtokens):
    linenumber=int(linenumber)
    cmdlist=Scripts[scriptname]
    lowerlist=cmdlist[:linenumber]
    lowerlist.append(utils.listtostring(cmdtokens))
    for ul in cmdlist[linenumber:]:
	lowerlist.append(ul)
    Scripts[scriptname]=lowerlist
    return 0

def delfromscript(scriptname,linenumber):
    print "NOT IMPLEMENTED"
    return 0

def appendtoscript(scriptname,cmdtokens):
    cmdstring=utils.listtostring(cmdtokens)
    if scriptname not in Scripts:
	Scripts[scriptname]=[]
	Scripts[scriptname].append(cmdstring)
    else:
	Scripts[scriptname].append(cmdstring)
    cmdreport('\nLine\n\t'+cmdstring+'\nAppended.')

def delscript(scriptname):
    if isScript(scriptname):
	del Scripts[scriptname]
	cmdreport('\nScript\n\t'+scriptname+'\nDeleted.')
    else:
	cmdreport('\nINFO:\tCould not find script '+scriptname+'\n')

def runscript(scriptname,parmlist):
    num=1
    for parmsub in parmlist:
	processcommand('sub '+str(num)+' '+parmsub)
	num=num+1
    cmdlist=Scripts[scriptname]
    for cmd in cmdlist:
	processcommand(cmd)
    num=1
    for parmsub in parmlist:
	processcommand('del sub '+str(num))
	num=num+1


def isScript(scriptname):
	if scriptname not in Scripts:
	    return 0
	else:
	    return 1

def showscripts(scriptname):
    DBGBN='showscripts'
    if scriptname=='all':
	scriptlist=Scripts.keys()
    else:
	scriptlist=[scriptname]
    for script in scriptlist:
	dbg('script '+script+' is in scriptlist to display',DBGBN)
    for script in scriptlist:
	print '\n\t'+script+'\n'
	ctr=1
	for cmds in Scripts[script]:
	    print str(ctr)+' : '+cmds
	    ctr=ctr+1
	print '\n'

def getscriptdefines():
    definelist=[]
    for scriptname in Scripts:
	for scriptline in Scripts[scriptname]:
	    definelist.append('addline '+scriptname+' '+scriptline)
    return definelist

def message(msg):
    print utils.listtostring(msg)
	    

def definesubstitution(SubName,SubList):
    Substitutions[SubName]=SubList
    cmdreport('\nSubstitution\n\t'+SubName+'\nDefined.')

def delsubstitution(SubName):
    del Substitutions[SubName]
    cmdreport('\nSubstitution\n\t'+SubName+'\nDeleted.')

def showsubstitutions():
    print ''
    for s in Substitutions:
	if len(s)<8:
	    tabs='\t\t'
	else:
	    tabs='\t'
	print s+tabs+utils.listtostring(Substitutions[s])
    print

def issubstitute(SubName):
    try:
	Substitutions[SubName]
	return 1
    except KeyError:
	return 0
	
def processsubstitutions(RawCmd):
    DBGBN='processsubstitutions'
    infprotect=1
    subhit=1
    while subhit==1:
	subhit=0
	for sub in Substitutions:
	    SubCheck=RawCmd
	    RawCmd=re.sub('~'+sub,utils.listtostring(Substitutions[sub]),RawCmd)
	    if SubCheck!=RawCmd:
		dbg('Made Substitution '+sub+' to get '+RawCmd,DBGBN)
		subhit=1
	infprotect=infprotect+1
	if infprotect>100:
	    return "ERROR: Infinitely deep substitution levels detected."
    return RawCmd

def displayhelp():
    helpfile=file(installroot+'FatController.hlp','r')
    for lines in helpfile:
	print lines#.strip()
    print '\n\nDefined Entities:-' 
    processcommand('show entities')
    print '\nAliases:-'
    processcommand('show aliases')
    print '\nSubstitutions:-'
    processcommand('show substitutions')
    processcommand('show options')
    processcommand('show daemons')
    processcommand('show active daemons')
    processcommand('show scripts')

def displayopts():
    print '\nCurrent Set Options:-\n'
    EntityManager.displayclassoptions()
    fcopts=getfatcontrolleroptiondefines()
    for d in fcopts:
	dl=d.split()
	d=' '.join(dl[1:])
	print d # twiddle becasue need to remove the set

def toggletrace(Fn):
    try:
	if TRACE[Fn]:
	    TRACE[Fn]=0
	    cmdreport('\nStop tracing block '+Fn+'\n')
	else:
	    TRACE[Fn]=1
	    cmdreport('\nStart tracing block '+Fn+'\n')
    except KeyError:
	TRACE[Fn]=1
	cmdreport('\nStart tracing block '+Fn+'\n')


def SetOption(EntityClass,Opt,Val):
    DBGBN='setoption'
    dbg('in setoption with '+EntityClass+' '+Opt+' '+Val,DBGBN)
    dbg('trapping FATCONTROLLER class.',DBGBN)
    if EntityClass=='FATCONTROLLER':
	dbg('Trapped OK',DBGBN)
	Opts[Opt]=Val
    else:
	EntityManager.SetClassOption(EntityClass,Opt,Val)
	cmdreport('\nOption\n\t'+EntityClass+' '+Opt+' '+Val+'\nHas been set.')

def getfatcontrolleroptiondefines():
    optlist=[]
    for opt in Opts:
	optlist.append('set FATCONTROLLER '+opt+' '+Opts[opt])
    return optlist


def processcommand(Command): #CODE PROBABLY NOT SAFE. USES EVAL()
    DBGBN='processcommand'
    dbg('Before Substitution: '+Command,DBGBN)
    Command=processsubstitutions(Command)  #  if ! aliascmd then flow is,  RawCmd->subbed->executed
			    # is IS aliascmd then flow is   RawCmd->Subbed->aliashit->subbed->executed
    dbg('After Substitution: '+Command,DBGBN)
    AliasHit=0
    CommandHit=0
    SplitCmd=Command.split()
    SplitLen=len(SplitCmd)
    Cmd=SplitCmd[0]
    InEtcRun=0
    Error=0
    CommandDefs=file(installroot+'FatControllerCommands.sav','r')
    for Def in CommandDefs:
	if Def!='ENDCOMMANDDEFS':
	    DefTokens=Def.split()
	    ctr=0
	    for Token in DefTokens:
		if re.search('input:',Token):
		    if SplitLen>ctr:
			ValidateExpression=Token.replace('input:','').replace('<<',SplitCmd[ctr])
		    else:
			Error=1
			ErrorText='Error: Missing parameter.'
			break
		    if not eval(ValidateExpression):##NOT SAFE NOT SAFE. Need to come up with entirely new
                                                    ##way to do all this
			Error=1
			ErrorText='Error: Parameter incorrect.'
			break
		elif re.search('create:',Token):
		    CreateExpression=Token.replace('create:','')
		elif Token!='+*':
		    if ctr>=SplitLen:
			Error=1
			ErrorText='Error: Bad command.'
			break
		    if Token!=SplitCmd[ctr]:
			Error=1
			ErrorText='Error: Bad command.'
			break
		ctr+=1
		CommandHit=1
	    else: #{EndOf for Token} all tokens found for else
		eval(CreateExpression)
		break
    else:   #{EndOf for Def} Check aliases
	for AliasName in Aliases:
	    if Cmd==AliasName: #then, make cmdstring alias cmd string and re-process
		AliasCmd=utils.listtostring(Aliases[AliasName])
		AliasHit=1
		dbg('Made alias hit to get '+AliasCmd,DBGBN)
		break
	else: #FOR loop else  not an alias, so try execute as last entity command
	    if not CommandHit:
		global LastExecutedEntity
		if LastExecutedEntity!='':
		    #global LastExecutedEntity
		    EntityManager.execute(LastExecutedEntity,SplitCmd[0:])
		else:
		    print '\nError: Dont know which entity to use.\n'
	    else:
		print '\nError: Bad command.\n'
	if AliasHit==1:
	    AliasHit=0
	    CommandDefs.close()
	    processcommand(AliasCmd)
    CommandDefs.close()
	    

def load(Profile):#will be load(profile)
    EntityManager=entitymanager()
    Aliases={}
    try:
        FileToLoad=file(installroot+Profile+'.sav')
        for Line in FileToLoad:
            processcommand(Line)
    except IOError,(errno,strerror):
        print "\nError: ["+str(errno)+"] "+strerror+"\n\t"+installroot+Profile+".sav\n"
    #makeObjectBrowser()

def handlealertrange(fromalert,toalert):
    for item in range(fromalert,toalert+1):
	try:
	    del AlertQueue[str(item)]
	except KeyError:
	    print "\nINFO:\tCould not find alert "+str(item)+"\n"
    cmdreport("\nAlerts handled.\n")
	




    
##################
# START OF __main__()
#
def main():        
    #processcommand('trace scheduledtaskhandler__init__')
    #processcommand('trace threadedscheduler__init__')
    #processcommand('trace threadedscheduleraddperiodicaction')
    #processcommand('trace daemonruntasks')
    #processcommand('trace scheduledtask_run')
    #processcommand('trace entitymanagerscheduledexecute')
    #processcommand('trace tsmexecute')
    #processcommand('trace entitymanagergetclassoptiondefines')
    #processcommand('trace savedata')
    #processcommand('trace FCsave')
    #processcommand('trace threadedschedulerunregistertask')
    #processcommand('trace daemoncollectorread')
    #processcommand('trace tsmexecute')
    #processcommand('trace entitymanagerexecute')
    #processcommand('set FATCONTROLLER VERBOSE yes')
    #processcommand('trace tsmgetoptions')
    #processcommand('trace tsmsetoption')
    #processcommand('trace entitymanagersetclassoption')
    #processcommand('trace entitymanagergetdefines')
    #processcommand('trace localgetparameterstring')
    #processcommand('trace telnetexecute')
    #processcommand('trace telnetopenconnection')
    #processcommand('trace objectbrowserclick')
    #processcommand('trace ALL')
    processcommand('load general')
    print startmessage 
    while 1:
	if len(AlertQueue)>0:
	    prompt='\nFC:*:'+LastExecutedEntity+'> '
	else:
	    prompt='\nFC:'+LastExecutedEntity+'> '
	UserCmd=raw_input(prompt)
	if UserCmd!='':
	    processcommand(UserCmd)
#
# END OF  __main__
###################

###########
# Some POSIX / winos setups
#
# Sets up disk 'root', point where all filenames
# for collector output etc.. are generated from.
# will make configurable option at some point...

if os.name=='posix':
    system='UNIX'
    installroot='/opt/yab/FatController/'
    copycmd='cp'
    driveroot=installroot
else:
    system='WINDOWS'
    installroot='c:\\program files\\yab\\FatController\\'
    copycmd='copy'
    driveroot='c:\\'
#
#
#####################

###############################################################################################################################################################################################################################################################################################################################
# START OF FATCONTROLLER GLOBALS
#
EntityManager=entitymanager()
Aliases={}  #Dictionary of aliasname/command 
Substitutions={}
Scripts={}
TRACE={}
FCScheduler=ThreadedScheduler()
FCScheduler.start()
DaemonManager=daemonmanager(EntityManager,FCScheduler)
#Daemons={}
#ActiveDaemons={}
AlertQueue={} # name:alerttext
Opts={}
LastExecutedEntity=''

startmessage='\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\
\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\n\
FatController v1f8r1a.\n'

GUIPaths={} #GUI paths plaintext->guipath
GUIObjects={} #GUIPath->object

#
# END OF FATCONTROLLER GLOBALS
###############################################################################################################################################################################################################################################################################################################################

#
#   G U I  S T U F F
#

#All terribly done. First time I ever used TK!
'''
OutputPane=None
ObjectPane=None
UserPane=None
DetailPane=None
ObjectBrowser=None
ConfigWidgets={}

#
#   What happens when 'entities' heading is clicke din ObjectBrowser
#

def clearconfigwdgets():
    global ConfigWdigets
    for button in ConfigWidgets:
        ConfigWidgets[button].destroy()
    ConfigWidgets.clear()
    return

def tasklistselection(taskname): #called when the tasks listbox has a choice made
    global ConfigWidgets, Daemons
    daemon=ConfigWidgets["dmname_val"].get()
    command=utils.listtostring(Daemons[daemon].gettask(taskname).getcommand())
    ConfigWidgets["taskcommand_val"].set(command)
    return

def ObjectBrowserClick(path):
    global GUIPaths, GUIObjects,DetailPane,ConfigWidgets, DaemonManager
    DBGBN='objectbrowserclick'
    for xpath in GUIPaths:
        if GUIPaths[xpath]==path:
            newpath=xpath
            break
    pathtokens=newpath.split(":")
    dbg("Path is "+newpath,DBGBN)    
    root=pathtokens[0]
    for button in ConfigWidgets:
        try:
            ConfigWidgets[button].destroy()
        except AttributeError:
            pass
    ConfigWidgets.clear()
    if root=="entities" and len(pathtokens)>2:
        entity=GUIObjects[newpath]
        parmlist=entity.getparameterdefs() ###first element MUST be name
        parmvals=[entity.getname()]+entity.getparameterlist()
        parmtuples=zip(parmlist,parmvals)
        for parm in parmtuples:
            ConfigWidgets[parm[0]]=Tix.LabelEntry(DetailPane,label=parm[0])
            ConfigWidgets[parm[0]+"_val"]=StringVar()
            ConfigWidgets[parm[0]].entry["textvariable"]=ConfigWidgets[parm[0]+"_val"]
            ConfigWidgets[parm[0]+"_val"].set(str(parm[1]))
            ConfigWidgets[parm[0]].pack(side="top",expand=1,fill="x")
    elif root=="daemons":
        #build   .. really really need to make a daemonmanager class
        ConfigWidgets["dmnname"]=Tix.LabelEntry(DetailPane,label="Name")
        ConfigWidgets["schedslice"]=Tix.Frame(DetailPane)
        ConfigWidgets["schedstart"]=Tix.LabelEntry(ConfigWidgets["schedslice"],label="Str")
        ConfigWidgets["schedstop"]=Tix.LabelEntry(ConfigWidgets["schedslice"],label="Stp")
        ConfigWidgets["schedper"]=Tix.LabelEntry(ConfigWidgets["schedslice"],label="Per")
        
        ConfigWidgets["taskcomboslice"]=Tix.Frame(DetailPane)
        #ConfigWidgets["taskcomboscrollbar"]=Scrollbar(ConfigWidgets["taskcomboslice"],orient='vertical')
        #ConfigWidgets["taskcombolabel"]=Label(ConfigWidgets["taskcomboslice"],text="Task")
        ConfigWidgets["taskcombo"]=Tix.ComboBox(ConfigWidgets["taskcomboslice"],label="Tasks",editable="yes",command=tasklistselection)
        #ConfigWidgets["taskcomboscrollbar"].config(command=ConfigWidgets["taskcombo"].yview)
        
        ConfigWidgets["taskcommand"]=Tix.Entry(DetailPane)

        ConfigWidgets["taskeditslice"]=Tix.Frame(DetailPane)
        ConfigWidgets["taskeditaddbutton"]=Tix.Button(ConfigWidgets["taskeditslice"],text="Add")
        ConfigWidgets["taskeditrembutton"]=Tix.Button(ConfigWidgets["taskeditslice"],text="Remove")
        ConfigWidgets["taskeditupdbutton"]=Tix.Button(ConfigWidgets["taskeditslice"],text="Update")
        ConfigWidgets["taskeditnamebox"]=Tix.Entry(ConfigWidgets["taskeditslice"])

        ConfigWidgets["subscribercombo"]=Tix.ComboBox(DetailPane,label="Subscribers")
        ConfigWidgets["subseditslice"]=Tix.Frame(DetailPane)
        ConfigWidgets["subseditaddbutton"]=Tix.Button(ConfigWidgets["subseditslice"],text="Add")
        ConfigWidgets["subseditrembutton"]=Tix.Button(ConfigWidgets["subseditslice"],text="Remove")
        ConfigWidgets["subseditnamebox"]=Tix.Entry(ConfigWidgets["subseditslice"])
        ConfigWidgets["collectorcombo"]=Tix.ComboBox(DetailPane,label="Collectors")
        ConfigWidgets["tag"]=Tix.LabelEntry(DetailPane,label="Tag")
        ConfigWidgets["skip"]=Tix.LabelEntry(DetailPane,label="Skip")
        ConfigWidgets["format"]=Tix.LabelEntry(DetailPane,label="Format")
        ConfigWidgets["outfile"]=Tix.LabelEntry(DetailPane,label="File")
        ConfigWidgets["alertmin"]=Tix.LabelEntry(DetailPane,label="Min")
        ConfigWidgets["alertmax"]=Tix.LabelEntry(DetailPane,label="Max")
        ConfigWidgets["alertmsg"]=Tix.LabelEntry(DetailPane,label="Msg")
        ConfigWidgets["colleditslice"]=Tix.Frame(DetailPane)
        ConfigWidgets["colleditaddbutton"]=Tix.Button(ConfigWidgets["colleditslice"],text="Add")
        ConfigWidgets["colleditrembutton"]=Tix.Button(ConfigWidgets["colleditslice"],text="Remove")
        ConfigWidgets["colleditupdbutton"]=Tix.Button(ConfigWidgets["colleditslice"],text="Update")
        ConfigWidgets["colleditnamebox"]=Tix.Entry(ConfigWidgets["colleditslice"])
        #pack
        ConfigWidgets["dmnname"].pack(fill="both",expand=1)
        ConfigWidgets["schedstart"].pack(side="left",fill="both",expand=1)
        ConfigWidgets["schedstop"].pack(side="left",fill="both",expand=1)
        ConfigWidgets["schedper"].pack(side="left",fill="both",expand=1)
        ConfigWidgets["schedslice"].pack(fill="both",expand=1)

        ConfigWidgets["taskcomboslice"].pack(fill="both",expand=1)
        #ConfigWidgets["taskcombolabel"].pack(side="left",expand=1)
        #ConfigWidgets["taskcomboscrollbar"].pack(side="right",fill="y",expand=1)
        ConfigWidgets["taskcombo"].pack(side="left",fill="both",expand=1)

        ConfigWidgets["taskcommand"].pack(fill="x",expand=1)
        ConfigWidgets["taskeditaddbutton"].pack(side="left",fill="both",expand=1)
        ConfigWidgets["taskeditrembutton"].pack(side="left",fill="both",expand=1)
        ConfigWidgets["taskeditupdbutton"].pack(side="left",fill="both",expand=1)
        ConfigWidgets["taskeditnamebox"].pack(side="left",fill="both",expand=1)
        ConfigWidgets["taskeditslice"].pack(fill="both",expand=1)
        ConfigWidgets["subscribercombo"].pack(fill="x",expand=1)
        ConfigWidgets["subseditaddbutton"].pack(side="left",fill="both",expand=1)
        ConfigWidgets["subseditrembutton"].pack(side="left",fill="both",expand=1)
        ConfigWidgets["subseditnamebox"].pack(side="left",fill="both",expand=1)
        ConfigWidgets["subseditslice"].pack(fill="both",expand=1)
        ConfigWidgets["collectorcombo"].pack(fill="x",expand=1)
        ConfigWidgets["colleditaddbutton"].pack(side="left",fill="both",expand=1)
        ConfigWidgets["colleditrembutton"].pack(side="left",fill="both",expand=1)
        ConfigWidgets["colleditupdbutton"].pack(side="left",fill="both",expand=1)
        ConfigWidgets["colleditnamebox"].pack(side="left",fill="both",expand=1)
        ConfigWidgets["colleditslice"].pack(fill="both",expand=1)
        ConfigWidgets["tag"].pack(fill="both",expand=1)
        ConfigWidgets["skip"].pack(fill="both",expand=1)
        ConfigWidgets["format"].pack(fill="both",expand=1)
        ConfigWidgets["outfile"].pack(fill="both",expand=1)
        ConfigWidgets["alertmin"].pack(fill="both",expand=1)
        ConfigWidgets["alertmax"].pack(fill="both",expand=1)
        ConfigWidgets["alertmsg"].pack(fill="both",expand=1)
        #populate (if len(path.split(":"))>=2)
        if len(pathtokens)>1:
            daemonname=pathtokens[1]
            #make the special 'linked' variable to hold the text
            ConfigWidgets["dmname_val"]=StringVar()
            ConfigWidgets["dmnname"].entry["textvariable"]=ConfigWidgets["dmname_val"]
            ConfigWidgets["dmname_val"].set(daemonname)

            ConfigWidgets["schedstart_val"]=IntVar()
            ConfigWidgets["schedstop_val"]=IntVar()
            ConfigWidgets["schedper_val"]=IntVar()
            
            ConfigWidgets["schedstart"].entry["textvariable"]=ConfigWidgets["schedstart_val"]
            ConfigWidgets["schedstop"].entry["textvariable"]=ConfigWidgets["schedstop_val"]
            ConfigWidgets["schedper"].entry["textvariable"]=ConfigWidgets["schedper_val"]
            ConfigWidgets["schedstart_val"].set(DaemonManager.getDaemon(daemonname).getschedule().getstart())
            ConfigWidgets["schedstop_val"].set(DaemonManager.getDaemon(daemonname).getschedule().getend())
            ConfigWidgets["schedper_val"].set(DaemonManager.getDaemon(daemonname).getschedule().getperiod())

            #add the task list values to the widget
            tasks=DaemonManager.getDaemon(daemonname).gettasks()
            for task in tasks:
                ConfigWidgets["taskcombo"].subwidget('listbox').insert(0,task)

            ConfigWidgets["taskcommand_val"]=StringVar()
            ConfigWidgets["taskcommand"]["textvariable"]=ConfigWidgets["taskcommand_val"]
            ConfigWidgets["taskcommand_val"].set(' ')
                
            
            
            
        

def makeObjectBrowser():
    
    global ObjectPane,ObjectBrowser,EntityManager,DaemonManager,Substitutions,Scripts,GUIPaths
    
    if ObjectBrowser!=None:
        ObjectBrowser.destroy()
    ObjectBrowser=Tix.Tree(ObjectPane,options='separator ":"',command=ObjectBrowserClick)
    
    GUIPaths["entities:"]=ObjectBrowser.hlist.add("entities",text="Entities",itemtype="text")
    GUIPaths["daemons:"]=ObjectBrowser.hlist.add("daemons",text="Daemons",itemtype="text")

    #
    #Build the entities section
    #
    
    etypes=EntityManager.getentitytypes()
    for etype in etypes:
        GUIPaths["entities:"+etype]=ObjectBrowser.hlist.add_child("entities",text=etype,itemtype="text")
    entities=EntityManager.getentitylist() # dict of entities    
    for entity in entities:
        ent=entities[entity]
        ename=ent.getname()
        etype=ent.getentitytype()
        GUIPaths["entities:"+etype+":"+ename]=ObjectBrowser.hlist.add_child(GUIPaths["entities:"+etype],text=ename,itemtype="text")
        GUIObjects["entities:"+etype+":"+ename]=entities[entity]

        #
        #Build Daemons sections
        #
        
    for daemon in DaemonManager.getDaemons():
        GUIPaths["daemons:"+daemon]=ObjectBrowser.hlist.add_child(GUIPaths["daemons:"],text=daemon,itemtype="text")
        GUIObjects["daemons:"+daemon]=DaemonManager.getDaemon(daemon)#Daemons[daemon]
        #schedule=Daemons[daemon].getschedule().tostring()
        #GUIPaths["daemons:"+daemon+":schedule"]=ObjectBrowser.hlist.add_child(GUIPaths["daemons:"+daemon],text=schedule,itemtype="text")
        #tasks=Daemons[daemon].gettasks()

        #
        #Tasks
        #
        
        #for task in tasks:
            #GUIPaths["daemons:"+daemon+":schedule:"+task]=ObjectBrowser.hlist.add_child(GUIPaths["daemons:"+daemon+":schedule"],text=task,itemtype="text")
            #subscribers=tasks[task].getsubscribers()
            #GUIPaths["daemons:"+daemon+":schedule:"+task+":subscribers"]=ObjectBrowser.hlist.add_child(GUIPaths["daemons:"+daemon+":schedule:"+task],text="Subscribers",itemtype="text")

            #
            #Subscribers
            #
            
            #for subscriber in subscribers:
                #GUIPaths["daemons:"+daemon+":schedule:"+task+":subscribers:"+subscriber]=ObjectBrowser.hlist.add_child(GUIPaths["daemons:"+daemon+":schedule:"+task+":subscribers"],text=subscriber,itemtype="text")
            #GUIPaths["daemons:"+daemon+":schedule:"+task+":collectors"]=ObjectBrowser.hlist.add_child(GUIPaths["daemons:"+daemon+":schedule:"+task],text="Collectors",itemtype="text")
            #collectors=tasks[task].getcollectors()

            #
            #Collectors
            #
            
            #for collector in collectors:
                #GUIPaths["daemons:"+daemon+":schedule:"+task+":collectors:"+collector]=\
                            #ObjectBrowser.hlist.add_child(\
                                #GUIPaths["daemons:"+daemon+":schedule:"+task+":collectors"],\
                                #text=collector,\
                                #itemtype="text")                
    ObjectBrowser.autosetmode()
    ObjectBrowser.pack(fill="both",expand=1)

            
#DRAWIT
    
FCRootWindow=Tix.Tk()
FCRootFrame=Tix.Frame(FCRootWindow,width=650,height=500)
FCRootFrame.master.title('T-Light FatController v1f6r1a')
FCRootFrame.pack(fill="both",expand=1)

#splits the window into left/right
SplitPane1=PanedWindow(FCRootFrame,orient="horizontal")
SplitPane1.pack(fill="both",expand=1)

LeftSplitPane1=Tix.Frame()
LeftSplitPane1.configure(width=450,height=500,bg="white")
LeftSplitPane1.pack(fill="both",expand=1)

RightSplitPane1=Tix.Frame()
RightSplitPane1.configure(width=200,height=500,bg="white")
RightSplitPane1.pack(fill="both",expand=1)

SplitPane1.add(LeftSplitPane1)
SplitPane1.add(RightSplitPane1)

#splits the left half into top/bottom
SplitPane2=PanedWindow(LeftSplitPane1,orient="vertical")
SplitPane2.pack(fill="both",expand=1)

TopSplitPane2=Tix.Frame()
TopSplitPane2.configure(width=450,height=300)
TopSplitPane2.pack(fill="both",expand=1)

BotSplitPane2=Tix.Frame()
BotSplitPane2.configure(width=450,height=200)
BotSplitPane2.pack(fill="both",expand=1)

SplitPane2.add(TopSplitPane2)
SplitPane2.add(BotSplitPane2)

#splits the right half into top/bottom
SplitPane3=PanedWindow(RightSplitPane1,orient="vertical")
SplitPane3.pack(fill="both",expand=1)

TopSplitPane3=Tix.Frame()
TopSplitPane3.configure(width=200,height=300)
TopSplitPane3.pack(fill="both",expand=1)

BotSplitPane3=Tix.Frame()
BotSplitPane3.configure(width=200,height=200)
BotSplitPane3.pack(fill="both",expand=1)

SplitPane3.add(TopSplitPane3)
SplitPane3.add(BotSplitPane3)

#Name our usable panes.
OutputPane=TopSplitPane2
ObjectPane=TopSplitPane3
UserPane=BotSplitPane2
DetailPane=BotSplitPane3
'''
##
############################################################

#                           G O !!

###########################################################
###########################################################
main()
