grammar Expr;

options {
	language=Python;
	output=AST;
	ASTLabelType=CommonTree;
}

tokens	{ NUM; NAME; FUNCALL; STRING; RELREF; ME; NEG; INDEX; ARITHSEQ2; ARITHSEQ3; }

// This next section tells antlr's generated code not to catch errors

@lexer::members {
def reportError(self, e):
   raise e
}
@members {
def mismatch(self, input, ttype, follow):
    raise MismatchedTokenException(ttype, input)

def recoverFromMismatchedSet(self, input, e, follow):
    raise e
}
@rulecatch {
except RecognitionException, e:
    raise
}

expr_all	:	expr SPACE* EOF -> expr;

expr	:	whereExpr;

whereExpr	:	seqExpr (SPACE* WHERE^ seqExpr)?;

seqExpr	:	(orExpr -> orExpr) 
		        ((SPACE* DOT DOT orExpr -> ^(ARITHSEQ2 $seqExpr orExpr))
		        |(SPACE* COMMA orExpr SPACE* DOT DOT orExpr -> ^(ARITHSEQ3 $seqExpr orExpr orExpr))
		        )?;

orExpr	:	andExpr (SPACE* OR^ andExpr)*;

andExpr	:	compExpr (SPACE* AND^ compExpr)*;

compExpr	:	addExpr (SPACE* (LESSTHAN^|GRTHAN^|LESSTHANEQ^|GRTHANEQ^|EQ^|NOTEQ^) addExpr)?;

addExpr	:	multExpr (SPACE* (PLUS^|MINUS^) multExpr)*;

multExpr	:	powExpr (SPACE* (ASTERISK^|SLASH^) powExpr)* ;

powExpr	:	negExpr (SPACE* CARROT^ powExpr)?; 	

negExpr	:	SPACE* MINUS lookOrFun -> ^(NEG lookOrFun)
	|	lookOrFun;

lookOrFun	:  	(atom -> atom) (
			    (SPACE* COLON atom -> ^(COLON $lookOrFun atom))
                                                                           |(SPACE* DOT atom -> ^(DOT $lookOrFun atom)) 
			   |(SPACE* LPAREN (orExpr (SPACE* COMMA orExpr)*)? SPACE* RPAREN -> ^(FUNCALL $lookOrFun orExpr*))
			   |(SPACE* LBRACKET expr RBRACKET -> ^(INDEX $lookOrFun expr))
			   )*;

atom	:	SPACE* numrex -> ^(NUM numrex)
	|	SPACE* name -> ^(NAME name)
	|	paren_expr
	|	SPACE* STRINGREX -> ^(STRING STRINGREX)
	;

name	:	NAMEREX (SPACE? (NAMEREX|numrex))*;

paren_expr	:	SPACE* LPAREN expr SPACE* RPAREN -> expr ;

numrex	:	DIGITS (DOT DIGITS)?;

LESSTHAN	:	'<';
GRTHAN	:	'>';
LESSTHANEQ	:	'<=';
GRTHANEQ	:	'>=';
EQ	:	'=';
NOTEQ	:	'!=';
PLUS	:	'+' ;
MINUS	:	'-' ;
ASTERISK	:	'*' ;
SLASH	:	'/' ;
CARROT	:	'^' ;
COLON	:	':' ;
DOT	:	'.' ;
LPAREN	:	'(' ;
RPAREN	:	')' ;
LBRACKET	:	'[';
RBRACKET	:	']';
COMMA	:	',' ;
AND	:	'and';
OR	:	'or';
WHERE	:	'where';
NAMEREX	:	('a'..'z'|'A'..'Z'|'_') ('a'..'z'|'A'..'Z'|'?'|'0'..'9'|'_')* ;
DIGITS	:	('0'..'9')+;
STRINGREX	:	'"' (STRINGESC | ~('\\'|'"') )* '"';
fragment
STRINGESC	:	'\\' ('\"'|'\''|'\\') ;
SPACE	:	' ';
// Only allow spaces for now
//WS	:	(' '|'\t'|'\n'|'\r')+ {self.skip()} ;
