# Copyright 2009 Ben Escoto
#
# This file is part of Explicans.

# Explicans is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.

# Explicans is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.

# You should have received a copy of the GNU General Public License
# along with Explicans.  If not, see <http://www.gnu.org/licenses/>.

import types, sys, code, time
from PyQt4 import QtGui, QtCore
import program, gui, stylesheets, lazyarray, eval, objects, extable

prog_str = """
Reference,Name,Formula
"()",, "array(4)"
"(0)", a, 5
"(1)", b, 7
"(2)", c, "a+b"
"(3)", d, "table(3,3)"
""" # this is a very simple but complete Explicans program
prog = program.Program(prog_str)

def LA_to_GuiCellList(prog, exa, abs_ref = program.AbsoluteReference(())):
    """Recursively build a list of GuiCell objects from given ExArray"""
    def exobj_to_string(exo):
        assert isinstance(exo, objects.ExObject)
        if exo.isblank().obj: return ''
        return str(exo.obj)

    assert isinstance(exa, objects.ExArray), exa
    results = []
    for index, (name, value) in enumerate(exa.obj.topairs()):
        print "**", index, name, value
        new_ar = abs_ref.append(index)
        try: form_str = prog[new_ar].form_str
        except KeyError: form_str = ''
        if isinstance(value, objects.ExArray):
            gc_val = LA_to_GuiCellList(prog, value, new_ar)
        elif isinstance(value, extable.ExTable):
            gc_val = gui.GuiTable(prog, value, new_ar)
        else: gc_val = exobj_to_string(value)
        gc = gui.GuiCell(exobj_to_string(name), form_str or '',
                         gc_val, 'tall', new_ar)
        try: gc.set_colform(prog.get_col_ps(new_ar))
        except KeyError: pass
        results.append(gc)
    return results


class MainWindow(QtGui.QMainWindow):
    """This class holds a program and repeated evaluates it as it changes

    For now, just reevaluate whole program on any change, destroy
    widget, and paint whole new one.
    """
    def __init__(self, initial_program):
        """Display the window and initial program, and start event loop"""
        QtGui.QMainWindow.__init__(self)
        self.createMenus()
        self.createScroll()
        self.prog = initial_program
        self.prog_results = self.get_prog_results()
        self.supervisor = self.get_gui(self.prog_results)
        self.setMainWidget(self.supervisor.get_main_widget())

    def get_prog_results(self):
        """Evaluate the program and return output"""
        exarray = eval.eval_prog(self.prog)
        print "$$$$", exarray.obj.totuple_recursive()
        return exarray

    def get_gui(self, prog_results):
        """Create gui Supervisor for given program results"""
        super = gui.Supervisor(self.valueChanged)
        root_gc_val = LA_to_GuiCellList(self.prog, prog_results)
        super.set_root(gui.GuiCell('', '', root_gc_val, 'wide',
                                   program.AbsoluteReference(()),
                                   include_col_form = False),
                       self.setMainWidget)
        super.root_gc.set_widget_table_recursive()
        self.connect(self.FlipAct, QtCore.SIGNAL("triggered()"),
                     super.flip_slot)
        return super

    def createScroll(self):
        """Create a scrollable viewing area"""
        self.scrollarea = QtGui.QScrollArea()
        self.scrollarea.setStyleSheet(stylesheets.background)
        self.scrollarea.setMinimumSize(200, 200)
        self.setCentralWidget(self.scrollarea)
        self.scrollarea.setWidgetResizable(True)

    def createMenus(self):
        """Initialize the Menus"""
        self.fileMenu = self.menuBar().addMenu(self.tr("&File"))
        self.FlipAct = QtGui.QAction(self.tr("&Flip"), self)
        self.exitAct = QtGui.QAction(self.tr("E&xit"), self)
        self.connect(self.exitAct, QtCore.SIGNAL("triggered()"),
                     QtCore.SLOT("close()"))
        self.fileMenu.addAction(self.FlipAct)
        self.fileMenu.addAction(self.exitAct)

    def setMainWidget(self, w):
        """Set the main display widget"""
        self.scrollarea.setWidget(w)

    def valueChanged(self, comptype, ar, text):
        try: propset = self.prog[ar]
        except KeyError:
            propset = program.PropertySet()
            self.prog[ar] = propset
        if comptype == 'name': propset.name = str(text) # QString -> string
        else:
            assert comptype == 'func', (comptype, ar, text)
            propset.set_formstr(str(text)) # must convert QString to string
        print "New Program:", str(self.prog)
        self.prog_results = self.get_prog_results()
        self.supervisor = self.get_gui(self.prog_results)
        self.setMainWidget(self.supervisor.get_main_widget())


if __name__ == '__main__':
    app = QtGui.QApplication(sys.argv)
    mainWin = MainWindow(prog)
    mainWin.show()
    sys.exit(app.exec_())
