/**CHeaderFile*************************************************************
  PackageName [versis]
  Synopsis    [Package 'versis' provides basic tools for formal
               verification of concurrent systems]

  FileName    [versisDecls.h]
  Revision    [$Revision: 76 $]
  Date        [$Date: 2013-04-26 14:26:09 +0200 (pet, 26 apr 2013) $]
  Authors     [Robert Meolic (meolic@uni-mb.si),
               Mirjam Sepesy Maucec (mirjam.sepesy@uni-mb.si),
               Tatjana Kapus (kapus@uni-mb.si)]
  Description [Generated by genStubs.tcl, see http://wiki.tcl.tk/3358]
  SeeAlso     [versis.h, versis.decls, versisStubInit.c, versisStubLib.c]

  Copyright   [This file is part of EST (Efficient Symbolic Tools).
               Copyright (C) 2003, 2013
               UM-FERI, Smetanova ulica 17, SI-2000 Maribor, Slovenia

               EST is free software; you can redistribute it and/or modify
               it under the terms of the GNU General Public License as
               published by the Free Software Foundation; either version 2
               of the License, or (at your option) any later version.

               EST is distributed in the hope that it will be useful,
               but WITHOUT ANY WARRANTY; without even the implied warranty of
               MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
               GNU General Public License for more details.

               You should have received a copy of the GNU General Public
               License along with this program; if not, write to the Free
               Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
               Boston, MA 02110-1301 USA.]
  ************************************************************************/

/* !BEGIN!: Do not edit below this line. */

/*
 * Exported function declarations: implemented in versis.h
 */

typedef struct VersisStubs {
    int magic;
    const struct VersisStubHooks *hooks;

    int *versis_status; /* 0 */
    void (*versis_InitPkg) (); /* 1 */
    void (*versis_ExitPkg) (); /* 2 */
    void (*versis_AboutPkg) (); /* 3 */
    void (*versis_Compose) (Est_String name, int type, Est_String process, Est_String actions, Est_Boolean onthefly); /* 4 */
    void (*versis_ComposeInit) (Est_String name); /* 5 */
    int (*versis_ComposeStep) (int numcomp, int N); /* 6 */
    void (*versis_ComposeFinish) (int numcomp); /* 7 */
    Est_Boolean (*versis_Equivalence) (int type, int par1, Est_String name1, int par2, Est_String name2); /* 8 */
    int (*versis_Minimization) (int type, int par, Est_String name); /* 9 */
    void (*versis_ChangeRename) (Est_String process, Est_String name1, Est_String name2); /* 10 */
    void (*versis_ChangeHide) (Est_String process, Est_String name1); /* 11 */
    void (*versis_ChangeForbid) (Est_String process, Est_String name1); /* 12 */
    Bdd_Edge (*versis_CheckDeadlock) (Bdd_Edge D); /* 13 */
    Bdd_Edge (*versis_CheckDivergence) (Bdd_Edge D, Bdd_Edge tau); /* 14 */
} VersisStubs;

#ifdef __cplusplus
extern "C" {
#endif
extern const VersisStubs *versisStubsPtr;
#ifdef __cplusplus
}
#endif

#if defined(USE_VERSIS_STUBS)

/*
 * Inline function declarations:
 */

#define versis_status \
	(*versisStubsPtr->versis_status) /* 0 */
#define Versis_InitPkg \
	(versisStubsPtr->versis_InitPkg) /* 1 */
#define Versis_ExitPkg \
	(versisStubsPtr->versis_ExitPkg) /* 2 */
#define Versis_AboutPkg \
	(versisStubsPtr->versis_AboutPkg) /* 3 */
#define Versis_Compose \
	(versisStubsPtr->versis_Compose) /* 4 */
#define Versis_ComposeInit \
	(versisStubsPtr->versis_ComposeInit) /* 5 */
#define Versis_ComposeStep \
	(versisStubsPtr->versis_ComposeStep) /* 6 */
#define Versis_ComposeFinish \
	(versisStubsPtr->versis_ComposeFinish) /* 7 */
#define Versis_Equivalence \
	(versisStubsPtr->versis_Equivalence) /* 8 */
#define Versis_Minimization \
	(versisStubsPtr->versis_Minimization) /* 9 */
#define Versis_ChangeRename \
	(versisStubsPtr->versis_ChangeRename) /* 10 */
#define Versis_ChangeHide \
	(versisStubsPtr->versis_ChangeHide) /* 11 */
#define Versis_ChangeForbid \
	(versisStubsPtr->versis_ChangeForbid) /* 12 */
#define Versis_CheckDeadlock \
	(versisStubsPtr->versis_CheckDeadlock) /* 13 */
#define Versis_CheckDivergence \
	(versisStubsPtr->versis_CheckDivergence) /* 14 */

#endif /* defined(USE_VERSIS_STUBS) */

/* !END!: Do not edit above this line. */
