/**CFile*******************************************************************
  PackageName [ccs]
  Synopsis    [Package 'ccs' provides an extended CCS parser.]

  FileName    [ccsParser.l]
  Revision    [$Revision: 76 $]
  Date        [$Date: 2013-04-26 14:26:09 +0200 (pet, 26 apr 2013) $]
  Authors     [Robert Meolic (meolic@uni-mb.si)]
  Description [File ccsParser.l is a flex file for CSS parser.]
  SeeAlso     [ccs.h, ccsInt.h, ccsParser.y]

  Copyright   [This file is part of EST (Efficient Symbolic Tools).
               Copyright (C) 2003, 2013
               UM-FERI, Smetanova ulica 17, SI-2000 Maribor, Slovenia

               EST is free software; you can redistribute it and/or modify
               it under the terms of the GNU General Public License as
               published by the Free Software Foundation; either version 2
               of the License, or (at your option) any later version.

               EST is distributed in the hope that it will be useful,
               but WITHOUT ANY WARRANTY; without even the implied warranty of
               MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
               GNU General Public License for more details.

               You should have received a copy of the GNU General Public
               License along with this program; if not, write to the Free
               Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
               Boston, MA 02110-1301 USA.]
  ************************************************************************/

PROCESS         agent|Agent|AGENT|process|Process|PROCESS
NET             net|Net|NET
CIRCUIT         circuit|Circuit|CIRCUIT
COMPOSITION     composition|Composition|COMPOSITION
ONTHEFLY        onthefly|OnTheFly|ONTHEFLY
RAW             raw|Raw|RAW
FULL            full|Full|FULL
TRACE           trace|Trace|TRACE
WEAK            weak|Weak|WEAK
STRONG          strong|Strong|STRONG
PROPERTY        property|Property|PROPERTY
AUTOMATON       automaton|Automaton|AUTOMATON
PRODUCT         product|Product|PRODUCT
TAU             tau[?!]*|Tau[?!]*|TAU[?!]*
NAME            [-_A-Za-z0-9][-_A-Za-z0-9]*
ACTION          {NAME}[?!]|[?!]{NAME}
FORMULA         ==[^;]*;

OUTLINE #.*
COMMENT --.*

%%
"/*" {
       int ch, inComm;
       for (inComm=1; inComm; ) {
          switch (ch=input()) {
            case '\n' : break;
            case '*'  : if (( ch=input()) == '/') {
                          inComm=0;
                        } else {
                          unput(ch);
                        }
                        break;
          }
       }
     }

[ \t\n\r] {/* empty space is ignored */}

"'" {/* qoutes are ignored */}

"\"" {/* qoutes are ignored */}

{PROCESS} {return PROCESS;}

{NET} {return NET;}

{CIRCUIT} {return CIRCUIT;}

{COMPOSITION} {return COMPOSITION;}

{ONTHEFLY} {return ONTHEFLY;}

{RAW} {return RAW;}

{FULL} {return FULL;}

{TRACE} {return TRACE;}

{WEAK} {return WEAK;}

{STRONG} {return STRONG;}

{PROPERTY} {return PROPERTY;}

{AUTOMATON} {return AUTOMATON;}

{PRODUCT} {return PRODUCT;}

{TAU} {
  yylval.word = strdup("TAU");
  return ACTION;
}

{NAME} {
  yylval.word = strdup(yytext);
  return NAME;
}

{ACTION} {
  yylval.word = strdup(yytext);
  return ACTION;
}

{FORMULA} {
  yylval.word = strdup(yytext);
  return FORMULA;
}

"|||" {return INTERLEAVE;}
"||" {return SYNCHRONOUS;}
"|" {return COMPOSE;}
"///" {return MULTIWAY;}
"//" {return COMPOSE;}
"|[" {return STARTPARTIAL;}
"]|" {return ENDPARTIAL;}

"." {return SEP;}
";" {return SEP;}

"=" {return yytext[0];}
"(" {return yytext[0];}
")" {return yytext[0];}
"+" {return yytext[0];}

"," {return yytext[0];}
"[" {return yytext[0];}
"]" {return yytext[0];}
"/" {return yytext[0];}
"\\" {return yytext[0];}

"@" {return yytext[0];}
"*" {return SYNPROD;}

{COMMENT} {};

{OUTLINE} {
  yylval.outline = strdup(yytext);
  return OUTLINE;
}

. {return UNKNOWN;}
%%
