/**CFile*******************************************************************
  PackageName [gui]
  Synopsis    [Package 'gui' is used to redirect output to GUI.]

  FileName    [guiMain.c]
  Revision    [$Revision: 50 $]
  Date        [$Date: 2012-04-11 15:32:59 +0200 (sre, 11 apr 2012) $]
  Authors     [Robert Meolic (meolic@uni-mb.si)]
  Description [File guiMain.c contains main functions.]
  SeeAlso     [gui.h, guiInt.h]

  Copyright   [This file is part of EST (Efficient Symbolic Tools).
               Copyright (C) 2003, 2012
               UM-FERI, Smetanova ulica 17, SI-2000 Maribor, Slovenia

               EST is free software; you can redistribute it and/or modify
               it under the terms of the GNU General Public License as
               published by the Free Software Foundation; either version 2
               of the License, or (at your option) any later version.

               EST is distributed in the hope that it will be useful,
               but WITHOUT ANY WARRANTY; without even the implied warranty of
               MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
               GNU General Public License for more details.

               You should have received a copy of the GNU General Public
               License along with this program; if not, write to the Free
               Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
               Boston, MA 02110-1301 USA.]
  ************************************************************************/

#ifdef USETHREADS
#include <pthread.h>
#include <sched.h>
#endif

#include "guiInt.h"

/*-----------------------------------------------------------------------*/
/* Constant declarations                                                 */
/*-----------------------------------------------------------------------*/

/*-----------------------------------------------------------------------*/
/* Variable declarations                                                 */
/*-----------------------------------------------------------------------*/

int gui_status = 0;                             /* initialization status */

#ifdef USETHREADS
pthread_mutex_t gui_mutex = PTHREAD_MUTEX_INITIALIZER;
#endif

/**AutomaticStart*********************************************************/

/*-----------------------------------------------------------------------*/
/* Static function prototypes                                            */
/*-----------------------------------------------------------------------*/

/**AutomaticEnd***********************************************************/

/*-----------------------------------------------------------------------*/
/* Definition of exported functions                                      */
/*-----------------------------------------------------------------------*/

/**Function****************************************************************
  Synopsis    []
  Description []
  SideEffects []
  SeeAlso     []
  ************************************************************************/

void
Gui_InitPkg()
{
  if (gui_status == 1) {
    printf("\nGUI package is already initialized. ");
    return;
  } else {
    gui_status = 1;
  }
}

/**Function****************************************************************
  Synopsis    []
  Description []
  SideEffects []
  SeeAlso     []
  ************************************************************************/

void
Gui_ExitPkg()
{
  if (gui_status == 0) {
    printf("\nGUI package is not initialized. ");
    return;
  } else {
    gui_status = 0;
  }
}

/**Function****************************************************************
  Synopsis    [Function Gui_AboutPkg]
  Description [Gui_AboutPkg reports type and version of GUI package.]
  SideEffects []
  SeeAlso     []
  ************************************************************************/

void
Gui_AboutPkg() {
  printf("EST ");
  printf(EDITION);
  printf(", version ");
  printf(VERSION);
  printf(", ");
  printf("GUI package");
  printf("\n");
}

/*-----------------------------------------------------------------------*/
/* Definition of internal functions                                      */
/*-----------------------------------------------------------------------*/

/*-----------------------------------------------------------------------*/
/* Definition of static functions                                        */
/*-----------------------------------------------------------------------*/
