/* *****************************************************************
Demo program to check installation.
****************************************************************** */

#include <bdd.h>
#include <pa.h>
#include <versis.h>
#include <mc.h>
#include <strucval.h>
#include <ccs.h>

static void concat(char **s1, const char *s2);

void hello() {
  printf("=======================================================================\n");
  printf("   Demo program from EST project.\n");
  printf("=======================================================================\n");
}

int main(int argc, char **argv)
{
  hello();

  Bdd_InitPkg();
  Pa_InitPkg();
  Versis_InitPkg();
  Mc_InitPkg();
  Strucval_InitPkg();
  Ccs_InitPkg();
 
  Bdd_AboutPkg();
  Pa_AboutPkg();
  Versis_AboutPkg();
  Mc_AboutPkg();
  Strucval_AboutPkg();
  Ccs_AboutPkg();

  Ccs_ExitPkg();
  Strucval_ExitPkg();
  Mc_ExitPkg();
  Versis_ExitPkg();
  Pa_ExitPkg();
  Bdd_ExitPkg();

  printf("Demo finished.\n");

  return(0);
}

/* ******************************************************* */
/* LOCAL FUNCTIONS - it is a good idea to make them static */
/* ******************************************************* */

static void
concat(char **s1, const char *s2)
{
   *s1 = (char*) realloc(*s1,strlen(*s1)+strlen(s2)+1);
   strcat(*s1,s2);
}
