macro(esp_generate_version_info ESPRESSO_VERSION ESPRESSO_TIMESTAMP) 
  execute_process( COMMAND sed -n "/^* /{s/.*\\(v[^[:space:]]*\\).*/\\1/p;q}" ${CMAKE_CURRENT_SOURCE_DIR}/RELEASE_NOTES OUTPUT_VARIABLE VERSION OUTPUT_STRIP_TRAILING_WHITESPACE)
  MESSAGE(STATUS "Found version ${VERSION}")
  SET(${ESPRESSO_VERSION} ${VERSION})
  execute_process( COMMAND sed -n "/^(/{s/^(...\\(.*\\)/\\1/p;q}" ${CMAKE_CURRENT_SOURCE_DIR}/RELEASE_NOTES OUTPUT_VARIABLE TIMESTAMP OUTPUT_STRIP_TRAILING_WHITESPACE)
  MESSAGE(STATUS "Last modified ${TIMESTAMP}")
  SET(${ESPRESSO_TIMESTAMP} ${TIMESTAMP})
endmacro(esp_generate_version_info ESPRESSO_VERSION ESPRESSO_TIMESTAMP) 
