/********************************************************************************
                               toolsuiteconfig.cpp
                               -------------------
           begin                : lun jui 14 19:50:56 CEST 2003
       copyright                : (C) 2003 by Thomas Silvi
           email                : thomas.silvi@laposte.net
*********************************************************************************/

/********************************************************************************
*                                                                               *
*   This file is part of the Escort Tools Suite program.                        *
*                                                                               *
*   Escort Tools Suite is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as published by        *
*   the Free Software Foundation; either version 2 of the License, or           *
*   (at your option) any later version.                                         *
*                                                                               *
*   Escort Tools Suite is distributed in the hope that it will be useful,       *
*   but WITHOUT ANY WARRANTY; without even the implied warranty of              *
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the               *
*   GNU General Public License for more details.                                *
*                                                                               *
*   You should have received a copy of the GNU General Public License           *
*   along with Escort Tools Suite; if not, write to the Free Software           *
*   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA   *
*                                                                               *
*********************************************************************************/

#include "ToolSuiteConfig.h"

ToolSuiteConfig::ToolSuiteConfig(KConfig *pConfig) :
	boolOptions(), stringOptions(), uintOptions()
{
	config = pConfig;

	config->setGroup("Startup");
	boolOptions["FillConnParamWithPGEnvVariable"] = 
		config->readBoolEntry("FillConnParamWithPGEnvVariable", true);
	boolOptions["FillLoginWithUnixLogin"] =
		config->readBoolEntry("FillLoginWithUnixLogin", true);
	boolOptions["FillConnParamWithLastActiveConnParam"] =
		config->readBoolEntry("FillConnParamWithLastActiveConnParam", true);

	config->setGroup("General");
	boolOptions["ShowToolBar"]= config->readBoolEntry("ShowToolBar", true);

	config->setGroup("QueryTool");
	boolOptions["AutoSwitchToResult"] =
		config->readBoolEntry("AutoSwitchToResult", true);
	stringOptions["DefaultWorkingDirectory"] =
		config->readEntry("DefaultWorkingDirectory", "~/tmp/");
	boolOptions["BatchExecutionContinueOnError"] =
		config->readBoolEntry("BatchExecutionContinueOnError", false);
	boolOptions["PromptForShowingResultsWithMoreThanNRows"] = 
		config->readBoolEntry("PromptForShowingResultsWithMoreThanNRows", true);
	uintOptions["NRows"] = config->readUnsignedNumEntry("NRows", 500);
	boolOptions["ClearNoticesOutput"] = config->readBoolEntry("ClearNoticesOutput", true);
	boolOptions["SameFileSaveLoad"]= config->readBoolEntry("SameFileSaveLoad", false);
	boolOptions["SetViewCfgWithCfgLastViewCreated"]= 
		config->readBoolEntry("SetViewCfgWithCfgLastViewCreated", false);


}

ToolSuiteConfig::~ToolSuiteConfig()
{
}

void ToolSuiteConfig::save()
{
	config->setGroup("Startup");

	config->writeEntry("FillConnParamWithPGEnvVariable",
		boolOptions["FillConnParamWithPGEnvVariable"]);
	config->writeEntry("FillLoginWithUnixLogin",
		boolOptions["FillLoginWithUnixLogin"]);
	config->writeEntry("FillConnParamWithLastActiveConnParam",
		boolOptions["FillConnParamWithLastActiveConnParam"]);

	config->setGroup("General");
	config->writeEntry("ShowToolBar", boolOptions["ShowToolBar"]);

	config->setGroup("QueryTool");
	config->writeEntry("AutoSwitchToResult",
		boolOptions["AutoSwitchToResult"]);
	config->writeEntry("DefaultWorkingDirectory",
		stringOptions["DefaultWorkingDirectory"]);
	config->writeEntry("BatchExecutionContinueOnError",
		boolOptions["BatchExecutionContinueOnError"]);
	config->writeEntry("PromptForShowingResultsWithMoreThanNRows",
		boolOptions["PromptForShowingResultsWithMoreThanNRows"]);
	config->writeEntry("NRows", uintOptions["NRows"]);
	config->writeEntry("ClearNoticesOutput", boolOptions["ClearNoticesOutput"]);
	config->writeEntry("SameFileSaveLoad", boolOptions["SameFileSaveLoad"]);
	config->writeEntry("SetViewCfgWithCfgLastViewCreated", 
		boolOptions["SetViewCfgWithCfgLastViewCreated"]);

	return;
}

bool ToolSuiteConfig::getBool(QString pOptionName) const
{
	// assert that key pOptionName exists
	return boolOptions[pOptionName];
}

void ToolSuiteConfig::setBool(QString pOptionName, bool pValue)
{
	// assert that key pOptionName exists
	boolOptions[pOptionName] = pValue;
	return;
}

QString ToolSuiteConfig::getString(QString pOptionName) const
{
	// assert that key pOptionName exists
	return stringOptions[pOptionName];
}

void ToolSuiteConfig::setString(QString pOptionName, QString pValue)
{
	// assert that key pOptionName exists
	stringOptions[pOptionName] = pValue;
	return;
}

unsigned int ToolSuiteConfig::getUInt(QString pOptionName) const
{
	// assert that key pOptionName exists
	return uintOptions[pOptionName];
}

void ToolSuiteConfig::setUInt(QString pOptionName, unsigned int pValue)
{
	// assert that key pOptionName exists
	uintOptions[pOptionName] = pValue;
	return;
}

