/********************************************************************************
                                 ToolSkeleton.cpp
                               -------------------
           begin                : lun jui 14 19:50:56 CEST 2003
       copyright                : (C) 2003 by Thomas Silvi
           email                : thomas.silvi@laposte.net
*********************************************************************************/

/********************************************************************************
*                                                                               *
*   This file is part of the Escort Tools Suite program.                        *
*                                                                               *
*   Escort Tools Suite is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as published by        *
*   the Free Software Foundation; either version 2 of the License, or           *
*   (at your option) any later version.                                         *
*                                                                               *
*   Escort Tools Suite is distributed in the hope that it will be useful,       *
*   but WITHOUT ANY WARRANTY; without even the implied warranty of              *
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the               *
*   GNU General Public License for more details.                                *
*                                                                               *
*   You should have received a copy of the GNU General Public License           *
*   along with Escort Tools Suite; if not, write to the Free Software           *
*   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA   *
*                                                                               *
*********************************************************************************/

#include "ToolSkeleton.h"

#include <kmenubar.h>

#include <qfile.h>
#include <qdir.h>

extern QString dataPath;
extern QString localDataPath;

extern QArray<QString> toolsArray;
extern unsigned int toolWindowsNumber;

ToolSkeleton::ToolSkeleton(QWidget *pParent,const char *pName) 
	: KMainWindow(pParent, pName)
{
	name = pName;
	
	this->setCaption(name);

	KShortcut shortcutQuit(CTRL+Key_Q);
	actionQuit = new KAction (i18n("&Quit"), shortcutQuit,
	        this, SLOT(byeBye()), actionCollection(),
	        "file_quit");
	actionQuit->setWhatsThis(i18n("Quit the application"));
	actionQuit->setIcon("exit");

}

ToolSkeleton::~ToolSkeleton()
{
}

void ToolSkeleton::initGUI()
{
	QString nameTmp(name), fullNameTmp;
	nameTmp.replace(" ","_");

	fullNameTmp = dataPath + nameTmp + ".rc";

	QFile fTmp(fullNameTmp);

	if (fTmp.exists() == false)
	{
		// the program is launch in the source directory
		QDir dTmp;

		fullNameTmp = dTmp.absPath() + "/" + localDataPath + nameTmp + ".rc";
#ifdef DEBUG_APP
		printf("DEBUG_APP Local data used : >%s\n",fullNameTmp.ascii());
#endif
	}

	createGUI(fullNameTmp);

	return;
}

void ToolSkeleton::closeEvent(QCloseEvent *pEvent)
{
	toolWindowsNumber--;
	KMainWindow::closeEvent(pEvent);
	return;
}

void ToolSkeleton::updateMenuTools(QObject *pLauncher, QString const &pToolName)
{
	QString sTools;

	sTools = i18n("&Tools");

	KMenuBar *mb;
	unsigned int idTmp, indexTmp;
	bool notFound;
	QString sTmp;

	mb = this->menuBar();

	notFound = true;
	indexTmp=0;

	while ((indexTmp < mb->count()) && (notFound==true))
	{
		idTmp = mb->idAt(indexTmp);
		sTmp = mb->text(idTmp);

		if (sTmp == sTools)
		{
			notFound=false;
			continue;
		}

		indexTmp++;
	}

	if (notFound==true)
	{
		printf ("Error : can not find menu Tools\n");
		return;
	}

	mb->removeItemAt(indexTmp);

	QPopupMenu * toolsPopupMenu;
	signed int indexTmp2, toolsArraySize;

	toolsArraySize = (signed int)(toolsArray.count());

	toolsPopupMenu = new QPopupMenu();

	indexTmp2=0;

	while ((indexTmp2<toolsArraySize) && (toolsArray[indexTmp2].isNull()==false))
	{
		toolsPopupMenu->insertItem(toolsArray[indexTmp2], pLauncher, 
			SLOT(launch(int)),0, indexTmp2);

// should we forbid to launch another <name> tool

		if (toolsArray[indexTmp2] == pToolName)
		{
			toolsPopupMenu->setItemEnabled(indexTmp2, false);
		}

		indexTmp2++;
	}

	mb->insertItem(i18n(sTools.ascii()), toolsPopupMenu, -1, indexTmp);

	return;
}

void ToolSkeleton::byeBye()
{
	close();
	return;
}



