/********************************************************************************
                                   QueryTool.h
                               -------------------
           begin                : lun jui 14 19:50:56 CEST 2003
       copyright                : (C) 2003 by Thomas Silvi
           email                : thomas.silvi@laposte.net
*********************************************************************************/

/********************************************************************************
*                                                                               *
*   This file is part of the Escort Tools Suite program.                        *
*                                                                               *
*   Escort Tools Suite is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as published by        *
*   the Free Software Foundation; either version 2 of the License, or           *
*   (at your option) any later version.                                         *
*                                                                               *
*   Escort Tools Suite is distributed in the hope that it will be useful,       *
*   but WITHOUT ANY WARRANTY; without even the implied warranty of              *
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the               *
*   GNU General Public License for more details.                                *
*                                                                               *
*   You should have received a copy of the GNU General Public License           *
*   along with Escort Tools Suite; if not, write to the Free Software           *
*   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA   *
*                                                                               *
*********************************************************************************/

#ifndef QUERY_TOOL_H
#define QUERY_TOOL_H


#include "ToolSkeleton.h"
#include "QueryToolView.h"
#include "ToolSuiteConfig.h"

// include files for Qt

#include <qworkspace.h>
#include <qmap.h>

// include files for KDE

#include <kpopupmenu.h>


class QueryTool : public ToolSkeleton
{
	Q_OBJECT

	public:

	QueryTool(QWidget *parent=0, const char *name=0, ToolSuiteConfig *pConfig=0);
	~QueryTool();

	QueryToolView * createClient(QueryToolDoc *pDoc);
	void unregister(QString &pConnectionName);
	
	void setActiveView(QString pMDIid);
	void setApp(KApplication *pApp);
	void closeEvent(QCloseEvent *pEvent);
	ToolSuiteConfig * getConfig();

	public slots:
	
	void openQuery();
	void saveQueryResult();
	void saveAsQueryResult();
	void requestTool();

	protected slots:
	
	void executeInput();
	void newConnection();
	void disconnect();
	void byebye();
	void changeConnectionView(int pIndex);
	void previousConnectionView();
	void nextConnectionView();
	void configureApp();
	void switchViewToInput();
	void switchViewToOutput();
	void switchViewToNoticeMessages();
	void configureKeyShortcuts();
	void stopBatch();
	void toggleMainToolbar();

	protected:

	void initView();
	void initActions();
	void updateConnectionMenu();
	unsigned int isThereBatchRunning();
	void showConnectionCreationDate();
	void updateLastView();

	QWorkspace *workspace;
	QMap<QString,QueryToolView*> *viewsMap;
	bool internalCanQuit;
	QueryToolView *lastViewCreated;

	KApplication *app;
	KPopupMenu * connections;
	
	KAction *actionNewConnection;
	KAction *actionDisconnect;
	KAction *actionExecute;
	KAction *actionOpen;
	KAction *actionSave;
	KAction *actionSaveAs;
	KAction *actionQuit;
	
	KAction *actionPreviousConnection;
	KAction *actionNextConnection;
	
	KAction *actionSettingsConfigureApp;
	KAction *actionSettingsConfigureKeyShortcuts;
	
	KAction *actionSwitchToInput;
	KAction *actionSwitchToOutput;
	KAction *actionSwitchToNoticeMessages;
	KAction *actionStopBatch;
	
	KAction *actionTheQueryTool;
	KAction *actionTheDataMiningTool;
	
	ToolSuiteConfig *config;
	
};

#endif

