/********************************************************************************
                                  ConfigDialog.h
                               -------------------
           begin                : lun jui 14 19:50:56 CEST 2003
       copyright                : (C) 2003 by Thomas Silvi
           email                : thomas.silvi@laposte.net
*********************************************************************************/

/********************************************************************************
*                                                                               *
*   This file is part of the Escort Tools Suite program.                        *
*                                                                               *
*   Escort Tools Suite is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as published by        *
*   the Free Software Foundation; either version 2 of the License, or           *
*   (at your option) any later version.                                         *
*                                                                               *
*   Escort Tools Suite is distributed in the hope that it will be useful,       *
*   but WITHOUT ANY WARRANTY; without even the implied warranty of              *
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the               *
*   GNU General Public License for more details.                                *
*                                                                               *
*   You should have received a copy of the GNU General Public License           *
*   along with Escort Tools Suite; if not, write to the Free Software           *
*   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA   *
*                                                                               *
*********************************************************************************/

#ifndef CONFIG_DIALOG_H
#define CONFIG_DIALOG_H

#include "ToolSuiteConfig.h"

#include <kdialogbase.h>
#include <knuminput.h>

#include <qcheckbox.h>

class ConfigDialog : public KDialogBase
{
	Q_OBJECT
	
	public:

	ConfigDialog(QWidget *pParent, ToolSuiteConfig *pConfig);
	~ConfigDialog();
	
	public slots:
	
	void slotOk();
	void slotApply();
	
	protected:

	void applyChanges();
		
	ToolSuiteConfig *config;
	
	// General Options

	QCheckBox *cbShowToolBar;
	
	// Query Tool Option
	QCheckBox *cbAutoSwitchToResult;
	QCheckBox *cbBatchExecutionContinueOnError;
	QCheckBox *cbNRows ; // AskForShowingResultWithMoreThanRows
	KIntNumInput *niRows;
	QCheckBox *cbClearNoticesOutput;
	QCheckBox *cbSetViewCfgWithLastCreatedView;
	QCheckBox *cbSameFileSaveLoad;

	// Connection Options
	QCheckBox *cbConFillEnvVarPG;
	QCheckBox *cbConFillLoginWithUnixLogin;
	QCheckBox *cbFillConnParamWithLastCreatedConnParam;

};

#endif
