/* This file is part of GNU epsilon, a functional language implementation

Copyright (C) 2002 Luca Saiu

GNU epsilon is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published
by the Free Software Foundation; either version 2, or (at your
option) any later version.

GNU epsilon is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with epsilon; see the file COPYING.  If not, write to the
Free Software Foundation, Inc., 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA. */

#ifndef STRUCTURES_H_
#define STRUCTURES_H_

#include <stdio.h>


void create_repl_data_structures();
void destroy_repl_data_structures();

/* If another definition for name exists but it's not active then an insertion does
   not overwrite it; but if the old definition is active then the new one overwrites
   the old one. */
void insert_define(char* name, char* value);

int  is_define_present(char* name); /* activation does not matter here */
void remove_define(char* name); /* activation does not matter here */
void remove_active_define(char* name);
void remove_not_active_define(char* name);

/* (De-)Activation is only meaningful for the _first_ define of any given identifier */
void activate_define(char* name);
void deactivate_define(char* name);

/* Only active definitions are dumped */
void dump_defines(FILE* output);

#endif /* #ifndef STRUCTURES_H_ */
