/* This file is automatically generated. Don't edit */
/* This file is part of GNU epsilon, a functional language implementation

Copyright (C) 2002, 2003 Luca Saiu

GNU epsilon is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published
by the Free Software Foundation; either version 2, or (at your
option) any later version.

GNU epsilon is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with epsilon; see the file COPYING.  If not, write to the
Free Software Foundation, Inc., 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA. */


#include <stdio.h>
#include <unistd.h>
#include <stdlib.h>

#include "eam_types.h"
#include "runtime.h"
#include "eam.h"
#include "output_c.h"

#include "instructions.h"

void output_string_constant(FILE *output_stream, int index){
  integer_t i, length = strlen(executable->string_constants[index]);
  
  /* Output length as the first element: */
  fprintf(output_stream, "{(word_t)" INTEGER_T_FORMAT " /* length */,\n", length);
  
  /* Output characters as the following elements: */
  for(i = 0; i < length; i++)
    fprintf(output_stream, "(word_t)%i,\n", /* char is coerced into int */
	    executable->string_constants[index][i]);
  fprintf(output_stream, "}");
}

void output_string_constants(FILE *output_stream){
  int i;
  /* Output a variable definition for each string constant: */
  for(i = 0; i < executable->string_constants_no; i++){
    fprintf(output_stream, "word_t string_constant_%i[] = ", i);
    output_string_constant(output_stream, i);
    fprintf(output_stream, ";\n");
  }
}

///////////////////////////////////////////////////////////////////

void declare_c_symbols(struct epsilon_executable *executable,
		       FILE *output_stream){
  integer_t i;
  fprintf(output_stream, "/* Declare all symbols: */\n");
  for(i = 0; i < executable->c_symbols_no; i++)
    fprintf(output_stream, "word_t c_symbol_"INTEGER_T_FORMAT";\n", i);
  fprintf(output_stream, "\n");
}

void initialize_c_symbols(struct epsilon_executable *executable,
			  FILE *output_stream){
  integer_t i;
  fprintf(output_stream, "{ /* Initialize C symbols: */\n");
  fprintf(output_stream, "  c_library_handle_t* c_libraries;\n");

  fprintf(output_stream, "  /* Initialize libraries/symbols handling: */\n");
  fprintf(output_stream, "  initialize_dynamic_libraries();\n\n");

  fprintf(output_stream, "  /* Open all C libraries: */\n");
  fprintf(output_stream, "  c_libraries = (c_library_handle_t*)\n");
  fprintf(output_stream, "    xmalloc(sizeof(c_library_handle_t) * "INTEGER_T_FORMAT");\n",
	  executable->c_libraries_no);
  for(i = 0; i < executable->c_libraries_no; i++)
    fprintf(output_stream, "  c_libraries["INTEGER_T_FORMAT"] = open_c_library(\"%s\");\n",
	    i, executable->c_libraries[i]);

  fprintf(output_stream, "\n  /* Load all C symbols: */\n");
  for(i = 0; i < executable->c_symbols_no; i++)
    fprintf(output_stream, "  c_symbol_"INTEGER_T_FORMAT
	    " = load_c_symbol(c_libraries["INTEGER_T_FORMAT"], \"%s\");\n",
	    i,
	    executable->c_symbols[i].library_index,
	    executable->c_symbols[i].symbol_name);
  
  fprintf(output_stream, "\n  /* We don't need c_libraries anymore: */\n");
  fprintf(output_stream, "  free(c_libraries);\n");
  fprintf(output_stream, "}\n");
}
///////////////////////////////////////////////////////////////////

void output_c(FILE *output_stream){
  int i;
  int instruction_pointer;
  
  //fprintf(output_stream,"#include ...");
  fprintf(output_stream,"#ifdef __GNUC__\n");
  fprintf(output_stream,"  #define THREADING\n");
  fprintf(output_stream,"#endif\n\n");
  fprintf(output_stream,"#define GENERATED_C_CODE\n");
  fprintf(output_stream,"#include \"eam_types.h\"\n\n");
  fprintf(output_stream,"#include <stdio.h>\n");
  fprintf(output_stream,"#include <unistd.h>\n");
  fprintf(output_stream,"#include <stdlib.h>\n");
  fprintf(output_stream,"#include <time.h>\n");
  fprintf(output_stream,"#include <math.h>\n");
  fprintf(output_stream,"#include \"../common/readline_wrapper.h\"\n");
  fprintf(output_stream,"#include \"runtime.h\"\n");
  fprintf(output_stream,"#include \"gc/gc.h\"\n\n");
  fprintf(output_stream,"#include \"library/library.h\"\n\n");

  fprintf(output_stream,
     "/* show GC statistics if nonzero; this is driven by command line: */\n");
  fprintf(output_stream, "integer_t verbose_gc = 0;\n\n");

  fprintf(output_stream,"#define MARK_GC_ROOTS() { \\\n");
  fprintf(output_stream,"  integer_t i; \\\n");
  fprintf(output_stream,"  /* Mark the stack: */ \\\n");
  fprintf(output_stream,"  add_gc_roots(stack, (undertop_stack_pointer + 1)); \\\n");
  fprintf(output_stream,"  add_gc_root(top); \\\n");
  fprintf(output_stream,"  /* Mark registers: */ \\\n");
  fprintf(output_stream,"  add_gc_root(environment); \\\n");
  fprintf(output_stream,"  add_gc_root(output_register); \\\n");
  fprintf(output_stream,"  /* Mark globals: */ \\\n");
  for(i = 0; i < executable->globals_no; i++)
    fprintf(output_stream, "add_gc_root(global_%i);\\\n", i);
  fprintf(output_stream,"  /* Mark C symbols: */ \\\n");
  for(i = 0; i < executable->c_symbols_no; i++)
    fprintf(output_stream, "add_gc_root(c_symbol_%i);\\\n", i);
  fprintf(output_stream,"  /* Mark exceptions structures: */ \\\n");
  fprintf(output_stream,"  add_gc_root(exception_value); \\\n");
  fprintf(output_stream,"  for(i = 0; i < exceptions_stack_pointer; i++) \\\n");
  fprintf(output_stream,"    add_gc_root(exceptions_stack[i].environment); \\\n");
  fprintf(output_stream,"}\n\n");

  fprintf(output_stream,"const int instructions_no = %i;\n",executable->instructions_no);

  fprintf(output_stream,"const int word_registers_no = %i;\n",executable->word_registers_no);
  fprintf(output_stream,"const int wide_integer_registers_no = %i;\n",executable->wide_integer_registers_no);
  fprintf(output_stream,"const int float_registers_no = %i;\n",executable->float_registers_no);
  fprintf(output_stream,"const int wide_float_registers_no = %i;\n",executable->wide_float_registers_no);
  fprintf(output_stream,"const int wide_wide_float_registers_no = %i;\n",executable->wide_wide_float_registers_no);

  fprintf(output_stream,"int stack_size = %i + 10;\n\n",executable->instructions_no);
  output_string_constants(output_stream);
  fprintf(output_stream,"\n");
  fprintf(output_stream,"int main(int argc, char** argv){\n");

  fprintf(output_stream,"  clock_t begin_time; /* for profiling, epecially GC profiling */\n\n");

  fprintf(output_stream,"  /* eAM general registers */\n");
  for(i = 0; i < executable->word_registers_no; i++)
    fprintf(output_stream,"  register word_t Rg%i; /* $g%i */\n", i, i);
  fprintf(output_stream,"\n");

  fprintf(output_stream,"  /* eAM wide integer registers: */\n");
  for(i = 0; i < executable->wide_integer_registers_no; i++)
    fprintf(output_stream,"  register wide_integer_t Rw%i; /* $w%i */\n", i, i);
  fprintf(output_stream,"\n");

  fprintf(output_stream,"  /* eAM float registers: */\n");
  for(i = 0; i < executable->float_registers_no; i++)
    fprintf(output_stream,"  register float_t Rf%i; /* $f%i */\n", i, i);
  fprintf(output_stream,"\n");

  fprintf(output_stream,"  /* eAM wide float registers: */\n");
  for(i = 0; i < executable->wide_float_registers_no; i++)
    fprintf(output_stream,"  register wide_float_t Rwf%i; /* $wf%i */\n", i, i);
  fprintf(output_stream,"\n");

  fprintf(output_stream,"  /* eAM wide wide float registers: */\n");
  for(i = 0; i < executable->wide_wide_float_registers_no; i++)
    fprintf(output_stream,"  register wide_wide_float_t RWf%i; /* $Wf%i */\n", i, i);
  fprintf(output_stream,"\n");

  fprintf(output_stream, "register word_t failure_point_register = NULL;\n");

  fprintf(output_stream,"  /* Runtime structures which should fit in physical registers: */\n");
  fprintf(output_stream,"  register word_t* environment = NULL;\n");
  fprintf(output_stream,"  register word_t  top;\n");
  fprintf(output_stream,"  register word_t* stack;\n");
  fprintf(output_stream,"  register integer_t undertop_stack_pointer;\n");
  fprintf(output_stream,"  register exception_t* exceptions_stack;\n");
  fprintf(output_stream,"  register integer_t frame_pointer;\n\n");
  fprintf(output_stream,"  /* Runtime structures for exception-handling */\n");
  fprintf(output_stream,"  register integer_t exceptions_stack_size;\n");
  fprintf(output_stream,"  register integer_t exceptions_stack_pointer;\n");
  fprintf(output_stream,"  register word_t exception_value;\n");
  fprintf(output_stream,"  register integer_t exception_type;\n");
  fprintf(output_stream,"  word_t output_register;\n");
  fprintf(output_stream,"  char* exceptions_names[] = {\n");
  for(i = 0; i < executable->exceptions_no; i++)
    //fprintf(output_stream," \"%s\",\n", executable->exceptions[i]);
    fprintf(output_stream," \"%s\", // %i\n", executable->exceptions[i], i);
  fprintf(output_stream,"  };\n");
  fprintf(output_stream,"\n");
  fprintf(output_stream,"  /* Globals: */\n");
  for(i = 0; i < executable->globals_no; i++)
    fprintf(output_stream, "  register word_t global_%i;\n", i);
  fprintf(output_stream,"\n");

  declare_c_symbols(executable, output_stream);

  ////////////////////////////////////////////////////////////
  fprintf(output_stream, "/* Initialize command-line handling: */\n");
  fprintf(output_stream, "set_program_name(\"some epsilon program [To do]\");\n");
  fprintf(output_stream, "set_general_help_message(\"One-line help [To do]\");\n");
  fprintf(output_stream, "set_synopsis_string(\"Command line [To do]\");\n");
  fprintf(output_stream, "set_version_string(\"Version string [To do]\");\n");
  fprintf(output_stream, "set_copyright_string(\"Copyright string [To do]\");\n");
  fprintf(output_stream,
	  "set_license_message(\"This is free software. You may redistribute copies of it under the\\n\"\n"
	  "\"terms of the GNU General Public License. There is NO warranty; not even\\n\"\n"
	  "\"for MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.\\n\"\n"
	  "\"For more information about these matters, see the file named COPYING.\");\n");

  fprintf(output_stream,
	  "add_toggle_option (\"benchmark\", 'b', 0,\n"
          "                   \"Report timing information after execution\");\n");
  fprintf(output_stream,
	  "add_toggle_option (\"verbose-gc\", 'g', 0,\n"
          "                   \"Show garbage-collecting statistics on stderr\");\n");

  fprintf(output_stream,
	  "set_bug_reporting_message(\"Bug reporting message [To do]\");\n\n");
  fprintf(output_stream, "parse_command_line(&argc, argv);\n\n");
  fprintf(output_stream, "argc--; argv++; /* Cut invoked program name */\n\n");

  fprintf(output_stream, "  /* Set global flags driven by command-line options: */\n");
  fprintf(output_stream, "  verbose_gc = (integer_t) long_option_to_value(\"verbose-gc\");\n");

  /////////////////////////////////////////////////////////////

  initialize_c_symbols(executable, output_stream);

  fprintf(output_stream,"  /* Start the GC: */\n");
  fprintf(output_stream,"  initialize_garbage_collector();\n\n");

  fprintf(output_stream,
	  "  /* See the comment in eam/library/use_everything.h: */\n");
  fprintf(output_stream,"  use_everything();\n\n");

  fprintf(output_stream,"  /* Initialize the runtime structures: */\n");
  fprintf(output_stream,"  stack = (word_t*) malloc(sizeof(word_t) * stack_size);\n");
  fprintf(output_stream,"  stack[0] = (word_t)NULL;  /* saved environment */\n");
  fprintf(output_stream,"  top = (word_t)(-1);  /* saved frame pointer */\n");
  fprintf(output_stream,"  undertop_stack_pointer = 0;\n");
  fprintf(output_stream,"  frame_pointer = 0;\n");
  fprintf(output_stream,"  exceptions_stack_size = 16;\n");
  fprintf(output_stream,"  exceptions_stack = (exception_t*)malloc(sizeof(exception_t) * exceptions_stack_size);\n");
  fprintf(output_stream,"  /* Initialize exception-handlingstructures: */\n");

  fprintf(output_stream,"  ASSIGN_CREATE_ARRAY(exceptions_stack[0].environment, 1);\n");
  fprintf(output_stream,"  exceptions_stack[0].handler_pointer = &&L%i;\n",executable->instructions_no - 1);
  fprintf(output_stream,"  exceptions_stack[0].undertop_stack_pointer = 0;\n");
  fprintf(output_stream,"  exceptions_stack[0].frame_pointer = 0;\n");
  fprintf(output_stream,"  exceptions_stack_pointer = 0;\n\n");

  fprintf(output_stream,"  begin_time =\n");
  fprintf(output_stream,"        ((double)clock()) * 1000.0 / (double)CLOCKS_PER_SEC;\n\n");

  fprintf(output_stream,"/* Here comes the actual translation of instructions: */\n");
  for(instruction_pointer = 0;
      instruction_pointer < executable->instructions_no;
      instruction_pointer++){
    fprintf(output_stream, "L%i:\n", instruction_pointer);
    fprintf(output_stream, "#undef PARAMETER_1\n");
    fprintf(output_stream, "#undef PARAMETER_2\n");
    fprintf(output_stream, "#undef PARAMETER_3\n");
    fprintf(output_stream, "#undef PARAMETER_1_AS_REGISTER\n");
    fprintf(output_stream, "#undef PARAMETER_2_AS_REGISTER\n");
    fprintf(output_stream, "#undef PARAMETER_3_AS_REGISTER\n");
    fprintf(output_stream, "#undef PARAMETER_3_AS_C_SYMBOL\n");
    fprintf(output_stream, "#undef PARAMETER_1_AS_STRING\n");
    fprintf(output_stream, "#undef PARAMETER_2_AS_STRING\n");
    fprintf(output_stream, "#undef PARAMETER_1_AS_GLOBAL\n");
    fprintf(output_stream, "#undef FLOAT_PARAMETER\n");
    fprintf(output_stream, "#undef LABEL_PARAMETER\n");
    fprintf(output_stream, "#undef THIS_INSTRUCTION\n");
    fprintf(output_stream, "#undef NEXT_INSTRUCTION\n");
    fprintf(output_stream, "#define PARAMETER_1 ((word_t)" INTEGER_T_FORMAT ")\n",
	    executable->instructions[instruction_pointer].parameter_1);
    fprintf(output_stream, "#define PARAMETER_2 ((word_t)" INTEGER_T_FORMAT ")\n", 
	    executable->instructions[instruction_pointer].parameter_2);
    fprintf(output_stream, "#define PARAMETER_3 ((word_t)" INTEGER_T_FORMAT ")\n", 
	    executable->instructions[instruction_pointer].parameter_3);
    fprintf(output_stream, "#define PARAMETER_1_AS_GLOBAL global_" INTEGER_T_FORMAT "\n",
	    executable->instructions[instruction_pointer].parameter_1);
    fprintf(output_stream, "#define PARAMETER_1_AS_STRING string_constant_" INTEGER_T_FORMAT "\n",
	    executable->instructions[instruction_pointer].parameter_1);
    fprintf(output_stream, "#define PARAMETER_2_AS_STRING string_constant_" INTEGER_T_FORMAT "\n",
	    executable->instructions[instruction_pointer].parameter_2);
    fprintf(output_stream, "#define PARAMETER_1_AS_REGISTER Rg" INTEGER_T_FORMAT "\n",
	    executable->instructions[instruction_pointer].parameter_1);
    fprintf(output_stream, "#define PARAMETER_2_AS_REGISTER Rg" INTEGER_T_FORMAT "\n", 
	    executable->instructions[instruction_pointer].parameter_2);
    fprintf(output_stream, "#define PARAMETER_3_AS_REGISTER Rg" INTEGER_T_FORMAT "\n", 
	    executable->instructions[instruction_pointer].parameter_3);
    fprintf(output_stream, "#define PARAMETER_3_AS_C_SYMBOL c_symbol_" INTEGER_T_FORMAT "\n", 
	    executable->instructions[instruction_pointer].parameter_3);
    fprintf(output_stream, "#define FLOAT_PARAMETER " FLOAT_T_FORMAT "\n",
	    executable->instructions[instruction_pointer].float_parameter);
    fprintf(output_stream, "#define LABEL_PARAMETER &&L%i\n",   
	    executable->instructions[instruction_pointer].label_parameter);
    fprintf(output_stream, "#ifdef THREADING\n");
    fprintf(output_stream, "#define THIS_INSTRUCTION &&L%i\n", instruction_pointer);
    fprintf(output_stream, "#define NEXT_INSTRUCTION &&L%i\n", instruction_pointer + 1);
    fprintf(output_stream, "#endif /* #ifdef THREADING */\n");
    
    switch(executable->instructions[instruction_pointer].opcode){
    /* These first cases are special in the sense that they are defined in
       output_c_c.head: */
    case nln:{
      /* Execute the C code held in the first string parameter: */
      
      integer_t string_index = (integer_t)(executable->instructions[instruction_pointer].parameter_1);
      fprintf(output_stream, "asm(\"\\t# --- Code for instruction nln ---\\n\");\n{\n");
      fprintf(output_stream, "{\n/* Code for nln: */\n%s;\n}}\n",
	      executable->string_constants[string_index]);
      break;
    }

    /* Here come the "normal" instructions */
    case addi:{
      char* text;
      fprintf(output_stream, "{\n");
      text=
#include "stringified_c_instructions/addi"
        ;
      fprintf(output_stream, "%s", text);
      fprintf(output_stream, "}\n");
      break;
    }
    case addi_i:{
      char* text;
      fprintf(output_stream, "{\n");
      text=
#include "stringified_c_instructions/addi_i"
        ;
      fprintf(output_stream, "%s", text);
      fprintf(output_stream, "}\n");
      break;
    }
    case clargs:{
      char* text;
      fprintf(output_stream, "{\n");
      text=
#include "stringified_c_instructions/clargs"
        ;
      fprintf(output_stream, "%s", text);
      fprintf(output_stream, "}\n");
      break;
    }
    case cpy:{
      char* text;
      fprintf(output_stream, "{\n");
      text=
#include "stringified_c_instructions/cpy"
        ;
      fprintf(output_stream, "%s", text);
      fprintf(output_stream, "}\n");
      break;
    }
    case dfhn:{
      char* text;
      fprintf(output_stream, "{\n");
      text=
#include "stringified_c_instructions/dfhn"
        ;
      fprintf(output_stream, "%s", text);
      fprintf(output_stream, "}\n");
      break;
    }
    case divi:{
      char* text;
      fprintf(output_stream, "{\n");
      text=
#include "stringified_c_instructions/divi"
        ;
      fprintf(output_stream, "%s", text);
      fprintf(output_stream, "}\n");
      break;
    }
    case divi_i:{
      char* text;
      fprintf(output_stream, "{\n");
      text=
#include "stringified_c_instructions/divi_i"
        ;
      fprintf(output_stream, "%s", text);
      fprintf(output_stream, "}\n");
      break;
    }
    case dummy_register_integer_register:{
      char* text;
      fprintf(output_stream, "{\n");
      text=
#include "stringified_c_instructions/dummy_register_integer_register"
        ;
      fprintf(output_stream, "%s", text);
      fprintf(output_stream, "}\n");
      break;
    }
    case f_divi:{
      char* text;
      fprintf(output_stream, "{\n");
      text=
#include "stringified_c_instructions/f_divi"
        ;
      fprintf(output_stream, "%s", text);
      fprintf(output_stream, "}\n");
      break;
    }
    case gcin:{
      char* text;
      fprintf(output_stream, "{\n");
      text=
#include "stringified_c_instructions/gcin"
        ;
      fprintf(output_stream, "%s", text);
      fprintf(output_stream, "}\n");
      break;
    }
    case hlt:{
      char* text;
      fprintf(output_stream, "{\n");
      text=
#include "stringified_c_instructions/hlt"
        ;
      fprintf(output_stream, "%s", text);
      fprintf(output_stream, "}\n");
      break;
    }
    case inc:{
      char* text;
      fprintf(output_stream, "{\n");
      text=
#include "stringified_c_instructions/inc"
        ;
      fprintf(output_stream, "%s", text);
      fprintf(output_stream, "}\n");
      break;
    }
    case ini:{
      char* text;
      fprintf(output_stream, "{\n");
      text=
#include "stringified_c_instructions/ini"
        ;
      fprintf(output_stream, "%s", text);
      fprintf(output_stream, "}\n");
      break;
    }
    case ins:{
      char* text;
      fprintf(output_stream, "{\n");
      text=
#include "stringified_c_instructions/ins"
        ;
      fprintf(output_stream, "%s", text);
      fprintf(output_stream, "}\n");
      break;
    }
    case j:{
      char* text;
      fprintf(output_stream, "{\n");
      text=
#include "stringified_c_instructions/j"
        ;
      fprintf(output_stream, "%s", text);
      fprintf(output_stream, "}\n");
      break;
    }
    case jde:{
      char* text;
      fprintf(output_stream, "{\n");
      text=
#include "stringified_c_instructions/jde"
        ;
      fprintf(output_stream, "%s", text);
      fprintf(output_stream, "}\n");
      break;
    }
    case lbl:{
      char* text;
      fprintf(output_stream, "{\n");
      text=
#include "stringified_c_instructions/lbl"
        ;
      fprintf(output_stream, "%s", text);
      fprintf(output_stream, "}\n");
      break;
    }
    case ldci:{
      char* text;
      fprintf(output_stream, "{\n");
      text=
#include "stringified_c_instructions/ldci"
        ;
      fprintf(output_stream, "%s", text);
      fprintf(output_stream, "}\n");
      break;
    }
    case muli:{
      char* text;
      fprintf(output_stream, "{\n");
      text=
#include "stringified_c_instructions/muli"
        ;
      fprintf(output_stream, "%s", text);
      fprintf(output_stream, "}\n");
      break;
    }
    case muli_i:{
      char* text;
      fprintf(output_stream, "{\n");
      text=
#include "stringified_c_instructions/muli_i"
        ;
      fprintf(output_stream, "%s", text);
      fprintf(output_stream, "}\n");
      break;
    }
    case nlcl:{
      char* text;
      fprintf(output_stream, "{\n");
      text=
#include "stringified_c_instructions/nlcl"
        ;
      fprintf(output_stream, "%s", text);
      fprintf(output_stream, "}\n");
      break;
    }
    case nop:{
      char* text;
      fprintf(output_stream, "{\n");
      text=
#include "stringified_c_instructions/nop"
        ;
      fprintf(output_stream, "%s", text);
      fprintf(output_stream, "}\n");
      break;
    }
    case outi:{
      char* text;
      fprintf(output_stream, "{\n");
      text=
#include "stringified_c_instructions/outi"
        ;
      fprintf(output_stream, "%s", text);
      fprintf(output_stream, "}\n");
      break;
    }
    case pop:{
      char* text;
      fprintf(output_stream, "{\n");
      text=
#include "stringified_c_instructions/pop"
        ;
      fprintf(output_stream, "%s", text);
      fprintf(output_stream, "}\n");
      break;
    }
    case popf:{
      char* text;
      fprintf(output_stream, "{\n");
      text=
#include "stringified_c_instructions/popf"
        ;
      fprintf(output_stream, "%s", text);
      fprintf(output_stream, "}\n");
      break;
    }
    case popfn:{
      char* text;
      fprintf(output_stream, "{\n");
      text=
#include "stringified_c_instructions/popfn"
        ;
      fprintf(output_stream, "%s", text);
      fprintf(output_stream, "}\n");
      break;
    }
    case popm:{
      char* text;
      fprintf(output_stream, "{\n");
      text=
#include "stringified_c_instructions/popm"
        ;
      fprintf(output_stream, "%s", text);
      fprintf(output_stream, "}\n");
      break;
    }
    case poptry:{
      char* text;
      fprintf(output_stream, "{\n");
      text=
#include "stringified_c_instructions/poptry"
        ;
      fprintf(output_stream, "%s", text);
      fprintf(output_stream, "}\n");
      break;
    }
    case pshcf:{
      char* text;
      fprintf(output_stream, "{\n");
      text=
#include "stringified_c_instructions/pshcf"
        ;
      fprintf(output_stream, "%s", text);
      fprintf(output_stream, "}\n");
      break;
    }
    case pshci:{
      char* text;
      fprintf(output_stream, "{\n");
      text=
#include "stringified_c_instructions/pshci"
        ;
      fprintf(output_stream, "%s", text);
      fprintf(output_stream, "}\n");
      break;
    }
    case pshcs:{
      char* text;
      fprintf(output_stream, "{\n");
      text=
#include "stringified_c_instructions/pshcs"
        ;
      fprintf(output_stream, "%s", text);
      fprintf(output_stream, "}\n");
      break;
    }
    case pshgl:{
      char* text;
      fprintf(output_stream, "{\n");
      text=
#include "stringified_c_instructions/pshgl"
        ;
      fprintf(output_stream, "%s", text);
      fprintf(output_stream, "}\n");
      break;
    }
    case pshnll:{
      char* text;
      fprintf(output_stream, "{\n");
      text=
#include "stringified_c_instructions/pshnll"
        ;
      fprintf(output_stream, "%s", text);
      fprintf(output_stream, "}\n");
      break;
    }
    case psho:{
      char* text;
      fprintf(output_stream, "{\n");
      text=
#include "stringified_c_instructions/psho"
        ;
      fprintf(output_stream, "%s", text);
      fprintf(output_stream, "}\n");
      break;
    }
    case pshtry:{
      char* text;
      fprintf(output_stream, "{\n");
      text=
#include "stringified_c_instructions/pshtry"
        ;
      fprintf(output_stream, "%s", text);
      fprintf(output_stream, "}\n");
      break;
    }
    case rthrw:{
      char* text;
      fprintf(output_stream, "{\n");
      text=
#include "stringified_c_instructions/rthrw"
        ;
      fprintf(output_stream, "%s", text);
      fprintf(output_stream, "}\n");
      break;
    }
    case s_addf:{
      char* text;
      fprintf(output_stream, "{\n");
      text=
#include "stringified_c_instructions/s_addf"
        ;
      fprintf(output_stream, "%s", text);
      fprintf(output_stream, "}\n");
      break;
    }
    case s_addi:{
      char* text;
      fprintf(output_stream, "{\n");
      text=
#include "stringified_c_instructions/s_addi"
        ;
      fprintf(output_stream, "%s", text);
      fprintf(output_stream, "}\n");
      break;
    }
    case s_addi_i:{
      char* text;
      fprintf(output_stream, "{\n");
      text=
#include "stringified_c_instructions/s_addi_i"
        ;
      fprintf(output_stream, "%s", text);
      fprintf(output_stream, "}\n");
      break;
    }
    case s_andi:{
      char* text;
      fprintf(output_stream, "{\n");
      text=
#include "stringified_c_instructions/s_andi"
        ;
      fprintf(output_stream, "%s", text);
      fprintf(output_stream, "}\n");
      break;
    }
    case s_barlt:{
      char* text;
      fprintf(output_stream, "{\n");
      text=
#include "stringified_c_instructions/s_barlt"
        ;
      fprintf(output_stream, "%s", text);
      fprintf(output_stream, "}\n");
      break;
    }
    case s_cact:{
      char* text;
      fprintf(output_stream, "{\n");
      text=
#include "stringified_c_instructions/s_cact"
        ;
      fprintf(output_stream, "%s", text);
      fprintf(output_stream, "}\n");
      break;
    }
    case s_cactp:{
      char* text;
      fprintf(output_stream, "{\n");
      text=
#include "stringified_c_instructions/s_cactp"
        ;
      fprintf(output_stream, "%s", text);
      fprintf(output_stream, "}\n");
      break;
    }
    case s_car:{
      char* text;
      fprintf(output_stream, "{\n");
      text=
#include "stringified_c_instructions/s_car"
        ;
      fprintf(output_stream, "%s", text);
      fprintf(output_stream, "}\n");
      break;
    }
    case s_cctba:{
      char* text;
      fprintf(output_stream, "{\n");
      text=
#include "stringified_c_instructions/s_cctba"
        ;
      fprintf(output_stream, "%s", text);
      fprintf(output_stream, "}\n");
      break;
    }
    case s_cdr:{
      char* text;
      fprintf(output_stream, "{\n");
      text=
#include "stringified_c_instructions/s_cdr"
        ;
      fprintf(output_stream, "%s", text);
      fprintf(output_stream, "}\n");
      break;
    }
    case s_cfun:{
      char* text;
      fprintf(output_stream, "{\n");
      text=
#include "stringified_c_instructions/s_cfun"
        ;
      fprintf(output_stream, "%s", text);
      fprintf(output_stream, "}\n");
      break;
    }
    case s_chst:{
      char* text;
      fprintf(output_stream, "{\n");
      text=
#include "stringified_c_instructions/s_chst"
        ;
      fprintf(output_stream, "%s", text);
      fprintf(output_stream, "}\n");
      break;
    }
    case s_cll:{
      char* text;
      fprintf(output_stream, "{\n");
      text=
#include "stringified_c_instructions/s_cll"
        ;
      fprintf(output_stream, "%s", text);
      fprintf(output_stream, "}\n");
      break;
    }
    case s_cls:{
      char* text;
      fprintf(output_stream, "{\n");
      text=
#include "stringified_c_instructions/s_cls"
        ;
      fprintf(output_stream, "%s", text);
      fprintf(output_stream, "}\n");
      break;
    }
    case s_clsr:{
      char* text;
      fprintf(output_stream, "{\n");
      text=
#include "stringified_c_instructions/s_clsr"
        ;
      fprintf(output_stream, "%s", text);
      fprintf(output_stream, "}\n");
      break;
    }
    case s_cns:{
      char* text;
      fprintf(output_stream, "{\n");
      text=
#include "stringified_c_instructions/s_cns"
        ;
      fprintf(output_stream, "%s", text);
      fprintf(output_stream, "}\n");
      break;
    }
    case s_cobj:{
      char* text;
      fprintf(output_stream, "{\n");
      text=
#include "stringified_c_instructions/s_cobj"
        ;
      fprintf(output_stream, "%s", text);
      fprintf(output_stream, "}\n");
      break;
    }
    case s_divf:{
      char* text;
      fprintf(output_stream, "{\n");
      text=
#include "stringified_c_instructions/s_divf"
        ;
      fprintf(output_stream, "%s", text);
      fprintf(output_stream, "}\n");
      break;
    }
    case s_divi:{
      char* text;
      fprintf(output_stream, "{\n");
      text=
#include "stringified_c_instructions/s_divi"
        ;
      fprintf(output_stream, "%s", text);
      fprintf(output_stream, "}\n");
      break;
    }
    case s_divi_i:{
      char* text;
      fprintf(output_stream, "{\n");
      text=
#include "stringified_c_instructions/s_divi_i"
        ;
      fprintf(output_stream, "%s", text);
      fprintf(output_stream, "}\n");
      break;
    }
    case s_eqf:{
      char* text;
      fprintf(output_stream, "{\n");
      text=
#include "stringified_c_instructions/s_eqf"
        ;
      fprintf(output_stream, "%s", text);
      fprintf(output_stream, "}\n");
      break;
    }
    case s_eqi:{
      char* text;
      fprintf(output_stream, "{\n");
      text=
#include "stringified_c_instructions/s_eqi"
        ;
      fprintf(output_stream, "%s", text);
      fprintf(output_stream, "}\n");
      break;
    }
    case s_eqi_i:{
      char* text;
      fprintf(output_stream, "{\n");
      text=
#include "stringified_c_instructions/s_eqi_i"
        ;
      fprintf(output_stream, "%s", text);
      fprintf(output_stream, "}\n");
      break;
    }
    case s_eqs:{
      char* text;
      fprintf(output_stream, "{\n");
      text=
#include "stringified_c_instructions/s_eqs"
        ;
      fprintf(output_stream, "%s", text);
      fprintf(output_stream, "}\n");
      break;
    }
    case s_f_divi:{
      char* text;
      fprintf(output_stream, "{\n");
      text=
#include "stringified_c_instructions/s_f_divi"
        ;
      fprintf(output_stream, "%s", text);
      fprintf(output_stream, "}\n");
      break;
    }
    case s_f_modi:{
      char* text;
      fprintf(output_stream, "{\n");
      text=
#include "stringified_c_instructions/s_f_modi"
        ;
      fprintf(output_stream, "%s", text);
      fprintf(output_stream, "}\n");
      break;
    }
    case s_fcll:{
      char* text;
      fprintf(output_stream, "{\n");
      text=
#include "stringified_c_instructions/s_fcll"
        ;
      fprintf(output_stream, "%s", text);
      fprintf(output_stream, "}\n");
      break;
    }
    case s_filec:{
      char* text;
      fprintf(output_stream, "{\n");
      text=
#include "stringified_c_instructions/s_filec"
        ;
      fprintf(output_stream, "%s", text);
      fprintf(output_stream, "}\n");
      break;
    }
    case s_fileor:{
      char* text;
      fprintf(output_stream, "{\n");
      text=
#include "stringified_c_instructions/s_fileor"
        ;
      fprintf(output_stream, "%s", text);
      fprintf(output_stream, "}\n");
      break;
    }
    case s_fileow:{
      char* text;
      fprintf(output_stream, "{\n");
      text=
#include "stringified_c_instructions/s_fileow"
        ;
      fprintf(output_stream, "%s", text);
      fprintf(output_stream, "}\n");
      break;
    }
    case s_filerc:{
      char* text;
      fprintf(output_stream, "{\n");
      text=
#include "stringified_c_instructions/s_filerc"
        ;
      fprintf(output_stream, "%s", text);
      fprintf(output_stream, "}\n");
      break;
    }
    case s_filewc:{
      char* text;
      fprintf(output_stream, "{\n");
      text=
#include "stringified_c_instructions/s_filewc"
        ;
      fprintf(output_stream, "%s", text);
      fprintf(output_stream, "}\n");
      break;
    }
    case s_flin:{
      char* text;
      fprintf(output_stream, "{\n");
      text=
#include "stringified_c_instructions/s_flin"
        ;
      fprintf(output_stream, "%s", text);
      fprintf(output_stream, "}\n");
      break;
    }
    case s_frtoba:{
      char* text;
      fprintf(output_stream, "{\n");
      text=
#include "stringified_c_instructions/s_frtoba"
        ;
      fprintf(output_stream, "%s", text);
      fprintf(output_stream, "}\n");
      break;
    }
    case s_fscll:{
      char* text;
      fprintf(output_stream, "{\n");
      text=
#include "stringified_c_instructions/s_fscll"
        ;
      fprintf(output_stream, "%s", text);
      fprintf(output_stream, "}\n");
      break;
    }
    case s_gl:{
      char* text;
      fprintf(output_stream, "{\n");
      text=
#include "stringified_c_instructions/s_gl"
        ;
      fprintf(output_stream, "%s", text);
      fprintf(output_stream, "}\n");
      break;
    }
    case s_gtef:{
      char* text;
      fprintf(output_stream, "{\n");
      text=
#include "stringified_c_instructions/s_gtef"
        ;
      fprintf(output_stream, "%s", text);
      fprintf(output_stream, "}\n");
      break;
    }
    case s_gtei:{
      char* text;
      fprintf(output_stream, "{\n");
      text=
#include "stringified_c_instructions/s_gtei"
        ;
      fprintf(output_stream, "%s", text);
      fprintf(output_stream, "}\n");
      break;
    }
    case s_gtei_i:{
      char* text;
      fprintf(output_stream, "{\n");
      text=
#include "stringified_c_instructions/s_gtei_i"
        ;
      fprintf(output_stream, "%s", text);
      fprintf(output_stream, "}\n");
      break;
    }
    case s_gtes:{
      char* text;
      fprintf(output_stream, "{\n");
      text=
#include "stringified_c_instructions/s_gtes"
        ;
      fprintf(output_stream, "%s", text);
      fprintf(output_stream, "}\n");
      break;
    }
    case s_gtf:{
      char* text;
      fprintf(output_stream, "{\n");
      text=
#include "stringified_c_instructions/s_gtf"
        ;
      fprintf(output_stream, "%s", text);
      fprintf(output_stream, "}\n");
      break;
    }
    case s_gti:{
      char* text;
      fprintf(output_stream, "{\n");
      text=
#include "stringified_c_instructions/s_gti"
        ;
      fprintf(output_stream, "%s", text);
      fprintf(output_stream, "}\n");
      break;
    }
    case s_gti_i:{
      char* text;
      fprintf(output_stream, "{\n");
      text=
#include "stringified_c_instructions/s_gti_i"
        ;
      fprintf(output_stream, "%s", text);
      fprintf(output_stream, "}\n");
      break;
    }
    case s_gts:{
      char* text;
      fprintf(output_stream, "{\n");
      text=
#include "stringified_c_instructions/s_gts"
        ;
      fprintf(output_stream, "%s", text);
      fprintf(output_stream, "}\n");
      break;
    }
    case s_infl:{
      char* text;
      fprintf(output_stream, "{\n");
      text=
#include "stringified_c_instructions/s_infl"
        ;
      fprintf(output_stream, "%s", text);
      fprintf(output_stream, "}\n");
      break;
    }
    case s_jandi:{
      char* text;
      fprintf(output_stream, "{\n");
      text=
#include "stringified_c_instructions/s_jandi"
        ;
      fprintf(output_stream, "%s", text);
      fprintf(output_stream, "}\n");
      break;
    }
    case s_jeqi:{
      char* text;
      fprintf(output_stream, "{\n");
      text=
#include "stringified_c_instructions/s_jeqi"
        ;
      fprintf(output_stream, "%s", text);
      fprintf(output_stream, "}\n");
      break;
    }
    case s_jeqi_i:{
      char* text;
      fprintf(output_stream, "{\n");
      text=
#include "stringified_c_instructions/s_jeqi_i"
        ;
      fprintf(output_stream, "%s", text);
      fprintf(output_stream, "}\n");
      break;
    }
    case s_jgtei:{
      char* text;
      fprintf(output_stream, "{\n");
      text=
#include "stringified_c_instructions/s_jgtei"
        ;
      fprintf(output_stream, "%s", text);
      fprintf(output_stream, "}\n");
      break;
    }
    case s_jgtei_i:{
      char* text;
      fprintf(output_stream, "{\n");
      text=
#include "stringified_c_instructions/s_jgtei_i"
        ;
      fprintf(output_stream, "%s", text);
      fprintf(output_stream, "}\n");
      break;
    }
    case s_jgti:{
      char* text;
      fprintf(output_stream, "{\n");
      text=
#include "stringified_c_instructions/s_jgti"
        ;
      fprintf(output_stream, "%s", text);
      fprintf(output_stream, "}\n");
      break;
    }
    case s_jgti_i:{
      char* text;
      fprintf(output_stream, "{\n");
      text=
#include "stringified_c_instructions/s_jgti_i"
        ;
      fprintf(output_stream, "%s", text);
      fprintf(output_stream, "}\n");
      break;
    }
    case s_jltei:{
      char* text;
      fprintf(output_stream, "{\n");
      text=
#include "stringified_c_instructions/s_jltei"
        ;
      fprintf(output_stream, "%s", text);
      fprintf(output_stream, "}\n");
      break;
    }
    case s_jltei_i:{
      char* text;
      fprintf(output_stream, "{\n");
      text=
#include "stringified_c_instructions/s_jltei_i"
        ;
      fprintf(output_stream, "%s", text);
      fprintf(output_stream, "}\n");
      break;
    }
    case s_jlti:{
      char* text;
      fprintf(output_stream, "{\n");
      text=
#include "stringified_c_instructions/s_jlti"
        ;
      fprintf(output_stream, "%s", text);
      fprintf(output_stream, "}\n");
      break;
    }
    case s_jlti_i:{
      char* text;
      fprintf(output_stream, "{\n");
      text=
#include "stringified_c_instructions/s_jlti_i"
        ;
      fprintf(output_stream, "%s", text);
      fprintf(output_stream, "}\n");
      break;
    }
    case s_jnandi:{
      char* text;
      fprintf(output_stream, "{\n");
      text=
#include "stringified_c_instructions/s_jnandi"
        ;
      fprintf(output_stream, "%s", text);
      fprintf(output_stream, "}\n");
      break;
    }
    case s_jneqi:{
      char* text;
      fprintf(output_stream, "{\n");
      text=
#include "stringified_c_instructions/s_jneqi"
        ;
      fprintf(output_stream, "%s", text);
      fprintf(output_stream, "}\n");
      break;
    }
    case s_jneqi_i:{
      char* text;
      fprintf(output_stream, "{\n");
      text=
#include "stringified_c_instructions/s_jneqi_i"
        ;
      fprintf(output_stream, "%s", text);
      fprintf(output_stream, "}\n");
      break;
    }
    case s_jnm:{
      char* text;
      fprintf(output_stream, "{\n");
      text=
#include "stringified_c_instructions/s_jnm"
        ;
      fprintf(output_stream, "%s", text);
      fprintf(output_stream, "}\n");
      break;
    }
    case s_jnori:{
      char* text;
      fprintf(output_stream, "{\n");
      text=
#include "stringified_c_instructions/s_jnori"
        ;
      fprintf(output_stream, "%s", text);
      fprintf(output_stream, "}\n");
      break;
    }
    case s_jnxori:{
      char* text;
      fprintf(output_stream, "{\n");
      text=
#include "stringified_c_instructions/s_jnxori"
        ;
      fprintf(output_stream, "%s", text);
      fprintf(output_stream, "}\n");
      break;
    }
    case s_jnz:{
      char* text;
      fprintf(output_stream, "{\n");
      text=
#include "stringified_c_instructions/s_jnz"
        ;
      fprintf(output_stream, "%s", text);
      fprintf(output_stream, "}\n");
      break;
    }
    case s_jori:{
      char* text;
      fprintf(output_stream, "{\n");
      text=
#include "stringified_c_instructions/s_jori"
        ;
      fprintf(output_stream, "%s", text);
      fprintf(output_stream, "}\n");
      break;
    }
    case s_jxori:{
      char* text;
      fprintf(output_stream, "{\n");
      text=
#include "stringified_c_instructions/s_jxori"
        ;
      fprintf(output_stream, "%s", text);
      fprintf(output_stream, "}\n");
      break;
    }
    case s_jz:{
      char* text;
      fprintf(output_stream, "{\n");
      text=
#include "stringified_c_instructions/s_jz"
        ;
      fprintf(output_stream, "%s", text);
      fprintf(output_stream, "}\n");
      break;
    }
    case s_lcl:{
      char* text;
      fprintf(output_stream, "{\n");
      text=
#include "stringified_c_instructions/s_lcl"
        ;
      fprintf(output_stream, "%s", text);
      fprintf(output_stream, "}\n");
      break;
    }
    case s_lkp:{
      char* text;
      fprintf(output_stream, "{\n");
      text=
#include "stringified_c_instructions/s_lkp"
        ;
      fprintf(output_stream, "%s", text);
      fprintf(output_stream, "}\n");
      break;
    }
    case s_lkp_i:{
      char* text;
      fprintf(output_stream, "{\n");
      text=
#include "stringified_c_instructions/s_lkp_i"
        ;
      fprintf(output_stream, "%s", text);
      fprintf(output_stream, "}\n");
      break;
    }
    case s_lkpb:{
      char* text;
      fprintf(output_stream, "{\n");
      text=
#include "stringified_c_instructions/s_lkpb"
        ;
      fprintf(output_stream, "%s", text);
      fprintf(output_stream, "}\n");
      break;
    }
    case s_ltbar:{
      char* text;
      fprintf(output_stream, "{\n");
      text=
#include "stringified_c_instructions/s_ltbar"
        ;
      fprintf(output_stream, "%s", text);
      fprintf(output_stream, "}\n");
      break;
    }
    case s_ltef:{
      char* text;
      fprintf(output_stream, "{\n");
      text=
#include "stringified_c_instructions/s_ltef"
        ;
      fprintf(output_stream, "%s", text);
      fprintf(output_stream, "}\n");
      break;
    }
    case s_ltei:{
      char* text;
      fprintf(output_stream, "{\n");
      text=
#include "stringified_c_instructions/s_ltei"
        ;
      fprintf(output_stream, "%s", text);
      fprintf(output_stream, "}\n");
      break;
    }
    case s_ltei_i:{
      char* text;
      fprintf(output_stream, "{\n");
      text=
#include "stringified_c_instructions/s_ltei_i"
        ;
      fprintf(output_stream, "%s", text);
      fprintf(output_stream, "}\n");
      break;
    }
    case s_ltes:{
      char* text;
      fprintf(output_stream, "{\n");
      text=
#include "stringified_c_instructions/s_ltes"
        ;
      fprintf(output_stream, "%s", text);
      fprintf(output_stream, "}\n");
      break;
    }
    case s_ltf:{
      char* text;
      fprintf(output_stream, "{\n");
      text=
#include "stringified_c_instructions/s_ltf"
        ;
      fprintf(output_stream, "%s", text);
      fprintf(output_stream, "}\n");
      break;
    }
    case s_lti:{
      char* text;
      fprintf(output_stream, "{\n");
      text=
#include "stringified_c_instructions/s_lti"
        ;
      fprintf(output_stream, "%s", text);
      fprintf(output_stream, "}\n");
      break;
    }
    case s_lti_i:{
      char* text;
      fprintf(output_stream, "{\n");
      text=
#include "stringified_c_instructions/s_lti_i"
        ;
      fprintf(output_stream, "%s", text);
      fprintf(output_stream, "}\n");
      break;
    }
    case s_lts:{
      char* text;
      fprintf(output_stream, "{\n");
      text=
#include "stringified_c_instructions/s_lts"
        ;
      fprintf(output_stream, "%s", text);
      fprintf(output_stream, "}\n");
      break;
    }
    case s_mka_i:{
      char* text;
      fprintf(output_stream, "{\n");
      text=
#include "stringified_c_instructions/s_mka_i"
        ;
      fprintf(output_stream, "%s", text);
      fprintf(output_stream, "}\n");
      break;
    }
    case s_mkba_i:{
      char* text;
      fprintf(output_stream, "{\n");
      text=
#include "stringified_c_instructions/s_mkba_i"
        ;
      fprintf(output_stream, "%s", text);
      fprintf(output_stream, "}\n");
      break;
    }
    case s_modi:{
      char* text;
      fprintf(output_stream, "{\n");
      text=
#include "stringified_c_instructions/s_modi"
        ;
      fprintf(output_stream, "%s", text);
      fprintf(output_stream, "}\n");
      break;
    }
    case s_modi_i:{
      char* text;
      fprintf(output_stream, "{\n");
      text=
#include "stringified_c_instructions/s_modi_i"
        ;
      fprintf(output_stream, "%s", text);
      fprintf(output_stream, "}\n");
      break;
    }
    case s_mulf:{
      char* text;
      fprintf(output_stream, "{\n");
      text=
#include "stringified_c_instructions/s_mulf"
        ;
      fprintf(output_stream, "%s", text);
      fprintf(output_stream, "}\n");
      break;
    }
    case s_muli:{
      char* text;
      fprintf(output_stream, "{\n");
      text=
#include "stringified_c_instructions/s_muli"
        ;
      fprintf(output_stream, "%s", text);
      fprintf(output_stream, "}\n");
      break;
    }
    case s_muli_i:{
      char* text;
      fprintf(output_stream, "{\n");
      text=
#include "stringified_c_instructions/s_muli_i"
        ;
      fprintf(output_stream, "%s", text);
      fprintf(output_stream, "}\n");
      break;
    }
    case s_neqi:{
      char* text;
      fprintf(output_stream, "{\n");
      text=
#include "stringified_c_instructions/s_neqi"
        ;
      fprintf(output_stream, "%s", text);
      fprintf(output_stream, "}\n");
      break;
    }
    case s_neqi_i:{
      char* text;
      fprintf(output_stream, "{\n");
      text=
#include "stringified_c_instructions/s_neqi_i"
        ;
      fprintf(output_stream, "%s", text);
      fprintf(output_stream, "}\n");
      break;
    }
    case s_neqs:{
      char* text;
      fprintf(output_stream, "{\n");
      text=
#include "stringified_c_instructions/s_neqs"
        ;
      fprintf(output_stream, "%s", text);
      fprintf(output_stream, "}\n");
      break;
    }
    case s_nlcl:{
      char* text;
      fprintf(output_stream, "{\n");
      text=
#include "stringified_c_instructions/s_nlcl"
        ;
      fprintf(output_stream, "%s", text);
      fprintf(output_stream, "}\n");
      break;
    }
    case s_nll:{
      char* text;
      fprintf(output_stream, "{\n");
      text=
#include "stringified_c_instructions/s_nll"
        ;
      fprintf(output_stream, "%s", text);
      fprintf(output_stream, "}\n");
      break;
    }
    case s_nnll:{
      char* text;
      fprintf(output_stream, "{\n");
      text=
#include "stringified_c_instructions/s_nnll"
        ;
      fprintf(output_stream, "%s", text);
      fprintf(output_stream, "}\n");
      break;
    }
    case s_noti:{
      char* text;
      fprintf(output_stream, "{\n");
      text=
#include "stringified_c_instructions/s_noti"
        ;
      fprintf(output_stream, "%s", text);
      fprintf(output_stream, "}\n");
      break;
    }
    case s_nxori:{
      char* text;
      fprintf(output_stream, "{\n");
      text=
#include "stringified_c_instructions/s_nxori"
        ;
      fprintf(output_stream, "%s", text);
      fprintf(output_stream, "}\n");
      break;
    }
    case s_ori:{
      char* text;
      fprintf(output_stream, "{\n");
      text=
#include "stringified_c_instructions/s_ori"
        ;
      fprintf(output_stream, "%s", text);
      fprintf(output_stream, "}\n");
      break;
    }
    case s_outc:{
      char* text;
      fprintf(output_stream, "{\n");
      text=
#include "stringified_c_instructions/s_outc"
        ;
      fprintf(output_stream, "%s", text);
      fprintf(output_stream, "}\n");
      break;
    }
    case s_outec:{
      char* text;
      fprintf(output_stream, "{\n");
      text=
#include "stringified_c_instructions/s_outec"
        ;
      fprintf(output_stream, "%s", text);
      fprintf(output_stream, "}\n");
      break;
    }
    case s_outes:{
      char* text;
      fprintf(output_stream, "{\n");
      text=
#include "stringified_c_instructions/s_outes"
        ;
      fprintf(output_stream, "%s", text);
      fprintf(output_stream, "}\n");
      break;
    }
    case s_outf:{
      char* text;
      fprintf(output_stream, "{\n");
      text=
#include "stringified_c_instructions/s_outf"
        ;
      fprintf(output_stream, "%s", text);
      fprintf(output_stream, "}\n");
      break;
    }
    case s_outi:{
      char* text;
      fprintf(output_stream, "{\n");
      text=
#include "stringified_c_instructions/s_outi"
        ;
      fprintf(output_stream, "%s", text);
      fprintf(output_stream, "}\n");
      break;
    }
    case s_outs:{
      char* text;
      fprintf(output_stream, "{\n");
      text=
#include "stringified_c_instructions/s_outs"
        ;
      fprintf(output_stream, "%s", text);
      fprintf(output_stream, "}\n");
      break;
    }
    case s_popl:{
      char* text;
      fprintf(output_stream, "{\n");
      text=
#include "stringified_c_instructions/s_popl"
        ;
      fprintf(output_stream, "%s", text);
      fprintf(output_stream, "}\n");
      break;
    }
    case s_powf:{
      char* text;
      fprintf(output_stream, "{\n");
      text=
#include "stringified_c_instructions/s_powf"
        ;
      fprintf(output_stream, "%s", text);
      fprintf(output_stream, "}\n");
      break;
    }
    case s_powi:{
      char* text;
      fprintf(output_stream, "{\n");
      text=
#include "stringified_c_instructions/s_powi"
        ;
      fprintf(output_stream, "%s", text);
      fprintf(output_stream, "}\n");
      break;
    }
    case s_powi_i:{
      char* text;
      fprintf(output_stream, "{\n");
      text=
#include "stringified_c_instructions/s_powi_i"
        ;
      fprintf(output_stream, "%s", text);
      fprintf(output_stream, "}\n");
      break;
    }
    case s_pshf:{
      char* text;
      fprintf(output_stream, "{\n");
      text=
#include "stringified_c_instructions/s_pshf"
        ;
      fprintf(output_stream, "%s", text);
      fprintf(output_stream, "}\n");
      break;
    }
    case s_pshl:{
      char* text;
      fprintf(output_stream, "{\n");
      text=
#include "stringified_c_instructions/s_pshl"
        ;
      fprintf(output_stream, "%s", text);
      fprintf(output_stream, "}\n");
      break;
    }
    case s_ret:{
      char* text;
      fprintf(output_stream, "{\n");
      text=
#include "stringified_c_instructions/s_ret"
        ;
      fprintf(output_stream, "%s", text);
      fprintf(output_stream, "}\n");
      break;
    }
    case s_retn:{
      char* text;
      fprintf(output_stream, "{\n");
      text=
#include "stringified_c_instructions/s_retn"
        ;
      fprintf(output_stream, "%s", text);
      fprintf(output_stream, "}\n");
      break;
    }
    case s_scll:{
      char* text;
      fprintf(output_stream, "{\n");
      text=
#include "stringified_c_instructions/s_scll"
        ;
      fprintf(output_stream, "%s", text);
      fprintf(output_stream, "}\n");
      break;
    }
    case s_seto:{
      char* text;
      fprintf(output_stream, "{\n");
      text=
#include "stringified_c_instructions/s_seto"
        ;
      fprintf(output_stream, "%s", text);
      fprintf(output_stream, "}\n");
      break;
    }
    case s_subf:{
      char* text;
      fprintf(output_stream, "{\n");
      text=
#include "stringified_c_instructions/s_subf"
        ;
      fprintf(output_stream, "%s", text);
      fprintf(output_stream, "}\n");
      break;
    }
    case s_subi:{
      char* text;
      fprintf(output_stream, "{\n");
      text=
#include "stringified_c_instructions/s_subi"
        ;
      fprintf(output_stream, "%s", text);
      fprintf(output_stream, "}\n");
      break;
    }
    case s_subi_i:{
      char* text;
      fprintf(output_stream, "{\n");
      text=
#include "stringified_c_instructions/s_subi_i"
        ;
      fprintf(output_stream, "%s", text);
      fprintf(output_stream, "}\n");
      break;
    }
    case s_swp:{
      char* text;
      fprintf(output_stream, "{\n");
      text=
#include "stringified_c_instructions/s_swp"
        ;
      fprintf(output_stream, "%s", text);
      fprintf(output_stream, "}\n");
      break;
    }
    case s_thrw:{
      char* text;
      fprintf(output_stream, "{\n");
      text=
#include "stringified_c_instructions/s_thrw"
        ;
      fprintf(output_stream, "%s", text);
      fprintf(output_stream, "}\n");
      break;
    }
    case s_umini:{
      char* text;
      fprintf(output_stream, "{\n");
      text=
#include "stringified_c_instructions/s_umini"
        ;
      fprintf(output_stream, "%s", text);
      fprintf(output_stream, "}\n");
      break;
    }
    case s_xori:{
      char* text;
      fprintf(output_stream, "{\n");
      text=
#include "stringified_c_instructions/s_xori"
        ;
      fprintf(output_stream, "%s", text);
      fprintf(output_stream, "}\n");
      break;
    }
    case setfp:{
      char* text;
      fprintf(output_stream, "{\n");
      text=
#include "stringified_c_instructions/setfp"
        ;
      fprintf(output_stream, "%s", text);
      fprintf(output_stream, "}\n");
      break;
    }
    case subi:{
      char* text;
      fprintf(output_stream, "{\n");
      text=
#include "stringified_c_instructions/subi"
        ;
      fprintf(output_stream, "%s", text);
      fprintf(output_stream, "}\n");
      break;
    }
    case subi_i:{
      char* text;
      fprintf(output_stream, "{\n");
      text=
#include "stringified_c_instructions/subi_i"
        ;
      fprintf(output_stream, "%s", text);
      fprintf(output_stream, "}\n");
      break;
    }
    case swp:{
      char* text;
      fprintf(output_stream, "{\n");
      text=
#include "stringified_c_instructions/swp"
        ;
      fprintf(output_stream, "%s", text);
      fprintf(output_stream, "}\n");
      break;
    }
/* This file is part of GNU epsilon, a functional language implementation

Copyright (C) 2002 Luca Saiu

GNU epsilon is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published
by the Free Software Foundation; either version 2, or (at your
option) any later version.

GNU epsilon is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License
along with epsilon; see the file COPYING.  If not, write to the
Free Software Foundation, Inc., 59 Temple Place - Suite 330,
Boston, MA 02111-1307, USA. */

    default:{
      fprintf(stderr, "Unknown opcode at instruction #" INTEGER_T_FORMAT "\n",
	      instruction_pointer);
      exit(EXIT_FAILURE);
    }
    } /* switch */
  }
  fprintf(output_stream, "  return EXIT_SUCCESS;\n");
  fprintf(output_stream, "} /* main */\n");
}
